/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_sequences;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import java.util.ArrayList;
import java.util.Arrays;

public class AmbiguousSequenceIterator {
    private char[] sequenceAsCharArray;
    private ArrayList<char[]> aaCombinations;
    private int[] iterationIndices;
    private int[] indicesOnSequence;
    private int secondaryIndex = 0;

    public AmbiguousSequenceIterator() {
    }

    public AmbiguousSequenceIterator(char[] sequence, int expectedNumberOfCombinations) {
        this.sequenceAsCharArray = sequence;
        this.initialize(expectedNumberOfCombinations);
    }

    public AmbiguousSequenceIterator(String sequence, int expectedNumberOfCombinations) {
        this(sequence.toCharArray(), expectedNumberOfCombinations);
    }

    public AmbiguousSequenceIterator(String sequence) {
        this(sequence, 2);
    }

    private void initialize(int expectedNumberOfCombinations) {
        int initialSize = Math.min(expectedNumberOfCombinations, 16);
        this.aaCombinations = new ArrayList(initialSize);
        ArrayList<Integer> indicesList = new ArrayList<Integer>(initialSize);
        for (int i = 0; i < this.sequenceAsCharArray.length; ++i) {
            char aa = this.sequenceAsCharArray[i];
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            if (!aminoAcid.iscombination()) continue;
            char[] possibleAas = aminoAcid.getSubAminoAcids(false);
            this.aaCombinations.add(possibleAas);
            indicesList.add(i);
        }
        this.indicesOnSequence = new int[indicesList.size()];
        this.iterationIndices = new int[indicesList.size()];
        int count = 0;
        for (Integer index : indicesList) {
            this.indicesOnSequence[count] = index;
            this.iterationIndices[count] = 0;
            ++count;
        }
        this.iterationIndices[0] = -1;
    }

    public char[] getNextSequence() {
        if (!this.increaseIndices()) {
            return null;
        }
        char[] newSequenceAsCharArray = Arrays.copyOf(this.sequenceAsCharArray, this.sequenceAsCharArray.length);
        for (int i = 0; i < this.indicesOnSequence.length; ++i) {
            char aa;
            int index = this.indicesOnSequence[i];
            char[] possibleAas = this.aaCombinations.get(i);
            int iterationIndex = this.iterationIndices[i];
            newSequenceAsCharArray[index] = aa = possibleAas[iterationIndex];
        }
        return newSequenceAsCharArray;
    }

    private boolean increaseIndices() {
        if (this.secondaryIndex == this.iterationIndices.length) {
            return false;
        }
        char[] aasAtIndex = this.aaCombinations.get(this.secondaryIndex);
        int aaIndex = this.iterationIndices[this.secondaryIndex];
        if (++aaIndex == aasAtIndex.length) {
            this.iterationIndices[this.secondaryIndex] = 0;
            ++this.secondaryIndex;
            return this.increaseIndices();
        }
        this.iterationIndices[this.secondaryIndex] = aaIndex;
        return true;
    }
}

