/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation;

import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.IonFactory;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.spectrum_annotation.NeutralLossesMap;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class AnnotationParameters
extends ExperimentObject {
    private boolean yAxisZoomExcludesBackgroundPeaks = true;
    private boolean showAllPeaks = false;
    private IntensityThresholdType intensityThresholdType = IntensityThresholdType.percentile;
    private double intensityLimit = 0.75;
    private boolean automaticAnnotation = true;
    private final HashMap<Ion.IonType, HashSet<Integer>> selectedIonsMap = new HashMap(4);
    private final ArrayList<NeutralLoss> neutralLossesList = new ArrayList(0);
    private boolean neutralLossesAuto = true;
    private boolean reporterIons = true;
    private boolean relatedIons = true;
    private double fragmentIonAccuracy;
    private boolean fragmentIonPpm = false;
    private boolean showForwardIonDeNovoTags = false;
    private boolean showRewindIonDeNovoTags = false;
    private int deNovoCharge = 1;
    private SpectrumAnnotator.TiesResolution tiesResolution = SpectrumAnnotator.TiesResolution.mostAccurateMz;

    public AnnotationParameters() {
    }

    public SpecificAnnotationParameters getSpecificAnnotationParameters(String spectrumFile, String spectrumTitle, SpectrumIdentificationAssumption spectrumIdentificationAssumption, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationSequenceMatchingParameters, SpectrumAnnotator spectrumAnnotator) {
        int precursorCharge = spectrumIdentificationAssumption.getIdentificationCharge();
        SpecificAnnotationParameters specificAnnotationParameters = new SpecificAnnotationParameters();
        specificAnnotationParameters.setPrecursorCharge(precursorCharge);
        specificAnnotationParameters.setNeutralLossesAuto(this.neutralLossesAuto);
        if (this.neutralLossesAuto) {
            specificAnnotationParameters.setNeutralLossesMap(SpectrumAnnotator.getDefaultLosses(spectrumIdentificationAssumption, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, spectrumAnnotator));
        } else {
            NeutralLossesMap tempNeutralLossesMap = new NeutralLossesMap();
            this.getNeutralLosses().forEach(neutralLoss -> tempNeutralLossesMap.addNeutralLoss((NeutralLoss)neutralLoss, 1, 1));
            specificAnnotationParameters.setNeutralLossesMap(tempNeutralLossesMap);
        }
        int max = precursorCharge == 1 ? 2 : precursorCharge;
        HashSet charges = IntStream.range(1, max).mapToObj(charge -> charge).collect(Collectors.toCollection(HashSet::new));
        if (precursorCharge == 1) {
            charges.add(precursorCharge);
        } else {
            for (int charge2 = 1; charge2 < precursorCharge; ++charge2) {
                charges.add(charge2);
            }
        }
        specificAnnotationParameters.setSelectedCharges(charges);
        specificAnnotationParameters.setSelectedIonsMap((HashMap)this.selectedIonsMap.clone());
        specificAnnotationParameters.setFragmentIonAccuracy(this.fragmentIonAccuracy);
        specificAnnotationParameters.setFragmentIonPpm(this.fragmentIonPpm);
        return specificAnnotationParameters;
    }

    public AnnotationParameters(SearchParameters searchParameters) {
        this.setParametersFromSearchParameters(searchParameters);
    }

    public void setParametersFromSearchParameters(SearchParameters searchParameters) {
        this.clearIonTypes();
        for (Integer ion : searchParameters.getForwardIons()) {
            this.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, ion);
            this.addIonType(Ion.IonType.TAG_FRAGMENT_ION, ion);
        }
        for (Integer ion : searchParameters.getRewindIons()) {
            this.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, ion);
            this.addIonType(Ion.IonType.TAG_FRAGMENT_ION, ion);
        }
        this.addIonType(Ion.IonType.PRECURSOR_ION);
        this.addIonType(Ion.IonType.IMMONIUM_ION);
        this.addIonType(Ion.IonType.REPORTER_ION);
        this.addIonType(Ion.IonType.RELATED_ION);
        this.setFragmentIonAccuracy(searchParameters.getFragmentIonAccuracy());
        this.setFragmentIonPpm(searchParameters.getFragmentAccuracyType() == SearchParameters.MassAccuracyType.PPM);
        ModificationParameters ptmSettings = searchParameters.getModificationParameters();
        if (this.getReporterIons()) {
            HashSet<Integer> ptmReporterIons = IonFactory.getReporterIons(ptmSettings);
            this.selectedIonsMap.put(Ion.IonType.REPORTER_ION, ptmReporterIons);
        }
        if (this.isAutomaticAnnotation() || this.areNeutralLossesSequenceAuto()) {
            HashSet<String> lossesNames = IonFactory.getNeutralLosses(searchParameters.getModificationParameters());
            for (String lossName : lossesNames) {
                NeutralLoss neutralLoss = NeutralLoss.getNeutralLoss(lossName);
                this.addNeutralLoss(neutralLoss);
            }
        }
    }

    public boolean areNeutralLossesSequenceAuto() {
        return this.neutralLossesAuto;
    }

    public void setNeutralLossesSequenceAuto(boolean neutralLossesAuto) {
        this.neutralLossesAuto = neutralLossesAuto;
    }

    public boolean getReporterIons() {
        return this.reporterIons;
    }

    public void setReporterIons(boolean reporterIons) {
        this.reporterIons = reporterIons;
    }

    public boolean getRelatedIons() {
        return this.relatedIons;
    }

    public void setRelatedIons(boolean relatedIons) {
        this.relatedIons = relatedIons;
    }

    public void clearNeutralLosses() {
        this.neutralLossesList.clear();
    }

    public ArrayList<NeutralLoss> getNeutralLosses() {
        return this.neutralLossesList;
    }

    public void addNeutralLoss(NeutralLoss neutralLoss) {
        boolean alreadyInList = false;
        for (NeutralLoss tempNeutralLoss : this.neutralLossesList) {
            if (!neutralLoss.isSameAs(tempNeutralLoss)) continue;
            alreadyInList = true;
            break;
        }
        if (!alreadyInList) {
            this.neutralLossesList.add(neutralLoss);
        }
    }

    public HashMap<Ion.IonType, HashSet<Integer>> getIonTypes() {
        return this.selectedIonsMap;
    }

    public HashSet<Integer> getFragmentIonTypes() {
        if (this.selectedIonsMap.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) == null) {
            return new HashSet<Integer>(0);
        }
        return this.selectedIonsMap.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION);
    }

    public void addIonType(Ion.IonType ionType, int subType) {
        HashSet<Integer> selectedSubtypes = this.selectedIonsMap.get((Object)ionType);
        if (selectedSubtypes == null) {
            selectedSubtypes = new HashSet(1);
            this.selectedIonsMap.put(ionType, selectedSubtypes);
        }
        selectedSubtypes.add(subType);
    }

    public void addIonType(Ion.IonType ionType) {
        int[] possibleSubtypes = Ion.getPossibleSubtypes(ionType);
        HashSet selectedSubtypes = this.selectedIonsMap.get((Object)ionType);
        if (selectedSubtypes == null) {
            selectedSubtypes = Arrays.stream(possibleSubtypes).boxed().collect(Collectors.toCollection(HashSet::new));
            this.selectedIonsMap.put(ionType, selectedSubtypes);
        } else {
            for (int i = 0; i < possibleSubtypes.length; ++i) {
                selectedSubtypes.add(possibleSubtypes[i]);
            }
        }
    }

    public void clearIonTypes() {
        this.selectedIonsMap.clear();
    }

    public void setAutomaticAnnotation(boolean automaticAnnotation) {
        this.automaticAnnotation = automaticAnnotation;
        if (automaticAnnotation) {
            this.neutralLossesAuto = true;
        }
    }

    public boolean isAutomaticAnnotation() {
        return this.automaticAnnotation;
    }

    public double getFragmentIonAccuracy() {
        return this.fragmentIonAccuracy;
    }

    public double getFragmentIonAccuracyInDa(double refMass) {
        return this.fragmentIonPpm ? this.fragmentIonAccuracy * refMass / 1000000.0 : this.fragmentIonAccuracy;
    }

    public void setFragmentIonAccuracy(double fragmentIonAccuracy) {
        this.fragmentIonAccuracy = fragmentIonAccuracy;
    }

    public boolean isFragmentIonPpm() {
        return this.fragmentIonPpm;
    }

    public void setFragmentIonPpm(boolean fragmentIonPpm) {
        this.fragmentIonPpm = fragmentIonPpm;
    }

    public double getAnnotationIntensityLimit() {
        return this.intensityLimit;
    }

    public void setIntensityLimit(double intensityLimit) {
        this.intensityLimit = intensityLimit;
    }

    public IntensityThresholdType getIntensityThresholdType() {
        return this.intensityThresholdType;
    }

    public void setIntensityThresholdType(IntensityThresholdType intensityThresholdType) {
        this.intensityThresholdType = intensityThresholdType;
    }

    public boolean showAllPeaks() {
        return this.showAllPeaks;
    }

    public void setShowAllPeaks(boolean showAllPeaks) {
        this.showAllPeaks = showAllPeaks;
    }

    public boolean yAxisZoomExcludesBackgroundPeaks() {
        return this.yAxisZoomExcludesBackgroundPeaks;
    }

    public void setYAxisZoomExcludesBackgroundPeaks(boolean yAxisZoomExcludesBackgroundPeaks) {
        this.yAxisZoomExcludesBackgroundPeaks = yAxisZoomExcludesBackgroundPeaks;
    }

    public boolean showForwardIonDeNovoTags() {
        return this.showForwardIonDeNovoTags;
    }

    public void setShowForwardIonDeNovoTags(boolean showForwardIonDeNovoTags) {
        this.showForwardIonDeNovoTags = showForwardIonDeNovoTags;
    }

    public boolean showRewindIonDeNovoTags() {
        return this.showRewindIonDeNovoTags;
    }

    public void setShowRewindIonDeNovoTags(boolean showRewindIonDeNovoTags) {
        this.showRewindIonDeNovoTags = showRewindIonDeNovoTags;
    }

    public int getDeNovoCharge() {
        return this.deNovoCharge;
    }

    public void setDeNovoCharge(int deNovoCharge) {
        this.deNovoCharge = deNovoCharge;
    }

    public SpectrumAnnotator.TiesResolution getTiesResolution() {
        return this.tiesResolution;
    }

    public void setTiesResolution(SpectrumAnnotator.TiesResolution tiesResolution) {
        this.tiesResolution = tiesResolution;
    }

    public AnnotationParameters clone() {
        AnnotationParameters annotationSettings = new AnnotationParameters();
        annotationSettings.setYAxisZoomExcludesBackgroundPeaks(this.yAxisZoomExcludesBackgroundPeaks);
        annotationSettings.setShowAllPeaks(this.showAllPeaks);
        annotationSettings.setIntensityLimit(this.intensityLimit);
        annotationSettings.setAutomaticAnnotation(this.automaticAnnotation);
        annotationSettings.setFragmentIonAccuracy(this.fragmentIonAccuracy);
        annotationSettings.setFragmentIonPpm(this.fragmentIonPpm);
        annotationSettings.setShowForwardIonDeNovoTags(this.showForwardIonDeNovoTags);
        annotationSettings.setShowRewindIonDeNovoTags(this.showRewindIonDeNovoTags);
        annotationSettings.setDeNovoCharge(this.deNovoCharge);
        annotationSettings.setTiesResolution(this.getTiesResolution());
        annotationSettings.setNeutralLossesSequenceAuto(this.neutralLossesAuto);
        annotationSettings.setReporterIons(this.getReporterIons());
        annotationSettings.setReporterIons(this.getRelatedIons());
        for (NeutralLoss neutralLoss : this.neutralLossesList) {
            annotationSettings.addNeutralLoss(neutralLoss);
        }
        for (Ion.IonType ionType : this.selectedIonsMap.keySet()) {
            for (Integer subType : this.selectedIonsMap.get((Object)ionType)) {
                annotationSettings.addIonType(ionType, subType);
            }
        }
        return annotationSettings;
    }

    public boolean isSameAs(AnnotationParameters annotationSettings) {
        if (this.yAxisZoomExcludesBackgroundPeaks != annotationSettings.yAxisZoomExcludesBackgroundPeaks()) {
            return false;
        }
        if (this.showAllPeaks != annotationSettings.showAllPeaks()) {
            return false;
        }
        if (this.intensityThresholdType != annotationSettings.getIntensityThresholdType()) {
            return false;
        }
        if (this.intensityLimit != annotationSettings.getAnnotationIntensityLimit()) {
            return false;
        }
        if (this.automaticAnnotation != annotationSettings.isAutomaticAnnotation()) {
            return false;
        }
        if (this.fragmentIonAccuracy != annotationSettings.getFragmentIonAccuracy()) {
            return false;
        }
        if (this.fragmentIonPpm != annotationSettings.isFragmentIonPpm()) {
            return false;
        }
        if (this.showForwardIonDeNovoTags != annotationSettings.showForwardIonDeNovoTags()) {
            return false;
        }
        if (this.showRewindIonDeNovoTags != annotationSettings.showRewindIonDeNovoTags()) {
            return false;
        }
        if (this.deNovoCharge != annotationSettings.getDeNovoCharge()) {
            return false;
        }
        if (this.getTiesResolution() != annotationSettings.getTiesResolution()) {
            return false;
        }
        if (this.neutralLossesAuto != annotationSettings.areNeutralLossesSequenceAuto()) {
            return false;
        }
        if (this.getReporterIons() != annotationSettings.getReporterIons()) {
            return false;
        }
        if (this.getRelatedIons() != annotationSettings.getRelatedIons()) {
            return false;
        }
        ArrayList<NeutralLoss> otherNeutralLosses = annotationSettings.getNeutralLosses();
        if (this.getNeutralLosses().size() != otherNeutralLosses.size()) {
            return false;
        }
        for (NeutralLoss neutralLoss1 : this.getNeutralLosses()) {
            boolean found = false;
            for (NeutralLoss neutralLoss2 : otherNeutralLosses) {
                if (!neutralLoss1.isSameAs(neutralLoss2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        HashMap<Ion.IonType, HashSet<Integer>> ionTypes = annotationSettings.getIonTypes();
        if (ionTypes.size() != this.selectedIonsMap.size()) {
            return false;
        }
        for (Ion.IonType ionType : ionTypes.keySet()) {
            HashSet<Integer> thisSubIons = this.selectedIonsMap.get((Object)ionType);
            if (thisSubIons == null) {
                return false;
            }
            HashSet<Integer> otherSubIons = ionTypes.get((Object)ionType);
            if (thisSubIons.size() != otherSubIons.size()) {
                return false;
            }
            for (Integer subIon1 : thisSubIons) {
                boolean found = false;
                for (Integer subIon2 : otherSubIons) {
                    if (!subIon1.equals(subIon2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public String getShortDescription() {
        ArrayList<NeutralLoss> selectedNeutralLosses;
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        if (!this.selectedIonsMap.isEmpty()) {
            output.append("Ion Types: ");
            String ionTypes = "";
            block15: for (Ion.IonType ionType : this.selectedIonsMap.keySet()) {
                if (null == ionType) continue;
                switch (ionType) {
                    case IMMONIUM_ION: {
                        if (!ionTypes.isEmpty()) {
                            ionTypes = ionTypes + ", ";
                        }
                        ionTypes = ionTypes + "immonium ions";
                        break;
                    }
                    case RELATED_ION: {
                        if (!ionTypes.isEmpty()) {
                            ionTypes = ionTypes + ", ";
                        }
                        ionTypes = ionTypes + "related ions";
                        break;
                    }
                    case PEPTIDE_FRAGMENT_ION: {
                        for (int subType : this.selectedIonsMap.get((Object)ionType)) {
                            switch (subType) {
                                case 0: {
                                    if (!ionTypes.isEmpty()) {
                                        ionTypes = ionTypes + ", ";
                                    }
                                    ionTypes = ionTypes + "a ions";
                                    break;
                                }
                                case 1: {
                                    if (!ionTypes.isEmpty()) {
                                        ionTypes = ionTypes + ", ";
                                    }
                                    ionTypes = ionTypes + "b ions";
                                    break;
                                }
                                case 2: {
                                    if (!ionTypes.isEmpty()) {
                                        ionTypes = ionTypes + ", ";
                                    }
                                    ionTypes = ionTypes + "x ions";
                                    break;
                                }
                                case 3: {
                                    if (!ionTypes.isEmpty()) {
                                        ionTypes = ionTypes + ", ";
                                    }
                                    ionTypes = ionTypes + "x ions";
                                    break;
                                }
                                case 4: {
                                    if (!ionTypes.isEmpty()) {
                                        ionTypes = ionTypes + ", ";
                                    }
                                    ionTypes = ionTypes + "y ions";
                                    break;
                                }
                                case 5: {
                                    if (!ionTypes.isEmpty()) {
                                        ionTypes = ionTypes + ", ";
                                    }
                                    ionTypes = ionTypes + "z ions";
                                    break;
                                }
                            }
                        }
                        continue block15;
                    }
                    case PRECURSOR_ION: {
                        if (!ionTypes.isEmpty()) {
                            ionTypes = ionTypes + ", ";
                        }
                        ionTypes = ionTypes + "precursor ions";
                        break;
                    }
                    case REPORTER_ION: {
                        if (!ionTypes.isEmpty()) {
                            ionTypes = ionTypes + ", ";
                        }
                        ionTypes = ionTypes + "reporter ions";
                        break;
                    }
                }
            }
            output.append(ionTypes).append(".").append(newLine);
        }
        if (!(selectedNeutralLosses = this.getNeutralLosses()).isEmpty()) {
            output.append("Neutral Losses: ");
            String neutralLosses = "";
            for (NeutralLoss selectedNeutralLoss : selectedNeutralLosses) {
                if (!neutralLosses.isEmpty()) {
                    neutralLosses = neutralLosses + ", ";
                }
                neutralLosses = neutralLosses + selectedNeutralLoss.name;
            }
            output.append(neutralLosses).append(".").append(newLine);
        }
        output.append("Intensity Threshold Type: ").append((Object)this.intensityThresholdType).append(".").append(newLine);
        output.append("Intensity Threshold: ").append(this.intensityLimit * 100.0).append(".").append(newLine);
        String unit = this.fragmentIonPpm ? "ppm" : "Da";
        output.append("Fragment Ion Accuracy: ").append(this.fragmentIonAccuracy).append(" ").append(unit).append(".").append(newLine);
        output.append("Best peak selection: ").append(this.tiesResolution.description).append(".").append(newLine);
        return output.toString();
    }

    public static enum IntensityThresholdType {
        percentile("Percentile of the intensities"),
        snp("Signal to noise probability");

        public final String description;

        private IntensityThresholdType(String description) {
            this.description = description;
        }

        public static String getCommandLineOptions() {
            return Arrays.stream(IntensityThresholdType.values()).map(value -> String.join((CharSequence)": ", value.name(), value.description)).collect(Collectors.joining(", "));
        }
    }
}

