/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation;

import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.IonFactory;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.ions.impl.TagFragmentIon;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.IonMatchKeysCache;
import com.compomics.util.experiment.identification.spectrum_annotation.NeutralLossesMap;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.TagSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.indexes.SpectrumIndex;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.gui.interfaces.SpectrumAnnotation;
import com.compomics.util.gui.spectrum.DefaultSpectrumAnnotation;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import java.util.stream.Collectors;

public abstract class SpectrumAnnotator {
    protected int precursorCharge;
    protected HashSet<Integer> defaultPrecursorCharges;
    protected HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> theoreticalFragmentIons;
    protected IonFactory fragmentFactory = IonFactory.getInstance();
    protected String spectrumFile = "";
    protected String spectrumTitle = "";
    protected double intensityLimit = 0.0;
    private SpectrumIndex spectrumIndex;
    protected double mzTolerance;
    protected boolean isPpm;
    protected static final boolean SUBTRACT_ISOTOPE = false;
    protected static final Integer MIN_ISOTOPIC_CORRRECTION = 0;
    protected static final Integer MAX_ISOTOPIC_CORRRECTION = 0;
    protected double massShift = 0.0;
    protected double massShiftNTerm = 0.0;
    protected double massShiftCTerm = 0.0;
    protected TiesResolution tiesResolution;
    protected SpecificAnnotationParameters specificAnnotationSettings = null;
    protected IonMatchKeysCache ionMatchKeysCache = new IonMatchKeysCache();

    public static Vector<SpectrumAnnotation> getSpectrumAnnotation(IonMatch[] ionMatches) {
        return Arrays.stream(ionMatches).map(ionMatch -> new DefaultSpectrumAnnotation(ionMatch.peakMz, ionMatch.getAbsoluteError(MIN_ISOTOPIC_CORRRECTION, MAX_ISOTOPIC_CORRRECTION), SpectrumPanel.determineFragmentIonColor(ionMatch.ion, true), ionMatch.getPeakAnnotation())).collect(Collectors.toCollection(Vector::new));
    }

    protected IonMatch matchInSpectrum(double[] spectrumMz, double[] spectrumIntensity, Ion theoreticIon, Integer inspectedCharge) {
        double fragmentMz = theoreticIon.getTheoreticMz(inspectedCharge);
        int[] matchedPeaksIndexes = this.spectrumIndex.getMatchingPeaks(fragmentMz);
        if (matchedPeaksIndexes.length == 0) {
            return null;
        }
        if (matchedPeaksIndexes.length == 1) {
            return new IonMatch(spectrumMz[matchedPeaksIndexes[0]], spectrumIntensity[matchedPeaksIndexes[0]], theoreticIon, inspectedCharge);
        }
        IonMatch ionMatch = new IonMatch(0.0, 0.0, theoreticIon, inspectedCharge);
        ionMatch = this.setBestPeak(spectrumMz, spectrumIntensity, matchedPeaksIndexes, ionMatch);
        return ionMatch;
    }

    protected IonMatch setBestPeak(double[] spectrumMz, double[] spectrumIntensity, int[] matchedPeaksIndexes, IonMatch ionMatch) {
        if (matchedPeaksIndexes.length == 1) {
            int index = matchedPeaksIndexes[0];
            ionMatch.peakMz = spectrumMz[index];
            ionMatch.peakIntensity = spectrumIntensity[index];
            return ionMatch;
        }
        int bestIndex = -1;
        switch (this.tiesResolution) {
            case mostAccurateMz: {
                double bestPeakError = Double.NaN;
                for (int index : matchedPeaksIndexes) {
                    if (Double.isNaN(bestPeakError)) {
                        bestIndex = index;
                        ionMatch.peakMz = spectrumMz[index];
                        bestPeakError = Math.abs(ionMatch.getError(this.isPpm));
                        continue;
                    }
                    ionMatch.peakMz = spectrumMz[index];
                    double peakError = Math.abs(ionMatch.getError(this.isPpm));
                    if (peakError < bestPeakError) {
                        bestIndex = index;
                        bestPeakError = peakError;
                        continue;
                    }
                    if (peakError != bestPeakError || !(spectrumIntensity[index] > spectrumIntensity[bestIndex])) continue;
                    bestIndex = index;
                }
                ionMatch.peakMz = spectrumMz[bestIndex];
                ionMatch.peakIntensity = spectrumIntensity[bestIndex];
                return ionMatch;
            }
            case mostIntense: {
                for (int index : matchedPeaksIndexes) {
                    if (bestIndex == -1 || spectrumIntensity[index] > spectrumIntensity[bestIndex]) {
                        bestIndex = index;
                        continue;
                    }
                    if (spectrumIntensity[index] != spectrumIntensity[bestIndex]) continue;
                    ionMatch.peakMz = spectrumMz[bestIndex];
                    double bestPeakError = Math.abs(ionMatch.getError(this.isPpm));
                    ionMatch.peakMz = spectrumMz[index];
                    double peakError = Math.abs(ionMatch.getError(this.isPpm));
                    if (!(peakError < bestPeakError)) continue;
                    bestIndex = index;
                }
                ionMatch.peakMz = spectrumMz[bestIndex];
                ionMatch.peakIntensity = spectrumIntensity[bestIndex];
                return ionMatch;
            }
        }
        throw new UnsupportedOperationException("Ties resolution method " + (Object)((Object)this.tiesResolution) + " not implemented.");
    }

    protected void setSpectrum(String spectrumFile, String spectrumTitle, Spectrum spectrum, double intensityLimit) {
        if (this.spectrumIndex == null || !spectrumTitle.equals(this.spectrumTitle) || !spectrumFile.equals(this.spectrumFile) || this.intensityLimit != intensityLimit) {
            this.spectrumFile = spectrumFile;
            this.spectrumTitle = spectrumTitle;
            this.intensityLimit = intensityLimit;
            this.spectrumIndex = new SpectrumIndex(spectrum.mz, spectrum.intensity, intensityLimit, this.mzTolerance, this.isPpm);
        }
    }

    protected void setMassTolerance(double mzTolerance, boolean isPpm, TiesResolution tiesResolution) {
        if (mzTolerance != this.mzTolerance || tiesResolution != this.tiesResolution) {
            this.spectrumIndex = null;
            this.mzTolerance = mzTolerance;
            this.isPpm = isPpm;
            this.tiesResolution = tiesResolution;
        }
    }

    public boolean isAccounted(NeutralLossesMap neutralLosses, NeutralLoss neutralLoss, Ion ion) {
        if (neutralLosses == null || neutralLosses.isEmpty()) {
            return false;
        }
        for (String neutralLossName : neutralLosses.getAccountedNeutralLosses()) {
            NeutralLoss neutralLossRef = NeutralLoss.getNeutralLoss(neutralLossName);
            if (!neutralLoss.isSameAs(neutralLossRef)) continue;
            switch (ion.getType()) {
                case PEPTIDE_FRAGMENT_ION: {
                    PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)ion;
                    switch (ion.getSubType()) {
                        case 0: 
                        case 1: 
                        case 2: {
                            return neutralLosses.getForwardStart(neutralLossName) <= peptideFragmentIon.getNumber();
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            return neutralLosses.getRewindStart(neutralLossName) <= peptideFragmentIon.getNumber();
                        }
                    }
                    throw new UnsupportedOperationException("Fragment ion type " + ion.getSubTypeAsString() + " not implemented in the spectrum annotator.");
                }
                case TAG_FRAGMENT_ION: {
                    TagFragmentIon tagFragmentIon = (TagFragmentIon)ion;
                    switch (ion.getSubType()) {
                        case 0: 
                        case 1: 
                        case 2: {
                            return neutralLosses.getForwardStart(neutralLossName) <= tagFragmentIon.getNumber();
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            return neutralLosses.getRewindStart(neutralLossName) <= tagFragmentIon.getNumber();
                        }
                    }
                    throw new UnsupportedOperationException("Fragment ion type " + ion.getSubTypeAsString() + " not implemented in the spectrum annotator.");
                }
            }
            return true;
        }
        return false;
    }

    public boolean lossesValidated(NeutralLossesMap neutralLosses, Ion theoreticIon) {
        if (theoreticIon.hasNeutralLosses()) {
            for (NeutralLoss neutralLoss : theoreticIon.getNeutralLosses()) {
                if (this.isAccounted(neutralLosses, neutralLoss, theoreticIon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean chargeValidated(Ion theoreticIon, int charge, int precursorCharge) {
        if (charge == 1) {
            return true;
        }
        switch (theoreticIon.getType()) {
            case IMMONIUM_ION: 
            case RELATED_ION: {
                return false;
            }
            case REPORTER_ION: {
                return false;
            }
            case PEPTIDE_FRAGMENT_ION: {
                PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)theoreticIon;
                return charge <= peptideFragmentIon.getNumber() && charge < precursorCharge;
            }
            case TAG_FRAGMENT_ION: {
                TagFragmentIon tagFragmentIon = (TagFragmentIon)theoreticIon;
                return charge <= tagFragmentIon.getNumber() && charge < precursorCharge;
            }
            case PRECURSOR_ION: {
                return charge >= precursorCharge;
            }
        }
        throw new UnsupportedOperationException("Ion type " + theoreticIon.getTypeAsString() + " not implemented in the spectrum annotator.");
    }

    public IonMatch[] getCurrentAnnotation(String spectrumFile, String spectrumTitle, Spectrum spectrum, AnnotationParameters annotationSettings, SpecificAnnotationParameters specificAnnotationSettings, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters) {
        return this.getCurrentAnnotation(spectrumFile, spectrumTitle, spectrum, annotationSettings, specificAnnotationSettings, modificationParameters, sequenceProvider, modificationsSequenceMatchingParameters, true);
    }

    public abstract IonMatch[] getCurrentAnnotation(String var1, String var2, Spectrum var3, AnnotationParameters var4, SpecificAnnotationParameters var5, ModificationParameters var6, SequenceProvider var7, SequenceMatchingParameters var8, boolean var9);

    public String getCurrentlyLoadedSpectrumFile() {
        return this.spectrumFile;
    }

    public String getCurrentlyLoadedSpectrumTitle() {
        return this.spectrumTitle;
    }

    public double getMassShift() {
        return this.massShift;
    }

    public double getMassShiftNTerm() {
        return this.massShiftNTerm;
    }

    public double getMassShiftCTerm() {
        return this.massShiftNTerm;
    }

    public void setMassShift(double massShift) {
        this.massShift = massShift;
        this.updateMassShifts();
    }

    public void setMassShifts(double massShift, double massShiftNTerm, double massShiftCTerm) {
        this.massShift = massShift;
        this.massShiftNTerm = massShiftNTerm;
        this.massShiftCTerm = massShiftCTerm;
        this.updateMassShifts();
    }

    public void setTerminalMassShifts(double massShiftNTerm, double massShiftCTerm) {
        this.massShiftNTerm = massShiftNTerm;
        this.massShiftCTerm = massShiftCTerm;
        this.updateMassShifts();
    }

    protected void updateMassShifts() {
        if (this.theoreticalFragmentIons != null) {
            HashMap<Integer, ArrayList<Ion>> tagFragmentIons;
            HashMap<Integer, ArrayList<Ion>> peptideFragmentIons = this.theoreticalFragmentIons.get(Ion.IonType.PEPTIDE_FRAGMENT_ION.index);
            ArrayList<Ion> ions = peptideFragmentIons.get(0);
            if (ions != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                }
            }
            if ((ions = peptideFragmentIons.get(1)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                }
            }
            if ((ions = peptideFragmentIons.get(2)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                }
            }
            if ((ions = peptideFragmentIons.get(3)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
            if ((ions = peptideFragmentIons.get(4)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
            if ((ions = peptideFragmentIons.get(5)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
            if ((ions = (tagFragmentIons = this.theoreticalFragmentIons.get(Ion.IonType.TAG_FRAGMENT_ION.index)).get(0)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                }
            }
            if ((ions = tagFragmentIons.get(1)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                }
            }
            if ((ions = tagFragmentIons.get(2)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                }
            }
            if ((ions = tagFragmentIons.get(3)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
            if ((ions = tagFragmentIons.get(4)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
            if ((ions = tagFragmentIons.get(5)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
        }
    }

    public static NeutralLossesMap getDefaultLosses(SpectrumIdentificationAssumption spectrumIdentificationAssumption, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters, SpectrumAnnotator spectrumAnnotator) {
        if (spectrumIdentificationAssumption instanceof PeptideAssumption) {
            PeptideAssumption peptideAssumption = (PeptideAssumption)spectrumIdentificationAssumption;
            return PeptideSpectrumAnnotator.getDefaultLosses(peptideAssumption.getPeptide(), modificationParameters, sequenceProvider, modificationsSequenceMatchingParameters);
        }
        if (spectrumIdentificationAssumption instanceof TagAssumption) {
            TagAssumption tagAssumption = (TagAssumption)spectrumIdentificationAssumption;
            return TagSpectrumAnnotator.getDefaultLosses(tagAssumption.getTag(), modificationParameters, modificationsSequenceMatchingParameters);
        }
        throw new IllegalArgumentException("Default neutral loss map not implemented for SpectrumIdentificationAssumption " + spectrumIdentificationAssumption.getClass() + ".");
    }

    protected ArrayList<IonMatch> matchPeak(SpecificAnnotationParameters specificAnnotationSettings, double peakMz, double peakIntensity) {
        ArrayList<IonMatch> result = new ArrayList<IonMatch>();
        HashMap<Ion.IonType, HashSet<Integer>> ionTypes = specificAnnotationSettings.getIonTypes();
        for (Ion.IonType ionType : ionTypes.keySet()) {
            HashMap<Integer, ArrayList<Ion>> ionMap = this.theoreticalFragmentIons.get(ionType.index);
            if (ionMap == null) continue;
            HashSet<Integer> subtypes = ionTypes.get((Object)ionType);
            for (int subType : subtypes) {
                ArrayList<Ion> ions = ionMap.get(subType);
                if (ions == null) continue;
                for (Ion ion : ions) {
                    for (int charge : specificAnnotationSettings.getSelectedCharges()) {
                        IonMatch ionMatch;
                        double absError;
                        if (!this.chargeValidated(ion, charge, specificAnnotationSettings.getPrecursorCharge()) || !this.lossesValidated(specificAnnotationSettings.getNeutralLossesMap(), ion) || !((absError = Math.abs((ionMatch = new IonMatch(peakMz, peakIntensity, ion, charge)).getError(specificAnnotationSettings.isFragmentIonPpm(), MIN_ISOTOPIC_CORRRECTION, MAX_ISOTOPIC_CORRRECTION))) <= specificAnnotationSettings.getFragmentIonAccuracy())) continue;
                        result.add(ionMatch);
                    }
                }
            }
        }
        return result;
    }

    protected HashMap<Integer, ArrayList<Ion>> getExpectedIons(SpecificAnnotationParameters specificAnnotationSettings) {
        HashMap<Integer, ArrayList<Ion>> result = new HashMap<Integer, ArrayList<Ion>>();
        HashMap<Ion.IonType, HashSet<Integer>> ionTypes = specificAnnotationSettings.getIonTypes();
        for (Ion.IonType ionType : ionTypes.keySet()) {
            HashMap<Integer, ArrayList<Ion>> ionMap = this.theoreticalFragmentIons.get(ionType.index);
            if (ionMap == null) continue;
            HashSet<Integer> subtypes = ionTypes.get((Object)ionType);
            for (int subType : subtypes) {
                ArrayList<Ion> ions = ionMap.get(subType);
                if (ions == null) continue;
                for (Ion ion : ions) {
                    if (!this.lossesValidated(specificAnnotationSettings.getNeutralLossesMap(), ion)) continue;
                    for (int charge : specificAnnotationSettings.getSelectedCharges()) {
                        if (!this.chargeValidated(ion, charge, this.precursorCharge)) continue;
                        ArrayList<Ion> resultsAtCharge = result.get(charge);
                        if (resultsAtCharge == null) {
                            resultsAtCharge = new ArrayList(1);
                            result.put(charge, resultsAtCharge);
                        }
                        resultsAtCharge.add(ion);
                    }
                }
            }
        }
        return result;
    }

    public static ArrayList<IonMatch> matchReporterIon(Ion theoreticIon, int charge, Spectrum spectrum, double massTolerance) {
        ArrayList<IonMatch> result = new ArrayList<IonMatch>(1);
        double targetMass = theoreticIon.getTheoreticMz(charge);
        for (int i = 0; i < spectrum.getNPeaks(); ++i) {
            double mz = spectrum.mz[i];
            double intensity = spectrum.intensity[i];
            if (Math.abs(mz - targetMass) <= massTolerance) {
                result.add(new IonMatch(mz, intensity, theoreticIon, charge));
            }
            if (mz > targetMass + massTolerance) break;
        }
        return result;
    }

    public static enum TiesResolution {
        mostIntense("Higest intensity"),
        mostAccurateMz("Most accurate m/z");

        public final String description;

        private TiesResolution(String description) {
            this.description = description;
        }
    }
}

