/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation.simple_annotators;

import com.compomics.util.experiment.biology.atoms.ElementaryElement;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.biology.ions.impl.ElementaryIon;
import com.compomics.util.experiment.biology.ions.impl.PrecursorIon;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.mass_spectrometry.indexes.SpectrumIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;

public class PrecursorAnnotator {
    private final ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private final double precursorMass;
    private final double[] neutralLossesMasses;
    private NeutralLoss[] neutralLosses = null;

    public PrecursorAnnotator() {
        this.precursorMass = 0.0;
        this.neutralLossesMasses = null;
    }

    public PrecursorAnnotator(Peptide peptide, String[] fixedModifications) {
        this.precursorMass = peptide.getMass();
        HashSet fixedModificationLosses = Arrays.stream(fixedModifications).filter(modName -> modName != null).map(modName -> this.modificationFactory.getModification((String)modName)).flatMap(modification -> modification.getNeutralLosses().stream()).map(neutralLoss -> neutralLoss.name).collect(Collectors.toCollection(HashSet::new));
        ModificationMatch[] variableModifications = peptide.getVariableModifications();
        HashSet variableModificationLosses = Arrays.stream(variableModifications).map(modificationMatch -> this.modificationFactory.getModification(modificationMatch.getModification())).flatMap(modification -> modification.getNeutralLosses().stream()).map(neutralLoss -> neutralLoss.name).collect(Collectors.toCollection(HashSet::new));
        HashSet modificationLosses = new HashSet(fixedModificationLosses);
        modificationLosses.addAll(variableModificationLosses);
        if (!modificationLosses.isEmpty()) {
            int nNeutralLosses = modificationLosses.size() + 2;
            this.neutralLosses = new NeutralLoss[nNeutralLosses];
            this.neutralLossesMasses = new double[nNeutralLosses];
            int count = 0;
            this.neutralLosses[count] = NeutralLoss.H2O;
            this.neutralLossesMasses[count++] = NeutralLoss.H2O.getMass();
            this.neutralLosses[count] = NeutralLoss.NH3;
            this.neutralLossesMasses[count++] = NeutralLoss.NH3.getMass();
            for (String modificationLoss : modificationLosses) {
                NeutralLoss neutralLoss2;
                this.neutralLosses[count] = neutralLoss2 = NeutralLoss.getNeutralLoss(modificationLoss);
                this.neutralLossesMasses[count++] = neutralLoss2.getMass();
            }
        } else {
            this.neutralLosses = new NeutralLoss[]{NeutralLoss.H2O, NeutralLoss.NH3};
            this.neutralLossesMasses = new double[]{NeutralLoss.H2O.getMass(), NeutralLoss.NH3.getMass()};
        }
    }

    public ArrayList<IonMatch> getIonMatches(SpectrumIndex spectrumIndex, int peptideCharge, int isotopeMax) {
        ArrayList<IonMatch> results = new ArrayList<IonMatch>(0);
        double protonatedMass = this.precursorMass + ElementaryIon.getProtonMassMultiple(peptideCharge);
        for (int isotope = 0; isotope <= isotopeMax; ++isotope) {
            double mass = protonatedMass + ElementaryElement.getNeutronMassMultiple(isotope);
            double mz = mass / (double)peptideCharge;
            int[] indexes = spectrumIndex.getMatchingPeaks(mz);
            if (indexes.length > 0) {
                PrecursorIon ion = new PrecursorIon(this.precursorMass, null);
                for (int index : indexes) {
                    results.add(new IonMatch(spectrumIndex.mzArray[index], spectrumIndex.intensityArray[index], ion, peptideCharge));
                }
            }
            for (int i = 0; i < this.neutralLosses.length; ++i) {
                NeutralLoss neutralLoss1 = this.neutralLosses[i];
                double massWithLoss1 = mass - neutralLoss1.getMass();
                mz = massWithLoss1 / (double)peptideCharge;
                indexes = spectrumIndex.getMatchingPeaks(mz);
                if (indexes.length > 0) {
                    NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLoss1};
                    PrecursorIon ion = new PrecursorIon(massWithLoss1, ionLosses);
                    for (int index : indexes) {
                        results.add(new IonMatch(spectrumIndex.mzArray[index], spectrumIndex.intensityArray[index], ion, peptideCharge));
                    }
                }
                for (int j = i + 1; j < this.neutralLosses.length; ++j) {
                    NeutralLoss neutralLoss2 = this.neutralLosses[j];
                    double massWithLoss2 = massWithLoss1 - neutralLoss2.getMass();
                    mz = massWithLoss1 / (double)peptideCharge;
                    indexes = spectrumIndex.getMatchingPeaks(mz);
                    if (indexes.length <= 0) continue;
                    NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLoss1, neutralLoss2};
                    PrecursorIon ion = new PrecursorIon(massWithLoss2, ionLosses);
                    for (int index : indexes) {
                        results.add(new IonMatch(spectrumIndex.mzArray[index], spectrumIndex.intensityArray[index], ion, peptideCharge));
                    }
                }
            }
        }
        return results;
    }
}

