/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identification.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.bind.JAXBException;

public class MsAmandaIdfileReader
implements IdfileReader {
    private final String softwareName = "MS Amanda";
    private String softwareVersion = null;
    private File msAmandaCsvFile;

    public MsAmandaIdfileReader() {
    }

    public MsAmandaIdfileReader(File msAmandaCsvFile) throws IOException {
        this(msAmandaCsvFile, null);
    }

    public MsAmandaIdfileReader(File msAmandaCsvFile, WaitingHandler waitingHandler) throws IOException {
        this.msAmandaCsvFile = msAmandaCsvFile;
        this.extractVersionNumber();
    }

    private void extractVersionNumber() {
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(this.msAmandaCsvFile);){
            String versionNumberString = reader.readLine();
            if (versionNumberString.toLowerCase().startsWith("#version: ")) {
                this.softwareVersion = versionNumberString.substring("#version: ".length()).trim();
            }
        }
    }

    @Override
    public String getExtension() {
        return ".ms-amanda.csv";
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(spectrumProvider, waitingHandler, searchParameters, null, true);
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        ArrayList<SpectrumMatch> result = new ArrayList<SpectrumMatch>();
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(this.msAmandaCsvFile);){
            String line;
            String versionNumberString = reader.readLine();
            String headerString = versionNumberString.toLowerCase().startsWith("#version: ") ? reader.readLine() : versionNumberString;
            String[] headers = headerString.split("\t");
            int scanNumberIndex = -1;
            int titleIndex = -1;
            int sequenceIndex = -1;
            int modificationsIndex = -1;
            int proteinAccessionsIndex = -1;
            int amandaScoreIndex = -1;
            int rankIndex = -1;
            int mzIndex = -1;
            int chargeIndex = -1;
            int rtIndex = -1;
            int nrMatchesPeaksIndex = -1;
            int filenameIndex = -1;
            int amandaWeightedProbabilityIndex = -1;
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i];
                if (header.equalsIgnoreCase("Scan Number")) {
                    scanNumberIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Title")) {
                    titleIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Sequence")) {
                    sequenceIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Modifications")) {
                    modificationsIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Protein Accessions")) {
                    proteinAccessionsIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Amanda Score")) {
                    amandaScoreIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Weighted Probability")) {
                    amandaWeightedProbabilityIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Rank")) {
                    rankIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("m/z")) {
                    mzIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Charge")) {
                    chargeIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("RT")) {
                    rtIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Nr of matched peaks")) {
                    nrMatchesPeaksIndex = i;
                    continue;
                }
                if (!header.equalsIgnoreCase("Filename")) continue;
                filenameIndex = i;
            }
            if (scanNumberIndex == -1 || titleIndex == -1 || sequenceIndex == -1 || modificationsIndex == -1 || proteinAccessionsIndex == -1 || amandaScoreIndex == -1 || rankIndex == -1 || mzIndex == -1 || chargeIndex == -1 || filenameIndex == -1) {
                throw new IllegalArgumentException("Mandatory columns are missing in the MS Amanda csv file. Please check the file!");
            }
            String currentSpectrumTitle = null;
            SpectrumMatch currentMatch = null;
            while ((line = reader.readLine()) != null) {
                double msAmandaTransformedScore;
                String[] elements = line.split("\t");
                if (line.trim().isEmpty()) continue;
                String spectrumTitle = elements[titleIndex].trim();
                String peptideSequence = elements[sequenceIndex].toUpperCase();
                String modifications = elements[modificationsIndex].trim();
                String scoreAsText = elements[amandaScoreIndex];
                double msAmandaRawScore = Util.readDoubleAsString(scoreAsText);
                if (amandaWeightedProbabilityIndex != -1) {
                    String eVaulueAsText = elements[amandaWeightedProbabilityIndex];
                    msAmandaTransformedScore = Util.readDoubleAsString(eVaulueAsText);
                } else {
                    msAmandaTransformedScore = Math.pow(10.0, -msAmandaRawScore);
                }
                int rank = Integer.valueOf(elements[rankIndex]);
                int charge = Integer.valueOf(elements[chargeIndex]);
                String fileName = elements[filenameIndex];
                spectrumTitle = URLDecoder.decode(spectrumTitle, "utf-8");
                if (currentMatch == null || currentSpectrumTitle != null && !currentSpectrumTitle.equalsIgnoreCase(spectrumTitle)) {
                    if (currentMatch != null) {
                        result.add(currentMatch);
                    }
                    currentMatch = new SpectrumMatch(fileName, spectrumTitle);
                    currentSpectrumTitle = spectrumTitle;
                }
                ArrayList<ModificationMatch> utilitiesModifications = new ArrayList<ModificationMatch>(1);
                if (!modifications.isEmpty()) {
                    String[] modificationsString;
                    for (String modificationString : modificationsString = modifications.split(";")) {
                        try {
                            String location = modificationString.substring(0, modificationString.indexOf("("));
                            int modSite = location.equalsIgnoreCase("N-Term") ? 1 : (location.equalsIgnoreCase("C-Term") ? peptideSequence.length() : Integer.parseInt(modificationString.substring(1, modificationString.indexOf("("))));
                            String rest = modificationString.substring(modificationString.indexOf("(") + 1, modificationString.length() - 1).toLowerCase();
                            String[] details = rest.split("\\|");
                            String modName = details[0];
                            String modMassAsString = details[1];
                            double modMass = Util.readDoubleAsString(modMassAsString);
                            String modFixedStatus = details[2];
                            if (!modFixedStatus.equalsIgnoreCase("variable")) continue;
                            utilitiesModifications.add(new ModificationMatch(modMass + "@" + peptideSequence.charAt(modSite - 1), modSite));
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Error parsing modification: " + modificationString + ".");
                        }
                    }
                }
                Peptide peptide = new Peptide(peptideSequence, utilitiesModifications.toArray(new ModificationMatch[utilitiesModifications.size()]), true);
                PeptideAssumption peptideAssumption = new PeptideAssumption(peptide, rank, Advocate.msAmanda.getIndex(), charge, msAmandaRawScore, msAmandaTransformedScore, IoUtil.getFileName(this.msAmandaCsvFile));
                if (expandAaCombinations && AminoAcidSequence.hasCombination(peptideSequence)) {
                    ModificationMatch[] previousModificationMatches = peptide.getVariableModifications();
                    for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations(peptide.getSequence())) {
                        ModificationMatch[] newModificationMatches = (ModificationMatch[])Arrays.stream(previousModificationMatches).map(modificationMatch -> modificationMatch.clone()).toArray(ModificationMatch[]::new);
                        Peptide newPeptide = new Peptide(expandedSequence.toString(), newModificationMatches, true);
                        PeptideAssumption newAssumption = new PeptideAssumption(newPeptide, peptideAssumption.getRank(), peptideAssumption.getAdvocate(), peptideAssumption.getIdentificationCharge(), peptideAssumption.getRawScore(), peptideAssumption.getScore(), peptideAssumption.getIdentificationFile());
                        currentMatch.addPeptideAssumption(Advocate.msAmanda.getIndex(), newAssumption);
                    }
                } else {
                    currentMatch.addPeptideAssumption(Advocate.msAmanda.getIndex(), peptideAssumption);
                }
                if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
                break;
            }
            if (currentMatch != null) {
                result.add(currentMatch);
            }
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.msAmandaCsvFile = null;
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add(this.softwareVersion);
        result.put("MS Amanda", versions);
        return result;
    }

    @Override
    public boolean hasDeNovoTags() {
        return false;
    }
}

