/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identification.idfilereaders;

import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.bind.JAXBException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class MzIdentMLIdfileReader
implements IdfileReader {
    private HashMap<String, ArrayList<String>> tempSoftwareVersions = new HashMap();
    private HashMap<String, ArrayList<String>> softwareVersions = new HashMap();
    private File mzIdentMLFile;
    private String mzIdentMLFileName;
    private HashMap<String, SimplePeptide> tempPeptideMap;
    private HashMap<String, String> tempPeptideEvidenceMap;
    private HashMap<String, String> spectrumFileNameMap;
    private ArrayList<SearchModificationCustom> fixedModificationsCustomParser;
    private SequenceMatchingParameters sequenceMatchingPreferences;
    private SpectrumProvider spectrumProvider;
    private boolean expandAaCombinations;
    private boolean hasDenovoTags = false;

    public MzIdentMLIdfileReader() {
    }

    public MzIdentMLIdfileReader(File mzIdentMLFile) throws IOException {
        this(mzIdentMLFile, null);
    }

    public MzIdentMLIdfileReader(File mzIdentMLFile, WaitingHandler waitingHandler) throws IOException {
        this.mzIdentMLFile = mzIdentMLFile;
        this.mzIdentMLFileName = IoUtil.getFileName(mzIdentMLFile);
    }

    @Override
    public String getExtension() {
        return ".mzid";
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException, XmlPullParserException {
        return this.getAllSpectrumMatches(spectrumProvider, waitingHandler, searchParameters, null, true);
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException, XmlPullParserException {
        this.spectrumProvider = spectrumProvider;
        this.sequenceMatchingPreferences = sequenceMatchingPreferences;
        this.expandAaCombinations = expandAaCombinations;
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
            try (SimpleFileReader reader = SimpleFileReader.getFileReader(this.mzIdentMLFile);){
                int lineCounter = 0;
                String line = reader.readLine();
                while (line != null) {
                    line = reader.readLine();
                    ++lineCounter;
                }
                waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                waitingHandler.setMaxSecondaryProgressCounter(lineCounter);
            }
        }
        return this.parseFile(waitingHandler);
    }

    private Advocate getAdvocate() {
        for (String softwareName : this.tempSoftwareVersions.keySet()) {
            Advocate advocate = Advocate.getAdvocate(softwareName);
            if (advocate == null) continue;
            return advocate;
        }
        Iterator<String> iterator = this.tempSoftwareVersions.keySet().iterator();
        if (iterator.hasNext()) {
            String softwareName;
            softwareName = iterator.next();
            return Advocate.addUserAdvocate(softwareName);
        }
        return Advocate.genericMzId;
    }

    @Override
    public void close() throws IOException {
        this.mzIdentMLFile = null;
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        return this.softwareVersions;
    }

    @Override
    public boolean hasDeNovoTags() {
        return this.hasDenovoTags;
    }

    public static void main(String[] args) {
        try {
            MzIdentMLIdfileReader temp = new MzIdentMLIdfileReader();
            temp.parseFile(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<SpectrumMatch> parseFile(WaitingHandler waitingHandler) throws XmlPullParserException, IOException {
        ArrayList<SpectrumMatch> result = new ArrayList<SpectrumMatch>();
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(this.mzIdentMLFile);){
            parser.setInput(reader.getReader());
            int type = parser.next();
            this.tempPeptideMap = new HashMap();
            this.tempPeptideEvidenceMap = new HashMap();
            this.spectrumFileNameMap = new HashMap();
            this.fixedModificationsCustomParser = new ArrayList();
            this.softwareVersions.clear();
            while (type != 1) {
                if (type == 2 && parser.getName().equals("AnalysisSoftware")) {
                    this.parseSoftware(parser);
                } else if (type == 2 && parser.getName().equals("Peptide")) {
                    this.parsePeptide(parser);
                } else if (type == 2 && parser.getName().equals("PeptideEvidence")) {
                    this.parsePeptideEvidence(parser);
                } else if (type == 2 && parser.getName().equals("SpectraData")) {
                    this.parseSpectraData(parser, this.spectrumFileNameMap);
                } else if (type == 2 && parser.getName().equals("ModificationParams")) {
                    this.parseFixedModifications(parser);
                } else if (type == 2 && parser.getName().equals("SpectrumIdentificationResult")) {
                    this.parsePsm(parser, result);
                }
                type = parser.next();
                if (waitingHandler == null) continue;
                waitingHandler.setSecondaryProgressCounter(parser.getLineNumber());
            }
        }
        return result;
    }

    private void parsePeptideEvidence(XmlPullParser parser) {
        String peptideEvidenceId = null;
        String peptideRef = null;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attributeName = parser.getAttributeName(i);
            if (attributeName.equalsIgnoreCase("id")) {
                peptideEvidenceId = parser.getAttributeValue(i);
                continue;
            }
            if (!attributeName.equalsIgnoreCase("peptide_ref")) continue;
            peptideRef = parser.getAttributeValue(i);
        }
        if (peptideEvidenceId != null && peptideRef != null) {
            this.tempPeptideEvidenceMap.put(peptideEvidenceId, peptideRef);
        }
    }

    private void parsePeptide(XmlPullParser parser) throws XmlPullParserException, IOException {
        String pepKey = parser.getAttributeValue(0);
        int type = parser.next();
        while (type != 2 || !parser.getName().equals("PeptideSequence")) {
            type = parser.next();
        }
        type = parser.next();
        String peptideSequence = parser.getText().trim();
        while (parser.getName() == null || !parser.getName().equals("Peptide") && !parser.getName().equals("Modification")) {
            type = parser.next();
        }
        ArrayList<SearchModificationCustom> modifications = new ArrayList<SearchModificationCustom>();
        while (type != 3 && parser.getName() != null && parser.getName().equals("Modification")) {
            Integer location = null;
            Double monoMassDelta = null;
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String attributeName = parser.getAttributeName(i);
                if (attributeName.equalsIgnoreCase("monoisotopicMassDelta")) {
                    monoMassDelta = Double.parseDouble(parser.getAttributeValue(i));
                    continue;
                }
                if (!attributeName.equalsIgnoreCase("location")) continue;
                location = Integer.parseInt(parser.getAttributeValue(i));
            }
            parser.next();
            parser.next();
            String accession = null;
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String attributeName = parser.getAttributeName(i);
                if (!attributeName.equalsIgnoreCase("accession")) continue;
                accession = parser.getAttributeValue(i);
            }
            if (location == null || monoMassDelta == null || accession == null) {
                throw new IllegalArgumentException("Could not parse PTM!");
            }
            modifications.add(new SearchModificationCustom(accession, location, monoMassDelta));
            parser.next();
            while (parser.getName() == null || parser.getName() != null && parser.getName().equals("cvParam")) {
                parser.next();
            }
            parser.next();
            parser.next();
        }
        this.tempPeptideMap.put(pepKey, new SimplePeptide(peptideSequence, modifications));
    }

    private void parseSoftware(XmlPullParser parser) throws XmlPullParserException, IOException {
        String softwareVersion = null;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attributeName = parser.getAttributeName(i);
            if (!attributeName.equalsIgnoreCase("version")) continue;
            softwareVersion = parser.getAttributeValue(i);
        }
        parser.next();
        while (parser.getName() == null || parser.getName() != null && !parser.getName().equals("SoftwareName")) {
            parser.next();
        }
        parser.next();
        if (parser.getName() == null) {
            parser.next();
        }
        String softwareName = null;
        if (parser.getName().equals("cvParam")) {
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String attributeName = parser.getAttributeName(i);
                if (!attributeName.equalsIgnoreCase("name")) continue;
                softwareName = parser.getAttributeValue(i);
            }
        } else if (parser.getName().equals("userParam")) {
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String attributeName = parser.getAttributeName(i);
                if (!attributeName.equalsIgnoreCase("name")) continue;
                softwareName = parser.getAttributeValue(i);
            }
        }
        if (softwareName != null && softwareVersion != null && Advocate.getAdvocate(softwareName) != null) {
            ArrayList<String> versions = this.tempSoftwareVersions.get(softwareName);
            if (versions == null) {
                versions = new ArrayList();
                versions.add(softwareVersion);
                this.tempSoftwareVersions.put(softwareName, versions);
            } else if (!versions.contains(softwareVersion)) {
                versions.add(softwareVersion);
            }
            this.softwareVersions.put(softwareName, versions);
        }
        this.softwareVersions.putAll(this.tempSoftwareVersions);
    }

    private boolean isVariableModification(SearchModificationCustom modification, String peptideSequence) {
        boolean fixed = false;
        int peptidePtmLocation = modification.getLocation();
        for (SearchModificationCustom fixedModification : this.fixedModificationsCustomParser) {
            double massDifference = Math.abs(fixedModification.getMassDelta() - modification.getMassDelta());
            if (modification.getAccession().equals(fixedModification.getAccession()) && !modification.getAccession().equals("MS:1001460") || massDifference < 1.0E-5) {
                boolean allRules = true;
                ArrayList<String> specificityRuleCvTerms = fixedModification.getModRuleCvTerms();
                if (specificityRuleCvTerms != null && !specificityRuleCvTerms.isEmpty()) {
                    for (String specificityRuleCvTerm : specificityRuleCvTerms) {
                        if (specificityRuleCvTerm.equals("MS:1001189") || specificityRuleCvTerm.equals("MS:1002057")) {
                            if (peptidePtmLocation != 0) {
                                allRules = false;
                                break;
                            }
                        } else if (specificityRuleCvTerm.equals("MS:1001190") || specificityRuleCvTerm.equals("MS:1002058")) {
                            if (peptidePtmLocation != peptideSequence.length() + 1) {
                                allRules = false;
                                break;
                            }
                        } else if (!specificityRuleCvTerm.equals("MS:1001875") && !specificityRuleCvTerm.equals("MS:1001876")) {
                            throw new IllegalArgumentException("Specificity rule " + specificityRuleCvTerm + " not recognized.");
                        }
                        if (allRules) continue;
                        break;
                    }
                } else if (peptidePtmLocation == 0 || peptidePtmLocation == peptideSequence.length() + 1) {
                    allRules = false;
                }
                if (allRules) {
                    String residues = fixedModification.getResidues();
                    if (residues == null || residues.isEmpty()) {
                        fixed = true;
                        break;
                    }
                    char aaAtLocation = peptidePtmLocation == 0 ? peptideSequence.charAt(0) : (peptidePtmLocation == peptideSequence.length() + 1 ? peptideSequence.charAt(peptidePtmLocation - 2) : peptideSequence.charAt(peptidePtmLocation - 1));
                    for (char residue : residues.toCharArray()) {
                        if (residue != aaAtLocation && residue != '.') continue;
                        fixed = true;
                        break;
                    }
                }
            }
            if (!fixed) continue;
            break;
        }
        return !fixed;
    }

    private void parseFixedModifications(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.next();
        parser.next();
        if (parser.getName() != null && !parser.getName().equals("ModificationParams")) {
            while (parser.getName().equalsIgnoreCase("SearchModification")) {
                String attributeName;
                String residues = null;
                Double massDelta = null;
                boolean fixed = false;
                ArrayList<String> modRuleCvTerms = new ArrayList<String>();
                ArrayList<String> modCvTerms = new ArrayList<String>();
                for (int i = 0; i < parser.getAttributeCount(); ++i) {
                    String attributeName2 = parser.getAttributeName(i);
                    if (attributeName2.equalsIgnoreCase("residues")) {
                        residues = parser.getAttributeValue(i);
                        continue;
                    }
                    if (attributeName2.equalsIgnoreCase("massDelta")) {
                        massDelta = Double.parseDouble(parser.getAttributeValue(i));
                        continue;
                    }
                    if (!attributeName2.equalsIgnoreCase("fixedMod")) continue;
                    fixed = Boolean.parseBoolean(parser.getAttributeValue(i));
                }
                parser.next();
                parser.next();
                if (parser.getName() != null && parser.getName().equals("SpecificityRules")) {
                    parser.next();
                    if (parser.getName() == null) {
                        parser.next();
                    }
                    while (parser.getName() != null && parser.getName().equals("cvParam")) {
                        if (parser.getName().equals("cvParam")) {
                            String accession = null;
                            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                                attributeName = parser.getAttributeName(i);
                                if (!attributeName.equalsIgnoreCase("accession")) continue;
                                accession = parser.getAttributeValue(i);
                            }
                            modRuleCvTerms.add(accession);
                        }
                        parser.next();
                        parser.next();
                        parser.next();
                    }
                    parser.next();
                    if (parser.getName() == null) {
                        parser.next();
                    }
                }
                while (parser.getName() != null && (parser.getName().equals("cvParam") || parser.getName().equals("userParam"))) {
                    if (parser.getName().equals("cvParam")) {
                        String accession = null;
                        for (int i = 0; i < parser.getAttributeCount(); ++i) {
                            attributeName = parser.getAttributeName(i);
                            if (!attributeName.equalsIgnoreCase("accession")) continue;
                            accession = parser.getAttributeValue(i);
                        }
                        if (accession != null && !accession.equalsIgnoreCase("MS:1002504")) {
                            modCvTerms.add(accession);
                        }
                    }
                    parser.next();
                    parser.next();
                    parser.next();
                }
                if (fixed && !modCvTerms.isEmpty()) {
                    for (String tempCvTerm : modCvTerms) {
                        this.fixedModificationsCustomParser.add(new SearchModificationCustom(tempCvTerm, residues, massDelta, modRuleCvTerms));
                    }
                }
                parser.next();
                parser.next();
            }
        }
    }

    private void parseSpectraData(XmlPullParser parser, HashMap<String, String> spectrumFileNameMap) {
        String location = null;
        String id = null;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attributeName = parser.getAttributeName(i);
            if (attributeName.equalsIgnoreCase("location")) {
                location = parser.getAttributeValue(i);
                continue;
            }
            if (!attributeName.equalsIgnoreCase("id")) continue;
            id = parser.getAttributeValue(i);
        }
        if (location != null && id != null) {
            String fileName = location;
            if (location.lastIndexOf("/") != -1) {
                fileName = location.substring(location.lastIndexOf("/") + 1);
            } else if (location.lastIndexOf("\\") != -1) {
                fileName = location.substring(location.lastIndexOf("\\") + 1);
            }
            spectrumFileNameMap.put(id, fileName);
        }
    }

    private void parsePsm(XmlPullParser parser, ArrayList<SpectrumMatch> result) throws XmlPullParserException, IOException {
        String spectraDataRef = null;
        String spectrumId = null;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attributeName = parser.getAttributeName(i);
            if (attributeName.equalsIgnoreCase("spectraData_ref")) {
                spectraDataRef = parser.getAttributeValue(i);
                continue;
            }
            if (!attributeName.equalsIgnoreCase("spectrumID")) continue;
            spectrumId = parser.getAttributeValue(i);
        }
        if (spectraDataRef == null || spectrumId == null) {
            throw new IllegalArgumentException("Error parsing SpectrumIdentificationResult!");
        }
        String spectrumTitle = null;
        String spectrumFileName = this.spectrumFileNameMap.get(spectraDataRef);
        if (spectrumId.startsWith("index=")) {
            Integer spectrumIndex = Integer.valueOf(spectrumId.substring(spectrumId.indexOf("=") + 1));
            spectrumTitle = this.spectrumProvider.getSpectrumTitles(IoUtil.removeExtension(spectrumFileName))[spectrumIndex];
        }
        SpectrumMatch currentMatch = new SpectrumMatch(spectrumFileName, spectrumId);
        parser.next();
        int type = parser.next();
        while (type != 3 && !parser.getName().equals("cvParam")) {
            Integer rank = null;
            String peptideRef = null;
            Integer chargeState = null;
            String spectrumIdItemId = null;
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String attributeName = parser.getAttributeName(i);
                if (attributeName.equalsIgnoreCase("rank")) {
                    rank = Integer.parseInt(parser.getAttributeValue(i));
                    continue;
                }
                if (attributeName.equalsIgnoreCase("peptide_ref")) {
                    peptideRef = parser.getAttributeValue(i);
                    continue;
                }
                if (attributeName.equalsIgnoreCase("chargeState")) {
                    chargeState = Integer.parseInt(parser.getAttributeValue(i));
                    continue;
                }
                if (!attributeName.equalsIgnoreCase("id")) continue;
                spectrumIdItemId = parser.getAttributeValue(i);
            }
            if (rank == null || chargeState == null || spectrumIdItemId == null) {
                System.out.println("spectrumIdItemId: " + spectrumIdItemId);
                throw new IllegalArgumentException("Error parsing SpectrumIdentificationItem!");
            }
            type = parser.next();
            while (parser.getName() == null || parser.getName() != null && !parser.getName().equals("PeptideEvidenceRef")) {
                type = parser.next();
            }
            String peptideEvidenceRef = null;
            if (peptideRef == null && parser.getName() != null && parser.getName().equals("PeptideEvidenceRef")) {
                for (int i = 0; i < parser.getAttributeCount(); ++i) {
                    String attributeName = parser.getAttributeName(i);
                    if (!attributeName.equalsIgnoreCase("peptideEvidence_ref")) continue;
                    peptideEvidenceRef = parser.getAttributeValue(0);
                    break;
                }
                type = parser.next();
            }
            if (peptideRef == null && peptideEvidenceRef == null) {
                System.out.println("spectrumIdItemId: " + spectrumIdItemId);
                throw new IllegalArgumentException("Error parsing SpectrumIdentificationItem!");
            }
            while (parser.getName() == null || parser.getName() != null && parser.getName().equals("PeptideEvidenceRef")) {
                type = parser.next();
            }
            if (parser.getName().equals("Fragmentation")) {
                parser.next();
                while (parser.getName() == null || parser.getName() != null && !parser.getName().equals("Fragmentation")) {
                    parser.next();
                }
                parser.next();
                type = parser.next();
            }
            HashMap<String, Double> eValueMap = new HashMap<String, Double>();
            while (parser.getName() != null && (parser.getName().equals("cvParam") || parser.getName().equals("userParam"))) {
                if (parser.getName().equals("cvParam")) {
                    String accession = null;
                    Double value = null;
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        String attributeName = parser.getAttributeName(i);
                        if (attributeName.equalsIgnoreCase("accession")) {
                            accession = parser.getAttributeValue(i);
                            continue;
                        }
                        if (!attributeName.equalsIgnoreCase("value")) continue;
                        try {
                            value = Double.parseDouble(parser.getAttributeValue(i));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (value != null) {
                        eValueMap.put(accession, value);
                    }
                }
                parser.next();
                parser.next();
                type = parser.next();
            }
            if (parser.getName().equals("SpectrumIdentificationItem") && type == 3) {
                parser.next();
                type = parser.next();
            } else {
                parser.next();
                parser.next();
                type = parser.next();
            }
            EValueObject tempEValue = this.getEValue(eValueMap, spectrumIdItemId);
            Advocate advocate = tempEValue.getAdvocate();
            Double eValue = tempEValue.getEValue();
            Double rawScore = tempEValue.getRawScore();
            if (rawScore == null) {
                rawScore = eValue;
            }
            if (peptideRef == null) {
                peptideRef = this.tempPeptideEvidenceMap.get(peptideEvidenceRef);
            }
            if (!this.tempPeptideMap.containsKey(peptideRef)) {
                System.out.println("spectrumIdItemId: " + spectrumIdItemId);
                throw new IllegalArgumentException("Error parsing SpectrumIdentificationItem!");
            }
            SimplePeptide tempPeptide = this.tempPeptideMap.get(peptideRef);
            ArrayList<ModificationMatch> modMatches = new ArrayList<ModificationMatch>();
            for (SearchModificationCustom tempMod : tempPeptide.getModifications()) {
                if (!this.isVariableModification(tempMod, tempPeptide.getPeptideSequence())) continue;
                int location = tempMod.getLocation();
                if (location == 0) {
                    location = 1;
                } else if (location == tempPeptide.getPeptideSequence().length() + 1) {
                    --location;
                }
                modMatches.add(new ModificationMatch(tempMod.getMassDelta() + "@" + tempPeptide.getPeptideSequence().charAt(location - 1), location));
            }
            Peptide peptide = new Peptide(tempPeptide.getPeptideSequence(), modMatches.toArray(new ModificationMatch[modMatches.size()]), true);
            PeptideAssumption peptideAssumption = new PeptideAssumption(peptide, rank, advocate.getIndex(), chargeState, rawScore, eValue, this.mzIdentMLFileName);
            if (this.expandAaCombinations && AminoAcidSequence.hasCombination(peptideAssumption.getPeptide().getSequence())) {
                ModificationMatch[] previousModificationMatches = peptide.getVariableModifications();
                for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations(peptide.getSequence())) {
                    ModificationMatch[] newModificationMatches = (ModificationMatch[])Arrays.stream(previousModificationMatches).map(modificationMatch -> new ModificationMatch(modificationMatch.getModification(), modificationMatch.getSite())).toArray(ModificationMatch[]::new);
                    Peptide newPeptide = new Peptide(expandedSequence.toString(), newModificationMatches, true);
                    PeptideAssumption newAssumption = new PeptideAssumption(newPeptide, peptideAssumption.getRank(), peptideAssumption.getAdvocate(), peptideAssumption.getIdentificationCharge(), rawScore, peptideAssumption.getScore(), peptideAssumption.getIdentificationFile());
                    currentMatch.addPeptideAssumption(advocate.getIndex(), newAssumption);
                }
                continue;
            }
            currentMatch.addPeptideAssumption(advocate.getIndex(), peptideAssumption);
        }
        while (parser.getName() != null && parser.getName().equals("cvParam")) {
            String accession = null;
            String name = null;
            String value = null;
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String attributeName = parser.getAttributeName(i);
                if (attributeName.equalsIgnoreCase("accession")) {
                    accession = parser.getAttributeValue(i);
                    continue;
                }
                if (attributeName.equalsIgnoreCase("value")) {
                    value = parser.getAttributeValue(i);
                    continue;
                }
                if (!attributeName.equalsIgnoreCase("name")) continue;
                name = parser.getAttributeValue(i);
            }
            if (accession != null && name != null && value != null && (accession.equalsIgnoreCase("MS:1000796") || name.equalsIgnoreCase("spectrum title"))) {
                spectrumTitle = value.trim();
                spectrumTitle = URLDecoder.decode(spectrumTitle, "utf-8");
            }
            parser.next();
            parser.next();
            parser.next();
        }
        if (spectrumTitle != null) {
            currentMatch.setSpectrumTitle(spectrumTitle);
        }
        result.add(currentMatch);
    }

    private EValueObject getEValueObject(HashMap<String, Double> scoreMap, Advocate advocate, String cvTerm, RawValueConversionType rawValueConversionType) {
        EValueObject eValueObject = null;
        Double eValue = scoreMap.get(cvTerm);
        Double rawScore = null;
        if (eValue != null) {
            switch (rawValueConversionType) {
                case noConversion: {
                    break;
                }
                case baseTwoPowerMinusValue: {
                    eValue = Math.pow(2.0, -eValue.doubleValue());
                    break;
                }
                case baseTenPowerMinusValue: {
                    eValue = Math.pow(10.0, -eValue.doubleValue());
                    break;
                }
                case baseTenPowerPlusValue: {
                    eValue = Math.pow(10.0, eValue);
                    break;
                }
                case baseNaturalLogPowerMinusValue: {
                    eValue = Math.pow(Math.E, -eValue.doubleValue());
                    break;
                }
                case oneMinusValue: {
                    eValue = 1.0 - eValue;
                }
            }
            String name = advocate.getName();
            if (!this.softwareVersions.containsKey(name)) {
                ArrayList<String> versions = this.tempSoftwareVersions.get(name);
                if (versions == null) {
                    versions = new ArrayList();
                }
                this.softwareVersions.put(name, versions);
            }
            eValueObject = new EValueObject(eValue, rawScore, advocate);
        }
        return eValueObject;
    }

    private EValueObject getEValue(HashMap<String, Double> scoreMap, String spectrumIdItemId) {
        String cvTerm = "MS:1001589";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.myriMatch, cvTerm, RawValueConversionType.baseNaturalLogPowerMinusValue);
        }
        cvTerm = "MS:1001590";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.myriMatch, cvTerm, RawValueConversionType.baseNaturalLogPowerMinusValue);
        }
        cvTerm = "MS:1002052";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.msgf, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1002053";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.msgf, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1002056";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.msgf, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1002055";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.msgf, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1002054";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.msgf, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1002049";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.msgf, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1002448";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.peaks, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1001950";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.peaks, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1001330";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.xtandem, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1001331";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.xtandem, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1001328";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.omssa, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1001329";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.omssa, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1002319";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.msAmanda, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1002338";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.andromeda, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1002255";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.comet, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1002252";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.comet, cvTerm, RawValueConversionType.baseTenPowerPlusValue);
        }
        cvTerm = "MS:1001172";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.mascot, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1001171";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.mascot, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1002466";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.peptideShaker, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1002467";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.peptideShaker, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1002262";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.byonic, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1002311";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.byonic, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1002265";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.byonic, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1002309";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.byonic, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1002266";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.byonic, cvTerm, RawValueConversionType.baseTenPowerPlusValue);
        }
        cvTerm = "MS:1001501";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.msFit, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1001396";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.phenyx, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1001395";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.phenyx, cvTerm, RawValueConversionType.baseTwoPowerMinusValue);
        }
        cvTerm = "MS:1001499";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.proFound, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1001498";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.proFound, cvTerm, RawValueConversionType.baseTwoPowerMinusValue);
        }
        cvTerm = "MS:1001570";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.proteinLynx, cvTerm, RawValueConversionType.baseTenPowerPlusValue);
        }
        cvTerm = "MS:1001569";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.proteinLynx, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1002045";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.proteinProspector, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1002044";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.proteinProspector, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1001503";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.proteinScape, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1001504";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.proteinScape, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1001154";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.sequest, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1001155";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.sequest, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1001215";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.sequest, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1002248";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.sequest, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1001887";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.sqid, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1001502";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.sonar, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1001417";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.spectraST, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1001572";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.spectrumMill, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1001952";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.zCore, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1001491";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.percolator, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1001493";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.percolator, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1001492";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.percolator, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1002662";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.morpheus, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1002827";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.metaMorpheus, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1002354";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.morpheus, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1002353";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.identiPy, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1002989";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.identiPy, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1001166";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.proteinPilot, cvTerm, RawValueConversionType.baseTenPowerMinusValue);
        }
        cvTerm = "MS:1001167";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.proteinPilot, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1001568";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, Advocate.scaffold, cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1002354";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, this.getAdvocate(), cvTerm, RawValueConversionType.noConversion);
        }
        cvTerm = "MS:1002357";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, this.getAdvocate(), cvTerm, RawValueConversionType.oneMinusValue);
        }
        cvTerm = "MS:1002352";
        if (scoreMap.containsKey(cvTerm)) {
            return this.getEValueObject(scoreMap, this.getAdvocate(), cvTerm, RawValueConversionType.oneMinusValue);
        }
        throw new IllegalArgumentException("No e-value found for SpectrumIdentificationItem with ID " + spectrumIdItemId + " in file " + this.mzIdentMLFileName + ".");
    }

    private class SimplePeptide {
        private String peptideSequence;
        private ArrayList<SearchModificationCustom> modifications;

        public SimplePeptide(String peptideSequence, ArrayList<SearchModificationCustom> modifications) {
            this.peptideSequence = peptideSequence;
            this.modifications = modifications;
        }

        public String getPeptideSequence() {
            return this.peptideSequence;
        }

        public ArrayList<SearchModificationCustom> getModifications() {
            return this.modifications;
        }
    }

    private class SearchModificationCustom {
        private String accession;
        private String residues;
        private double massDelta;
        private ArrayList<String> modRuleCvTerms;
        private int location;

        public SearchModificationCustom(String accession, int location, double massDelta) {
            this.accession = accession;
            this.location = location;
            this.massDelta = massDelta;
        }

        public SearchModificationCustom(String accession, String residues, double massDelta, ArrayList<String> modRuleCvTerms) {
            this.accession = accession;
            this.residues = residues;
            this.massDelta = massDelta;
            this.modRuleCvTerms = modRuleCvTerms;
        }

        public String getResidues() {
            return this.residues;
        }

        public double getMassDelta() {
            return this.massDelta;
        }

        public ArrayList<String> getModRuleCvTerms() {
            return this.modRuleCvTerms;
        }

        public String getAccession() {
            return this.accession;
        }

        public int getLocation() {
            return this.location;
        }
    }

    private class EValueObject {
        private Double eValue;
        private Advocate advocate;
        private Double rawScore;

        public EValueObject(Double eValue, Double rawScore, Advocate advocate) {
            this.eValue = eValue;
            this.rawScore = rawScore;
            this.advocate = advocate;
        }

        public Double getEValue() {
            return this.eValue;
        }

        public Double getRawScore() {
            return this.rawScore;
        }

        public Advocate getAdvocate() {
            return this.advocate;
        }
    }

    public static enum RawValueConversionType {
        noConversion,
        baseTwoPowerMinusValue,
        baseTenPowerMinusValue,
        baseTenPowerPlusValue,
        baseNaturalLogPowerMinusValue,
        oneMinusValue;

    }
}

