/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identification.idfilereaders;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XTandemIdfileReader
extends ExperimentObject
implements IdfileReader {
    private File inputFile = null;
    private final HashMap<Integer, SpectrumMatch> allMatches = new HashMap();
    private String spectrumFileName;
    private String softwareVersion;

    public XTandemIdfileReader() {
    }

    public XTandemIdfileReader(File inputFile) throws IOException {
        this(inputFile, null);
    }

    public XTandemIdfileReader(File inputFile, WaitingHandler waitingHandler) throws IOException {
        this.inputFile = inputFile;
    }

    @Override
    public String getExtension() {
        return ".t.xml";
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException, XMLStreamException {
        return this.getAllSpectrumMatches(spectrumProvider, waitingHandler, searchParameters, null, false);
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException, XMLStreamException {
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(100);
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        HashSet fixedNonTerminalModifications = searchParameters.getModificationParameters().getFixedModifications().stream().map(modName -> modificationFactory.getModification((String)modName)).filter(modification -> modification.getModificationType() == ModificationType.modaa).flatMap(mod -> mod.getPattern().getAminoAcidsAtTarget().stream().map(aa -> this.trimModificationName(String.join((CharSequence)"@", Double.toString(mod.getMass()), aa.toString())))).collect(Collectors.toCollection(HashSet::new));
        HashSet<String> fixedNTerminalModifications = new HashSet<String>();
        HashSet<String> fixedCTerminalModifications = new HashSet<String>();
        ArrayList<String> allFixedModifications = searchParameters.getModificationParameters().getFixedModifications();
        block31: for (String tempFixedModification : allFixedModifications) {
            Modification tempModification = modificationFactory.getModification(tempFixedModification);
            if (tempModification.getModificationType() == ModificationType.modaa) continue;
            switch (tempModification.getModificationType()) {
                case modn_protein: 
                case modn_peptide: {
                    for (String tempAminoAcid : AminoAcid.getAminoAcidsList()) {
                        fixedNTerminalModifications.add(this.trimModificationName(String.join((CharSequence)"@", Double.toString(tempModification.getMass()), tempAminoAcid)));
                    }
                    continue block31;
                }
                case modnaa_protein: 
                case modnaa_peptide: {
                    for (Character tempCharacter : tempModification.getPattern().getAminoAcidsAtTarget()) {
                        fixedNTerminalModifications.add(this.trimModificationName(String.join((CharSequence)"@", Double.toString(tempModification.getMass()), tempCharacter.toString())));
                    }
                    continue block31;
                }
                case modc_protein: 
                case modc_peptide: {
                    for (String tempAminoAcid : AminoAcid.getAminoAcidsList()) {
                        fixedCTerminalModifications.add(this.trimModificationName(String.join((CharSequence)"@", Double.toString(tempModification.getMass()), tempAminoAcid)));
                    }
                    continue block31;
                }
                case modcaa_protein: 
                case modcaa_peptide: {
                    for (Character tempCharacter : tempModification.getPattern().getAminoAcidsAtTarget()) {
                        fixedCTerminalModifications.add(this.trimModificationName(String.join((CharSequence)"@", Double.toString(tempModification.getMass()), tempCharacter.toString())));
                    }
                    continue block31;
                }
            }
        }
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(this.inputFile);){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader parser = factory.createXMLStreamReader(reader.getReader());
            while (parser.hasNext()) {
                double progress = reader.getProgressInPercent();
                waitingHandler.setSecondaryProgressCounter((int)progress);
                parser.next();
                block10 : switch (parser.getEventType()) {
                    case 7: {
                        break;
                    }
                    case 8: {
                        parser.close();
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 1: {
                        String element = parser.getLocalName();
                        if (element.equalsIgnoreCase("group") && parser.getAttributeValue("", "type") != null) {
                            switch (parser.getAttributeValue("", "type").toLowerCase()) {
                                case "model": {
                                    int id = Integer.parseInt(parser.getAttributeValue("", "id"));
                                    SpectrumMatch spectrumMatch = new SpectrumMatch(this.spectrumFileName, Integer.toString(id));
                                    this.allMatches.put(id, spectrumMatch);
                                    double expect = Double.parseDouble(parser.getAttributeValue("", "expect"));
                                    this.readGroupOrProtein(parser, id, expect, fixedNonTerminalModifications, fixedNTerminalModifications, fixedCTerminalModifications);
                                    break block10;
                                }
                                case "parameters": {
                                    this.readParameters(parser);
                                    break block10;
                                }
                            }
                            break;
                        }
                        if (!element.equalsIgnoreCase("bioml")) break;
                        this.spectrumFileName = parser.getAttributeValue("", "label");
                        this.spectrumFileName = this.spectrumFileName.split("'")[1];
                        this.spectrumFileName = new File(this.spectrumFileName.replaceAll("\\\\", "/")).getName();
                        break;
                    }
                }
            }
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
            if (expandAaCombinations) {
                for (SpectrumMatch spectrumMatch : this.allMatches.values()) {
                    spectrumMatch.getAllPeptideAssumptions().forEach(currentAssumption -> {
                        Peptide peptide = currentAssumption.getPeptide();
                        String peptideSequence = peptide.getSequence();
                        ModificationMatch[] foundModifications = peptide.getVariableModifications();
                        if (AminoAcidSequence.hasCombination(peptideSequence)) {
                            for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations(peptide.getSequence())) {
                                if (expandedSequence.toString().equals(peptideSequence)) continue;
                                ModificationMatch[] newModificationMatches = (ModificationMatch[])Arrays.stream(foundModifications).map(modificationMatch -> modificationMatch.clone()).toArray(ModificationMatch[]::new);
                                Peptide newPeptide = new Peptide(expandedSequence.toString(), newModificationMatches);
                                PeptideAssumption newAssumption = new PeptideAssumption(newPeptide, currentAssumption.getRank(), currentAssumption.getAdvocate(), currentAssumption.getIdentificationCharge(), currentAssumption.getScore(), currentAssumption.getScore(), currentAssumption.getIdentificationFile());
                                spectrumMatch.addPeptideAssumption(Advocate.xtandem.getIndex(), newAssumption);
                            }
                        }
                    });
                }
            }
        }
        return new ArrayList<SpectrumMatch>(this.allMatches.values());
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add(this.softwareVersion);
        result.put("X!Tandem", versions);
        return result;
    }

    @Override
    public boolean hasDeNovoTags() {
        return false;
    }

    private void readGroupOrProtein(XMLStreamReader parser, int id, double expect, HashSet<String> fixedNonTerminalModifications, HashSet<String> fixedNTerminalModifications, HashSet<String> fixedCTerminalModifications) throws XMLStreamException, UnsupportedEncodingException {
        block16: while (parser.hasNext()) {
            parser.next();
            switch (parser.getEventType()) {
                case 7: {
                    return;
                }
                case 8: {
                    return;
                }
                case 13: {
                    continue block16;
                }
                case 4: {
                    continue block16;
                }
                case 2: {
                    if (!"group".equalsIgnoreCase(parser.getLocalName())) continue block16;
                    return;
                }
                case 1: {
                    switch (parser.getLocalName().toLowerCase()) {
                        case "group": {
                            if (parser.getAttributeValue("", "label") == null || !"fragment ion mass spectrum".equalsIgnoreCase(parser.getAttributeValue("", "label"))) break;
                            this.readGroupFragment(parser, id);
                            break;
                        }
                        case "protein": {
                            this.readProtein(parser, id, expect, fixedNonTerminalModifications, fixedNTerminalModifications, fixedCTerminalModifications);
                            break;
                        }
                    }
                    continue block16;
                }
            }
        }
    }

    private void readGroupFragment(XMLStreamReader parser, int id) throws XMLStreamException, UnsupportedEncodingException {
        boolean write = false;
        StringBuilder content = new StringBuilder();
        block16: while (parser.hasNext()) {
            parser.next();
            switch (parser.getEventType()) {
                case 7: {
                    return;
                }
                case 8: {
                    return;
                }
                case 13: {
                    continue block16;
                }
                case 4: {
                    if (!write) continue block16;
                    content.append(parser.getText());
                    continue block16;
                }
                case 2: {
                    if ("note".equalsIgnoreCase(parser.getLocalName()) && write) {
                        String value = content.toString().trim();
                        String title = URLDecoder.decode(value, "utf-8");
                        if (title.contains("RTINSECONDS")) {
                            title = title.split("RTINSECONDS")[0].trim();
                        }
                        SpectrumMatch spectrumMatch = this.allMatches.get(id);
                        spectrumMatch.setSpectrumTitle(title);
                        content = new StringBuilder();
                        write = false;
                        continue block16;
                    }
                    if (!"group".equalsIgnoreCase(parser.getLocalName())) continue block16;
                    return;
                }
                case 1: {
                    switch (parser.getLocalName().toLowerCase()) {
                        case "note": {
                            write = true;
                            break;
                        }
                        case "trace": {
                            if (parser.getAttributeValue("", "type") == null || !"tandem mass spectrum".equalsIgnoreCase(parser.getAttributeValue("", "type"))) break;
                            this.readGroupFragmentTrace(parser, id);
                            break;
                        }
                    }
                    continue block16;
                }
            }
        }
    }

    private void readGroupFragmentTrace(XMLStreamReader parser, int id) throws XMLStreamException {
        boolean readCharge = false;
        block14: while (parser.hasNext()) {
            parser.next();
            switch (parser.getEventType()) {
                case 7: {
                    return;
                }
                case 8: {
                    return;
                }
                case 13: {
                    continue block14;
                }
                case 4: {
                    if (readCharge) {
                        int chrg = Integer.parseInt(parser.getText());
                        this.allMatches.get(id).getAllPeptideAssumptions().forEach(peptideAssumption -> peptideAssumption.setIdentificationCharge(chrg));
                    }
                    readCharge = false;
                    continue block14;
                }
                case 2: {
                    if (!"trace".equalsIgnoreCase(parser.getLocalName())) continue block14;
                    return;
                }
                case 1: {
                    switch (parser.getLocalName().toLowerCase()) {
                        case "attribute": {
                            if (!"charge".equalsIgnoreCase(parser.getAttributeValue("", "type"))) break;
                            readCharge = true;
                            break;
                        }
                    }
                    continue block14;
                }
            }
        }
    }

    private void readProtein(XMLStreamReader parser, int id, double expect, HashSet<String> fixedNonTerminalModifications, HashSet<String> fixedNTerminalModifications, HashSet<String> fixedCTerminalModifications) throws XMLStreamException {
        block8: while (parser.hasNext()) {
            parser.next();
            switch (parser.getEventType()) {
                case 7: {
                    return;
                }
                case 8: {
                    return;
                }
                case 13: {
                    continue block8;
                }
                case 4: {
                    continue block8;
                }
                case 2: {
                    if (!"protein".equalsIgnoreCase(parser.getLocalName())) continue block8;
                    return;
                }
                case 1: {
                    if (!"peptide".equalsIgnoreCase(parser.getLocalName().toLowerCase())) continue block8;
                    this.readPeptide(parser, id, expect, fixedNonTerminalModifications, fixedNTerminalModifications, fixedCTerminalModifications);
                    continue block8;
                }
            }
        }
    }

    private void readPeptide(XMLStreamReader parser, int id, double expect, HashSet<String> fixedNonTerminalModifications, HashSet<String> fixedNTerminalModifications, HashSet<String> fixedCTerminalModifications) throws XMLStreamException {
        Peptide peptide = null;
        int pepStart = -1;
        boolean addAA = false;
        block16: while (parser.hasNext()) {
            parser.next();
            switch (parser.getEventType()) {
                case 7: {
                    return;
                }
                case 8: {
                    return;
                }
                case 13: {
                    continue block16;
                }
                case 4: {
                    continue block16;
                }
                case 2: {
                    if ("domain".equalsIgnoreCase(parser.getLocalName())) {
                        addAA = false;
                        continue block16;
                    }
                    if (!"peptide".equalsIgnoreCase(parser.getLocalName())) continue block16;
                    return;
                }
                case 1: {
                    switch (parser.getLocalName().toLowerCase()) {
                        case "domain": {
                            String pepSeq = parser.getAttributeValue("", "seq");
                            boolean adding = true;
                            if (this.allMatches.get(id).getAllPeptideAssumptions(Advocate.xtandem.getIndex()) != null) {
                                ArrayList<PeptideAssumption> matchAssuptions = this.allMatches.get(id).getAllPeptideAssumptions(Advocate.xtandem.getIndex()).get(expect);
                                for (int i = 0; i < matchAssuptions.size(); ++i) {
                                    if (!matchAssuptions.get(i).getPeptide().getSequence().equals(pepSeq)) continue;
                                    adding = false;
                                    break;
                                }
                            }
                            if (!adding) break;
                            peptide = new Peptide(pepSeq);
                            PeptideAssumption currentAssumption = new PeptideAssumption(peptide, 1, Advocate.xtandem.getIndex(), 0, expect, expect, this.inputFile.getName());
                            this.allMatches.get(id).addPeptideAssumption(Advocate.xtandem.getIndex(), currentAssumption);
                            pepStart = Integer.parseInt(parser.getAttributeValue("", "start"));
                            addAA = true;
                            break;
                        }
                        case "aa": {
                            if (!addAA) break;
                            String modName = String.join((CharSequence)"@", parser.getAttributeValue("", "modified"), parser.getAttributeValue("", "type"));
                            int modPosition = Integer.parseInt(parser.getAttributeValue("", "at")) - pepStart + 1;
                            String reformattedName = this.trimModificationName(modName);
                            if (modPosition == 1 && !fixedNTerminalModifications.isEmpty() && fixedNTerminalModifications.contains(reformattedName) || modPosition == peptide.getSequence().length() && !fixedCTerminalModifications.isEmpty() && fixedCTerminalModifications.contains(reformattedName)) break;
                            if (fixedNonTerminalModifications.contains(reformattedName)) continue block16;
                            peptide.addVariableModification(new ModificationMatch(modName, modPosition));
                            break;
                        }
                    }
                    continue block16;
                }
            }
        }
    }

    private void readParameters(XMLStreamReader parser) throws XMLStreamException, UnsupportedEncodingException {
        int theCase = 0;
        block13: while (parser.hasNext()) {
            parser.next();
            switch (parser.getEventType()) {
                case 7: {
                    return;
                }
                case 8: {
                    return;
                }
                case 13: {
                    continue block13;
                }
                case 4: {
                    switch (theCase) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            this.softwareVersion = parser.getText().trim();
                            break;
                        }
                    }
                    theCase = 0;
                    continue block13;
                }
                case 2: {
                    if (!"group".equalsIgnoreCase(parser.getLocalName())) continue block13;
                    return;
                }
                case 1: {
                    if (!"note".equalsIgnoreCase(parser.getLocalName())) continue block13;
                    String label = parser.getAttributeValue("", "label").toLowerCase();
                    if (label.startsWith("residue, modification mass")) {
                        theCase = 1;
                        continue block13;
                    }
                    if (label.startsWith("residue, potential modification mass")) {
                        theCase = 2;
                        continue block13;
                    }
                    if (!"process, version".equalsIgnoreCase(label)) continue block13;
                    theCase = 3;
                    continue block13;
                }
            }
        }
    }

    private String trimModificationName(String modification) {
        int indexPoint = modification.indexOf(".");
        int size = modification.length();
        if (indexPoint >= 0) {
            modification = modification.substring(0, indexPoint + 5) + modification.substring(size - 2, size);
        }
        return modification;
    }
}

