/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identification.writers;

import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.biology.ions.impl.ImmoniumIon;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.ions.impl.PrecursorIon;
import com.compomics.util.experiment.biology.ions.impl.RelatedIon;
import com.compomics.util.experiment.biology.ions.impl.ReporterIon;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationProvider;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.utils.ModificationUtils;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.io.identification.MzIdentMLVersion;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.compression.SectionGzWriter.WriterBySection;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.pride.CvTerm;
import com.compomics.util.threading.SimpleSemaphore;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.text.StringEscapeUtils;

public class SimpleMzIdentMLExporter
implements Closeable {
    public static final String HEAD_SECTION = "HEAD_SECTION";
    public static final String PEPTIDE_SECTION = "PEPTIDE_SECTION";
    public static final String PEPTIDE_EVIDENCE_SECTION = "PEPTIDE_EVIDENCE_SECTION";
    public static final String ANALYSIS_SECTION = "ANALYSIS_SECTION";
    public static final String DATA_SECTION = "DATA_SECTION";
    public static final MzIdentMLVersion MZIDENTML_VERSION = MzIdentMLVersion.v1_2;
    private final boolean peptideInference;
    public static final int MAX_NEUTRAL_LOSSES = 2;
    public static final int N_AA = 1;
    private final WriterBySection writer;
    private final ArrayList<File> spectrumFiles;
    private final File searchEngineFile;
    private final File fastaFile;
    private final HashMap<String, ArrayList<String>> searchEngines;
    private final ConcurrentHashMap<String, Integer> indentationMap = new ConcurrentHashMap(6);
    private final ModificationProvider modificationProvider;
    private final SequenceProvider sequenceProvider;
    private final SpectrumProvider spectrumProvider;
    private final FastaSummary fastaSummary;
    private final ProteinDetailsProvider proteinDetailsProvider;
    private final String softwareName;
    private final String softwareVersion;
    private final String softwareUrl;
    private final ConcurrentHashMap<String, String> pepEvidenceIds = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Peptide> debugMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Integer> spectrumTitleToIndexMap = new ConcurrentHashMap();
    private final HashSet<Long> peptideKeys = new HashSet();
    private int psmCount = 0;
    private final IdentificationParameters identificationParameters;
    private final HashMap<Double, Integer> modIndexMap = new HashMap();
    private final SimpleSemaphore peptideSemaphore = new SimpleSemaphore(1);
    private final SimpleSemaphore spectrumSemaphore = new SimpleSemaphore(1);
    private final SimpleSemaphore spectrumMatchSemaphore = new SimpleSemaphore(1);
    private int peptideEvidenceCounter = 0;
    private final SimpleSemaphore initSemaphore = new SimpleSemaphore(1);
    private Exception initException = null;

    public SimpleMzIdentMLExporter(String softwareName, String softwareVersion, String softwareUrl, File tempFolder, File destinationFile, ArrayList<File> spectrumFiles, File searchEngineFile, HashMap<String, ArrayList<String>> searchEngines, File fastaFile, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider, ModificationProvider modificationProvider, FastaSummary fastaSummary, String contactFirstName, String contactLastName, String contactAddress, String contactEmail, String contactOrganizationName, String contactOrganizationAddress, String contactOrganizationEmail, boolean peptideInference) throws FileNotFoundException, IOException {
        this.softwareName = softwareName;
        this.softwareVersion = softwareVersion;
        this.softwareUrl = softwareUrl;
        this.spectrumFiles = spectrumFiles;
        this.searchEngineFile = searchEngineFile;
        this.searchEngines = searchEngines;
        this.fastaFile = fastaFile;
        this.identificationParameters = identificationParameters;
        this.sequenceProvider = sequenceProvider;
        this.proteinDetailsProvider = proteinDetailsProvider;
        this.spectrumProvider = spectrumProvider;
        this.modificationProvider = modificationProvider;
        this.fastaSummary = fastaSummary;
        this.peptideInference = peptideInference;
        this.writer = new WriterBySection(destinationFile, tempFolder, false, false, true);
        this.initWriter();
        this.initIndentationMap();
        this.init(contactFirstName, contactLastName, contactAddress, contactEmail, contactOrganizationName, contactOrganizationAddress, contactOrganizationEmail);
    }

    public void init(final String contactFirstName, final String contactLastName, final String contactAddress, final String contactEmail, final String contactOrganizationName, final String contactOrganizationAddress, final String contactOrganizationEmail) {
        this.initSemaphore.acquire();
        new Thread(HEAD_SECTION){

            @Override
            public synchronized void run() {
                try {
                    SimpleMzIdentMLExporter.this.writeMzIdentMLStartTag();
                    SimpleMzIdentMLExporter.this.writeCvList();
                    SimpleMzIdentMLExporter.this.writeAnalysisSoftwareList();
                    SimpleMzIdentMLExporter.this.writeProviderDetails();
                    SimpleMzIdentMLExporter.this.writeAuditCollection(contactFirstName, contactLastName, contactAddress, contactEmail, contactOrganizationName, contactOrganizationAddress, contactOrganizationEmail);
                    SimpleMzIdentMLExporter.this.writeProteinSequenceCollection();
                    SimpleMzIdentMLExporter.this.writer.sectionCompleted(SimpleMzIdentMLExporter.HEAD_SECTION);
                }
                catch (Exception e) {
                    SimpleMzIdentMLExporter.this.initException = e;
                    throw e;
                }
                finally {
                    SimpleMzIdentMLExporter.this.initSemaphore.release();
                }
            }
        }.start();
        this.writeAnalysisCollection();
        this.writeAnalysisProtocol();
        this.setupDataCollection();
    }

    public void finalizeFile() {
        this.initSemaphore.acquire();
        if (this.initException != null) {
            throw new IllegalArgumentException("An error occurred while initializing the mzIdentML file.", this.initException);
        }
        this.initSemaphore.release();
        this.writer.sectionCompleted(PEPTIDE_SECTION);
        this.finalizePeptideEvidenceSection();
        this.writer.sectionCompleted(PEPTIDE_EVIDENCE_SECTION);
        this.writer.sectionCompleted(ANALYSIS_SECTION);
        this.finalizeDataCollection();
        this.writeMzIdentMLEndTag();
        this.writer.sectionCompleted(DATA_SECTION);
    }

    private void writeMzIdentMLStartTag() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.writer.write(HEAD_SECTION, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writer.newLine(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, "<MzIdentML id=\"" + this.softwareName + " v" + this.softwareVersion + "\" xmlns:xsi=\"https://www.w3.org/2001/XMLSchema-instance\"  xmlns=\"http://psidev.info/psi/pi/mzIdentML/1.2\" version=\"1.2.0\" creationDate=\"" + dateFormat.format(new Date()) + "\">");
        this.writer.newLine(HEAD_SECTION);
        this.increaseIndentation(HEAD_SECTION);
    }

    private void writeCvList() {
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<cvList>");
        this.writer.newLine(HEAD_SECTION);
        this.increaseIndentation(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<cv id=\"PSI-MS\" ");
        this.writer.write(HEAD_SECTION, "uri=\"https://raw.githubusercontent.com/HUPO-PSI/psi-ms-CV/master/psi-ms.obo\" ");
        this.writer.write(HEAD_SECTION, "fullName=\"PSI-MS\"/>");
        this.writer.newLine(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<cv id=\"UNIMOD\" ");
        this.writer.write(HEAD_SECTION, "uri=\"http://www.unimod.org/obo/unimod.obo\" ");
        this.writer.write(HEAD_SECTION, "fullName=\"UNIMOD\"/>");
        this.writer.newLine(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<cv id=\"UO\" ");
        this.writer.write(HEAD_SECTION, "uri=\"https://raw.githubusercontent.com/bio-ontology-research-group/unit-ontology/master/unit.obo\" ");
        this.writer.write(HEAD_SECTION, "fullName=\"UNIT-ONTOLOGY\"/>");
        this.writer.newLine(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<cv id=\"PRIDE\" ");
        this.writer.write(HEAD_SECTION, "uri=\"https://github.com/PRIDE-Utilities/pride-ontology/blob/master/pride_cv.obo\" ");
        this.writer.write(HEAD_SECTION, "fullName=\"PRIDE\"/>");
        this.writer.newLine(HEAD_SECTION);
        this.decreaseIndent(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "</cvList>");
        this.writer.newLine(HEAD_SECTION);
    }

    private void writeAnalysisSoftwareList() {
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<AnalysisSoftwareList>");
        this.writer.newLine(HEAD_SECTION);
        this.increaseIndentation(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<AnalysisSoftware name=\"");
        this.writer.write(HEAD_SECTION, this.softwareName);
        this.writer.write(HEAD_SECTION, "\" version=\"");
        this.writer.write(HEAD_SECTION, this.softwareVersion);
        this.writer.write(HEAD_SECTION, "\" id=\"ID_software\" uri=\"");
        this.writer.write(HEAD_SECTION, this.softwareUrl);
        this.writer.write(HEAD_SECTION, "\">");
        this.writer.newLine(HEAD_SECTION);
        this.increaseIndentation(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<ContactRole contact_ref=\"PS_DEV\">");
        this.writer.newLine(HEAD_SECTION);
        this.increaseIndentation(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<Role>");
        this.writer.newLine(HEAD_SECTION);
        this.increaseIndentation(HEAD_SECTION);
        this.writeCvTerm(HEAD_SECTION, new CvTerm("PSI-MS", "MS:1001267", "software vendor", null));
        this.decreaseIndent(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "</Role>");
        this.writer.newLine(HEAD_SECTION);
        this.decreaseIndent(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "</ContactRole>");
        this.writer.newLine(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<SoftwareName>");
        this.writer.newLine(HEAD_SECTION);
        this.increaseIndentation(HEAD_SECTION);
        this.writeCvTerm(HEAD_SECTION, new CvTerm("PSI-MS", "MS:1002458", "PeptideShaker", null));
        this.decreaseIndent(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "</SoftwareName>");
        this.writer.newLine(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<Customizations>No customisations</Customizations>");
        this.writer.newLine(HEAD_SECTION);
        this.decreaseIndent(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "</AnalysisSoftware>");
        this.writer.newLine(HEAD_SECTION);
        this.decreaseIndent(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "</AnalysisSoftwareList>");
        this.writer.newLine(HEAD_SECTION);
    }

    private void writeProviderDetails() {
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<Provider id=\"PROVIDER\">");
        this.writer.newLine(HEAD_SECTION);
        this.increaseIndentation(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<ContactRole contact_ref=\"PROVIDER\">");
        this.writer.newLine(HEAD_SECTION);
        this.increaseIndentation(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<Role>");
        this.writer.newLine(HEAD_SECTION);
        this.increaseIndentation(HEAD_SECTION);
        this.writeCvTerm(HEAD_SECTION, new CvTerm("PSI-MS", "MS:1001271", "researcher", null));
        this.decreaseIndent(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "</Role>");
        this.writer.newLine(HEAD_SECTION);
        this.decreaseIndent(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "</ContactRole>");
        this.writer.newLine(HEAD_SECTION);
        this.decreaseIndent(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "</Provider>");
        this.writer.newLine(HEAD_SECTION);
    }

    private void writeAuditCollection(String contactFirstName, String contactLastName, String contactAddress, String contactEmail, String contactOrganizationName, String contactOrganizationAddress, String contactOrganizationEmail) {
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<AuditCollection>");
        this.writer.newLine(HEAD_SECTION);
        this.increaseIndentation(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<Person firstName=\"");
        this.writer.write(HEAD_SECTION, contactFirstName);
        this.writer.write(HEAD_SECTION, "\" lastName=\"");
        this.writer.write(HEAD_SECTION, contactLastName);
        this.writer.write(HEAD_SECTION, "\" id=\"PROVIDER\">");
        this.writer.newLine(HEAD_SECTION);
        this.increaseIndentation(HEAD_SECTION);
        this.writeCvTerm(HEAD_SECTION, new CvTerm("PSI-MS", "MS:1000587", "contact address", StringEscapeUtils.escapeHtml4((String)contactAddress)));
        this.writeCvTerm(HEAD_SECTION, new CvTerm("PSI-MS", "MS:1000589", "contact email", contactEmail));
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<Affiliation organization_ref=\"ORG_DOC_OWNER\"/>");
        this.writer.newLine(HEAD_SECTION);
        this.decreaseIndent(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "</Person>");
        this.writer.newLine(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<Organization name=\"");
        this.writer.write(HEAD_SECTION, StringEscapeUtils.escapeHtml4((String)contactOrganizationName));
        this.writer.write(HEAD_SECTION, "\" id=\"ORG_DOC_OWNER\">");
        this.writer.newLine(HEAD_SECTION);
        this.increaseIndentation(HEAD_SECTION);
        this.writeCvTerm(HEAD_SECTION, new CvTerm("PSI-MS", "MS:1000586", "contact name", StringEscapeUtils.escapeHtml4((String)contactOrganizationName)));
        this.writeCvTerm(HEAD_SECTION, new CvTerm("PSI-MS", "MS:1000587", "contact address", StringEscapeUtils.escapeHtml4((String)contactOrganizationAddress)));
        this.writeCvTerm(HEAD_SECTION, new CvTerm("PSI-MS", "MS:1000589", "contact email", contactOrganizationEmail));
        this.decreaseIndent(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "</Organization>");
        this.writer.newLine(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<Organization name=\"PeptideShaker developers\" id=\"PS_DEV\">");
        this.writer.newLine(HEAD_SECTION);
        this.increaseIndentation(HEAD_SECTION);
        this.writeCvTerm(HEAD_SECTION, new CvTerm("PSI-MS", "MS:1000586", "contact name", "PeptideShaker developers"));
        this.writeCvTerm(HEAD_SECTION, new CvTerm("PSI-MS", "MS:1000587", "contact address", "Proteomics Unit, Building for Basic Biology, University of Bergen, Jonas Liesvei 91, N-5009 Bergen, Norway"));
        this.writeCvTerm(HEAD_SECTION, new CvTerm("PSI-MS", "MS:1000588", "contact URL", "https://compomics.github.io/projects/peptide-shaker.html"));
        this.writeCvTerm(HEAD_SECTION, new CvTerm("PSI-MS", "MS:1000589", "contact email", "peptide-shaker@googlegroups.com"));
        this.decreaseIndent(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "</Organization>");
        this.writer.newLine(HEAD_SECTION);
        this.decreaseIndent(HEAD_SECTION);
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "</AuditCollection>");
        this.writer.newLine(HEAD_SECTION);
    }

    private void writeProteinSequenceCollection() {
        this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
        this.writer.write(HEAD_SECTION, "<SequenceCollection>");
        this.writer.newLine(HEAD_SECTION);
        this.increaseIndentation(HEAD_SECTION);
        for (String accession : this.sequenceProvider.getAccessions()) {
            this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
            this.writer.write(HEAD_SECTION, "<DBSequence id=\"");
            this.writer.write(HEAD_SECTION, accession);
            this.writer.write(HEAD_SECTION, "\" ");
            this.writer.write(HEAD_SECTION, "accession=\"");
            this.writer.write(HEAD_SECTION, accession);
            this.writer.write(HEAD_SECTION, "\" searchDatabase_ref=\"SearchDB_1\" >");
            this.writer.newLine(HEAD_SECTION);
            this.increaseIndentation(HEAD_SECTION);
            String sequence = this.sequenceProvider.getSequence(accession);
            this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
            this.writer.write(HEAD_SECTION, "<Seq>");
            this.writer.write(HEAD_SECTION, sequence);
            this.writer.write(HEAD_SECTION, "</Seq>");
            this.writer.newLine(HEAD_SECTION);
            String description = this.proteinDetailsProvider.getDescription(accession);
            this.writeCvTerm(HEAD_SECTION, new CvTerm("PSI-MS", "MS:1001088", "protein description", StringEscapeUtils.escapeHtml4((String)description)));
            this.decreaseIndent(HEAD_SECTION);
            this.writer.write(HEAD_SECTION, this.getCurrentIndentation(HEAD_SECTION));
            this.writer.write(HEAD_SECTION, "</DBSequence>");
            this.writer.newLine(HEAD_SECTION);
        }
    }

    public void addSpectrum(String spectrumFile, String spectrumTitle, ArrayList<PeptideAssumption> peptideAssumptions, ArrayList<TreeMap<Double, HashMap<Integer, Double>>> modificationLocalizationScores, PeptideSpectrumAnnotator peptideSpectrumAnnotator) {
        Integer spectrumIndex = this.spectrumTitleToIndexMap.get(spectrumTitle);
        if (spectrumIndex != null) {
            throw new IllegalArgumentException("Multiple entries for the same spectrum.");
        }
        this.spectrumSemaphore.acquire();
        spectrumIndex = this.spectrumTitleToIndexMap.size();
        this.spectrumTitleToIndexMap.put(spectrumTitle, spectrumIndex);
        this.spectrumSemaphore.release();
        for (PeptideAssumption peptideAssumption : peptideAssumptions) {
            Peptide peptide = peptideAssumption.getPeptide();
            long peptideKey = this.peptideInference ? peptide.getMatchingKey(this.identificationParameters.getSequenceMatchingParameters()) : peptide.getKey();
            if (this.peptideKeys.contains(peptideKey)) continue;
            this.peptideSemaphore.acquire();
            if (!this.peptideKeys.contains(peptideKey)) {
                this.writePeptide(peptide);
                this.peptideKeys.add(peptideKey);
            }
            this.peptideSemaphore.release();
        }
        this.spectrumMatchSemaphore.acquire();
        this.writeSpectrumIdentificationResult(spectrumFile, spectrumTitle, peptideAssumptions, modificationLocalizationScores, peptideSpectrumAnnotator);
        this.spectrumMatchSemaphore.release();
    }

    private void writePeptide(Peptide peptide) {
        String peptideSequence = peptide.getSequence();
        long peptideKey = this.peptideInference ? peptide.getMatchingKey(this.identificationParameters.getSequenceMatchingParameters()) : peptide.getKey();
        this.writer.write(PEPTIDE_SECTION, this.getCurrentIndentation(PEPTIDE_SECTION));
        this.writer.write(PEPTIDE_SECTION, "<Peptide id=\"");
        this.writer.write(PEPTIDE_SECTION, Long.toString(peptideKey));
        this.writer.write(PEPTIDE_SECTION, "\">");
        this.writer.newLine(PEPTIDE_SECTION);
        this.increaseIndentation(PEPTIDE_SECTION);
        this.writer.write(PEPTIDE_SECTION, this.getCurrentIndentation(PEPTIDE_SECTION));
        this.writer.write(PEPTIDE_SECTION, "<PeptideSequence>");
        this.writer.write(PEPTIDE_SECTION, peptideSequence);
        this.writer.write(PEPTIDE_SECTION, "</PeptideSequence>");
        this.writer.newLine(PEPTIDE_SECTION);
        String[] fixedModifications = peptide.getFixedModifications(this.identificationParameters.getSearchParameters().getModificationParameters(), this.sequenceProvider, this.identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters());
        for (int site = 0; site < fixedModifications.length; ++site) {
            String string = fixedModifications[site];
            if (string == null) continue;
            Modification modification = this.modificationProvider.getModification(string);
            int aa = Math.min(Math.max(site, 1), peptideSequence.length());
            this.writer.write(PEPTIDE_SECTION, this.getCurrentIndentation(PEPTIDE_SECTION));
            this.writer.write(PEPTIDE_SECTION, "<Modification monoisotopicMassDelta=\"");
            this.writer.write(PEPTIDE_SECTION, Double.toString(modification.getRoundedMass()));
            this.writer.write(PEPTIDE_SECTION, "\" residues=\"");
            this.writer.write(PEPTIDE_SECTION, Character.toString(peptideSequence.charAt(aa - 1)));
            this.writer.write(PEPTIDE_SECTION, "\" location=\"");
            this.writer.write(PEPTIDE_SECTION, Integer.toString(site));
            this.writer.write(PEPTIDE_SECTION, "\" >");
            this.writer.newLine(PEPTIDE_SECTION);
            CvTerm ptmCvTerm = modification.getUnimodCvTerm();
            if (ptmCvTerm != null) {
                this.increaseIndentation(PEPTIDE_SECTION);
                this.writeCvTerm(PEPTIDE_SECTION, ptmCvTerm, false);
                this.decreaseIndent(PEPTIDE_SECTION);
            } else {
                ptmCvTerm = modification.getPsiModCvTerm();
                if (ptmCvTerm != null) {
                    this.increaseIndentation(PEPTIDE_SECTION);
                    this.writeCvTerm(PEPTIDE_SECTION, ptmCvTerm, false);
                    this.decreaseIndent(PEPTIDE_SECTION);
                }
            }
            this.writer.write(PEPTIDE_SECTION, this.getCurrentIndentation(PEPTIDE_SECTION));
            this.writer.write(PEPTIDE_SECTION, "</Modification>");
            this.writer.newLine(PEPTIDE_SECTION);
        }
        for (ModificationMatch modMatch : peptide.getVariableModifications()) {
            Modification modification = this.modificationProvider.getModification(modMatch.getModification());
            int site = modMatch.getSite();
            int aa = Math.min(Math.max(site, 1), peptideSequence.length());
            this.writer.write(PEPTIDE_SECTION, this.getCurrentIndentation(PEPTIDE_SECTION));
            this.writer.write(PEPTIDE_SECTION, "<Modification monoisotopicMassDelta=\"");
            this.writer.write(PEPTIDE_SECTION, Double.toString(modification.getRoundedMass()));
            this.writer.write(PEPTIDE_SECTION, "\" residues=\"");
            this.writer.write(PEPTIDE_SECTION, Character.toString(peptideSequence.charAt(aa - 1)));
            this.writer.write(PEPTIDE_SECTION, "\" location=\"");
            this.writer.write(PEPTIDE_SECTION, Integer.toString(site));
            this.writer.write(PEPTIDE_SECTION, "\" >");
            this.writer.newLine(PEPTIDE_SECTION);
            CvTerm ptmCvTerm = modification.getUnimodCvTerm();
            if (ptmCvTerm != null) {
                this.increaseIndentation(PEPTIDE_SECTION);
                this.writeCvTerm(PEPTIDE_SECTION, ptmCvTerm, false);
                this.decreaseIndent(PEPTIDE_SECTION);
            } else {
                ptmCvTerm = modification.getPsiModCvTerm();
                this.increaseIndentation(PEPTIDE_SECTION);
                this.writeCvTerm(PEPTIDE_SECTION, ptmCvTerm, false);
                this.decreaseIndent(PEPTIDE_SECTION);
            }
            this.writer.write(PEPTIDE_SECTION, this.getCurrentIndentation(PEPTIDE_SECTION));
            this.writer.write(PEPTIDE_SECTION, "</Modification>");
            this.writer.newLine(PEPTIDE_SECTION);
        }
        this.decreaseIndent(PEPTIDE_SECTION);
        this.writer.write(PEPTIDE_SECTION, this.getCurrentIndentation(PEPTIDE_SECTION));
        this.writer.write(PEPTIDE_SECTION, "</Peptide>");
        this.writer.newLine(PEPTIDE_SECTION);
        for (Map.Entry entry : peptide.getProteinMapping().entrySet()) {
            int[] indexes;
            String accession = (String)entry.getKey();
            for (int index : indexes = (int[])entry.getValue()) {
                String aaAfter;
                String aaBefore = PeptideUtils.getAaBefore(peptide, accession, index, 1, this.sequenceProvider);
                if (aaBefore.length() == 0) {
                    aaBefore = "-";
                }
                if ((aaAfter = PeptideUtils.getAaAfter(peptide, accession, index, 1, this.sequenceProvider)).length() == 0) {
                    aaAfter = "-";
                }
                int peptideStart = index;
                int peptideEnd = index + peptide.getSequence().length();
                String pepEvidenceKey = SimpleMzIdentMLExporter.getPeptideEvidenceKey(accession, index, peptideKey);
                StringBuilder pepEvidenceValueBuilder = new StringBuilder();
                pepEvidenceValueBuilder.append("PepEv_").append(++this.peptideEvidenceCounter);
                String pepEvidenceValue = pepEvidenceValueBuilder.toString();
                this.pepEvidenceIds.put(pepEvidenceKey, pepEvidenceValue);
                this.writer.write(PEPTIDE_EVIDENCE_SECTION, this.getCurrentIndentation(PEPTIDE_EVIDENCE_SECTION));
                this.writer.write(PEPTIDE_EVIDENCE_SECTION, "<PeptideEvidence isDecoy=\"");
                this.writer.write(PEPTIDE_EVIDENCE_SECTION, Boolean.toString(PeptideUtils.isDecoy(peptide, this.sequenceProvider)));
                this.writer.write(PEPTIDE_EVIDENCE_SECTION, "\" pre=\"");
                this.writer.write(PEPTIDE_EVIDENCE_SECTION, aaBefore);
                this.writer.write(PEPTIDE_EVIDENCE_SECTION, "\" post=\"");
                this.writer.write(PEPTIDE_EVIDENCE_SECTION, aaAfter);
                this.writer.write(PEPTIDE_EVIDENCE_SECTION, "\" start=\"");
                this.writer.write(PEPTIDE_EVIDENCE_SECTION, Integer.toString(peptideStart + 1));
                this.writer.write(PEPTIDE_EVIDENCE_SECTION, "\" end=\"");
                this.writer.write(PEPTIDE_EVIDENCE_SECTION, Integer.toString(peptideEnd + 1));
                this.writer.write(PEPTIDE_EVIDENCE_SECTION, "\" peptide_ref=\"");
                this.writer.write(PEPTIDE_EVIDENCE_SECTION, Long.toString(peptideKey));
                this.writer.write(PEPTIDE_EVIDENCE_SECTION, "\" dBSequence_ref=\"");
                this.writer.write(PEPTIDE_EVIDENCE_SECTION, accession);
                this.writer.write(PEPTIDE_EVIDENCE_SECTION, "\" id=\"");
                this.writer.write(PEPTIDE_EVIDENCE_SECTION, pepEvidenceValue);
                this.writer.write(PEPTIDE_EVIDENCE_SECTION, "\" />");
                this.writer.newLine(PEPTIDE_EVIDENCE_SECTION);
            }
        }
    }

    public static String getPeptideEvidenceKey(String accession, int peptideStart, long peptideKey) {
        String peptideStartAsString = Integer.toString(peptideStart);
        String peptideKeyAsString = Long.toString(peptideKey);
        StringBuilder pepEvidenceKeybuilder = new StringBuilder(accession.length() + peptideStartAsString.length() + peptideKeyAsString.length() + 2);
        pepEvidenceKeybuilder.append(accession).append('_').append(peptideStartAsString).append('_').append(peptideKeyAsString);
        return pepEvidenceKeybuilder.toString();
    }

    private void finalizePeptideEvidenceSection() {
        this.decreaseIndent(PEPTIDE_EVIDENCE_SECTION);
        this.writer.write(PEPTIDE_EVIDENCE_SECTION, this.getCurrentIndentation(PEPTIDE_EVIDENCE_SECTION));
        this.writer.write(PEPTIDE_EVIDENCE_SECTION, "</SequenceCollection>");
        this.writer.newLine(PEPTIDE_EVIDENCE_SECTION);
    }

    private void writeAnalysisCollection() {
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "<AnalysisCollection>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.increaseIndentation(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "<SpectrumIdentification spectrumIdentificationList_ref=\"SIL_1\" ");
        this.writer.write(ANALYSIS_SECTION, "spectrumIdentificationProtocol_ref=\"SearchProtocol_1\" id=\"SpecIdent_1\">");
        this.writer.newLine(ANALYSIS_SECTION);
        this.increaseIndentation(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "<InputSpectra spectraData_ref=\"");
        for (File spectrumFile : this.spectrumFiles) {
            this.writer.write(ANALYSIS_SECTION, IoUtil.getFileName(spectrumFile));
        }
        this.writer.write(ANALYSIS_SECTION, "\"/>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "<SearchDatabaseRef searchDatabase_ref=\"SearchDB_1\"/>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.decreaseIndent(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "</SpectrumIdentification>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "<ProteinDetection proteinDetectionProtocol_ref=\"PeptideShaker_1\" ");
        this.writer.write(ANALYSIS_SECTION, "proteinDetectionList_ref=\"Protein_groups\" id=\"PD_1\">");
        this.writer.newLine(ANALYSIS_SECTION);
        this.increaseIndentation(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "<InputSpectrumIdentifications spectrumIdentificationList_ref=\"SIL_1\"/>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.decreaseIndent(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "</ProteinDetection>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.decreaseIndent(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "</AnalysisCollection>");
        this.writer.newLine(ANALYSIS_SECTION);
    }

    private void writeAnalysisProtocol() {
        String precursorIonToleranceUnit;
        String unitAccession;
        String fragmentIonToleranceUnit;
        CvTerm enzymeCvTerm;
        Object modification;
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "<AnalysisProtocolCollection>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.increaseIndentation(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "<SpectrumIdentificationProtocol analysisSoftware_ref=\"ID_software\" id=\"SearchProtocol_1\">");
        this.writer.newLine(ANALYSIS_SECTION);
        this.increaseIndentation(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "<SearchType>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.increaseIndentation(ANALYSIS_SECTION);
        this.writeCvTerm(ANALYSIS_SECTION, new CvTerm("PSI-MS", "MS:1001083", "ms-ms search", null));
        this.decreaseIndent(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "</SearchType>");
        this.writer.newLine(ANALYSIS_SECTION);
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "<AdditionalSearchParams>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.increaseIndentation(ANALYSIS_SECTION);
        this.writeCvTerm(ANALYSIS_SECTION, new CvTerm("PSI-MS", "MS:1001211", "parent mass type mono", null));
        this.writeCvTerm(ANALYSIS_SECTION, new CvTerm("PSI-MS", "MS:1001256", "fragment mass type mono", null));
        this.writeCvTerm(ANALYSIS_SECTION, new CvTerm("PSI-MS", "MS:1002491", "modification localization scoring", null));
        this.decreaseIndent(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "</AdditionalSearchParams>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "<ModificationParams>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.increaseIndentation(ANALYSIS_SECTION);
        for (String modName : searchParameters.getModificationParameters().getAllModifications()) {
            modification = this.modificationProvider.getModification(modName);
            Double modMass = ((Modification)modification).getMass();
            Integer index = this.modIndexMap.get(modMass);
            if (index != null) continue;
            this.modIndexMap.put(modMass, this.modIndexMap.size());
        }
        for (String modName : searchParameters.getModificationParameters().getAllModifications()) {
            CvTerm ptmCvTerm;
            String aminoAcidsAtTarget;
            modification = this.modificationProvider.getModification(modName);
            ModificationType modificationType = ((Modification)modification).getModificationType();
            double modMass = ((Modification)modification).getMass();
            if (modificationType == ModificationType.modaa || modificationType == ModificationType.modcaa_peptide || modificationType == ModificationType.modcaa_protein || modificationType == ModificationType.modnaa_peptide || modificationType == ModificationType.modnaa_protein) {
                StringBuilder sb = new StringBuilder();
                for (Character aa : ((Modification)modification).getPattern().getAminoAcidsAtTarget()) {
                    sb.append(aa);
                }
                aminoAcidsAtTarget = sb.toString();
            } else {
                aminoAcidsAtTarget = ".";
            }
            this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
            this.writer.write(ANALYSIS_SECTION, "<SearchModification residues=\"");
            this.writer.write(ANALYSIS_SECTION, aminoAcidsAtTarget);
            this.writer.write(ANALYSIS_SECTION, "\" massDelta=\"");
            this.writer.write(ANALYSIS_SECTION, Double.toString(((Modification)modification).getRoundedMass()));
            this.writer.write(ANALYSIS_SECTION, "\" fixedMod= \"");
            this.writer.write(ANALYSIS_SECTION, Boolean.toString(searchParameters.getModificationParameters().getFixedModifications().contains(modName)));
            this.writer.write(ANALYSIS_SECTION, "\" >");
            this.writer.newLine(ANALYSIS_SECTION);
            this.increaseIndentation(ANALYSIS_SECTION);
            if (modificationType != ModificationType.modaa) {
                this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
                this.writer.write(ANALYSIS_SECTION, "<SpecificityRules>");
                this.writer.newLine(ANALYSIS_SECTION);
                this.increaseIndentation(ANALYSIS_SECTION);
                switch (modificationType) {
                    case modn_protein: 
                    case modnaa_protein: {
                        this.writeCvTerm(ANALYSIS_SECTION, new CvTerm("PSI-MS", "MS:1002057", "modification specificity protein N-term", null));
                        break;
                    }
                    case modn_peptide: 
                    case modnaa_peptide: {
                        this.writeCvTerm(ANALYSIS_SECTION, new CvTerm("PSI-MS", "MS:1001189", "modification specificity peptide N-term", null));
                        break;
                    }
                    case modc_protein: 
                    case modcaa_protein: {
                        this.writeCvTerm(ANALYSIS_SECTION, new CvTerm("PSI-MS", "MS:1002058", "modification specificity protein C-term", null));
                        break;
                    }
                    case modc_peptide: 
                    case modcaa_peptide: {
                        this.writeCvTerm(ANALYSIS_SECTION, new CvTerm("PSI-MS", "MS:1001190", "modification specificity peptide C-term", null));
                        break;
                    }
                }
                this.decreaseIndent(ANALYSIS_SECTION);
                this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
                this.writer.write(ANALYSIS_SECTION, "</SpecificityRules>");
                this.writer.newLine(ANALYSIS_SECTION);
            }
            if ((ptmCvTerm = ((Modification)modification).getUnimodCvTerm()) != null) {
                this.writeCvTerm(ANALYSIS_SECTION, ptmCvTerm);
            } else {
                ptmCvTerm = ((Modification)modification).getPsiModCvTerm();
                if (ptmCvTerm != null) {
                    this.writeCvTerm(ANALYSIS_SECTION, ptmCvTerm);
                } else {
                    this.writeCvTerm(ANALYSIS_SECTION, new CvTerm("PSI-MS", "MS:1001460", "unknown modification", null));
                }
            }
            Integer modIndex = this.modIndexMap.get(modMass);
            if (modIndex == null) {
                throw new IllegalArgumentException("No index found for PTM " + ((Modification)modification).getName() + " of mass " + modMass + ".");
            }
            this.writeCvTerm(ANALYSIS_SECTION, new CvTerm("PSI-MS", "MS:1002504", "modification index", modIndex.toString()));
            this.decreaseIndent(ANALYSIS_SECTION);
            this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
            this.writer.write(ANALYSIS_SECTION, "</SearchModification>");
            this.writer.newLine(ANALYSIS_SECTION);
        }
        this.decreaseIndent(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "</ModificationParams>");
        this.writer.newLine(ANALYSIS_SECTION);
        DigestionParameters digestionPreferences = searchParameters.getDigestionParameters();
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.unSpecific) {
            this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
            this.writer.write(ANALYSIS_SECTION, "<Enzymes independent=\"false\">");
            this.writer.newLine(ANALYSIS_SECTION);
            this.increaseIndentation(ANALYSIS_SECTION);
            this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
            this.writer.write(ANALYSIS_SECTION, "<Enzyme name=\"unspecific cleavage\">");
            this.writer.newLine(ANALYSIS_SECTION);
            this.increaseIndentation(ANALYSIS_SECTION);
            this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
            this.writer.write(ANALYSIS_SECTION, "<EnzymeName>");
            this.writer.newLine(ANALYSIS_SECTION);
            this.increaseIndentation(ANALYSIS_SECTION);
            enzymeCvTerm = new CvTerm("PSI-MS", "MS:1001091", "unspecific cleavage", null);
            this.writeCvTerm(ANALYSIS_SECTION, enzymeCvTerm);
            this.decreaseIndent(ANALYSIS_SECTION);
            this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
            this.writer.write(ANALYSIS_SECTION, "</EnzymeName>");
            this.writer.newLine(ANALYSIS_SECTION);
            this.decreaseIndent(ANALYSIS_SECTION);
            this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
            this.writer.write(ANALYSIS_SECTION, "</Enzyme>");
            this.writer.newLine(ANALYSIS_SECTION);
        } else if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.wholeProtein) {
            this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
            this.writer.write(ANALYSIS_SECTION, "<Enzymes independent=\"false\">");
            this.writer.newLine(ANALYSIS_SECTION);
            this.increaseIndentation(ANALYSIS_SECTION);
            this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
            this.writer.write(ANALYSIS_SECTION, "<Enzyme name=\"NoEnzyme\">");
            this.writer.newLine(ANALYSIS_SECTION);
            this.increaseIndentation(ANALYSIS_SECTION);
            this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
            this.writer.write(ANALYSIS_SECTION, "<EnzymeName>");
            this.writer.newLine(ANALYSIS_SECTION);
            this.increaseIndentation(ANALYSIS_SECTION);
            enzymeCvTerm = new CvTerm("PSI-MS", "MS:1001955", "NoEnzyme", null);
            this.writeCvTerm(ANALYSIS_SECTION, enzymeCvTerm);
            this.decreaseIndent(ANALYSIS_SECTION);
            this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
            this.writer.write(ANALYSIS_SECTION, "</EnzymeName>");
            this.writer.newLine(ANALYSIS_SECTION);
            this.decreaseIndent(ANALYSIS_SECTION);
            this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
            this.writer.write(ANALYSIS_SECTION, "</Enzyme>");
            this.writer.newLine(ANALYSIS_SECTION);
        } else {
            ArrayList<Enzyme> enzymes = digestionPreferences.getEnzymes();
            this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
            this.writer.write(ANALYSIS_SECTION, "<Enzymes independent=\"");
            this.writer.write(ANALYSIS_SECTION, Boolean.toString(enzymes.size() > 1));
            this.writer.write(ANALYSIS_SECTION, "\">");
            this.writer.newLine(ANALYSIS_SECTION);
            this.increaseIndentation(ANALYSIS_SECTION);
            for (Enzyme enzyme : enzymes) {
                String enzymeName = enzyme.getName();
                this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
                this.writer.write(ANALYSIS_SECTION, "<Enzyme missedCleavages=\"");
                this.writer.write(ANALYSIS_SECTION, Integer.toString(digestionPreferences.getnMissedCleavages(enzymeName)));
                this.writer.write(ANALYSIS_SECTION, "\" semiSpecific=\"");
                this.writer.write(ANALYSIS_SECTION, Boolean.toString(digestionPreferences.getSpecificity(enzymeName) == DigestionParameters.Specificity.semiSpecific));
                this.writer.write(ANALYSIS_SECTION, "\" ");
                this.writer.write(ANALYSIS_SECTION, "id=\"Enz1\" name=\"");
                this.writer.write(ANALYSIS_SECTION, enzyme.getName());
                this.writer.write(ANALYSIS_SECTION, "\">");
                this.writer.newLine(ANALYSIS_SECTION);
                this.increaseIndentation(ANALYSIS_SECTION);
                this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
                this.writer.write(ANALYSIS_SECTION, "<EnzymeName>");
                this.writer.newLine(ANALYSIS_SECTION);
                this.increaseIndentation(ANALYSIS_SECTION);
                CvTerm enzymeCvTerm2 = enzyme.getCvTerm();
                if (enzymeCvTerm2 != null) {
                    this.writeCvTerm(ANALYSIS_SECTION, enzymeCvTerm2);
                } else {
                    this.writeUserParam(ANALYSIS_SECTION, enzyme.getName());
                }
                this.decreaseIndent(ANALYSIS_SECTION);
                this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
                this.writer.write(ANALYSIS_SECTION, "</EnzymeName>");
                this.writer.newLine(ANALYSIS_SECTION);
                this.decreaseIndent(ANALYSIS_SECTION);
                this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
                this.writer.write(ANALYSIS_SECTION, "</Enzyme>");
                this.writer.newLine(ANALYSIS_SECTION);
                this.decreaseIndent(ANALYSIS_SECTION);
            }
        }
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "</Enzymes>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "<FragmentTolerance>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.increaseIndentation(ANALYSIS_SECTION);
        switch (searchParameters.getFragmentAccuracyType()) {
            case DA: {
                fragmentIonToleranceUnit = "dalton";
                unitAccession = "UO:0000221";
                break;
            }
            case PPM: {
                fragmentIonToleranceUnit = "parts per million";
                unitAccession = "UO:0000169";
                break;
            }
            default: {
                throw new UnsupportedOperationException("CV term not implemented for fragment accuracy in " + (Object)((Object)searchParameters.getFragmentAccuracyType()) + ".");
            }
        }
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "<cvParam accession=\"MS:1001412\" cvRef=\"PSI-MS\" unitCvRef=\"UO\" unitName=\"");
        this.writer.write(ANALYSIS_SECTION, fragmentIonToleranceUnit);
        this.writer.write(ANALYSIS_SECTION, "\" unitAccession=\"");
        this.writer.write(ANALYSIS_SECTION, unitAccession);
        this.writer.write(ANALYSIS_SECTION, "\" value=\"");
        this.writer.write(ANALYSIS_SECTION, Double.toString(searchParameters.getFragmentIonAccuracy()));
        this.writer.write(ANALYSIS_SECTION, "\" ");
        this.writer.write(ANALYSIS_SECTION, "name=\"search tolerance plus value\" />");
        this.writer.newLine(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "<cvParam accession=\"MS:1001413\" cvRef=\"PSI-MS\" unitCvRef=\"UO\" unitName=\"");
        this.writer.write(ANALYSIS_SECTION, fragmentIonToleranceUnit);
        this.writer.write(ANALYSIS_SECTION, "\" unitAccession=\"");
        this.writer.write(ANALYSIS_SECTION, unitAccession);
        this.writer.write(ANALYSIS_SECTION, "\" value=\"");
        this.writer.write(ANALYSIS_SECTION, Double.toString(searchParameters.getFragmentIonAccuracy()));
        this.writer.write(ANALYSIS_SECTION, "\" name=\"search tolerance minus value\" />");
        this.writer.newLine(ANALYSIS_SECTION);
        this.decreaseIndent(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "</FragmentTolerance>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "<ParentTolerance>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.increaseIndentation(ANALYSIS_SECTION);
        switch (searchParameters.getPrecursorAccuracyType()) {
            case DA: {
                precursorIonToleranceUnit = "dalton";
                break;
            }
            case PPM: {
                precursorIonToleranceUnit = "parts per million";
                break;
            }
            default: {
                throw new UnsupportedOperationException("CV term not implemented for precursor accuracy in " + (Object)((Object)searchParameters.getFragmentAccuracyType()) + ".");
            }
        }
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "<cvParam accession=\"MS:1001412\" cvRef=\"PSI-MS\" unitCvRef=\"UO\" unitName=\"");
        this.writer.write(ANALYSIS_SECTION, precursorIonToleranceUnit);
        this.writer.write(ANALYSIS_SECTION, "\" unitAccession=\"UO:0000169\" value=\"");
        this.writer.write(ANALYSIS_SECTION, Double.toString(searchParameters.getPrecursorAccuracy()));
        this.writer.write(ANALYSIS_SECTION, "\" name=\"search tolerance plus value\" />");
        this.writer.newLine(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "<cvParam accession=\"MS:1001413\" cvRef=\"PSI-MS\" unitCvRef=\"UO\" unitName=\"");
        this.writer.write(ANALYSIS_SECTION, precursorIonToleranceUnit);
        this.writer.write(ANALYSIS_SECTION, "\" unitAccession=\"UO:0000169\" value=\"");
        this.writer.write(ANALYSIS_SECTION, Double.toString(searchParameters.getPrecursorAccuracy()));
        this.writer.write(ANALYSIS_SECTION, "\" name=\"search tolerance minus value\" />");
        this.decreaseIndent(ANALYSIS_SECTION);
        this.writer.newLine(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "</ParentTolerance>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "<Threshold>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.increaseIndentation(ANALYSIS_SECTION);
        this.writeCvTerm(ANALYSIS_SECTION, new CvTerm("PSI-MS", "MS:1001494", "no threshold", null));
        this.decreaseIndent(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "</Threshold>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.decreaseIndent(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "</SpectrumIdentificationProtocol>");
        this.writer.newLine(ANALYSIS_SECTION);
        this.decreaseIndent(ANALYSIS_SECTION);
        this.writer.write(ANALYSIS_SECTION, this.getCurrentIndentation(ANALYSIS_SECTION));
        this.writer.write(ANALYSIS_SECTION, "</AnalysisProtocolCollection>");
        this.writer.newLine(ANALYSIS_SECTION);
    }

    private void setupDataCollection() {
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<DataCollection>");
        this.writer.newLine(DATA_SECTION);
        this.increaseIndentation(DATA_SECTION);
        this.writeInputFileDetails();
        this.setupDataAnalysis();
    }

    private void finalizeDataCollection() {
        this.finalizeDataAnalysis();
        this.decreaseIndent(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "</DataCollection>");
        this.writer.newLine(DATA_SECTION);
    }

    private void writeInputFileDetails() {
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<Inputs>");
        this.writer.newLine(DATA_SECTION);
        this.increaseIndentation(DATA_SECTION);
        int sourceFileCounter = 1;
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<SourceFile location=\"");
        this.writer.write(DATA_SECTION, this.searchEngineFile.toURI().toString());
        this.writer.write(DATA_SECTION, "\" id=\"SourceFile_");
        this.writer.write(DATA_SECTION, Integer.toString(sourceFileCounter++));
        this.writer.write(DATA_SECTION, "\">");
        this.writer.newLine(DATA_SECTION);
        this.increaseIndentation(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<FileFormat>");
        this.writer.newLine(DATA_SECTION);
        this.increaseIndentation(DATA_SECTION);
        for (String algorithmName : this.searchEngines.keySet()) {
            Advocate advocate = Advocate.getAdvocate(algorithmName);
            int advocateIndex = advocate.getIndex();
            if (advocateIndex == Advocate.mascot.getIndex()) {
                this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1001199", "Mascot DAT format", null));
                continue;
            }
            if (advocateIndex == Advocate.xtandem.getIndex()) {
                this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1001401", "X!Tandem xml format", null));
                continue;
            }
            if (advocateIndex == Advocate.omssa.getIndex()) {
                this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1001400", "OMSSA xml format", null));
                continue;
            }
            if (advocateIndex == Advocate.msgf.getIndex() || advocateIndex == Advocate.myriMatch.getIndex()) {
                this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1002073", "mzIdentML format", null));
                continue;
            }
            if (advocateIndex == Advocate.msAmanda.getIndex()) {
                this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1002459", "MS Amanda csv format", null));
                continue;
            }
            if (advocateIndex == Advocate.comet.getIndex()) {
                this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1001421", "pepXML format", null));
                continue;
            }
            if (advocateIndex == Advocate.tide.getIndex()) {
                this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1000914", "tab delimited text format", null));
                continue;
            }
            if (advocateIndex != Advocate.andromeda.getIndex()) continue;
            this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1002576", "Andromeda result file", null));
        }
        this.decreaseIndent(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "</FileFormat>");
        this.writer.newLine(DATA_SECTION);
        this.decreaseIndent(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "</SourceFile>");
        this.writer.newLine(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<SearchDatabase numDatabaseSequences=\"");
        this.writer.write(DATA_SECTION, Integer.toString(this.fastaSummary.nSequences));
        this.writer.write(DATA_SECTION, "\" location=\"");
        this.writer.write(DATA_SECTION, this.fastaFile.toURI().toString());
        this.writer.write(DATA_SECTION, "\" id=\"SearchDB_1\">");
        this.writer.newLine(DATA_SECTION);
        this.increaseIndentation(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<FileFormat>");
        this.writer.newLine(DATA_SECTION);
        this.increaseIndentation(DATA_SECTION);
        this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1001348", "FASTA format", null));
        this.decreaseIndent(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "</FileFormat>");
        this.writer.newLine(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<DatabaseName>");
        this.writer.newLine(DATA_SECTION);
        this.increaseIndentation(DATA_SECTION);
        this.writeUserParam(DATA_SECTION, this.fastaFile.getName());
        this.decreaseIndent(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "</DatabaseName>");
        this.writer.newLine(DATA_SECTION);
        this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1001073", "database type amino acid", null));
        this.decreaseIndent(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "</SearchDatabase>");
        this.writer.newLine(DATA_SECTION);
        for (File spectrumFile : this.spectrumFiles) {
            this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
            this.writer.write(DATA_SECTION, "<SpectraData location=\"");
            this.writer.write(DATA_SECTION, spectrumFile.toURI().toString());
            this.writer.write(DATA_SECTION, "\" id=\"");
            this.writer.write(DATA_SECTION, IoUtil.getFileName(spectrumFile));
            this.writer.write(DATA_SECTION, "\" name=\"");
            this.writer.write(DATA_SECTION, spectrumFile.getName());
            this.writer.write(DATA_SECTION, "\">");
            this.writer.newLine(DATA_SECTION);
            this.increaseIndentation(DATA_SECTION);
            this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
            this.writer.write(DATA_SECTION, "<FileFormat>");
            this.writer.newLine(DATA_SECTION);
            this.increaseIndentation(DATA_SECTION);
            this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1001062", "Mascot MGF format", null));
            this.decreaseIndent(DATA_SECTION);
            this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
            this.writer.write(DATA_SECTION, "</FileFormat>");
            this.writer.newLine(DATA_SECTION);
            this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
            this.writer.write(DATA_SECTION, "<SpectrumIDFormat>");
            this.writer.newLine(DATA_SECTION);
            this.increaseIndentation(DATA_SECTION);
            this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1000774", "multiple peak list nativeID format", null));
            this.decreaseIndent(DATA_SECTION);
            this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
            this.writer.write(DATA_SECTION, "</SpectrumIDFormat>");
            this.writer.newLine(DATA_SECTION);
            this.decreaseIndent(DATA_SECTION);
            this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
            this.writer.write(DATA_SECTION, "</SpectraData>");
            this.writer.newLine(DATA_SECTION);
        }
        this.decreaseIndent(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "</Inputs>");
        this.writer.newLine(DATA_SECTION);
    }

    private void setupDataAnalysis() {
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<AnalysisData>");
        this.writer.newLine(DATA_SECTION);
        this.increaseIndentation(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<SpectrumIdentificationList id=\"SIL_1\">");
        this.writer.newLine(DATA_SECTION);
        this.increaseIndentation(DATA_SECTION);
        this.writeFragmentationTable();
    }

    private void finalizeDataAnalysis() {
        this.decreaseIndent(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "</SpectrumIdentificationList>");
        this.writer.newLine(DATA_SECTION);
        this.decreaseIndent(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "</AnalysisData>");
        this.writer.newLine(DATA_SECTION);
    }

    private void writeFragmentationTable() {
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<FragmentationTable>");
        this.writer.newLine(DATA_SECTION);
        this.increaseIndentation(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<Measure id=\"Measure_MZ\">");
        this.writer.newLine(DATA_SECTION);
        this.increaseIndentation(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<cvParam cvRef=\"PSI-MS\" accession=\"MS:1001225\" name=\"product ion m/z\" unitCvRef=\"PSI-MS\" unitAccession=\"MS:1000040\" unitName=\"m/z\" />");
        this.writer.newLine(DATA_SECTION);
        this.decreaseIndent(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "</Measure>");
        this.writer.newLine(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<Measure id=\"Measure_Int\">");
        this.writer.newLine(DATA_SECTION);
        this.increaseIndentation(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<cvParam cvRef=\"PSI-MS\" accession=\"MS:1001226\" name=\"product ion intensity\" unitCvRef=\"PSI-MS\" unitAccession=\"MS:1000131\" unitName=\"number of detector counts\"/>");
        this.writer.newLine(DATA_SECTION);
        this.decreaseIndent(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "</Measure>");
        this.writer.newLine(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<Measure id=\"Measure_Error\">");
        this.writer.newLine(DATA_SECTION);
        this.increaseIndentation(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<cvParam cvRef=\"PSI-MS\" accession=\"MS:1001227\" name=\"product ion m/z error\" unitCvRef=\"PSI-MS\" unitAccession=\"MS:1000040\" unitName=\"m/z\"/>");
        this.writer.newLine(DATA_SECTION);
        this.decreaseIndent(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "</Measure>");
        this.writer.newLine(DATA_SECTION);
        this.decreaseIndent(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "</FragmentationTable>");
        this.writer.newLine(DATA_SECTION);
    }

    private void writeSpectrumIdentificationResult(String spectrumFile, String spectrumTitle, ArrayList<PeptideAssumption> peptideAssumptions, ArrayList<TreeMap<Double, HashMap<Integer, Double>>> modificationLocalizationScores, PeptideSpectrumAnnotator peptideSpectrumAnnotator) {
        int spectrumMatchIndex = ++this.psmCount;
        int spectrumIndex = this.spectrumTitleToIndexMap.get(spectrumTitle);
        String spectrumIdentificationResultItemKey = String.join((CharSequence)"", "SIR_", Integer.toString(spectrumMatchIndex));
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<SpectrumIdentificationResult spectraData_ref=\"");
        this.writer.write(DATA_SECTION, spectrumFile);
        this.writer.write(DATA_SECTION, "\" spectrumID=\"index=");
        this.writer.write(DATA_SECTION, Integer.toString(spectrumIndex));
        this.writer.write(DATA_SECTION, "\" id=\"");
        this.writer.write(DATA_SECTION, spectrumIdentificationResultItemKey);
        this.writer.write(DATA_SECTION, "\">");
        this.writer.newLine(DATA_SECTION);
        this.increaseIndentation(DATA_SECTION);
        for (int i = 0; i < peptideAssumptions.size(); ++i) {
            String spectrumIdentificationItemKey = String.join((CharSequence)"", "SII_", Integer.toString(spectrumMatchIndex), "_", Integer.toString(i));
            this.writeSpectrumIdentificationItem(spectrumFile, spectrumTitle, spectrumIdentificationItemKey, peptideAssumptions.get(i), modificationLocalizationScores.get(i), peptideSpectrumAnnotator);
        }
        this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1000796", "spectrum title", spectrumTitle));
        double precursorRt = this.spectrumProvider.getPrecursorRt(spectrumFile, spectrumTitle);
        if (!Double.isNaN(precursorRt)) {
            this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
            this.writer.write(DATA_SECTION, "<cvParam cvRef=\"PSI-MS\" accession=\"MS:1000894\" name=\"retention time\" value=\"");
            this.writer.write(DATA_SECTION, Double.toString(precursorRt));
            this.writer.write(DATA_SECTION, "\" unitCvRef=\"UO\" unitAccession=\"UO:0000010\" unitName=\"second\"/>");
            this.writer.newLine(DATA_SECTION);
        }
        this.decreaseIndent(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "</SpectrumIdentificationResult>");
        this.writer.newLine(DATA_SECTION);
    }

    private void writeSpectrumIdentificationItem(String spectrumFile, String spectrumTitle, String spectrumIdentificationItemKey, PeptideAssumption peptideAssumption, TreeMap<Double, HashMap<Integer, Double>> modificationLocalizationScores, PeptideSpectrumAnnotator peptideSpectrumAnnotator) {
        Peptide peptide = peptideAssumption.getPeptide();
        long peptideKey = this.peptideInference ? peptide.getMatchingKey(this.identificationParameters.getSequenceMatchingParameters()) : peptide.getKey();
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<SpectrumIdentificationItem peptide_ref=\"");
        this.writer.write(DATA_SECTION, Long.toString(peptideKey));
        this.writer.write(DATA_SECTION, "\" calculatedMassToCharge=\"");
        this.writer.write(DATA_SECTION, Double.toString(peptideAssumption.getTheoreticMz()));
        this.writer.write(DATA_SECTION, "\" experimentalMassToCharge=\"");
        this.writer.write(DATA_SECTION, Double.toString(this.spectrumProvider.getPrecursorMz(spectrumFile, spectrumTitle)));
        this.writer.write(DATA_SECTION, "\" chargeState=\"");
        this.writer.write(DATA_SECTION, Integer.toString(peptideAssumption.getIdentificationCharge()));
        this.writer.write(DATA_SECTION, "\" id=\"");
        this.writer.write(DATA_SECTION, spectrumIdentificationItemKey);
        this.writer.write(DATA_SECTION, "\">");
        this.writer.newLine(DATA_SECTION);
        this.increaseIndentation(DATA_SECTION);
        TreeMap<String, int[]> proteinMapping = peptide.getProteinMapping();
        String peptideSequence = peptide.getSequence();
        for (Map.Entry<String, int[]> entry : proteinMapping.entrySet()) {
            int[] indexes;
            String accession = entry.getKey();
            for (int index : indexes = entry.getValue()) {
                String pepEvidenceKey = SimpleMzIdentMLExporter.getPeptideEvidenceKey(accession, index, peptideKey);
                String peptideEvidenceId = this.pepEvidenceIds.get(pepEvidenceKey);
                this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
                this.writer.write(DATA_SECTION, "<PeptideEvidenceRef peptideEvidence_ref=\"");
                this.writer.write(DATA_SECTION, peptideEvidenceId);
                this.writer.write(DATA_SECTION, "\"/>");
                this.writer.newLine(DATA_SECTION);
            }
        }
        AnnotationParameters annotationParameters = this.identificationParameters.getAnnotationParameters();
        Spectrum spectrum = this.spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
        ModificationParameters modificationParameters = this.identificationParameters.getSearchParameters().getModificationParameters();
        SequenceMatchingParameters modificationSequenceMatchingParameters = this.identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
        SpecificAnnotationParameters specificAnnotationParameters = annotationParameters.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, peptideAssumption, modificationParameters, this.sequenceProvider, modificationSequenceMatchingParameters, peptideSpectrumAnnotator);
        IonMatch[] matches = peptideSpectrumAnnotator.getSpectrumAnnotation(annotationParameters, specificAnnotationParameters, spectrumFile, spectrumTitle, spectrum, peptideAssumption.getPeptide(), modificationParameters, this.sequenceProvider, modificationSequenceMatchingParameters);
        HashMap allFragmentIons = new HashMap();
        for (IonMatch ionMatch : matches) {
            if (ionMatch.ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION && ionMatch.ion.getType() != Ion.IonType.IMMONIUM_ION && ionMatch.ion.getType() != Ion.IonType.PRECURSOR_ION && ionMatch.ion.getType() != Ion.IonType.REPORTER_ION && ionMatch.ion.getType() != Ion.IonType.RELATED_ION) continue;
            CvTerm fragmentIonCvTerm = ionMatch.ion.getPsiMsCvTerm();
            Integer charge = ionMatch.charge;
            boolean neutralLossesTestPassed = true;
            if (ionMatch.ion.hasNeutralLosses()) {
                boolean bl = neutralLossesTestPassed = ionMatch.ion.getNeutralLosses().length <= 2;
            }
            if (fragmentIonCvTerm == null || !neutralLossesTestPassed) continue;
            String fragmentIonName = ionMatch.ion.getName();
            if (!allFragmentIons.containsKey(fragmentIonName)) {
                allFragmentIons.put(fragmentIonName, new HashMap(1));
            }
            if (!((HashMap)allFragmentIons.get(fragmentIonName)).containsKey(charge)) {
                ((HashMap)allFragmentIons.get(fragmentIonName)).put(charge, new ArrayList(1));
            }
            ((ArrayList)((HashMap)allFragmentIons.get(fragmentIonName)).get(charge)).add(ionMatch);
        }
        if (!allFragmentIons.isEmpty()) {
            this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
            this.writer.write(DATA_SECTION, "<Fragmentation>");
            this.writer.newLine(DATA_SECTION);
            this.increaseIndentation(DATA_SECTION);
            for (String fragmentType : allFragmentIons.keySet()) {
                for (Integer fragmentCharge : ((HashMap)allFragmentIons.get(fragmentType)).keySet()) {
                    ArrayList ionMatches = (ArrayList)((HashMap)allFragmentIons.get(fragmentType)).get(fragmentCharge);
                    Ion currentIon = ((IonMatch)ionMatches.get((int)0)).ion;
                    CvTerm fragmentIonCvTerm = currentIon.getPsiMsCvTerm();
                    StringBuilder indexes = new StringBuilder();
                    StringBuilder mzValues = new StringBuilder();
                    StringBuilder intensityValues = new StringBuilder();
                    StringBuilder errorValues = new StringBuilder();
                    for (IonMatch ionMatch : ionMatches) {
                        if (ionMatch.ion instanceof PeptideFragmentIon) {
                            indexes.append(((PeptideFragmentIon)ionMatch.ion).getNumber()).append(' ');
                        } else if (ionMatch.ion instanceof ImmoniumIon) {
                            char residue = ((ImmoniumIon)ionMatch.ion).aa;
                            char[] peptideAsArray = peptideSequence.toCharArray();
                            for (int i = 0; i < peptideAsArray.length; ++i) {
                                if (peptideAsArray[i] != residue) continue;
                                indexes.append(i + 1).append(' ');
                            }
                        } else if (ionMatch.ion instanceof ReporterIon || ionMatch.ion instanceof RelatedIon || ionMatch.ion instanceof PrecursorIon) {
                            indexes.append('0');
                        }
                        mzValues.append(ionMatch.peakMz).append(' ');
                        intensityValues.append(ionMatch.peakIntensity).append(' ');
                        errorValues.append(ionMatch.getAbsoluteError()).append(' ');
                    }
                    if (fragmentIonCvTerm == null) continue;
                    this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
                    this.writer.write(DATA_SECTION, "<IonType charge=\"");
                    this.writer.write(DATA_SECTION, Integer.toString(fragmentCharge));
                    this.writer.write(DATA_SECTION, "\" index=\"");
                    this.writer.write(DATA_SECTION, indexes.toString().trim());
                    this.writer.write(DATA_SECTION, "\">");
                    this.writer.newLine(DATA_SECTION);
                    this.increaseIndentation(DATA_SECTION);
                    this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
                    this.writer.write(DATA_SECTION, "<FragmentArray measure_ref=\"Measure_MZ\" values=\"");
                    this.writer.write(DATA_SECTION, mzValues.toString().trim());
                    this.writer.write(DATA_SECTION, "\"/>");
                    this.writer.newLine(DATA_SECTION);
                    this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
                    this.writer.write(DATA_SECTION, "<FragmentArray measure_ref=\"Measure_Int\" values=\"");
                    this.writer.write(DATA_SECTION, intensityValues.toString().trim());
                    this.writer.write(DATA_SECTION, "\"/>");
                    this.writer.newLine(DATA_SECTION);
                    this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
                    this.writer.write(DATA_SECTION, "<FragmentArray measure_ref=\"Measure_Error\" values=\"");
                    this.writer.write(DATA_SECTION, errorValues.toString().trim());
                    this.writer.write(DATA_SECTION, "\"/>");
                    this.writer.newLine(DATA_SECTION);
                    this.writeCvTerm(DATA_SECTION, fragmentIonCvTerm);
                    if (currentIon.getNeutralLosses() != null) {
                        int neutralLossesCount = currentIon.getNeutralLosses().length;
                        if (neutralLossesCount > 2) {
                            throw new IllegalArgumentException("A maximum of 2 neutral losses is supported.");
                        }
                        for (NeutralLoss tempNeutralLoss : currentIon.getNeutralLosses()) {
                            this.writeCvTerm(DATA_SECTION, tempNeutralLoss.getPsiMsCvTerm());
                        }
                    }
                    this.decreaseIndent(DATA_SECTION);
                    this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
                    this.writer.write(DATA_SECTION, "</IonType>");
                    this.writer.newLine(DATA_SECTION);
                }
            }
            this.decreaseIndent(DATA_SECTION);
            this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
            this.writer.write(DATA_SECTION, "</Fragmentation>");
            this.writer.newLine(DATA_SECTION);
        }
        for (Map.Entry<Double, HashMap<Integer, Double>> entry1 : modificationLocalizationScores.entrySet()) {
            double modMass = entry1.getKey();
            for (Map.Entry<Integer, Double> entry2 : entry1.getValue().entrySet()) {
                int site = entry2.getKey();
                String modName = this.getModificationName(modMass, peptide, site);
                Integer modIndex = this.modIndexMap.get(modMass);
                if (modIndex == null) {
                    throw new IllegalArgumentException("No index found for modification " + modName + " of mass " + modMass + ".");
                }
                double score = entry2.getValue();
                StringBuilder sb = new StringBuilder();
                sb.append(modIndex).append(':').append(score).append(':').append(site).append(':').append("true");
                this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1001969", "phosphoRS score", sb.toString()));
            }
        }
        int advocate = peptideAssumption.getAdvocate();
        double score = peptideAssumption.getRawScore();
        if (advocate == Advocate.xtandem.getIndex()) {
            this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1001330", "X!Tandem:expect", Double.toString(score)));
        } else if (advocate == Advocate.comet.getIndex()) {
            this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1002257", "Comet:expectation value", Double.toString(score)));
        } else if (advocate == Advocate.myriMatch.getIndex()) {
            this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1001589", "MyriMatch:MVH", Double.toString(score)));
        } else if (advocate == Advocate.msgf.getIndex()) {
            this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1002052", "MS-GF:SpecEValue", Double.toString(score)));
        } else if (advocate == Advocate.omssa.getIndex()) {
            this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1001328", "OMSSA:evalue", Double.toString(score)));
        } else if (advocate == Advocate.mascot.getIndex()) {
            this.writeCvTerm(DATA_SECTION, new CvTerm("PSI-MS", "MS:1001172", "Mascot:expectation value", Double.toString(score)));
        } else {
            this.writeUserParam(DATA_SECTION, String.join((CharSequence)"", Advocate.getAdvocate(advocate).getName(), " score"), Double.toString(score));
        }
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "<cvParam cvRef=\"PSI-MS\" accession=\"MS:1001117\" name=\"theoretical mass\" value=\"");
        this.writer.write(DATA_SECTION, Double.toString(peptideAssumption.getTheoreticMass()));
        this.writer.write(DATA_SECTION, "\" unitCvRef=\"UO\" unitAccession=\"UO:0000221\" unitName=\"dalton\"/>");
        this.writer.newLine(DATA_SECTION);
        this.decreaseIndent(DATA_SECTION);
        this.writer.write(DATA_SECTION, this.getCurrentIndentation(DATA_SECTION));
        this.writer.write(DATA_SECTION, "</SpectrumIdentificationItem>");
        this.writer.newLine(DATA_SECTION);
    }

    public String getModificationName(double modMass, Peptide peptide, int modSite) {
        String hitAtOtherSite = null;
        for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
            String modName = modificationMatch.getModification();
            Modification modification = this.modificationProvider.getModification(modName);
            if (modification.getMass() != modMass) continue;
            if (modificationMatch.getSite() == modSite) {
                return modName;
            }
            hitAtOtherSite = modName;
        }
        if (hitAtOtherSite != null) {
            return hitAtOtherSite;
        }
        for (String modName : this.identificationParameters.getSearchParameters().getModificationParameters().getAllNotFixedModifications()) {
            int[] possibleSites;
            Modification modification = this.modificationProvider.getModification(modName);
            if (modification.getMass() != modMass) continue;
            for (int site : possibleSites = ModificationUtils.getPossibleModificationSites(peptide, modification, this.sequenceProvider, this.identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters())) {
                if (site != modSite) continue;
                return modName;
            }
        }
        throw new IllegalArgumentException("No modification found for mass " + modMass + " at site " + modSite + " on peptide " + peptide.getSequence() + ".");
    }

    private void writeMzIdentMLEndTag() {
        this.decreaseIndent(DATA_SECTION);
        this.writer.write(DATA_SECTION, "</MzIdentML>");
    }

    private void initWriter() throws FileNotFoundException, IOException {
        this.writer.registerSection(HEAD_SECTION);
        this.writer.registerSection(PEPTIDE_SECTION);
        this.writer.registerSection(PEPTIDE_EVIDENCE_SECTION);
        this.writer.registerSection(ANALYSIS_SECTION);
        this.writer.registerSection(DATA_SECTION);
    }

    private void initIndentationMap() {
        this.indentationMap.put(HEAD_SECTION, 0);
        this.indentationMap.put(PEPTIDE_SECTION, 2);
        this.indentationMap.put(PEPTIDE_EVIDENCE_SECTION, 2);
        this.indentationMap.put(ANALYSIS_SECTION, 1);
        this.indentationMap.put(DATA_SECTION, 1);
    }

    private void increaseIndentation(String sectionName) {
        this.indentationMap.put(sectionName, this.indentationMap.get(sectionName) + 1);
    }

    private void decreaseIndent(String sectionName) {
        this.indentationMap.put(sectionName, this.indentationMap.get(sectionName) - 1);
    }

    private String getCurrentIndentation(String sectionName) {
        int tabCounter = this.indentationMap.get(sectionName);
        switch (tabCounter) {
            case 0: {
                return "";
            }
            case 1: {
                return "\t";
            }
            case 2: {
                return "\t\t";
            }
            case 3: {
                return "\t\t\t";
            }
            case 4: {
                return "\t\t\t\t";
            }
            case 5: {
                return "\t\t\t\t\t";
            }
            case 6: {
                return "\t\t\t\t\t\t";
            }
            case 7: {
                return "\t\t\t\t\t\t\t";
            }
            case 8: {
                return "\t\t\t\t\t\t\t\t";
            }
            case 9: {
                return "\t\t\t\t\t\t\t\t\t";
            }
            case 10: {
                return "\t\t\t\t\t\t\t\t\t\t";
            }
            case 11: {
                return "\t\t\t\t\t\t\t\t\t\t\t";
            }
            case 12: {
                return "\t\t\t\t\t\t\t\t\t\t\t\t";
            }
        }
        StringBuilder sb = new StringBuilder(tabCounter);
        for (int i = 0; i < tabCounter; ++i) {
            sb.append('\t');
        }
        return sb.toString();
    }

    private void writeCvTerm(String sectionName, CvTerm cvTerm) {
        this.writeCvTerm(sectionName, cvTerm, true);
    }

    private void writeCvTerm(String sectionName, CvTerm cvTerm, boolean writeValue) {
        this.writer.write(sectionName, this.getCurrentIndentation(sectionName));
        this.writer.write(sectionName, "<cvParam cvRef=\"");
        this.writer.write(sectionName, StringEscapeUtils.escapeHtml4((String)cvTerm.getOntology()));
        this.writer.write(sectionName, "\" accession=\"");
        this.writer.write(sectionName, cvTerm.getAccession());
        this.writer.write(sectionName, "\" name=\"");
        this.writer.write(sectionName, StringEscapeUtils.escapeHtml4((String)cvTerm.getName()));
        this.writer.write(sectionName, "\"");
        this.writeCvTermValue(sectionName, cvTerm, writeValue);
    }

    private void writeCvTermValue(String sectionName, CvTerm cvTerm, boolean writeValue) {
        String value = cvTerm.getValue();
        if (writeValue && value != null) {
            this.writer.write(sectionName, " value=\"");
            this.writer.write(sectionName, StringEscapeUtils.escapeHtml4((String)value));
            this.writer.write(sectionName, "\"/>");
        } else {
            this.writer.write(sectionName, "/>");
        }
        this.writer.newLine(sectionName);
    }

    private void writeUserParam(String sectionName, String userParamAsString) {
        this.writer.write(sectionName, this.getCurrentIndentation(sectionName));
        this.writer.write(sectionName, "<userParam name=\"");
        this.writer.write(sectionName, StringEscapeUtils.escapeHtml4((String)userParamAsString));
        this.writer.write(sectionName, "\"/>");
        this.writer.newLine(sectionName);
    }

    private void writeUserParam(String sectionName, String name, String value) {
        this.writer.write(sectionName, this.getCurrentIndentation(sectionName));
        this.writer.write(sectionName, "<userParam name=\"");
        this.writer.write(sectionName, StringEscapeUtils.escapeHtml4((String)name));
        this.writer.write(sectionName, "\" value=\"");
        this.writer.write(sectionName, StringEscapeUtils.escapeHtml4((String)value));
        this.writer.write(sectionName, "\" />");
        this.writer.newLine(sectionName);
    }

    @Override
    public void close() {
        this.finalizeFile();
        this.writer.close();
    }
}

