/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.mass_spectrometry.cms;

import com.compomics.util.TempByteArray;
import com.compomics.util.experiment.io.mass_spectrometry.cms.CmsFileUtils;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.io.compression.ZstdUtils;
import io.airlift.compress.zstd.ZstdCompressor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class CmsFileWriter
implements AutoCloseable {
    public static final int HEADER_LENGTH = CmsFileUtils.MAGIC_NUMBER.length + 8 + 32;
    private final RandomAccessFile raf;
    private double minMz = Double.MAX_VALUE;
    private double maxMz = 0.0;
    private double maxInt = 0.0;
    private double maxRt = 0.0;
    private final ArrayList<String> titles = new ArrayList();
    private final ArrayList<Integer> indexes = new ArrayList();
    private final ZstdCompressor compressor = new ZstdCompressor();

    public CmsFileWriter(File outputFile) throws FileNotFoundException, IOException {
        this.raf = new RandomAccessFile(outputFile, "rw");
        this.raf.seek(HEADER_LENGTH);
    }

    public void addSpectrum(String spectrumTitle, Spectrum spectrum) throws IOException {
        long index = this.raf.getFilePointer() - (long)HEADER_LENGTH;
        if (index > Integer.MAX_VALUE) {
            throw new IOException("File exceeds memory mapped reader max buffer size.");
        }
        int nPeaks = spectrum.mz.length;
        this.indexes.add((int)index);
        this.titles.add(spectrumTitle);
        Precursor precursor = spectrum.precursor;
        double precursorMz = precursor == null ? Double.NaN : precursor.mz;
        double precursorRt = precursor == null ? Double.NaN : precursor.rt;
        double precursorIntensity = precursor == null ? Double.NaN : precursor.intensity;
        int[] possibleCharges = precursor == null ? new int[]{} : precursor.possibleCharges;
        ByteBuffer buffer = ByteBuffer.allocate(2 * nPeaks * 8);
        for (int i = 0; i < nPeaks; ++i) {
            buffer.putDouble(spectrum.mz[i]);
            buffer.putDouble(spectrum.intensity[i]);
        }
        TempByteArray compressedData = nPeaks > 0 ? this.compress(buffer.array()) : new TempByteArray(buffer.array(), 0);
        buffer = ByteBuffer.allocate(24 + (3 + possibleCharges.length) * 4 + compressedData.length);
        buffer.putDouble(precursorMz).putDouble(precursorRt).putDouble(precursorIntensity).putInt(compressedData.length).putInt(nPeaks).put(compressedData.array, 0, compressedData.length).putInt(possibleCharges.length);
        for (int charge : possibleCharges) {
            buffer.putInt(charge);
        }
        byte[] arrayToWrite = buffer.array();
        this.raf.write(arrayToWrite, 0, arrayToWrite.length);
        if (this.minMz > precursorMz) {
            this.minMz = precursorMz;
        }
        if (this.maxMz < precursorMz) {
            this.maxMz = precursorMz;
        }
        if (this.maxInt < precursorIntensity) {
            this.maxInt = precursorIntensity;
        }
        if (this.maxRt < precursorRt) {
            this.maxRt = precursorRt;
        }
    }

    private void compressAndWrite(byte[] uncompressedData) throws IOException {
        TempByteArray compressedData = this.compress(uncompressedData);
        this.raf.writeInt(compressedData.length);
        this.raf.writeInt(uncompressedData.length);
        this.raf.write(compressedData.array, 0, compressedData.length);
    }

    private synchronized TempByteArray compress(byte[] uncompressedData) {
        return ZstdUtils.zstdCompress(this.compressor, uncompressedData);
    }

    private void writeHeaderAndFooter() throws IOException {
        long footerPosition = this.raf.getFilePointer();
        String titleString = this.titles.stream().collect(Collectors.joining("\t"));
        String indexString = this.indexes.stream().map(index -> index.toString()).collect(Collectors.joining("\t"));
        String titleIndexString = String.join((CharSequence)"\t", titleString, indexString);
        byte[] titleBytes = titleIndexString.getBytes("UTF-8");
        this.compressAndWrite(titleBytes);
        this.raf.seek(0L);
        ByteBuffer buffer = ByteBuffer.allocate(HEADER_LENGTH);
        buffer.put(CmsFileUtils.MAGIC_NUMBER).putLong(footerPosition).putDouble(this.minMz).putDouble(this.maxMz).putDouble(this.maxInt).putDouble(this.maxRt);
        this.raf.write(buffer.array());
    }

    @Override
    public void close() throws IOException {
        this.writeHeaderAndFooter();
        this.raf.close();
    }
}

