/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.mass_spectrometry.mgf;

import com.compomics.util.experiment.io.mass_spectrometry.mgf.MgfIndex;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class IndexedMgfReader {
    public static MgfIndex getMgfIndex(File mgfFile) throws FileNotFoundException, IOException {
        return IndexedMgfReader.getMgfIndex(mgfFile, null);
    }

    public static MgfIndex getMgfIndex(File mgfFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        boolean precursorChargesMissing;
        boolean peakPicked;
        HashMap<String, Long> indexes = new HashMap<String, Long>();
        HashMap<String, Integer> spectrumIndexes = new HashMap<String, Integer>();
        HashMap<Integer, Double> precursorMzMap = new HashMap<Integer, Double>();
        LinkedHashSet<String> spectrumTitles = new LinkedHashSet<String>();
        HashMap<String, Integer> duplicateTitles = new HashMap<String, Integer>();
        String title = null;
        int spectrumCounter = 0;
        double maxRT = -1.0;
        double minRT = Double.MAX_VALUE;
        double maxMz = -1.0;
        double maxIntensity = 0.0;
        int maxCharge = 0;
        int maxPeakCount = 0;
        BufferedRandomAccessFile bufferedRandomAccessFile = new BufferedRandomAccessFile(mgfFile, "r", 102400);
        Object object = null;
        try {
            String line;
            long currentIndex = 0L;
            int peakCount = 0;
            peakPicked = true;
            precursorChargesMissing = false;
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                waitingHandler.setMaxSecondaryProgressCounter(100);
                waitingHandler.setSecondaryProgressCounter(0);
            }
            long progressUnit = bufferedRandomAccessFile.length() / 100L;
            boolean insideSpectrum = false;
            boolean chargeTagFound = false;
            while ((line = bufferedRandomAccessFile.getNextLine()) != null) {
                if (line.endsWith("\r")) {
                    line = line.replace("\r", "");
                }
                if (line.equals("BEGIN IONS")) {
                    insideSpectrum = true;
                    chargeTagFound = false;
                    currentIndex = bufferedRandomAccessFile.getFilePointer();
                    ++spectrumCounter;
                    peakCount = 0;
                    if (waitingHandler == null) continue;
                    if (waitingHandler.isRunCanceled()) break;
                    waitingHandler.setSecondaryProgressCounter((int)(currentIndex / progressUnit));
                    continue;
                }
                if (line.startsWith("TITLE")) {
                    title = line.substring(line.indexOf(61) + 1).trim();
                    try {
                        title = URLDecoder.decode(title, "utf-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        if (waitingHandler != null) {
                            waitingHandler.appendReport("An exception was thrown when trying to decode an mgf title: " + title, true, true);
                        }
                        System.out.println("An exception was thrown when trying to decode an mgf title: " + title);
                        e.printStackTrace();
                    }
                    Integer nDuplicates = (Integer)duplicateTitles.get(title);
                    if (nDuplicates != null || spectrumTitles.contains(title)) {
                        if (nDuplicates == null) {
                            nDuplicates = 0;
                            System.err.println("Warning: Spectrum title " + title + " is not unique in " + mgfFile.getName() + "!");
                        }
                        nDuplicates = nDuplicates + 1;
                        duplicateTitles.put(title, nDuplicates);
                        title = title + "_" + nDuplicates;
                    }
                    spectrumTitles.add(title);
                    indexes.put(title, currentIndex);
                    spectrumIndexes.put(title, spectrumCounter - 1);
                    continue;
                }
                if (line.startsWith("CHARGE")) {
                    int[] precursorCharges;
                    for (int charge : precursorCharges = IndexedMgfReader.parseCharges(line)) {
                        if (charge <= maxCharge) continue;
                        maxCharge = charge;
                    }
                    chargeTagFound = true;
                    continue;
                }
                if (line.startsWith("PEPMASS")) {
                    double precursorIntensity;
                    String temp = line.substring(line.indexOf("=") + 1);
                    String[] values = temp.split("\\s");
                    double precursorMz = Double.parseDouble(values[0]);
                    if (precursorMz > maxMz) {
                        maxMz = precursorMz;
                    }
                    if (values.length > 1 && (precursorIntensity = Double.parseDouble(values[1])) > maxIntensity) {
                        maxIntensity = precursorIntensity;
                    }
                    precursorMzMap.put(spectrumCounter - 1, precursorMz);
                    continue;
                }
                if (line.startsWith("RTINSECONDS")) {
                    String rtInput = "";
                    try {
                        double rt2;
                        rtInput = line.substring(line.indexOf(61) + 1);
                        String[] rtWindow = rtInput.split("-");
                        if (rtWindow.length == 1) {
                            double rt;
                            String tempRt = rtWindow[0];
                            if (tempRt.startsWith("PT") && tempRt.endsWith("S")) {
                                tempRt = tempRt.substring(2, tempRt.length() - 1);
                            }
                            if ((rt = Double.valueOf(tempRt).doubleValue()) > maxRT) {
                                maxRT = rt;
                            }
                            if (!(rt < minRT)) continue;
                            minRT = rt;
                            continue;
                        }
                        if (rtWindow.length != 2 || rtWindow[0].equals("")) continue;
                        double rt1 = Double.valueOf(rtWindow[0]);
                        if (rt1 > maxRT) {
                            maxRT = rt1;
                        }
                        if (rt1 < minRT) {
                            minRT = rt1;
                        }
                        if ((rt2 = Double.valueOf(rtWindow[1]).doubleValue()) > maxRT) {
                            maxRT = rt2;
                        }
                        if (!(rt2 < minRT)) continue;
                        minRT = rt2;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Cannot parse retention time: " + rtInput);
                    }
                }
                if (line.startsWith("END IONS")) {
                    insideSpectrum = false;
                    if (title != null && peakCount > maxPeakCount) {
                        maxPeakCount = peakCount;
                    }
                    title = null;
                    if (chargeTagFound) continue;
                    precursorChargesMissing = true;
                    continue;
                }
                if (!insideSpectrum || line.equals("")) continue;
                try {
                    String[] values = line.split("\\s+");
                    Double intensity = Double.valueOf(values[1]);
                    if (peakPicked && intensity == 0.0) {
                        peakPicked = false;
                    }
                    ++peakCount;
                }
                catch (Exception exception) {}
            }
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressCounterIndeterminate(true);
            }
        }
        catch (Throwable currentIndex) {
            object = currentIndex;
            throw currentIndex;
        }
        finally {
            if (bufferedRandomAccessFile != null) {
                if (object != null) {
                    try {
                        bufferedRandomAccessFile.close();
                    }
                    catch (Throwable currentIndex) {
                        ((Throwable)object).addSuppressed(currentIndex);
                    }
                } else {
                    bufferedRandomAccessFile.close();
                }
            }
        }
        if (minRT == Double.MAX_VALUE) {
            minRT = 0.0;
        }
        ArrayList<String> spectrumTitlesAsArrayList = new ArrayList<String>(spectrumTitles.size());
        for (String temp : spectrumTitles) {
            spectrumTitlesAsArrayList.add(temp);
        }
        return new MgfIndex(spectrumTitlesAsArrayList, duplicateTitles, indexes, spectrumIndexes, precursorMzMap, mgfFile.getName(), minRT, maxRT, maxMz, maxIntensity, maxCharge, maxPeakCount, peakPicked, precursorChargesMissing, mgfFile.lastModified(), spectrumCounter);
    }

    public static Spectrum getSpectrum(BufferedRandomAccessFile bufferedRandomAccessFile, long index, String fileName) throws IOException {
        String line;
        bufferedRandomAccessFile.seek(index);
        double precursorMz = 0.0;
        double precursorIntensity = 0.0;
        double rt = -1.0;
        double rt1 = -1.0;
        double rt2 = -1.0;
        int[] precursorCharges = null;
        String spectrumTitle = "";
        boolean insideSpectrum = false;
        ArrayList<Double> mzList = new ArrayList<Double>(0);
        ArrayList<Double> intensityList = new ArrayList<Double>(0);
        while ((line = bufferedRandomAccessFile.getNextLine()) != null) {
            if (line.endsWith("\r")) {
                line = line.replace("\r", "");
            }
            if (line.startsWith("BEGIN IONS")) {
                insideSpectrum = true;
                mzList = new ArrayList();
                intensityList = new ArrayList();
                continue;
            }
            if (line.startsWith("TITLE")) {
                insideSpectrum = true;
                spectrumTitle = line.substring(line.indexOf(61) + 1).trim();
                try {
                    spectrumTitle = URLDecoder.decode(spectrumTitle, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("An exception was thrown when trying to decode an mgf title: " + spectrumTitle);
                    e.printStackTrace();
                }
                continue;
            }
            if (line.startsWith("CHARGE")) {
                precursorCharges = IndexedMgfReader.parseCharges(line);
                continue;
            }
            if (line.startsWith("PEPMASS")) {
                String temp = line.substring(line.indexOf("=") + 1);
                String[] values = temp.split("\\s");
                precursorMz = Double.parseDouble(values[0]);
                if (values.length > 1) {
                    precursorIntensity = Double.parseDouble(values[1]);
                    continue;
                }
                precursorIntensity = 0.0;
                continue;
            }
            if (line.startsWith("RTINSECONDS")) {
                try {
                    String rtInput = line.substring(line.indexOf(61) + 1);
                    String[] rtWindow = rtInput.split("-");
                    if (rtWindow.length == 1) {
                        String tempRt = rtWindow[0];
                        if (tempRt.startsWith("PT") && tempRt.endsWith("S")) {
                            tempRt = tempRt.substring(2, tempRt.length() - 1);
                        }
                        rt = Double.valueOf(tempRt);
                        continue;
                    }
                    if (rtWindow.length != 2) continue;
                    rt1 = Double.valueOf(rtWindow[0]);
                    rt2 = Double.valueOf(rtWindow[1]);
                }
                catch (Exception e) {
                    System.out.println("An exception was thrown when trying to decode the retention time: " + spectrumTitle);
                    e.printStackTrace();
                }
                continue;
            }
            if (line.startsWith("TOLU") || line.startsWith("TOL") || line.startsWith("SEQ") || line.startsWith("COMP") || line.startsWith("ETAG") || line.startsWith("TAG") || line.startsWith("SCANS") || line.startsWith("INSTRUMENT")) continue;
            if (line.startsWith("END IONS")) {
                insideSpectrum = false;
                Precursor precursor = rt1 != -1.0 && rt2 != -1.0 ? new Precursor(precursorMz, precursorIntensity, precursorCharges, rt1, rt2) : new Precursor(rt, precursorMz, precursorIntensity, precursorCharges);
                double[] mzArray = mzList.stream().mapToDouble(a -> a).toArray();
                double[] intensityArray = intensityList.stream().mapToDouble(a -> a).toArray();
                Spectrum spectrum = new Spectrum(precursor, mzArray, intensityArray);
                return spectrum;
            }
            if (!insideSpectrum || line.equals("")) continue;
            try {
                String[] values = line.split("\\s+");
                double mz = Double.parseDouble(values[0]);
                mzList.add(mz);
                double intensity = Double.parseDouble(values[1]);
                intensityList.add(intensity);
            }
            catch (Exception exception) {}
        }
        throw new IllegalArgumentException("End of the file reached before encountering the tag \"END IONS\".");
    }

    private static int[] parseCharges(String chargeLine) {
        ArrayList<Integer> result = new ArrayList<Integer>(1);
        String tempLine = chargeLine.substring(chargeLine.indexOf("=") + 1);
        String[] chargesAnd = tempLine.split(" and ");
        ArrayList<String> chargesAsString = new ArrayList<String>();
        for (String charge : chargesAnd) {
            for (String charge2 : charge.split(",")) {
                chargesAsString.add(charge2.trim());
            }
        }
        for (String chargeAsString : chargesAsString) {
            if ((chargeAsString = chargeAsString.trim()).isEmpty()) continue;
            try {
                int value;
                if (chargeAsString.endsWith("+")) {
                    value = Integer.parseInt(chargeAsString.substring(0, chargeAsString.length() - 1));
                    result.add(value);
                    continue;
                }
                if (chargeAsString.endsWith("-")) {
                    value = Integer.parseInt(chargeAsString.substring(0, chargeAsString.length() - 1));
                    result.add(value);
                    continue;
                }
                if (chargeAsString.equalsIgnoreCase("Mr")) continue;
                value = Integer.parseInt(chargeAsString);
                result.add(value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("'" + chargeAsString + "' could not be processed as a valid precursor charge!");
            }
        }
        if (result.isEmpty()) {
            result.add(1);
        }
        return result.stream().mapToInt(a -> a).toArray();
    }

    public static Precursor getPrecursor(BufferedRandomAccessFile bufferedRandomAccessFile, long index, String fileName) throws IOException {
        String line;
        bufferedRandomAccessFile.seek(index);
        String title = null;
        double precursorMz = 0.0;
        double precursorIntensity = 0.0;
        double rt = -1.0;
        double rt1 = -1.0;
        double rt2 = -1.0;
        int[] precursorCharges = null;
        while ((line = bufferedRandomAccessFile.getNextLine()) != null) {
            if (line.endsWith("\r")) {
                line = line.replace("\r", "");
            }
            if (line.startsWith("TITLE")) {
                title = line.substring(line.indexOf("=") + 1).trim();
                try {
                    title = URLDecoder.decode(title, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("An exception was thrown when trying to decode an mgf title: " + title);
                    e.printStackTrace();
                }
                continue;
            }
            if (line.startsWith("CHARGE")) {
                precursorCharges = IndexedMgfReader.parseCharges(line);
                continue;
            }
            if (line.startsWith("PEPMASS")) {
                String temp = line.substring(line.indexOf("=") + 1);
                String[] values = temp.split("\\s");
                precursorMz = Double.parseDouble(values[0]);
                if (values.length > 1) {
                    precursorIntensity = Double.parseDouble(values[1]);
                    continue;
                }
                precursorIntensity = 0.0;
                continue;
            }
            if (line.startsWith("RTINSECONDS")) {
                try {
                    String rtInput = line.substring(line.indexOf(61) + 1);
                    String[] rtWindow = rtInput.split("-");
                    if (rtWindow.length == 1) {
                        String tempRt = rtWindow[0];
                        if (tempRt.startsWith("PT") && tempRt.endsWith("S")) {
                            tempRt = tempRt.substring(2, tempRt.length() - 1);
                        }
                        rt = Double.valueOf(tempRt);
                        continue;
                    }
                    if (rtWindow.length != 2) continue;
                    rt1 = Double.valueOf(rtWindow[0]);
                    rt2 = Double.valueOf(rtWindow[1]);
                }
                catch (Exception e) {
                    System.out.println("An exception was thrown when trying to decode the retention time: " + title);
                    e.printStackTrace();
                }
                continue;
            }
            if (line.isEmpty() || !line.startsWith("END IONS") && (line.contains("#") || line.contains("="))) continue;
            if (rt1 != -1.0 && rt2 != -1.0) {
                return new Precursor(precursorMz, precursorIntensity, precursorCharges, rt1, rt2);
            }
            return new Precursor(rt, precursorMz, precursorIntensity, precursorCharges);
        }
        throw new IllegalArgumentException("End of the file reached before encountering the tag \"END IONS\". File: " + fileName + ", title: " + title);
    }
}

