/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.mass_spectrometry.mgf;

import com.compomics.util.experiment.io.mass_spectrometry.MsFileIterator;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;

public class MgfFileIterator
implements MsFileIterator {
    private final SimpleFileReader reader;
    private final WaitingHandler waitingHandler;
    private Spectrum spectrum = null;

    public MgfFileIterator(File mgfFile, WaitingHandler waitingHandler) {
        this.reader = SimpleFileReader.getFileReader(mgfFile);
        this.waitingHandler = waitingHandler;
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(100);
    }

    @Override
    public String next() {
        String line;
        this.spectrum = null;
        double precursorMz = 0.0;
        double precursorIntensity = 0.0;
        double rt = -1.0;
        double rt1 = -1.0;
        double rt2 = -1.0;
        int[] precursorCharges = new int[]{};
        String spectrumTitle = "";
        ArrayList<Double> mzList = new ArrayList<Double>(0);
        ArrayList<Double> intensityList = new ArrayList<Double>(0);
        boolean spectrumBlock = false;
        while ((line = this.reader.readLine()) != null && !this.waitingHandler.isRunCanceled()) {
            if (line.endsWith("\r")) {
                line = line.replace("\r", "");
            }
            if (line.startsWith("BEGIN IONS")) {
                spectrumTitle = "";
                mzList = new ArrayList();
                intensityList = new ArrayList();
                spectrumBlock = true;
                continue;
            }
            if (line.startsWith("TITLE")) {
                spectrumTitle = line.substring(line.indexOf(61) + 1).trim();
                try {
                    spectrumTitle = URLDecoder.decode(spectrumTitle, "utf-8");
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("An exception was thrown when trying to decode the mgf title '" + spectrumTitle + "'.");
                }
            }
            if (line.startsWith("CHARGE")) {
                precursorCharges = MgfFileIterator.parseCharges(line);
                continue;
            }
            if (line.startsWith("PEPMASS")) {
                String temp = line.substring(line.indexOf("=") + 1);
                String[] values = temp.split("\\s");
                precursorMz = Double.parseDouble(values[0]);
                if (values.length > 1) {
                    precursorIntensity = Double.parseDouble(values[1]);
                    continue;
                }
                precursorIntensity = 0.0;
                continue;
            }
            if (line.startsWith("RTINSECONDS")) {
                String rtInput = line.substring(line.indexOf(61) + 1);
                try {
                    String[] rtWindow = rtInput.split("-");
                    if (rtWindow.length == 1) {
                        String tempRt = rtWindow[0];
                        if (tempRt.startsWith("PT") && tempRt.endsWith("S")) {
                            tempRt = tempRt.substring(2, tempRt.length() - 1);
                        }
                        rt = Double.valueOf(tempRt);
                        continue;
                    }
                    if (rtWindow.length != 2) continue;
                    rt1 = Double.valueOf(rtWindow[0]);
                    rt2 = Double.valueOf(rtWindow[1]);
                }
                catch (Exception e) {
                    System.out.println("An exception was thrown when trying to decode the retention time " + rtInput + " in spectrum " + spectrumTitle + ".");
                    e.printStackTrace();
                }
                continue;
            }
            if (line.startsWith("TOLU") || line.startsWith("TOL") || line.startsWith("SEQ") || line.startsWith("COMP") || line.startsWith("ETAG") || line.startsWith("TAG") || line.startsWith("SCANS") || line.startsWith("TAG") || line.startsWith("RAWSCANS")) continue;
            if (line.startsWith("END IONS")) {
                Precursor precursor = rt1 != -1.0 && rt2 != -1.0 ? new Precursor(precursorMz, precursorIntensity, precursorCharges, rt1, rt2) : new Precursor(rt, precursorMz, precursorIntensity, precursorCharges);
                double[] mzArray = mzList.stream().mapToDouble(a -> a).toArray();
                double[] intensityArray = intensityList.stream().mapToDouble(a -> a).toArray();
                this.spectrum = new Spectrum(precursor, mzArray, intensityArray);
                spectrumBlock = false;
                double progress = this.reader.getProgressInPercent();
                this.waitingHandler.setSecondaryProgressCounter((int)progress);
                return spectrumTitle;
            }
            if (!spectrumBlock || line.equals("")) continue;
            try {
                String[] values = line.split("\\s+");
                double mz = Double.valueOf(values[0]);
                mzList.add(mz);
                double intensity = Double.valueOf(values[1]);
                intensityList.add(intensity);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    @Override
    public Spectrum getSpectrum() {
        return this.spectrum;
    }

    private static int[] parseCharges(String chargeLine) {
        ArrayList<Integer> result = new ArrayList<Integer>(1);
        String tempLine = chargeLine.substring(chargeLine.indexOf("=") + 1);
        String[] chargesAnd = tempLine.split(" and ");
        ArrayList<String> chargesAsString = new ArrayList<String>();
        for (String charge : chargesAnd) {
            for (String charge2 : charge.split(",")) {
                chargesAsString.add(charge2.trim());
            }
        }
        for (String chargeAsString : chargesAsString) {
            if ((chargeAsString = chargeAsString.trim()).isEmpty()) continue;
            try {
                int value;
                if (chargeAsString.endsWith("+")) {
                    value = Integer.parseInt(chargeAsString.substring(0, chargeAsString.length() - 1));
                    result.add(value);
                    continue;
                }
                if (chargeAsString.endsWith("-")) {
                    value = Integer.parseInt(chargeAsString.substring(0, chargeAsString.length() - 1));
                    result.add(value);
                    continue;
                }
                if (chargeAsString.equalsIgnoreCase("Mr")) continue;
                value = Integer.parseInt(chargeAsString);
                result.add(value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("'" + chargeAsString + "' could not be processed as a valid precursor charge!");
            }
        }
        if (result.isEmpty()) {
            result.add(1);
        }
        return result.stream().mapToInt(a -> a).toArray();
    }

    @Override
    public void close() {
        this.waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        this.reader.close();
    }
}

