/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.mass_spectrometry.mgf;

import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class MgfIndex
extends ExperimentObject
implements Serializable {
    private HashMap<String, Long> indexMap;
    private HashMap<String, Integer> spectrumNumberIndexMap;
    private ArrayList<String> spectrumTitles = null;
    private HashMap<String, Integer> duplicatedSpectrumTitles = null;
    private HashMap<Integer, Double> precursorMzMap = null;
    private String fileName;
    private Long lastModified;
    private Double maxRT;
    private Double minRT;
    private Double maxMz;
    private Double maxIntensity;
    private Integer maxCharge;
    private Integer maxPeakCount;
    private Boolean peakPicked = null;
    private Integer spectrumCount = null;
    private Boolean precursorChargesMissing = null;

    public MgfIndex() {
    }

    public MgfIndex(ArrayList<String> spectrumTitles, HashMap<String, Long> indexMap, HashMap<String, Integer> spectrumNumberIndexMap, HashMap<Integer, Double> precursorMzMap, String fileName, double minRT, double maxRT, double maxMz, double maxIntensity, int maxCharge, int maxPeakCount, boolean peakPicked, boolean precursorChargesMissing, long lastModified) {
        this.spectrumTitles = spectrumTitles;
        this.duplicatedSpectrumTitles = null;
        this.indexMap = indexMap;
        this.spectrumNumberIndexMap = spectrumNumberIndexMap;
        this.precursorMzMap = precursorMzMap;
        this.fileName = fileName;
        this.maxRT = maxRT;
        this.minRT = minRT;
        this.maxMz = maxMz;
        this.maxIntensity = maxIntensity;
        this.maxCharge = maxCharge;
        this.maxPeakCount = maxPeakCount;
        this.peakPicked = peakPicked;
        this.precursorChargesMissing = precursorChargesMissing;
        this.lastModified = lastModified;
    }

    public MgfIndex(ArrayList<String> spectrumTitles, HashMap<String, Integer> duplicatedSpectrumTitles, HashMap<String, Long> indexMap, HashMap<String, Integer> spectrumNumberIndexMap, HashMap<Integer, Double> precursorMzMap, String fileName, double minRT, double maxRT, double maxMz, double maxIntensity, int maxCharge, int maxPeakCount, boolean peakPicked, boolean precursorChargesMissing, long lastModified, int spectrumCount) {
        this.spectrumTitles = spectrumTitles;
        this.duplicatedSpectrumTitles = duplicatedSpectrumTitles;
        this.indexMap = indexMap;
        this.spectrumNumberIndexMap = spectrumNumberIndexMap;
        this.precursorMzMap = precursorMzMap;
        this.fileName = fileName;
        this.maxRT = maxRT;
        this.minRT = minRT;
        this.maxMz = maxMz;
        this.maxIntensity = maxIntensity;
        this.maxCharge = maxCharge;
        this.maxPeakCount = maxPeakCount;
        this.peakPicked = peakPicked;
        this.precursorChargesMissing = precursorChargesMissing;
        this.lastModified = lastModified;
        this.spectrumCount = spectrumCount;
    }

    public Long getIndex(String spectrumTitle) {
        return this.indexMap.get(spectrumTitle);
    }

    public Integer getSpectrumIndex(String spectrumTitle) {
        if (this.spectrumNumberIndexMap == null) {
            return null;
        }
        Integer index = this.spectrumNumberIndexMap.get(spectrumTitle);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public Double getPrecursorMz(int spectrumIndex) {
        if (this.precursorMzMap == null) {
            return null;
        }
        Double mz = this.precursorMzMap.get(spectrumIndex);
        if (mz == null) {
            return null;
        }
        return mz;
    }

    public String getSpectrumTitle(int number) {
        return this.spectrumTitles.get(number);
    }

    public boolean containsSpectrum(String spectrumTitle) {
        return this.indexMap.containsKey(spectrumTitle);
    }

    public ArrayList<String> getSpectrumTitles() {
        if (this.spectrumTitles != null) {
            return this.spectrumTitles;
        }
        return new ArrayList<String>(this.indexMap.keySet());
    }

    public HashMap<String, Integer> getDuplicatedSpectrumTitles() {
        return this.duplicatedSpectrumTitles;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Double getMaxRT() {
        return this.maxRT;
    }

    public void setMaxRT(Double maxRT) {
        this.maxRT = maxRT;
    }

    public Double getMaxMz() {
        return this.maxMz;
    }

    public void setMaxCharge(Integer maxCharge) {
        this.maxCharge = maxCharge;
    }

    public Integer getMaxCharge() {
        return this.maxCharge;
    }

    public void setMaxMz(Double maxMz) {
        this.maxMz = maxMz;
    }

    public Double getMaxIntensity() {
        return this.maxIntensity;
    }

    public void setMaxIntensity(Double maxIntensity) {
        this.maxIntensity = maxIntensity;
    }

    public Double getMinRT() {
        return this.minRT;
    }

    public void setMinRT(Double minRT) {
        this.minRT = minRT;
    }

    public Integer getMaxPeakCount() {
        return this.maxPeakCount;
    }

    public void setMaxPeakCount(Integer maxPeakCount) {
        this.maxPeakCount = maxPeakCount;
    }

    public int getNSpectra() {
        if (this.spectrumCount == null) {
            this.spectrumCount = this.spectrumTitles.size();
        }
        return this.spectrumCount;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public Boolean isPeakPicked() {
        if (this.peakPicked == null) {
            this.peakPicked = true;
        }
        return this.peakPicked;
    }

    public void setPeakPicked(Boolean peakPicked) {
        this.peakPicked = peakPicked;
    }

    public Boolean isPrecursorChargesMissing() {
        return this.precursorChargesMissing;
    }

    public void setPrecursorChargesMissing(Boolean precursorChargesMissing) {
        this.precursorChargesMissing = precursorChargesMissing;
    }

    public static Spectrum getSpectrum(BufferedRandomAccessFile bufferedRandomAccessFile, long index) throws IOException {
        String line;
        bufferedRandomAccessFile.seek(index);
        double precursorMz = 0.0;
        double precursorIntensity = 0.0;
        double rt = -1.0;
        double rt1 = -1.0;
        double rt2 = -1.0;
        int[] precursorCharges = null;
        String spectrumTitle = "";
        boolean insideSpectrum = false;
        ArrayList<Double> mzList = new ArrayList<Double>(0);
        ArrayList<Double> intensityList = new ArrayList<Double>(0);
        while ((line = bufferedRandomAccessFile.getNextLine()) != null) {
            if (line.endsWith("\r")) {
                line = line.replace("\r", "");
            }
            if (line.startsWith("BEGIN IONS")) {
                insideSpectrum = true;
                mzList = new ArrayList();
                intensityList = new ArrayList();
                continue;
            }
            if (line.startsWith("TITLE")) {
                insideSpectrum = true;
                spectrumTitle = line.substring(line.indexOf(61) + 1).trim();
                try {
                    spectrumTitle = URLDecoder.decode(spectrumTitle, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("An exception was thrown when trying to decode an mgf title: " + spectrumTitle);
                    e.printStackTrace();
                }
                continue;
            }
            if (line.startsWith("CHARGE")) {
                precursorCharges = MgfIndex.parseCharges(line);
                continue;
            }
            if (line.startsWith("PEPMASS")) {
                String temp = line.substring(line.indexOf("=") + 1);
                String[] values = temp.split("\\s");
                precursorMz = Double.parseDouble(values[0]);
                if (values.length > 1) {
                    precursorIntensity = Double.parseDouble(values[1]);
                    continue;
                }
                precursorIntensity = 0.0;
                continue;
            }
            if (line.startsWith("RTINSECONDS")) {
                try {
                    String rtInput = line.substring(line.indexOf(61) + 1);
                    String[] rtWindow = rtInput.split("-");
                    if (rtWindow.length == 1) {
                        String tempRt = rtWindow[0];
                        if (tempRt.startsWith("PT") && tempRt.endsWith("S")) {
                            tempRt = tempRt.substring(2, tempRt.length() - 1);
                        }
                        rt = Double.valueOf(tempRt);
                        continue;
                    }
                    if (rtWindow.length != 2) continue;
                    rt1 = Double.valueOf(rtWindow[0]);
                    rt2 = Double.valueOf(rtWindow[1]);
                }
                catch (Exception e) {
                    System.out.println("An exception was thrown when trying to decode the retention time: " + spectrumTitle);
                    e.printStackTrace();
                }
                continue;
            }
            if (line.startsWith("TOLU") || line.startsWith("TOL") || line.startsWith("SEQ") || line.startsWith("COMP") || line.startsWith("ETAG") || line.startsWith("TAG") || line.startsWith("SCANS") || line.startsWith("INSTRUMENT")) continue;
            if (line.startsWith("END IONS")) {
                insideSpectrum = false;
                Precursor precursor = rt1 != -1.0 && rt2 != -1.0 ? new Precursor(precursorMz, precursorIntensity, precursorCharges, rt1, rt2) : new Precursor(rt, precursorMz, precursorIntensity, precursorCharges);
                double[] mzArray = mzList.stream().mapToDouble(a -> a).toArray();
                double[] intensityArray = intensityList.stream().mapToDouble(a -> a).toArray();
                Spectrum spectrum = new Spectrum(precursor, mzArray, intensityArray);
                return spectrum;
            }
            if (!insideSpectrum || line.equals("")) continue;
            try {
                String[] values = line.split("\\s+");
                double mz = Double.parseDouble(values[0]);
                mzList.add(mz);
                double intensity = Double.parseDouble(values[1]);
                intensityList.add(intensity);
            }
            catch (Exception exception) {}
        }
        throw new IllegalArgumentException("End of the file reached before encountering the tag \"END IONS\".");
    }

    private static int[] parseCharges(String chargeLine) {
        ArrayList<Integer> result = new ArrayList<Integer>(1);
        String tempLine = chargeLine.substring(chargeLine.indexOf("=") + 1);
        String[] chargesAnd = tempLine.split(" and ");
        ArrayList<String> chargesAsString = new ArrayList<String>();
        for (String charge : chargesAnd) {
            for (String charge2 : charge.split(",")) {
                chargesAsString.add(charge2.trim());
            }
        }
        for (String chargeAsString : chargesAsString) {
            if ((chargeAsString = chargeAsString.trim()).isEmpty()) continue;
            try {
                int value;
                if (chargeAsString.endsWith("+")) {
                    value = Integer.parseInt(chargeAsString.substring(0, chargeAsString.length() - 1));
                    result.add(value);
                    continue;
                }
                if (chargeAsString.endsWith("-")) {
                    value = Integer.parseInt(chargeAsString.substring(0, chargeAsString.length() - 1));
                    result.add(value);
                    continue;
                }
                if (chargeAsString.equalsIgnoreCase("Mr")) continue;
                value = Integer.parseInt(chargeAsString);
                result.add(value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("'" + chargeAsString + "' could not be processed as a valid precursor charge!");
            }
        }
        if (result.isEmpty()) {
            result.add(1);
        }
        return result.stream().mapToInt(a -> a).toArray();
    }
}

