/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.mass_spectrometry.ms2;

import com.compomics.util.experiment.biology.ions.impl.ElementaryIon;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.io.flat.SimpleFileWriter;
import java.io.File;
import java.util.Date;
import java.util.stream.IntStream;

public class Ms2FileWriter {
    private final SimpleFileWriter writer;

    public Ms2FileWriter() {
        this.writer = null;
    }

    public Ms2FileWriter(File destinationFile) {
        this.writer = new SimpleFileWriter(destinationFile, false);
    }

    public void writeHeader() {
        this.writer.writeLine("H\tCreationDate\t" + new Date());
        this.writer.writeLine("H\tExtractor\tUnknown");
        this.writer.writeLine("H\tExtractorVersion\tUnknown");
        this.writer.writeLine("H\tExtractorOptions\tUnknown");
        this.writer.writeLine("H\tComment\tCreated by compomics utilities based on http://cruxtoolkit.sourceforge.net/ms2-format.html");
    }

    public void writeSpectrum(Spectrum spectrum, int scanNumber) {
        Precursor precursor = spectrum.getPrecursor();
        this.writer.writeLine(String.join((CharSequence)"\t", "S", Integer.toString(scanNumber), Integer.toString(scanNumber), Double.toString(precursor.mz)));
        for (int charge : precursor.possibleCharges) {
            this.writer.writeLine(String.join((CharSequence)"\t", "Z", Integer.toString(charge), Double.toString(precursor.getMass(charge) + ElementaryIon.proton.getTheoreticMass())));
        }
        IntStream.range(0, spectrum.getNPeaks()).forEach(i -> this.writer.writeLine(String.join((CharSequence)" ", Double.toString(spectrum.mz[i]), Double.toString(spectrum.intensity[i]))));
        this.writer.newLine();
    }
}

