/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.mass_spectrometry.spectra;

import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class RecalibrationUtils {
    public static Precursor getRecalibratedPrecursor(Precursor precursor, double mzCorrection, double rtCorrection) {
        return new Precursor(precursor.rt - rtCorrection, precursor.mz - mzCorrection, precursor.intensity, precursor.possibleCharges);
    }

    public static double[] getRecalibratedMz(TreeMap<Double, Double> mzCorrections, double[] originalMz) {
        double[] result = new double[originalMz.length];
        for (int i = 0; i < originalMz.length; ++i) {
            double fragmentMz = originalMz[i];
            double correction = RecalibrationUtils.getCorrection(fragmentMz, mzCorrections);
            result[i] = fragmentMz - correction;
        }
        return result;
    }

    private static double getCorrection(double fragmentMz, TreeMap<Double, Double> mzCorrections) {
        Map.Entry<Double, Double> entry = mzCorrections.firstEntry();
        if (fragmentMz <= entry.getKey() || mzCorrections.size() == 1) {
            return entry.getValue();
        }
        entry = mzCorrections.lastEntry();
        if (fragmentMz >= entry.getKey()) {
            return entry.getValue();
        }
        ArrayList<Map.Entry<Double, Double>> entryList = new ArrayList<Map.Entry<Double, Double>>(mzCorrections.entrySet());
        for (int i = 0; i < entryList.size() - 1; ++i) {
            Map.Entry<Double, Double> entry1 = entryList.get(i);
            if (entry1.getKey() == fragmentMz) {
                return entry1.getKey();
            }
            Map.Entry<Double, Double> entry2 = entryList.get(i + 1);
            if (!(entry1.getKey() < fragmentMz) || !(fragmentMz < entry2.getKey())) continue;
            return entry1.getValue() + (fragmentMz - entry1.getKey()) * (entry2.getValue() - entry1.getValue()) / (entry2.getKey() - entry1.getKey());
        }
        throw new IllegalArgumentException("Could not find correction for fragment m/z.");
    }
}

