/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.mass_spectrometry.thermo_raw_file_parser.gui;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.mass_spectrometry.thermo_raw_file_parser.ThermoRawFileParserOutputFormat;
import com.compomics.util.experiment.mass_spectrometry.thermo_raw_file_parser.ThermoRawFileParserParameters;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class ThermoRawFileParserParametersDialog
extends JDialog {
    private boolean canceled = false;
    private JLabel advancedSettingsWarningLabel;
    private JPanel backgourdPanel;
    private JButton cancelButton;
    private JPanel installationPanel;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JComboBox outputFormatCmb;
    private JLabel outputPepXmlLabel;
    private JComboBox peakPickingCmb;
    private JLabel peakPickingLabel;

    public ThermoRawFileParserParametersDialog(Frame parent, ThermoRawFileParserParameters thermoRawFileParserParameters) {
        super(parent, true);
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(thermoRawFileParserParameters);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public ThermoRawFileParserParametersDialog(Dialog parent, ThermoRawFileParserParameters thermoRawFileParserParameters) {
        super(parent, true);
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(thermoRawFileParserParameters);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.outputFormatCmb.setRenderer(new AlignedListCellRenderer(0));
        this.peakPickingCmb.setRenderer(new AlignedListCellRenderer(0));
    }

    private void populateGUI(ThermoRawFileParserParameters thermoRawFileParserParameters) {
        this.outputFormatCmb.setSelectedItem((Object)thermoRawFileParserParameters.getOutputFormat());
        if (thermoRawFileParserParameters.isPeackPicking()) {
            this.peakPickingCmb.setSelectedIndex(0);
        } else {
            this.peakPickingCmb.setSelectedIndex(1);
        }
    }

    private void initComponents() {
        this.backgourdPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.installationPanel = new JPanel();
        this.outputPepXmlLabel = new JLabel();
        this.outputFormatCmb = new JComboBox();
        this.peakPickingLabel = new JLabel();
        this.peakPickingCmb = new JComboBox();
        this.openDialogHelpJButton = new JButton();
        this.advancedSettingsWarningLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("ThermoRawFileParser Settings");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ThermoRawFileParserParametersDialog.this.formWindowClosing(evt);
            }
        });
        this.backgourdPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThermoRawFileParserParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThermoRawFileParserParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.installationPanel.setBorder(BorderFactory.createTitledBorder("Conversion Setttings"));
        this.installationPanel.setOpaque(false);
        this.outputPepXmlLabel.setText("Output Format");
        this.outputFormatCmb.setModel(new DefaultComboBoxModel<ThermoRawFileParserOutputFormat>(ThermoRawFileParserOutputFormat.values()));
        this.peakPickingLabel.setText("Peak Picking");
        this.peakPickingCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        GroupLayout installationPanelLayout = new GroupLayout(this.installationPanel);
        this.installationPanel.setLayout(installationPanelLayout);
        installationPanelLayout.setHorizontalGroup(installationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(installationPanelLayout.createSequentialGroup().addContainerGap().addGroup(installationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.outputPepXmlLabel, -1, 154, Short.MAX_VALUE).addComponent(this.peakPickingLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(installationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.peakPickingCmb, 0, -1, Short.MAX_VALUE).addComponent(this.outputFormatCmb, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        installationPanelLayout.setVerticalGroup(installationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(installationPanelLayout.createSequentialGroup().addContainerGap().addGroup(installationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputPepXmlLabel).addComponent(this.outputFormatCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(installationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.peakPickingLabel).addComponent(this.peakPickingCmb, -2, -1, -2)).addContainerGap()));
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ThermoRawFileParserParametersDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ThermoRawFileParserParametersDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThermoRawFileParserParametersDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.advancedSettingsWarningLabel.setText("Open ThermoRawFileParser web page");
        GroupLayout backgourdPanelLayout = new GroupLayout(this.backgourdPanel);
        this.backgourdPanel.setLayout(backgourdPanelLayout);
        backgourdPanelLayout.setHorizontalGroup(backgourdPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgourdPanelLayout.createSequentialGroup().addGroup(backgourdPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgourdPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.installationPanel, -1, -1, Short.MAX_VALUE)).addGroup(backgourdPanelLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.openDialogHelpJButton).addGap(18, 18, 18).addComponent(this.advancedSettingsWarningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 45, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgourdPanelLayout.setVerticalGroup(backgourdPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgourdPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.installationPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgourdPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.advancedSettingsWarningLabel).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgourdPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgourdPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        int value;
        boolean formatCheck = true;
        ThermoRawFileParserOutputFormat selectedFormat = (ThermoRawFileParserOutputFormat)((Object)this.outputFormatCmb.getSelectedItem());
        if (selectedFormat != ThermoRawFileParserOutputFormat.mgf && selectedFormat != ThermoRawFileParserOutputFormat.mzML && selectedFormat != ThermoRawFileParserOutputFormat.mzMLIndexed && (value = JOptionPane.showConfirmDialog(this, "This format is not compatible with SearchGUI. Proceed anyway?", "Output Format Warning", 0, 2)) == 1) {
            formatCheck = false;
        }
        if (formatCheck) {
            this.dispose();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelButtonActionPerformed(null);
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://github.com/compomics/ThermoRawFileParser");
        this.setCursor(new Cursor(0));
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public ThermoRawFileParserParameters getThermoRawFileParserParameters() {
        ThermoRawFileParserParameters thermoRawFileParserParameters = new ThermoRawFileParserParameters();
        thermoRawFileParserParameters.setMsFormat((ThermoRawFileParserOutputFormat)((Object)this.outputFormatCmb.getSelectedItem()));
        thermoRawFileParserParameters.setPeackPicking(this.peakPickingCmb.getSelectedIndex() == 0);
        return thermoRawFileParserParameters;
    }
}

