/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.general;

import com.compomics.util.enumeration.MolecularElement;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IsotopicElement {
    Logger logger = LogManager.getLogger(IsotopicElement.class);
    private final MolecularElement iElement;
    private final int iDaltonDifference;
    private final double iOccurrence;

    private IsotopicElement(MolecularElement iElement, int iDaltonDifference, double iOccurrence) {
        this.iElement = iElement;
        this.iDaltonDifference = iDaltonDifference;
        this.iOccurrence = iOccurrence;
    }

    public static Vector<IsotopicElement> getAllIsotopicElements(Class lClass, Logger lLogger) {
        Vector<IsotopicElement> lResult = new Vector<IsotopicElement>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(lClass.getClassLoader().getResourceAsStream("isotopicElement.txt")));
            while ((line = br.readLine()) != null) {
                String[] lEle = line.split(",");
                for (MolecularElement lMolecularElement : MolecularElement.values()) {
                    if (!lMolecularElement.toString().equalsIgnoreCase(lEle[0])) continue;
                    lResult.add(new IsotopicElement(lMolecularElement, Integer.valueOf(lEle[1]), Double.valueOf(lEle[2])));
                }
            }
            br.close();
        }
        catch (Exception e) {
            lLogger.error((Object)e);
        }
        return lResult;
    }

    public MolecularElement getElement() {
        return this.iElement;
    }

    public int getDaltonDifference() {
        return this.iDaltonDifference;
    }

    public double getOccurrence() {
        return this.iOccurrence;
    }

    public String toString() {
        return (Object)((Object)this.iElement) + " Da diff:" + this.iDaltonDifference + " Occurrence:" + this.iOccurrence;
    }
}

