/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.enzymes;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.gui.enzymes.EnzymesDialog;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.pride.CvTerm;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class NewEnzymeDialog
extends JDialog {
    private EnzymeFactory enzymeFactory = EnzymeFactory.getInstance();
    private EnzymesDialog enzymesDialog;
    private boolean canceled = false;
    private JPanel backgroundPanel;
    private JLabel butNotAfterLabel;
    private JTextField butNotAfterTxt;
    private JLabel butNotBeforeLabel;
    private JTextField butNotBeforeTxt;
    private JButton cancelButton;
    private JPanel cleavageRulesPanel;
    private JLabel cleavesAfterLabel;
    private JTextField cleavesAfterTxt;
    private JLabel cleavesBeforeLabel;
    private JTextField cleavesBeforeTxt;
    private JButton helpJButton;
    private JLabel nameLabel;
    private JTextField nameTxt;
    private JButton okButton;
    private JPanel psMsMappingPanel;
    private JTextField psiMsAccessionJTextField;
    private JLabel psiMsAccessionLabel;
    private JLabel psiMsLinkLabel;

    public NewEnzymeDialog(EnzymesDialog enzymesDialog) {
        super((Dialog)enzymesDialog, true);
        this.enzymesDialog = enzymesDialog;
        this.initComponents();
        this.setLocationRelativeTo(enzymesDialog);
        this.setVisible(true);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private boolean validateInput(boolean showMessage) {
        boolean error = false;
        this.nameLabel.setForeground(Color.BLACK);
        this.cleavesAfterLabel.setForeground(Color.BLACK);
        this.butNotBeforeLabel.setForeground(Color.BLACK);
        this.cleavesBeforeLabel.setForeground(Color.BLACK);
        this.butNotAfterLabel.setForeground(Color.BLACK);
        this.psiMsAccessionLabel.setForeground(Color.BLACK);
        this.nameLabel.setToolTipText(null);
        this.nameTxt.setToolTipText(null);
        this.cleavesAfterLabel.setToolTipText(null);
        this.cleavesAfterTxt.setToolTipText(null);
        this.butNotBeforeLabel.setToolTipText(null);
        this.butNotBeforeTxt.setToolTipText(null);
        this.cleavesBeforeLabel.setToolTipText(null);
        this.cleavesBeforeTxt.setToolTipText(null);
        this.butNotAfterLabel.setToolTipText(null);
        this.butNotAfterTxt.setToolTipText(null);
        this.psiMsAccessionLabel.setToolTipText(null);
        this.psiMsAccessionJTextField.setToolTipText(null);
        String name = this.nameTxt.getText().trim();
        if (name.isEmpty()) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "Enzyme name required.");
            }
            error = true;
            this.nameLabel.setForeground(Color.RED);
            this.nameLabel.setToolTipText("Please provide an enzyme name");
            this.nameTxt.setToolTipText("Please provide an enzyme name");
        }
        if (name.lastIndexOf(",") != -1) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "Enzyme names cannot contain comma.");
            }
            error = true;
            this.nameLabel.setForeground(Color.RED);
            this.nameLabel.setToolTipText("Enzyme names cannot contain comma");
            this.nameTxt.setToolTipText("Enzyme names cannot contain comma");
        }
        if (this.enzymeFactory.getEnzyme(name) != null) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "An enzyme named '" + name + "' already exists.\nPlease choose a different name.", "Enzyme Already Exists", 2);
            } else {
                this.nameLabel.setForeground(Color.RED);
                this.nameLabel.setToolTipText("<html>An enzyme named '" + name + "' already exists.<br>Please choose a different name.</html>");
                this.nameTxt.setToolTipText("<html>An enzyme named '" + name + "' already exists.<br>Please choose a different name.</html>");
            }
            error = true;
        }
        if (this.cleavesAfterTxt.getText().trim().isEmpty() && this.cleavesBeforeTxt.getText().trim().isEmpty()) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "Please provide at least one amino acid for the\ncleaves after or cleaves before options.", "Cleaving Pattern Missing", 2);
            }
            error = true;
            this.cleavesAfterLabel.setForeground(Color.RED);
            this.cleavesAfterLabel.setToolTipText("Please provide a cleavage pattern");
            this.cleavesAfterTxt.setToolTipText("Please provide a cleavage pattern");
            this.cleavesBeforeLabel.setForeground(Color.RED);
            this.cleavesBeforeLabel.setToolTipText("Please provide a cleavage pattern");
            this.cleavesBeforeTxt.setToolTipText("Please provide a cleavage pattern");
        }
        if (!this.cleavesAfterTxt.getText().trim().isEmpty() && !this.validateAminoAcidInput(this.cleavesAfterTxt.getText())) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "Please provide a comma separate list of amino acids.", "Amino Acid List Error", 2);
            }
            error = true;
            this.cleavesAfterLabel.setForeground(Color.RED);
            this.cleavesAfterLabel.setToolTipText("Please provide a comma separate list of amino acids");
            this.cleavesAfterTxt.setToolTipText("Please provide a comma separate list of amino acids");
        }
        if (!this.butNotBeforeTxt.getText().trim().isEmpty() && !this.validateAminoAcidInput(this.butNotBeforeTxt.getText())) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "Please provide a comma separate list of amino acids.", "Amino Acid List Error", 2);
            }
            error = true;
            this.butNotBeforeLabel.setForeground(Color.RED);
            this.butNotBeforeLabel.setToolTipText("Please provide a comma separate list of amino acids");
            this.butNotBeforeTxt.setToolTipText("Please provide a comma separate list of amino acids");
        }
        if (!this.cleavesBeforeTxt.getText().trim().isEmpty() && !this.validateAminoAcidInput(this.cleavesBeforeTxt.getText())) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "Please provide a comma separate list of amino acids.", "Amino Acid List Error", 2);
            }
            error = true;
            this.cleavesBeforeLabel.setForeground(Color.RED);
            this.cleavesBeforeLabel.setToolTipText("Please provide a comma separate list of amino acids");
            this.cleavesBeforeTxt.setToolTipText("Please provide a comma separate list of amino acids");
        }
        if (!this.butNotAfterTxt.getText().trim().isEmpty() && !this.validateAminoAcidInput(this.butNotAfterTxt.getText())) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "Please provide a comma separate list of amino acids.", "Amino Acid List Error", 2);
            }
            error = true;
            this.butNotAfterLabel.setForeground(Color.RED);
            this.butNotAfterLabel.setToolTipText("Please provide a comma separate list of amino acids");
            this.butNotAfterTxt.setToolTipText("Please provide a comma separate list of amino acids");
        }
        if (!this.psiMsAccessionJTextField.getText().trim().isEmpty()) {
            try {
                Integer.valueOf(this.psiMsAccessionJTextField.getText().trim());
            }
            catch (NumberFormatException e) {
                if (showMessage && !error) {
                    JOptionPane.showMessageDialog(this, "Please provide the PSI-MS accession number as an integer.", "PSI-MS Accession", 2);
                }
                error = true;
                this.psiMsAccessionLabel.setForeground(Color.RED);
                this.psiMsAccessionLabel.setToolTipText("Please provide the PSI-MS accession number as an integer");
                this.psiMsAccessionJTextField.setToolTipText("Please provide the PSI-MS accession number as an integer");
            }
        }
        this.okButton.setEnabled(!error);
        return true;
    }

    private boolean validateAminoAcidInput(String aminoAcidList) {
        String[] tempAminoAcids;
        for (String tempAminoAcid : tempAminoAcids = aminoAcidList.split(",")) {
            if (AminoAcid.getAminoAcidsList().contains(tempAminoAcid.trim())) continue;
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.cleavageRulesPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTxt = new JTextField();
        this.cleavesAfterLabel = new JLabel();
        this.cleavesAfterTxt = new JTextField();
        this.butNotBeforeLabel = new JLabel();
        this.butNotBeforeTxt = new JTextField();
        this.cleavesBeforeLabel = new JLabel();
        this.cleavesBeforeTxt = new JTextField();
        this.butNotAfterLabel = new JLabel();
        this.butNotAfterTxt = new JTextField();
        this.psMsMappingPanel = new JPanel();
        this.psiMsAccessionLabel = new JLabel();
        this.psiMsAccessionJTextField = new JTextField();
        this.psiMsLinkLabel = new JLabel();
        this.helpJButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("New Enzyme");
        this.setMinimumSize(new Dimension(400, 300));
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.backgroundPanel.setPreferredSize(new Dimension(800, 600));
        this.cleavageRulesPanel.setBorder(BorderFactory.createTitledBorder("Cleavage Rules"));
        this.cleavageRulesPanel.setOpaque(false);
        this.nameLabel.setText("Name");
        this.nameLabel.setToolTipText("The modification name");
        this.nameTxt.setHorizontalAlignment(0);
        this.nameTxt.setToolTipText("The enzyme name");
        this.nameTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NewEnzymeDialog.this.nameTxtKeyReleased(evt);
            }
        });
        this.cleavesAfterLabel.setText("Cleaves After");
        this.cleavesAfterTxt.setHorizontalAlignment(0);
        this.cleavesAfterTxt.setToolTipText("Comma separated list of amino acids");
        this.cleavesAfterTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NewEnzymeDialog.this.cleavesAfterTxtKeyReleased(evt);
            }
        });
        this.butNotBeforeLabel.setText("But Not Before");
        this.butNotBeforeLabel.setToolTipText("Residues modified");
        this.butNotBeforeTxt.setHorizontalAlignment(0);
        this.butNotBeforeTxt.setToolTipText("Comma separated list of amino acids");
        this.butNotBeforeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NewEnzymeDialog.this.butNotBeforeTxtKeyReleased(evt);
            }
        });
        this.cleavesBeforeLabel.setText("Cleaves Before");
        this.cleavesBeforeLabel.setToolTipText("The modification name");
        this.cleavesBeforeTxt.setHorizontalAlignment(0);
        this.cleavesBeforeTxt.setToolTipText("Comma separated list of amino acids");
        this.cleavesBeforeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NewEnzymeDialog.this.cleavesBeforeTxtKeyReleased(evt);
            }
        });
        this.butNotAfterLabel.setText("But Not After");
        this.butNotAfterLabel.setToolTipText("Monoisotopic mass");
        this.butNotAfterTxt.setHorizontalAlignment(0);
        this.butNotAfterTxt.setToolTipText("Comma separated list of amino acids");
        this.butNotAfterTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NewEnzymeDialog.this.butNotAfterTxtKeyReleased(evt);
            }
        });
        GroupLayout cleavageRulesPanelLayout = new GroupLayout(this.cleavageRulesPanel);
        this.cleavageRulesPanel.setLayout(cleavageRulesPanelLayout);
        cleavageRulesPanelLayout.setHorizontalGroup(cleavageRulesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cleavageRulesPanelLayout.createSequentialGroup().addContainerGap().addGroup(cleavageRulesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cleavageRulesPanelLayout.createSequentialGroup().addComponent(this.nameLabel, -1, 90, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.nameTxt)).addGroup(cleavageRulesPanelLayout.createSequentialGroup().addGroup(cleavageRulesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.butNotBeforeLabel, -2, 90, -2).addComponent(this.cleavesAfterLabel).addComponent(this.cleavesBeforeLabel).addComponent(this.butNotAfterLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(cleavageRulesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.butNotBeforeTxt).addComponent(this.cleavesAfterTxt).addComponent(this.cleavesBeforeTxt).addComponent(this.butNotAfterTxt)))).addContainerGap()));
        cleavageRulesPanelLayout.linkSize(0, this.butNotBeforeLabel, this.nameLabel);
        cleavageRulesPanelLayout.setVerticalGroup(cleavageRulesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cleavageRulesPanelLayout.createSequentialGroup().addContainerGap().addGroup(cleavageRulesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameTxt, -2, -1, -2).addComponent(this.nameLabel)).addGap(0, 0, 0).addGroup(cleavageRulesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cleavesAfterTxt, -2, -1, -2).addComponent(this.cleavesAfterLabel)).addGap(0, 0, 0).addGroup(cleavageRulesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.butNotBeforeTxt, -2, -1, -2).addComponent(this.butNotBeforeLabel)).addGap(0, 0, 0).addGroup(cleavageRulesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cleavesBeforeLabel).addComponent(this.cleavesBeforeTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(cleavageRulesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.butNotAfterLabel).addComponent(this.butNotAfterTxt, -2, -1, -2)).addContainerGap()));
        this.psMsMappingPanel.setBorder(BorderFactory.createTitledBorder("PSI-MS Mapping"));
        this.psMsMappingPanel.setOpaque(false);
        this.psiMsAccessionLabel.setText("Accession");
        this.psiMsAccessionJTextField.setHorizontalAlignment(0);
        this.psiMsAccessionJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NewEnzymeDialog.this.psiMsAccessionJTextFieldKeyReleased(evt);
            }
        });
        this.psiMsLinkLabel.setText("<html><a href>See: ebi.ac.uk/ols/ontologies/ms</a></html>");
        this.psiMsLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                NewEnzymeDialog.this.psiMsLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                NewEnzymeDialog.this.psiMsLinkLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                NewEnzymeDialog.this.psiMsLinkLabelMouseReleased(evt);
            }
        });
        GroupLayout psMsMappingPanelLayout = new GroupLayout(this.psMsMappingPanel);
        this.psMsMappingPanel.setLayout(psMsMappingPanelLayout);
        psMsMappingPanelLayout.setHorizontalGroup(psMsMappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psMsMappingPanelLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(psMsMappingPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(psMsMappingPanelLayout.createSequentialGroup().addComponent(this.psiMsAccessionLabel, -2, 84, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.psiMsAccessionJTextField, -1, 252, Short.MAX_VALUE)).addComponent(this.psiMsLinkLabel, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        psMsMappingPanelLayout.setVerticalGroup(psMsMappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psMsMappingPanelLayout.createSequentialGroup().addContainerGap().addGroup(psMsMappingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psiMsAccessionJTextField, -2, -1, -2).addComponent(this.psiMsAccessionLabel)).addGap(0, 0, 0).addComponent(this.psiMsLinkLabel, -2, -1, -2).addContainerGap()));
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                NewEnzymeDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                NewEnzymeDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewEnzymeDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewEnzymeDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewEnzymeDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.helpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cleavageRulesPanel, -1, -1, Short.MAX_VALUE)).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psMsMappingPanel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cleavageRulesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.psMsMappingPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, 344, -2));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            CvTerm psiMsCvTerm = null;
            if (!this.psiMsAccessionJTextField.getText().trim().isEmpty()) {
                int psiMsAccession = Integer.valueOf(this.psiMsAccessionJTextField.getText().trim());
                psiMsCvTerm = new CvTerm("MS", "MS:" + psiMsAccession, this.nameTxt.getText().trim(), null);
            }
            Enzyme enzyme = new Enzyme(this.nameTxt.getText().trim());
            if (!this.cleavesAfterTxt.getText().trim().isEmpty()) {
                for (String tempAminoAcid : this.cleavesAfterTxt.getText().split(",")) {
                    enzyme.addAminoAcidBefore(Character.valueOf(tempAminoAcid.trim().charAt(0)));
                }
            }
            if (!this.butNotBeforeTxt.getText().trim().isEmpty()) {
                for (String tempAminoAcid : this.butNotBeforeTxt.getText().split(",")) {
                    enzyme.addRestrictionAfter(Character.valueOf(tempAminoAcid.trim().charAt(0)));
                }
            }
            if (!this.cleavesBeforeTxt.getText().trim().isEmpty()) {
                for (String tempAminoAcid : this.cleavesBeforeTxt.getText().split(",")) {
                    enzyme.addAminoAcidBefore(Character.valueOf(tempAminoAcid.trim().charAt(0)));
                }
            }
            if (!this.butNotAfterTxt.getText().trim().isEmpty()) {
                for (String tempAminoAcid : this.butNotAfterTxt.getText().split(",")) {
                    enzyme.addRestrictionAfter(Character.valueOf(tempAminoAcid.trim().charAt(0)));
                }
            }
            enzyme.setCvTerm(psiMsCvTerm);
            this.enzymeFactory.addEnzyme(enzyme);
            this.enzymesDialog.updateEnzymesTable();
            this.dispose();
        }
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/NewEnzymeDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), null, "New Enzyme - Help");
        this.setCursor(new Cursor(0));
    }

    private void nameTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void cleavesBeforeTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void psiMsAccessionJTextFieldKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void psiMsLinkLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.ebi.ac.uk/ols/ontologies/mod");
        this.setCursor(new Cursor(0));
    }

    private void psiMsLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void psiMsLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void cleavesAfterTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void butNotBeforeTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void butNotAfterTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }
}

