/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.filtering;

import com.compomics.util.experiment.filtering.FilterItem;
import com.compomics.util.experiment.filtering.FilterItemComparator;
import com.compomics.util.experiment.identification.filtering.MatchFilter;
import com.compomics.util.gui.utils.user_choice.ListChooser;
import com.compomics.util.gui.utils.user_choice.list_choosers.ModificationChooser;
import com.compomics.util.gui.utils.user_choice.list_choosers.StringListChooser;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FilterDialog
extends JDialog {
    private boolean canceled = false;
    private final MatchFilter matchFilter;
    private ArrayList<String> itemsNames = null;
    private ArrayList<String> allModifications = null;
    private JMenuItem addItemMenuItem;
    private JButton cancelButton;
    private JLabel descriptionLbl;
    private JScrollPane descriptionScrollPane;
    private JTextArea descriptionTxt;
    private JPanel exceptionsPanel;
    private JScrollPane exceptionsScrollPane;
    private JTextArea exceptionsTxt;
    private JPanel filterItemsPanel;
    private JTable filterItemsTable;
    private JScrollPane filterItemsTableScrollPane;
    private JPanel filterPanel;
    private JPanel filterSettingsPanel;
    private JSplitPane filterSplitPane;
    private JLabel helpLbl;
    private JPopupMenu itemPopupMenu;
    private JSplitPane manualSelectionSplitPane;
    private JPanel manualValidationPanel;
    private JScrollPane manualValidationScrollPane;
    private JTextArea manualValidationTxt;
    private JLabel nameLbl;
    private JTextField nameTxt;
    private JButton okButton;
    private JPanel propertiesPanel;
    private JMenuItem removeItemMenuItem;

    public FilterDialog(JDialog parent, MatchFilter filter, ArrayList<String> allModifications) {
        super((Dialog)parent, true);
        this.allModifications = allModifications;
        this.matchFilter = filter.clone();
        this.initComponents();
        this.setUpGUI();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public void setUpGUI() {
        this.filterItemsTableScrollPane.getViewport().setOpaque(false);
        this.filterItemsTable.getTableHeader().setReorderingAllowed(false);
        this.nameTxt.setText(this.matchFilter.getName());
        this.descriptionTxt.setText(this.matchFilter.getDescription());
        String text = this.matchFilter.getManualValidation().stream().map(key -> key.toString()).collect(Collectors.joining(";"));
        this.manualValidationTxt.setText(text);
        text = this.matchFilter.getExceptions().stream().map(key -> key.toString()).collect(Collectors.joining(";"));
        this.exceptionsTxt.setText(text);
        this.setUpTable();
    }

    public void setUpTable() {
        FilterItemsTableModel tableModel = new FilterItemsTableModel();
        this.filterItemsTable.setModel(tableModel);
        TableColumnModel tableColumnModel = this.filterItemsTable.getColumnModel();
        tableColumnModel.getColumn(0).setMaxWidth(50);
        TableColumn nameColumn = tableColumnModel.getColumn(1);
        JComboBox<Object> comboBox = new JComboBox<String>(this.matchFilter.getPossibleFilterItemsNames());
        nameColumn.setCellEditor(new DefaultCellEditor(comboBox));
        TableColumn comparatorColumn = tableColumnModel.getColumn(2);
        comparatorColumn.setMaxWidth(300);
        comboBox = new JComboBox<FilterItemComparator>(FilterItemComparator.values());
        comparatorColumn.setCellEditor(new DefaultCellEditor(comboBox));
    }

    public void updateTable() {
        this.setUpTable();
        ((DefaultTableModel)this.filterItemsTable.getModel()).fireTableDataChanged();
    }

    private void initComponents() {
        this.itemPopupMenu = new JPopupMenu();
        this.addItemMenuItem = new JMenuItem();
        this.removeItemMenuItem = new JMenuItem();
        this.filterPanel = new JPanel();
        this.filterSplitPane = new JSplitPane();
        this.propertiesPanel = new JPanel();
        this.nameLbl = new JLabel();
        this.nameTxt = new JTextField();
        this.descriptionLbl = new JLabel();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTxt = new JTextArea();
        this.filterSettingsPanel = new JPanel();
        this.manualSelectionSplitPane = new JSplitPane();
        this.manualValidationPanel = new JPanel();
        this.manualValidationScrollPane = new JScrollPane();
        this.manualValidationTxt = new JTextArea();
        this.exceptionsPanel = new JPanel();
        this.exceptionsScrollPane = new JScrollPane();
        this.exceptionsTxt = new JTextArea();
        this.filterItemsPanel = new JPanel();
        this.filterItemsTableScrollPane = new JScrollPane();
        this.filterItemsTable = new JTable();
        this.helpLbl = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.addItemMenuItem.setText("Add Item");
        this.addItemMenuItem.setToolTipText("Add a new filter item");
        this.addItemMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterDialog.this.addItemMenuItemActionPerformed(evt);
            }
        });
        this.itemPopupMenu.add(this.addItemMenuItem);
        this.removeItemMenuItem.setText("Remove Item");
        this.removeItemMenuItem.setToolTipText("Removes the filter item");
        this.removeItemMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                FilterDialog.this.removeItemMenuItemMouseReleased(evt);
            }
        });
        this.itemPopupMenu.add(this.removeItemMenuItem);
        this.setDefaultCloseOperation(2);
        this.setTitle("Filter Editor (beta)");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FilterDialog.this.formWindowClosing(evt);
            }
        });
        this.filterPanel.setBackground(new Color(230, 230, 230));
        this.filterSplitPane.setBorder(null);
        this.filterSplitPane.setDividerLocation(200);
        this.filterSplitPane.setDividerSize(0);
        this.filterSplitPane.setOrientation(0);
        this.filterSplitPane.setOpaque(false);
        this.propertiesPanel.setBorder(BorderFactory.createTitledBorder("Filter Properties"));
        this.propertiesPanel.setOpaque(false);
        this.nameLbl.setText("Name");
        this.descriptionLbl.setText("Description");
        this.descriptionTxt.setColumns(20);
        this.descriptionTxt.setRows(3);
        this.descriptionScrollPane.setViewportView(this.descriptionTxt);
        GroupLayout propertiesPanelLayout = new GroupLayout(this.propertiesPanel);
        this.propertiesPanel.setLayout(propertiesPanelLayout);
        propertiesPanelLayout.setHorizontalGroup(propertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(propertiesPanelLayout.createSequentialGroup().addContainerGap().addGroup(propertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionScrollPane).addGroup(propertiesPanelLayout.createSequentialGroup().addGroup(propertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionLbl).addGroup(propertiesPanelLayout.createSequentialGroup().addComponent(this.nameLbl).addGap(18, 18, 18).addComponent(this.nameTxt, -2, 762, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        propertiesPanelLayout.setVerticalGroup(propertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(propertiesPanelLayout.createSequentialGroup().addContainerGap().addGroup(propertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLbl).addComponent(this.nameTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.descriptionLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionScrollPane, -1, 104, Short.MAX_VALUE).addContainerGap()));
        this.filterSplitPane.setLeftComponent(this.propertiesPanel);
        this.filterSettingsPanel.setOpaque(false);
        this.manualSelectionSplitPane.setBorder(null);
        this.manualSelectionSplitPane.setDividerLocation(425);
        this.manualSelectionSplitPane.setDividerSize(0);
        this.manualSelectionSplitPane.setOpaque(false);
        this.manualValidationPanel.setBorder(BorderFactory.createTitledBorder("Manual Validation"));
        this.manualValidationPanel.setOpaque(false);
        this.manualValidationScrollPane.setOpaque(false);
        this.manualValidationTxt.setColumns(20);
        this.manualValidationTxt.setRows(1);
        this.manualValidationScrollPane.setViewportView(this.manualValidationTxt);
        GroupLayout manualValidationPanelLayout = new GroupLayout(this.manualValidationPanel);
        this.manualValidationPanel.setLayout(manualValidationPanelLayout);
        manualValidationPanelLayout.setHorizontalGroup(manualValidationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(manualValidationPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.manualValidationScrollPane, -1, 393, Short.MAX_VALUE).addContainerGap()));
        manualValidationPanelLayout.setVerticalGroup(manualValidationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(manualValidationPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.manualValidationScrollPane, -1, 138, Short.MAX_VALUE).addContainerGap()));
        this.manualSelectionSplitPane.setLeftComponent(this.manualValidationPanel);
        this.exceptionsPanel.setBorder(BorderFactory.createTitledBorder("Exceptions"));
        this.exceptionsPanel.setOpaque(false);
        this.exceptionsScrollPane.setOpaque(false);
        this.exceptionsTxt.setColumns(20);
        this.exceptionsTxt.setRows(1);
        this.exceptionsScrollPane.setViewportView(this.exceptionsTxt);
        GroupLayout exceptionsPanelLayout = new GroupLayout(this.exceptionsPanel);
        this.exceptionsPanel.setLayout(exceptionsPanelLayout);
        exceptionsPanelLayout.setHorizontalGroup(exceptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, exceptionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.exceptionsScrollPane, -1, 382, Short.MAX_VALUE).addContainerGap()));
        exceptionsPanelLayout.setVerticalGroup(exceptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(exceptionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.exceptionsScrollPane, -1, 138, Short.MAX_VALUE).addContainerGap()));
        this.manualSelectionSplitPane.setRightComponent(this.exceptionsPanel);
        this.filterItemsPanel.setBorder(BorderFactory.createTitledBorder("Filter Item"));
        this.filterItemsPanel.setOpaque(false);
        this.filterItemsTableScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                FilterDialog.this.filterItemsTableScrollPaneMouseReleased(evt);
            }
        });
        this.filterItemsTable.setModel(new FilterItemsTableModel());
        this.filterItemsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                FilterDialog.this.filterItemsTableMouseReleased(evt);
            }
        });
        this.filterItemsTableScrollPane.setViewportView(this.filterItemsTable);
        this.helpLbl.setFont(new Font("Tahoma", 2, 11));
        this.helpLbl.setText("Right-click in the table to edit the filters.");
        GroupLayout filterItemsPanelLayout = new GroupLayout(this.filterItemsPanel);
        this.filterItemsPanel.setLayout(filterItemsPanelLayout);
        filterItemsPanelLayout.setHorizontalGroup(filterItemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterItemsPanelLayout.createSequentialGroup().addContainerGap().addGroup(filterItemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filterItemsTableScrollPane).addGroup(filterItemsPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpLbl).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        filterItemsPanelLayout.setVerticalGroup(filterItemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterItemsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.filterItemsTableScrollPane, -1, 153, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpLbl).addContainerGap()));
        GroupLayout filterSettingsPanelLayout = new GroupLayout(this.filterSettingsPanel);
        this.filterSettingsPanel.setLayout(filterSettingsPanelLayout);
        filterSettingsPanelLayout.setHorizontalGroup(filterSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filterItemsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.manualSelectionSplitPane));
        filterSettingsPanelLayout.setVerticalGroup(filterSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterSettingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.filterItemsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.manualSelectionSplitPane)));
        this.filterSplitPane.setRightComponent(this.filterSettingsPanel);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout filterPanelLayout = new GroupLayout(this.filterPanel);
        this.filterPanel.setLayout(filterPanelLayout);
        filterPanelLayout.setHorizontalGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addContainerGap().addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.filterSplitPane)).addContainerGap()));
        filterPanelLayout.setVerticalGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, filterPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.filterSplitPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filterPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filterPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            this.setFilter();
            this.dispose();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void addItemMenuItemActionPerformed(ActionEvent evt) {
        String filterItemName = null;
        String[] filterItems = this.matchFilter.getPossibleFilterItemsNames();
        HashSet<String> taken = this.matchFilter.getItemsNames();
        for (String name : filterItems) {
            if (taken.contains(name)) continue;
            filterItemName = name;
            break;
        }
        if (filterItemName != null) {
            FilterItemComparator filterItemComparator = FilterItemComparator.equal;
            Double value = 0.0;
            this.matchFilter.setFilterItem(filterItemName, filterItemComparator, value);
            this.updateTable();
        }
    }

    private void removeItemMenuItemMouseReleased(MouseEvent evt) {
        int row = this.filterItemsTable.getSelectedRow();
        if (row >= 0) {
            String itemName = this.filterItemsTable.getValueAt(row, 1).toString();
            this.matchFilter.removeFilterItem(itemName);
            this.updateTable();
        }
    }

    private void filterItemsTableMouseReleased(MouseEvent evt) {
        int row;
        if (evt != null && this.filterItemsTable.rowAtPoint(evt.getPoint()) != -1) {
            row = this.filterItemsTable.rowAtPoint(evt.getPoint());
            this.filterItemsTable.setRowSelectionInterval(row, row);
        }
        if (evt != null && evt.getButton() == 3) {
            this.itemPopupMenu.show(this.filterItemsTable, evt.getX(), evt.getY());
        }
        if (evt != null && evt.getButton() == 1 && evt.getClickCount() == 2) {
            row = this.filterItemsTable.rowAtPoint(evt.getPoint());
            String itemName = this.itemsNames.get(row);
            this.editValue(itemName);
        }
    }

    private void filterItemsTableScrollPaneMouseReleased(MouseEvent evt) {
        this.filterItemsTableMouseReleased(evt);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private void editValue(String itemName) {
        FilterItem filterItem = this.matchFilter.getFilterItem(itemName);
        ListChooser listChooser = null;
        if (filterItem.needsModifications()) {
            if (this.allModifications != null && this.allModifications.size() > 0) {
                listChooser = new ModificationChooser(this, this.allModifications, false);
            }
        } else {
            ArrayList<String> possibilities = filterItem.getPossibilities();
            if (possibilities != null && possibilities.size() > 0) {
                listChooser = new StringListChooser(this, possibilities, null, null, null, false);
            }
        }
        if (listChooser != null && !listChooser.isCanceled()) {
            this.matchFilter.setValueForItem(itemName, listChooser.getSelectedItem());
            this.updateTable();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public MatchFilter getFilter() {
        return this.matchFilter;
    }

    public void setFilter() {
        this.matchFilter.setName(this.nameTxt.getText());
        this.matchFilter.setDescription(this.descriptionTxt.getText());
        this.matchFilter.setManualValidation(this.parseAccessions(this.manualValidationTxt.getText()));
        this.matchFilter.setExceptions(this.parseAccessions(this.exceptionsTxt.getText()));
    }

    public boolean validateInput() {
        return true;
    }

    private HashSet<Long> parseAccessions(String text) {
        if (text.trim().isEmpty()) {
            return new HashSet<Long>(0);
        }
        return Arrays.stream(text.split(";")).map(key -> Long.valueOf(key)).collect(Collectors.toCollection(HashSet::new));
    }

    public boolean hasInput() {
        return false;
    }

    private boolean validateInput(String filterItemName, Object value) {
        FilterItem filterItem = this.matchFilter.getFilterItem(filterItemName);
        if (filterItem.isNumber()) {
            String stringValue = value.toString();
            try {
                Double.valueOf(stringValue);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, stringValue + " cannot be used for item " + filterItem.getName() + ", number expected.", "File Not Found", 2);
                return false;
            }
        }
        return true;
    }

    private class FilterItemsTableModel
    extends DefaultTableModel {
        public FilterItemsTableModel() {
            if (FilterDialog.this.matchFilter != null) {
                FilterDialog.this.itemsNames = new ArrayList<String>(FilterDialog.this.matchFilter.getItemsNames());
                Collections.sort(FilterDialog.this.itemsNames);
            }
        }

        @Override
        public int getRowCount() {
            if (FilterDialog.this.itemsNames == null) {
                return 0;
            }
            return FilterDialog.this.itemsNames.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Type";
                }
                case 3: {
                    return "Value";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    String itemName = (String)FilterDialog.this.itemsNames.get(row);
                    return itemName;
                }
                case 2: {
                    String itemName = (String)FilterDialog.this.itemsNames.get(row);
                    return ((FilterDialog)FilterDialog.this).matchFilter.getComparatorForItem((String)itemName).name;
                }
                case 3: {
                    String itemName = (String)FilterDialog.this.itemsNames.get(row);
                    return FilterDialog.this.matchFilter.getValue(itemName);
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            switch (column) {
                case 1: {
                    final String finalItemName = value.toString();
                    String previousItem = (String)FilterDialog.this.itemsNames.get(row);
                    FilterItemComparator comparator = FilterDialog.this.matchFilter.getComparatorForItem(previousItem);
                    Object filterValue = FilterDialog.this.matchFilter.getValue(finalItemName);
                    FilterDialog.this.matchFilter.removeFilterItem(previousItem);
                    FilterDialog.this.matchFilter.setFilterItem(finalItemName, comparator, filterValue);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FilterDialog.this.editValue(finalItemName);
                        }
                    });
                    break;
                }
                case 2: {
                    String itemName = (String)FilterDialog.this.itemsNames.get(row);
                    FilterDialog.this.matchFilter.setComparatorForItem(itemName, (FilterItemComparator)((Object)value));
                    break;
                }
                case 3: {
                    String itemName = (String)FilterDialog.this.itemsNames.get(row);
                    if (!FilterDialog.this.validateInput(itemName, value)) break;
                    FilterDialog.this.matchFilter.setValueForItem(itemName, value);
                }
            }
            FilterDialog.this.updateTable();
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            switch (column) {
                case 1: 
                case 2: {
                    return true;
                }
                case 3: {
                    String itemName = (String)FilterDialog.this.itemsNames.get(row);
                    FilterItem filterItem = FilterDialog.this.matchFilter.getFilterItem(itemName);
                    return !filterItem.needsModifications() && filterItem.getPossibilities() == null;
                }
            }
            return false;
        }
    }
}

