/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.genes;

import com.compomics.util.experiment.biology.genes.ProteinGeneDetailsProvider;
import com.compomics.util.experiment.biology.genes.ensembl.EnsemblVersion;
import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.experiment.biology.taxonomy.mappings.EnsemblGenomesSpecies;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class SpeciesDialog
extends JDialog {
    private Frame parentFrame = null;
    private boolean canceled = false;
    private ProteinGeneDetailsProvider geneFactory = new ProteinGeneDetailsProvider();
    private SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
    private ProgressDialogX progressDialog;
    private JDialog dialogParent = null;
    public static final String SELECT_SPECIES_TAG = "-- Select Species --";
    public static final String NO_SPECIES_TAG = "-- (no selection) --";
    private Image waitingImage = null;
    private Image normalImage = null;
    private HashMap<String, Integer> speciesToTaxonMap;
    private ArrayList<String> selectedSpeciesList;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JLabel chickenLabel;
    private JLabel comma1Label;
    private JLabel comma2Label;
    private JLabel comma3Label;
    private JLabel comma4Label;
    private JComboBox ensemblCategoryJComboBox;
    private JLabel ensemblVersionLabel;
    private JLabel humanLabel;
    private JLabel mouseLabel;
    private JButton okButton;
    private JLabel popularSpeciesLabel;
    private JLabel ratLabel;
    private JComboBox speciesJComboBox;
    private JPanel speciesPanel;
    private JLabel unknownSpeciesLabel;
    private JButton updateMappingsButton;
    private JLabel zebrafishLabel;

    public SpeciesDialog(Frame parentFrame, boolean modal, Image waitingImage, Image normalImage, Integer selectedSpecies) {
        super(parentFrame, modal);
        this.parentFrame = parentFrame;
        this.initComponents();
        this.waitingImage = waitingImage;
        this.normalImage = normalImage;
        this.setUpGUI(selectedSpecies);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public SpeciesDialog(JDialog parentDialog, JFrame mainFrame, boolean modal, Image waitingImage, Image normalImage, Integer selectedSpecies) {
        super((Dialog)parentDialog, modal);
        this.dialogParent = parentDialog;
        this.parentFrame = mainFrame;
        this.initComponents();
        this.waitingImage = waitingImage;
        this.normalImage = normalImage;
        this.setUpGUI(selectedSpecies);
        this.speciesJComboBox.requestFocus();
        this.setLocationRelativeTo(parentDialog);
        this.setVisible(true);
    }

    private void setUpGUI(Integer selectedSpecies) {
        this.ensemblCategoryJComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.speciesJComboBox.setRenderer(new AlignedListCellRenderer(0));
        EnsemblGenomesSpecies.EnsemblGenomeDivision ensemblGenomeDivision = null;
        if (selectedSpecies != null) {
            ensemblGenomeDivision = this.speciesFactory.getEnsemblGenomesSpecies().getDivision(selectedSpecies);
            String type = this.getTypeForGenomeDivision(ensemblGenomeDivision);
            this.ensemblCategoryJComboBox.setSelectedItem(type);
        }
        this.updateSpeciesList(ensemblGenomeDivision, selectedSpecies);
    }

    private void updateSpeciesList(EnsemblGenomesSpecies.EnsemblGenomeDivision ensemblGenomeDivision, Integer selectedSpeciesTaxon) {
        this.speciesJComboBox.setEnabled(this.ensemblCategoryJComboBox.getSelectedIndex() > 0);
        if (this.ensemblCategoryJComboBox.getSelectedIndex() > 0) {
            HashMap<String, HashSet<Integer>> ensemblSpecies = this.speciesFactory.getEnsembleSpecies();
            HashSet<Integer> taxons = ensemblGenomeDivision != null ? ensemblSpecies.get(ensemblGenomeDivision.name()) : ensemblSpecies.get("vertebrates");
            if (taxons != null && !taxons.isEmpty()) {
                ArrayList<String> speciesList = new ArrayList<String>(taxons.size());
                this.selectedSpeciesList = new ArrayList(taxons.size());
                speciesList.add(SELECT_SPECIES_TAG);
                String selectedItem = null;
                this.speciesToTaxonMap = new HashMap();
                for (Integer taxon : taxons) {
                    String speciesName = this.speciesFactory.getName(taxon);
                    String tempEnsemblVersion = this.geneFactory.getEnsemblVersion(taxon);
                    if (tempEnsemblVersion == null) {
                        tempEnsemblVersion = "N/A";
                    }
                    this.speciesToTaxonMap.put(speciesName, taxon);
                    String displayedText = speciesName + " [" + tempEnsemblVersion + "]";
                    if (taxon.equals(selectedSpeciesTaxon)) {
                        selectedItem = displayedText;
                    }
                    speciesList.add(displayedText);
                    this.selectedSpeciesList.add(speciesName);
                }
                Collections.sort(speciesList);
                Collections.sort(this.selectedSpeciesList);
                speciesList.add(NO_SPECIES_TAG);
                String[] tempTable = new String[speciesList.size()];
                this.speciesJComboBox.setModel(new DefaultComboBoxModel<String>(speciesList.toArray(tempTable)));
                if (selectedItem != null) {
                    this.speciesJComboBox.setSelectedItem(selectedItem);
                }
            } else {
                String[] content = new String[]{NO_SPECIES_TAG};
                this.speciesJComboBox.setModel(new DefaultComboBoxModel<String>(content));
            }
        } else {
            String[] content = new String[]{SELECT_SPECIES_TAG};
            this.speciesJComboBox.setModel(new DefaultComboBoxModel<String>(content));
        }
        this.updateMappingsButton.setEnabled(this.ensemblCategoryJComboBox.getSelectedIndex() > 0 && this.speciesJComboBox.getSelectedIndex() > 0 && this.speciesJComboBox.getSelectedIndex() < this.speciesJComboBox.getItemCount() - 1 && this.geneFactory.newVersionExists(this.getSelectedSpecies()));
    }

    public Integer getSelectedSpecies() {
        int selectedIndex = this.speciesJComboBox.getSelectedIndex();
        if (selectedIndex > 0 && selectedIndex < this.speciesJComboBox.getItemCount() - 1) {
            String selectedSpecies = this.selectedSpeciesList.get(selectedIndex - 1);
            return this.speciesToTaxonMap.get(selectedSpecies);
        }
        return null;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getTypeForGenomeDivision(EnsemblGenomesSpecies.EnsemblGenomeDivision ensemblGenomeDivision) {
        if (ensemblGenomeDivision == null) {
            return "Vertebrates";
        }
        switch (ensemblGenomeDivision) {
            case bacteria: {
                return "Bacteria";
            }
            case fungi: {
                return "Fungi";
            }
            case metazoa: {
                return "Metazoa";
            }
            case plants: {
                return "Plants";
            }
            case protists: {
                return "Protists";
            }
        }
        return "Vertebrates";
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.speciesPanel = new JPanel();
        this.speciesJComboBox = new JComboBox();
        this.updateMappingsButton = new JButton();
        this.ensemblCategoryJComboBox = new JComboBox();
        this.popularSpeciesLabel = new JLabel();
        this.humanLabel = new JLabel();
        this.comma1Label = new JLabel();
        this.mouseLabel = new JLabel();
        this.comma2Label = new JLabel();
        this.ratLabel = new JLabel();
        this.comma3Label = new JLabel();
        this.zebrafishLabel = new JLabel();
        this.comma4Label = new JLabel();
        this.chickenLabel = new JLabel();
        this.okButton = new JButton();
        this.unknownSpeciesLabel = new JLabel();
        this.ensemblVersionLabel = new JLabel();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Species");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SpeciesDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.speciesPanel.setBorder(BorderFactory.createTitledBorder("Select Species (for gene and gene ontology mapping)"));
        this.speciesPanel.setOpaque(false);
        this.speciesJComboBox.setMaximumRowCount(20);
        this.speciesJComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.speciesJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpeciesDialog.this.speciesJComboBoxActionPerformed(evt);
            }
        });
        this.updateMappingsButton.setText("Update");
        this.updateMappingsButton.setToolTipText("Update Gene and GO Mappings");
        this.updateMappingsButton.setEnabled(false);
        this.updateMappingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpeciesDialog.this.updateMappingsButtonActionPerformed(evt);
            }
        });
        this.ensemblCategoryJComboBox.setMaximumRowCount(20);
        this.ensemblCategoryJComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"-- Select Species Type ---", "Fungi", "Plants", "Protists", "Metazoa", "Vertebrates"}));
        this.ensemblCategoryJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpeciesDialog.this.ensemblCategoryJComboBoxActionPerformed(evt);
            }
        });
        this.popularSpeciesLabel.setText("Popular Species:");
        this.humanLabel.setText("<html><a href>Human</a></html>");
        this.humanLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpeciesDialog.this.humanLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpeciesDialog.this.humanLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SpeciesDialog.this.humanLabelMouseReleased(evt);
            }
        });
        this.comma1Label.setFont(new Font("Tahoma", 2, 11));
        this.comma1Label.setText(",");
        this.mouseLabel.setText("<html><a href>Mouse</a></html>");
        this.mouseLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpeciesDialog.this.mouseLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpeciesDialog.this.mouseLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SpeciesDialog.this.mouseLabelMouseReleased(evt);
            }
        });
        this.comma2Label.setFont(new Font("Tahoma", 2, 11));
        this.comma2Label.setText(",");
        this.ratLabel.setText("<html><a href>Rat</a></html>");
        this.ratLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpeciesDialog.this.ratLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpeciesDialog.this.ratLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SpeciesDialog.this.ratLabelMouseReleased(evt);
            }
        });
        this.comma3Label.setFont(new Font("Tahoma", 2, 11));
        this.comma3Label.setText(",");
        this.zebrafishLabel.setText("<html><a href>Zebrafish</a></html>");
        this.zebrafishLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpeciesDialog.this.zebrafishLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpeciesDialog.this.zebrafishLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SpeciesDialog.this.zebrafishLabelMouseReleased(evt);
            }
        });
        this.comma4Label.setFont(new Font("Tahoma", 2, 11));
        this.comma4Label.setText(",");
        this.chickenLabel.setText("<html><a href>Chicken</a></html>");
        this.chickenLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpeciesDialog.this.chickenLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpeciesDialog.this.chickenLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SpeciesDialog.this.chickenLabelMouseReleased(evt);
            }
        });
        GroupLayout speciesPanelLayout = new GroupLayout(this.speciesPanel);
        this.speciesPanel.setLayout(speciesPanelLayout);
        speciesPanelLayout.setHorizontalGroup(speciesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(speciesPanelLayout.createSequentialGroup().addContainerGap().addGroup(speciesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, speciesPanelLayout.createSequentialGroup().addGroup(speciesPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.ensemblCategoryJComboBox, 0, 416, Short.MAX_VALUE).addComponent(this.speciesJComboBox, 0, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.updateMappingsButton, -2, 86, -2)).addGroup(speciesPanelLayout.createSequentialGroup().addComponent(this.popularSpeciesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.humanLabel, -2, -1, -2).addGap(0, 0, 0).addComponent(this.comma1Label).addGap(5, 5, 5).addComponent(this.mouseLabel, -2, -1, -2).addGap(0, 0, 0).addComponent(this.comma2Label).addGap(5, 5, 5).addComponent(this.ratLabel, -2, -1, -2).addGap(0, 0, 0).addComponent(this.comma3Label).addGap(5, 5, 5).addComponent(this.zebrafishLabel, -2, -1, -2).addGap(0, 0, 0).addComponent(this.comma4Label).addGap(5, 5, 5).addComponent(this.chickenLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        speciesPanelLayout.setVerticalGroup(speciesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(speciesPanelLayout.createSequentialGroup().addContainerGap().addGroup(speciesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.popularSpeciesLabel).addComponent(this.humanLabel, -2, -1, -2).addComponent(this.comma1Label).addComponent(this.mouseLabel, -2, -1, -2).addComponent(this.comma2Label).addComponent(this.ratLabel, -2, -1, -2).addComponent(this.comma3Label).addComponent(this.zebrafishLabel, -2, -1, -2).addComponent(this.comma4Label).addComponent(this.chickenLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ensemblCategoryJComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(speciesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.speciesJComboBox, -2, -1, -2).addComponent(this.updateMappingsButton, -2, 23, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        speciesPanelLayout.linkSize(1, this.speciesJComboBox, this.updateMappingsButton);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpeciesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.unknownSpeciesLabel.setText("<html><a href>Species not in list?</a></html>");
        this.unknownSpeciesLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SpeciesDialog.this.unknownSpeciesLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpeciesDialog.this.unknownSpeciesLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpeciesDialog.this.unknownSpeciesLabelMouseExited(evt);
            }
        });
        this.ensemblVersionLabel.setText("<html><a href>Ensembl version?</a></html>");
        this.ensemblVersionLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SpeciesDialog.this.ensemblVersionLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpeciesDialog.this.ensemblVersionLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpeciesDialog.this.ensemblVersionLabelMouseExited(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpeciesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.unknownSpeciesLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.ensemblVersionLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, 75, -2)).addComponent(this.speciesPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.speciesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.unknownSpeciesLabel, -2, -1, -2).addComponent(this.ensemblVersionLabel, -2, -1, -2).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void speciesJComboBoxActionPerformed(ActionEvent evt) {
        Integer taxon = this.getSelectedSpecies();
        if (taxon != null) {
            String ensemblDatasetName = this.speciesFactory.getEnsemblDataset(taxon);
            if (ensemblDatasetName == null || !ProteinGeneDetailsProvider.getGeneMappingFile(ensemblDatasetName).exists() || !ProteinGeneDetailsProvider.getGoMappingFile(ensemblDatasetName).exists()) {
                this.updateMappingsButton.setText("Download");
                this.updateMappingsButton.setToolTipText("Download Gene and GO Mappings");
                this.updateMappingsButton.setEnabled(true);
            } else {
                this.updateMappingsButton.setText("Update");
                this.updateMappingsButton.setToolTipText("Update Gene and GO Mappings");
                this.updateMappingsButton.setEnabled(this.geneFactory.newVersionExists(taxon));
            }
        } else {
            this.updateMappingsButton.setText("Download");
            this.updateMappingsButton.setToolTipText("Download Gene and GO Mappings");
            this.updateMappingsButton.setEnabled(false);
        }
    }

    private void unknownSpeciesLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/SpeciesDialog.html"), "#Species", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), "Species - Help");
        this.setCursor(new Cursor(0));
    }

    private void unknownSpeciesLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void unknownSpeciesLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void ensemblVersionLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/SpeciesDialog.html"), "#Ensembl_Version", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), "Species - Help");
        this.setCursor(new Cursor(0));
    }

    private void ensemblVersionLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void ensemblVersionLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Integer taxon = this.getSelectedSpecies();
        if (taxon != null) {
            if (this.geneFactory.newVersionExists(taxon)) {
                int option = JOptionPane.showConfirmDialog(this, "The gene and GO annotations are not downloaded for the selected species.\nDownload now?", "Gene Annotation Missing", 1);
                if (option != 2 && option != -1) {
                    if (option == 0) {
                        this.downloadMappings();
                    } else {
                        this.dispose();
                    }
                }
            } else {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    private void updateMappingsButtonActionPerformed(ActionEvent evt) {
        Integer taxon = this.getSelectedSpecies();
        EnsemblGenomesSpecies.EnsemblGenomeDivision ensemblGenomeDivision = this.speciesFactory.getEnsemblGenomesSpecies().getDivision(taxon);
        Integer latestEnsemblVersion = EnsemblVersion.getCurrentEnsemblVersion(ensemblGenomeDivision);
        if (latestEnsemblVersion != null) {
            if (this.updateMappingsButton.getText().equalsIgnoreCase("Download")) {
                this.downloadMappings();
            } else if (this.geneFactory.newVersionExists(taxon)) {
                Integer currentEnsemblVersion;
                String currentEnsemblVersionAsString = this.geneFactory.getEnsemblVersion(taxon);
                currentEnsemblVersionAsString = currentEnsemblVersionAsString.substring(currentEnsemblVersionAsString.indexOf(" ") + 1);
                try {
                    currentEnsemblVersion = Integer.valueOf(currentEnsemblVersionAsString);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    currentEnsemblVersion = latestEnsemblVersion;
                }
                if (currentEnsemblVersion < latestEnsemblVersion) {
                    this.downloadMappings();
                } else {
                    JOptionPane.showMessageDialog(this, "Ensembl mappings are already up to date.", "Ensembl Mappings", 1);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "Ensembl mapping not available. Try again later.", "Ensembl Error", 1);
        }
    }

    private void ensemblCategoryJComboBoxActionPerformed(ActionEvent evt) {
        this.updateSpeciesList(null, null);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void humanLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void humanLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void humanLabelMouseReleased(MouseEvent evt) {
        this.ensemblCategoryJComboBox.setSelectedItem("Vertebrates");
        this.speciesJComboBox.setSelectedItem("Human (Homo sapiens)");
    }

    private void mouseLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void mouseLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void mouseLabelMouseReleased(MouseEvent evt) {
        this.ensemblCategoryJComboBox.setSelectedItem("Vertebrates");
        this.speciesJComboBox.setSelectedItem("Mouse (Mus musculus)");
    }

    private void ratLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void ratLabelMouseReleased(MouseEvent evt) {
        this.ensemblCategoryJComboBox.setSelectedItem("Vertebrates");
        this.speciesJComboBox.setSelectedItem("Mouse (Mus musculus)");
    }

    private void zebrafishLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void zebrafishLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void ratLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void chickenLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void chickenLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void chickenLabelMouseReleased(MouseEvent evt) {
        this.ensemblCategoryJComboBox.setSelectedItem("Vertebrates");
        this.speciesJComboBox.setSelectedItem("Chicken (Gallus gallus)");
    }

    private void zebrafishLabelMouseReleased(MouseEvent evt) {
        this.ensemblCategoryJComboBox.setSelectedItem("Vertebrates");
        this.speciesJComboBox.setSelectedItem("Zebrafish (Danio rerio)");
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private void downloadMappings() {
        this.progressDialog = this.dialogParent == null ? new ProgressDialogX(this.parentFrame, this.normalImage, this.waitingImage, true) : new ProgressDialogX(this.dialogParent, this.parentFrame, this.normalImage, this.waitingImage, true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Sending Request. Please Wait...");
        final SpeciesDialog finalRef = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                SpeciesDialog.this.progressDialog.setVisible(true);
            }
        }, "ProgressDialog").start();
        new Thread("DownloadThread"){

            @Override
            public void run() {
                boolean success = false;
                try {
                    success = SpeciesDialog.this.geneFactory.downloadMappings(SpeciesDialog.this.progressDialog, SpeciesDialog.this.getSelectedSpecies());
                    if (success) {
                        int selectedIndex = SpeciesDialog.this.speciesJComboBox.getSelectedIndex();
                        SpeciesDialog.this.updateSpeciesList(null, null);
                        JOptionPane.showMessageDialog(finalRef, "Gene mappings downloaded.", "Gene Mappings", 1);
                        SpeciesDialog.this.speciesJComboBox.setSelectedIndex(selectedIndex);
                        SpeciesDialog.this.speciesJComboBoxActionPerformed(null);
                    }
                }
                catch (Exception e) {
                    SpeciesDialog.this.progressDialog.setRunFinished();
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(finalRef, "An error occurred when downloading the mappings.", "Download Error", 0);
                }
            }
        }.start();
    }

    private String getSelectedEnsemblType() {
        int selectedIndex = this.ensemblCategoryJComboBox.getSelectedIndex();
        switch (selectedIndex) {
            case 1: {
                return "fungi";
            }
            case 2: {
                return "plants";
            }
            case 3: {
                return "protists";
            }
            case 4: {
                return "metazoa";
            }
            case 5: {
                return "ensembl";
            }
        }
        return "unknown";
    }
}

