/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.modification;

import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidPattern;
import com.compomics.util.experiment.biology.atoms.AtomChain;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.biology.ions.impl.ReporterIon;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationCategory;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.gui.AminoAcidPatternDialog;
import com.compomics.util.gui.atoms.AtomChainDialog;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.gui.renderers.ToolTipComboBoxRenderer;
import com.compomics.util.pride.CvTerm;
import com.compomics.util.pride.PtmToPrideMap;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.TrueFalseIconRenderer;

public class ModificationDialog
extends JDialog {
    private ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private Modification currentPtm = null;
    private ArrayList<NeutralLoss> neutralLosses = new ArrayList();
    private ArrayList<ReporterIon> reporterIons = new ArrayList();
    private boolean editable;
    private AminoAcidPattern pattern;
    private AtomChain atomChainAdded;
    private AtomChain atomChainRemoved;
    private ArrayList<String> reporterIonTableToolTips;
    private ArrayList<String> neutralLossesTableToolTips;
    private boolean canceled = false;
    private JButton addNeutralLoss;
    private JButton addReporterIon;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JComboBox categoryCmb;
    private JLabel categoryLabel;
    private JLabel compositionLabel;
    private JTextField compositionTxt;
    private JSplitPane cvTermSplitPane;
    private JButton helpJButton;
    private JLabel massLabel;
    private JTextField massTxt;
    private JLabel nameLabel;
    private JLabel nameShortLabel;
    private JTextField nameShortTxt;
    private JTextField nameTxt;
    private JTabbedPane neutralLossesAndReportIonsTabbedPane;
    private JScrollPane neutralLossesJScrollPane;
    private JPanel neutralLossesPanel;
    private JTable neutralLossesTable;
    private JButton okButton;
    private JLabel patternLabel;
    private JTextField patternTxt;
    private JPanel propertiesPanel;
    private JTextField psiModAccessionJTextField;
    private JLabel psiModAccessionLabel;
    private JLabel psiModLabel;
    private JLabel psiModLinkLabel;
    private JTextField psiModNameJTextField;
    private JLabel psiModNameLabel;
    private JPanel psiModPanel;
    private JButton removeNeutralLoss;
    private JButton removerReporterIon;
    private JPanel reporterIonsAndNeutralLossesPanel;
    private JScrollPane reporterIonsJScrollPane;
    private JPanel reporterIonsPanel;
    private JTable reporterIonsTable;
    private JComboBox typeCmb;
    private JLabel typeLabel;
    private JTextField unimodAccessionJTextField;
    private JLabel unimodAccessionLabel;
    private JLabel unimodLabel;
    private JLabel unimodLinkLabel;
    private JPanel unimodMappingPanel;
    private JTextField unimodNameJTextField;
    private JLabel unimodNameLabel;
    private JPanel unimodPanel;

    public ModificationDialog(JDialog parent, Modification currentModification, boolean editable) {
        super((Dialog)parent, true);
        this.currentPtm = currentModification;
        if (currentModification != null) {
            this.pattern = this.currentPtm.getPattern();
            this.atomChainAdded = this.currentPtm.getAtomChainAdded();
            this.atomChainRemoved = this.currentPtm.getAtomChainRemoved();
        } else {
            this.pattern = null;
            this.atomChainAdded = new AtomChain();
            this.atomChainRemoved = new AtomChain();
        }
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public ModificationDialog(JFrame parent, PtmToPrideMap modificationToPrideMap, Modification currentModification, boolean editable) {
        super((Frame)parent, true);
        this.currentPtm = currentModification;
        this.editable = editable;
        if (currentModification != null) {
            this.pattern = this.currentPtm.getPattern();
            this.atomChainAdded = currentModification.getAtomChainAdded();
            this.atomChainRemoved = currentModification.getAtomChainRemoved();
        } else {
            this.pattern = null;
            this.atomChainAdded = new AtomChain();
            this.atomChainRemoved = new AtomChain();
        }
        this.initComponents();
        this.setUpGui();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.neutralLossesAndReportIonsTabbedPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.typeCmb.setRenderer(new AlignedListCellRenderer(0));
        this.categoryCmb.setRenderer(new AlignedListCellRenderer(0));
        this.neutralLossesTable.getTableHeader().setReorderingAllowed(false);
        this.reporterIonsTable.getTableHeader().setReorderingAllowed(false);
        this.neutralLossesJScrollPane.getViewport().setOpaque(false);
        this.reporterIonsJScrollPane.getViewport().setOpaque(false);
        this.neutralLossesTable.getColumn(" ").setMaxWidth(50);
        this.neutralLossesTable.getColumn(" ").setMinWidth(50);
        this.neutralLossesTable.getColumn("Fixed").setMaxWidth(50);
        this.neutralLossesTable.getColumn("Fixed").setMinWidth(50);
        this.reporterIonsTable.getColumn(" ").setMaxWidth(50);
        this.reporterIonsTable.getColumn(" ").setMinWidth(50);
        this.neutralLossesTable.getColumn("Fixed").setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/selected_green-new.png")), null, "Fixed", null));
        this.reporterIonTableToolTips = new ArrayList();
        this.reporterIonTableToolTips.add(null);
        this.reporterIonTableToolTips.add("Reporter Ion Name");
        this.reporterIonTableToolTips.add("Reporter Ion Composition");
        this.reporterIonTableToolTips.add("Reporter Ion Mass (m/z)");
        this.neutralLossesTableToolTips = new ArrayList();
        this.neutralLossesTableToolTips.add(null);
        this.neutralLossesTableToolTips.add("Neutral Loss Name");
        this.neutralLossesTableToolTips.add("Neutral Loss Composition");
        this.neutralLossesTableToolTips.add("Neutral Loss Mass");
        this.neutralLossesTableToolTips.add("Fixed Neutral Loss");
        Vector<String> comboboxTooltips = new Vector<String>();
        for (ModificationType modType : ModificationType.values()) {
            comboboxTooltips.add(modType.description);
        }
        this.typeCmb.setRenderer(new ToolTipComboBoxRenderer(comboboxTooltips, 0));
        this.typeCmb.setEnabled(this.editable);
        this.categoryCmb.setEnabled(this.editable);
        this.nameTxt.setEditable(this.editable);
        this.nameShortTxt.setEditable(this.editable);
        this.addNeutralLoss.setEnabled(this.editable);
        this.removeNeutralLoss.setEnabled(this.editable);
        this.addReporterIon.setEnabled(this.editable);
        this.removerReporterIon.setEnabled(this.editable);
        this.unimodAccessionJTextField.setEditable(this.editable);
        this.unimodNameJTextField.setEditable(this.editable);
        this.psiModAccessionJTextField.setEditable(this.editable);
        this.psiModNameJTextField.setEditable(this.editable);
        if (this.currentPtm != null) {
            this.typeCmb.setSelectedItem((Object)this.currentPtm.getModificationType());
            this.categoryCmb.setSelectedItem((Object)this.currentPtm.getCategory());
            this.nameTxt.setText(this.currentPtm.getName());
            this.nameShortTxt.setText(this.currentPtm.getShortName());
            String addition = "";
            if (this.atomChainAdded != null && this.atomChainAdded.size() > 0) {
                addition = this.atomChainAdded.toString();
            }
            String deletion = "";
            if (this.atomChainRemoved != null && this.atomChainRemoved.size() > 0) {
                deletion = "-" + this.atomChainRemoved.toString();
            }
            String temp = addition + " " + deletion;
            this.compositionTxt.setText(temp.trim());
            if (this.pattern != null) {
                this.patternTxt.setText(this.pattern.toString());
            }
            this.updateMass();
            if (!this.currentPtm.getNeutralLosses().isEmpty()) {
                for (NeutralLoss tempNeutralLoss : this.currentPtm.getNeutralLosses()) {
                    this.neutralLosses.add(tempNeutralLoss.clone());
                }
            }
            if (!this.currentPtm.getReporterIons().isEmpty()) {
                for (ReporterIon tempReporterIon : this.currentPtm.getReporterIons()) {
                    this.reporterIons.add(tempReporterIon.clone());
                }
            }
            this.updateTables();
            CvTerm unimodCvTerm = this.currentPtm.getUnimodCvTerm();
            CvTerm psiModcvTerm = this.currentPtm.getPsiModCvTerm();
            this.updateModMappingText(unimodCvTerm, psiModcvTerm);
            if (unimodCvTerm == null) {
                this.unimodAccessionJTextField.setEditable(true);
                this.unimodNameJTextField.setEditable(true);
            }
            if (psiModcvTerm == null) {
                this.psiModAccessionJTextField.setEditable(true);
                this.psiModNameJTextField.setEditable(true);
            }
            this.setTitle("Edit Modification");
        }
        this.cvTermSplitPane.setDividerLocation(0.5);
        this.validateInput(false);
    }

    private void updateMass() {
        try {
            double mass = 0.0;
            if (this.atomChainAdded != null) {
                mass += this.atomChainAdded.getMass();
            }
            if (this.atomChainRemoved != null) {
                mass -= this.atomChainRemoved.getMass();
            }
            this.massTxt.setText("" + Util.roundDouble(mass, 4));
        }
        catch (IllegalArgumentException e) {
            this.massTxt.setText("");
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private boolean validateInput(boolean showMessage) {
        ModificationType tempModificationType;
        int outcome;
        String newName;
        String name;
        boolean error = false;
        this.nameLabel.setForeground(Color.BLACK);
        this.compositionLabel.setForeground(Color.BLACK);
        this.patternLabel.setForeground(Color.BLACK);
        this.unimodAccessionLabel.setForeground(Color.BLACK);
        this.unimodNameLabel.setForeground(Color.BLACK);
        ((TitledBorder)this.reporterIonsAndNeutralLossesPanel.getBorder()).setTitleColor(Color.BLACK);
        this.reporterIonsAndNeutralLossesPanel.repaint();
        this.nameLabel.setToolTipText(null);
        this.nameTxt.setToolTipText(null);
        this.compositionLabel.setToolTipText(null);
        this.compositionTxt.setToolTipText(null);
        this.patternLabel.setToolTipText(null);
        this.patternTxt.setToolTipText(null);
        this.unimodAccessionLabel.setToolTipText(null);
        this.unimodAccessionJTextField.setToolTipText(null);
        this.reporterIonsAndNeutralLossesPanel.setToolTipText(null);
        this.reporterIonsPanel.setToolTipText(null);
        if (this.compositionTxt.getText().trim().length() == 0) {
            error = true;
            this.compositionLabel.setForeground(Color.RED);
            this.compositionLabel.setToolTipText("Please provide a modification composition");
        }
        if ((name = this.nameTxt.getText().trim()).length() == 0) {
            error = true;
            this.nameLabel.setForeground(Color.RED);
            this.nameLabel.setToolTipText("Please provide a modification name");
            this.nameTxt.setToolTipText("Please provide a modification name");
        }
        if (name.lastIndexOf("|") != -1) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "Modification names cannot contain '|'.");
            }
            error = true;
            this.nameLabel.setForeground(Color.RED);
            this.nameLabel.setToolTipText("Modification names cannot contain '|'");
            this.nameTxt.setToolTipText("Modification names cannot contain '|'");
        }
        if (name.lastIndexOf(",") != -1) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "Modification names cannot contain ','.");
            }
            error = true;
            this.nameLabel.setForeground(Color.RED);
            this.nameLabel.setToolTipText("Modification names cannot contain ','");
            this.nameTxt.setToolTipText("Modification names cannot contain ','");
        }
        if (name.contains("_")) {
            newName = name.replace("_", " ");
            if (showMessage && !error) {
                outcome = JOptionPane.showConfirmDialog(this, "'_' should be avoided in modification names.\nShall " + name + " be replaced by " + newName + "?", "'_' in Name", 0);
                if (outcome == 0) {
                    this.nameTxt.setText(newName);
                } else {
                    error = true;
                    this.nameLabel.setForeground(Color.RED);
                    this.nameLabel.setToolTipText("'_' should be avoided in modification names");
                    this.nameTxt.setToolTipText("'_' should be avoided in modification names");
                }
            } else {
                error = true;
                this.nameLabel.setForeground(Color.RED);
                this.nameLabel.setToolTipText("'_' should be avoided in modification names");
                this.nameTxt.setToolTipText("'_' should be avoided in modification names");
            }
        }
        if (name.contains("-ATAA-")) {
            newName = name.replace("-ATAA-", "AT-AA");
            if (showMessage && !error) {
                outcome = JOptionPane.showConfirmDialog(this, "'-ATAA-' should be avoided in modification names.\nShall " + name + " be replaced by " + newName + "?", "'-ATAA-' in Name", 0);
                if (outcome == 0) {
                    this.nameTxt.setText(newName);
                } else {
                    error = true;
                    this.nameLabel.setForeground(Color.RED);
                    this.nameLabel.setToolTipText("'-ATAA-' should be avoided in modification names.");
                    this.nameTxt.setToolTipText("'-ATAA-' should be avoided in modification names.");
                }
            } else {
                error = true;
                this.nameLabel.setForeground(Color.RED);
                this.nameLabel.setToolTipText("'-ATAA-' should be avoided in modification names.");
                this.nameTxt.setToolTipText("'-ATAA-' should be avoided in modification names.");
            }
        }
        if (name.contains("|single_aa")) {
            newName = name.replace("|single_aa", "SEARCH-ONLY");
            if (showMessage && !error) {
                outcome = JOptionPane.showConfirmDialog(this, "'|single_aa' should be avoided in the end of modification names.\nShall " + name + " be replaced by " + newName + "?", "'|single_aa' Ending Name", 0);
                if (outcome == 0) {
                    this.nameTxt.setText(newName);
                } else {
                    error = true;
                    this.nameLabel.setForeground(Color.RED);
                    this.nameLabel.setToolTipText("'|single_aa' should be avoided in modification names.");
                    this.nameTxt.setToolTipText("'|single_aa' should be avoided in modification names.");
                }
            } else {
                error = true;
                this.nameLabel.setForeground(Color.RED);
                this.nameLabel.setToolTipText("'|single_aa' should be avoided in modification names.");
                this.nameTxt.setToolTipText("'|single_aa' should be avoided in modification names.");
            }
        }
        name = this.nameTxt.getText().trim();
        if (this.modificationFactory.getDefaultModifications().contains(name) && (this.currentPtm == null || !name.equals(this.currentPtm.getName()))) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "A modification named '" + name + "' already exists in the default modification lists.\nPlease select the default modification or use another name.", "Modification Already Exists", 2);
            } else {
                this.nameLabel.setForeground(Color.RED);
                this.nameLabel.setToolTipText("<html>A modification named '" + name + "' already exists in the default modification lists.<br>Please select the default modification or use another name.</html>");
                this.nameTxt.setToolTipText("<html>A modification named '" + name + "' already exists in the default modification lists.<br>Please select the default modification or use another name.</html>");
            }
            error = true;
        }
        if (this.modificationFactory.getUserModifications().contains(name) && (this.currentPtm == null || !name.equals(this.currentPtm.getName()))) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "There is already a modification named '" + name + "'!", "Modification Already Exists", 2);
            }
            error = true;
            this.nameLabel.setForeground(Color.RED);
            this.nameLabel.setToolTipText("There is already a modification named '" + name + "'!");
            this.nameTxt.setToolTipText("There is already a modification named '" + name + "'!");
        }
        if (this.patternTxt.getText().length() == 0 && ((tempModificationType = (ModificationType)((Object)this.typeCmb.getSelectedItem())) == ModificationType.modaa || tempModificationType == ModificationType.modcaa_peptide || tempModificationType == ModificationType.modcaa_protein || tempModificationType == ModificationType.modnaa_peptide || tempModificationType == ModificationType.modnaa_protein)) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the modification pattern.", "Missing Pattern", 2);
            }
            error = true;
            this.patternLabel.setForeground(Color.RED);
            this.patternLabel.setToolTipText("Please provide a modification pattern");
            this.patternTxt.setToolTipText("Please provide a modification pattern");
        }
        if (!this.unimodAccessionJTextField.getText().trim().isEmpty()) {
            try {
                Integer.valueOf(this.unimodAccessionJTextField.getText().trim());
            }
            catch (NumberFormatException e) {
                if (showMessage && !error) {
                    JOptionPane.showMessageDialog(this, "Please provide the Unimod accession number as an integer.", "Unimod Accession", 2);
                }
                error = true;
                this.unimodAccessionLabel.setForeground(Color.RED);
                this.unimodAccessionLabel.setToolTipText("Please provide the Unimod accession number as an integer");
                this.unimodAccessionJTextField.setToolTipText("Please provide the Unimod accession number as an integer");
            }
        }
        if (!this.psiModAccessionJTextField.getText().trim().isEmpty()) {
            try {
                Integer.valueOf(this.psiModAccessionJTextField.getText().trim());
            }
            catch (NumberFormatException e) {
                if (showMessage && !error) {
                    JOptionPane.showMessageDialog(this, "Please provide the PSI-MOD accession number as an integer.", "PSI-MOD Accession", 2);
                }
                error = true;
                this.psiModAccessionLabel.setForeground(Color.RED);
                this.psiModAccessionLabel.setToolTipText("Please provide the PSI-MOD accession number as an integer");
                this.psiModAccessionJTextField.setToolTipText("Please provide the PSI-MOD accession number as an integer");
            }
        }
        if (!this.neutralLosses.isEmpty()) {
            for (NeutralLoss tempNeutralLoss : this.neutralLosses) {
                NeutralLoss existingNeutralLoss = NeutralLoss.getNeutralLoss(tempNeutralLoss.name);
                if (existingNeutralLoss == null || tempNeutralLoss.isSameAs(existingNeutralLoss)) continue;
                if (showMessage && !error) {
                    JOptionPane.showMessageDialog(this, "A neutral loss named '" + tempNeutralLoss.name + "' already exists. Please choose a different name.", "Neutral Loss", 2);
                }
                error = true;
                ((TitledBorder)this.reporterIonsAndNeutralLossesPanel.getBorder()).setTitleColor(Color.RED);
                this.reporterIonsAndNeutralLossesPanel.setToolTipText("A neutral loss named '" + tempNeutralLoss.name + "' already exists");
                this.reporterIonsAndNeutralLossesPanel.repaint();
            }
        }
        if (!this.reporterIons.isEmpty()) {
            for (ReporterIon tempReporterIon : this.reporterIons) {
                ReporterIon existingReporterIon = ReporterIon.getReporterIon(tempReporterIon.getName());
                if (existingReporterIon == null || tempReporterIon.isSameAs(existingReporterIon)) continue;
                if (showMessage && !error) {
                    JOptionPane.showMessageDialog(this, "A reporter ion named '" + tempReporterIon.getName() + "' already exists. Please choose a different name.", "Reporter Ion", 2);
                }
                error = true;
                ((TitledBorder)this.reporterIonsPanel.getBorder()).setTitleColor(Color.RED);
                this.reporterIonsPanel.setToolTipText("A reporter ion named '" + tempReporterIon.getName() + "' already exists");
                this.reporterIonsPanel.repaint();
            }
        }
        this.okButton.setEnabled(!error);
        return true;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.propertiesPanel = new JPanel();
        this.typeLabel = new JLabel();
        this.typeCmb = new JComboBox();
        this.categoryLabel = new JLabel();
        this.categoryCmb = new JComboBox();
        this.nameLabel = new JLabel();
        this.nameTxt = new JTextField();
        this.nameShortLabel = new JLabel();
        this.nameShortTxt = new JTextField();
        this.compositionLabel = new JLabel();
        this.compositionTxt = new JTextField();
        this.massLabel = new JLabel();
        this.massTxt = new JTextField();
        this.patternLabel = new JLabel();
        this.patternTxt = new JTextField();
        this.reporterIonsAndNeutralLossesPanel = new JPanel();
        this.neutralLossesAndReportIonsTabbedPane = new JTabbedPane();
        this.neutralLossesPanel = new JPanel();
        this.removeNeutralLoss = new JButton();
        this.neutralLossesJScrollPane = new JScrollPane();
        this.neutralLossesTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)ModificationDialog.this.neutralLossesTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.addNeutralLoss = new JButton();
        this.reporterIonsPanel = new JPanel();
        this.reporterIonsJScrollPane = new JScrollPane();
        this.reporterIonsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)ModificationDialog.this.reporterIonTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.addReporterIon = new JButton();
        this.removerReporterIon = new JButton();
        this.unimodMappingPanel = new JPanel();
        this.cvTermSplitPane = new JSplitPane();
        this.unimodPanel = new JPanel();
        this.unimodNameJTextField = new JTextField();
        this.unimodAccessionJTextField = new JTextField();
        this.unimodLinkLabel = new JLabel();
        this.unimodLabel = new JLabel();
        this.unimodNameLabel = new JLabel();
        this.unimodAccessionLabel = new JLabel();
        this.psiModPanel = new JPanel();
        this.psiModLinkLabel = new JLabel();
        this.psiModAccessionJTextField = new JTextField();
        this.psiModLabel = new JLabel();
        this.psiModNameJTextField = new JTextField();
        this.psiModNameLabel = new JLabel();
        this.psiModAccessionLabel = new JLabel();
        this.helpJButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("New Modification");
        this.setMinimumSize(new Dimension(400, 500));
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.backgroundPanel.setPreferredSize(new Dimension(800, 600));
        this.propertiesPanel.setBorder(BorderFactory.createTitledBorder("Properties"));
        this.propertiesPanel.setOpaque(false);
        this.typeLabel.setText("Type");
        this.typeLabel.setToolTipText("The modification type. See help for details.");
        this.typeCmb.setMaximumRowCount(15);
        this.typeCmb.setModel(new DefaultComboBoxModel<ModificationType>(ModificationType.values()));
        this.typeCmb.setToolTipText("The modification type. See help for details.");
        this.typeCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationDialog.this.typeCmbActionPerformed(evt);
            }
        });
        this.categoryLabel.setText("Category");
        this.categoryLabel.setToolTipText("The modification type. See help for details.");
        this.categoryCmb.setMaximumRowCount(15);
        this.categoryCmb.setModel(new DefaultComboBoxModel<ModificationCategory>(ModificationCategory.values()));
        this.categoryCmb.setToolTipText("The modification category.");
        this.nameLabel.setText("Name");
        this.nameLabel.setToolTipText("The modification name");
        this.nameTxt.setEditable(false);
        this.nameTxt.setHorizontalAlignment(0);
        this.nameTxt.setToolTipText("The modification name");
        this.nameTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ModificationDialog.this.nameTxtKeyReleased(evt);
            }
        });
        this.nameShortLabel.setText("Short");
        this.nameShortLabel.setToolTipText("The modification name");
        this.nameShortTxt.setEditable(false);
        this.nameShortTxt.setHorizontalAlignment(0);
        this.nameShortTxt.setToolTipText("The modification name");
        this.nameShortTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ModificationDialog.this.nameShortTxtKeyReleased(evt);
            }
        });
        this.compositionLabel.setText("Composition");
        this.compositionTxt.setEditable(false);
        this.compositionTxt.setHorizontalAlignment(0);
        this.compositionTxt.setToolTipText("Monoisotopic mass in Dalton");
        this.compositionTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationDialog.this.compositionTxtMouseReleased(evt);
            }
        });
        this.massLabel.setText("Mass");
        this.massLabel.setToolTipText("Monoisotopic mass");
        this.massTxt.setEditable(false);
        this.massTxt.setHorizontalAlignment(0);
        this.massTxt.setToolTipText("Monoisotopic mass in Dalton");
        this.patternLabel.setText("Pattern");
        this.patternLabel.setToolTipText("Residues modified");
        this.patternTxt.setEditable(false);
        this.patternTxt.setHorizontalAlignment(0);
        this.patternTxt.setToolTipText("Residues modified");
        this.patternTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationDialog.this.patternTxtMouseReleased(evt);
            }
        });
        GroupLayout propertiesPanelLayout = new GroupLayout(this.propertiesPanel);
        this.propertiesPanel.setLayout(propertiesPanelLayout);
        propertiesPanelLayout.setHorizontalGroup(propertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(propertiesPanelLayout.createSequentialGroup().addContainerGap().addGroup(propertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(propertiesPanelLayout.createSequentialGroup().addGroup(propertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.nameLabel, -1, 90, Short.MAX_VALUE).addComponent(this.typeLabel, -1, 90, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(propertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.typeCmb, 0, -1, Short.MAX_VALUE).addComponent(this.categoryCmb, 0, -1, Short.MAX_VALUE).addGroup(propertiesPanelLayout.createSequentialGroup().addComponent(this.nameTxt).addGap(18, 18, 18).addComponent(this.nameShortLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameShortTxt, -2, 116, -2)))).addGroup(propertiesPanelLayout.createSequentialGroup().addComponent(this.categoryLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(propertiesPanelLayout.createSequentialGroup().addGroup(propertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.patternLabel, -2, 90, -2).addComponent(this.compositionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(propertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(propertiesPanelLayout.createSequentialGroup().addComponent(this.compositionTxt).addGap(18, 18, 18).addComponent(this.massLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.massTxt, -2, 116, -2)).addComponent(this.patternTxt)))).addContainerGap()));
        propertiesPanelLayout.linkSize(0, this.nameLabel, this.patternLabel, this.typeLabel);
        propertiesPanelLayout.setVerticalGroup(propertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(propertiesPanelLayout.createSequentialGroup().addContainerGap().addGroup(propertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeCmb, -2, -1, -2).addComponent(this.typeLabel)).addGap(0, 0, 0).addGroup(propertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.categoryLabel).addComponent(this.categoryCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(propertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameTxt, -2, -1, -2).addComponent(this.nameLabel).addComponent(this.nameShortLabel).addComponent(this.nameShortTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(propertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.compositionTxt, -2, -1, -2).addComponent(this.compositionLabel).addComponent(this.massLabel).addComponent(this.massTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(propertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.patternTxt, -2, -1, -2).addComponent(this.patternLabel)).addContainerGap()));
        this.reporterIonsAndNeutralLossesPanel.setBorder(BorderFactory.createTitledBorder("Reporter Ions & Neutral Losses"));
        this.reporterIonsAndNeutralLossesPanel.setOpaque(false);
        this.neutralLossesAndReportIonsTabbedPane.setTabPlacement(3);
        this.neutralLossesPanel.setOpaque(false);
        this.removeNeutralLoss.setText("Remove");
        this.removeNeutralLoss.setToolTipText("Remove the selected neutral loss");
        this.removeNeutralLoss.setEnabled(false);
        this.removeNeutralLoss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationDialog.this.removeNeutralLossActionPerformed(evt);
            }
        });
        this.neutralLossesTable.setModel(new NeutralLossesTable());
        this.neutralLossesTable.setSelectionMode(0);
        this.neutralLossesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationDialog.this.neutralLossesTableMouseReleased(evt);
            }
        });
        this.neutralLossesJScrollPane.setViewportView(this.neutralLossesTable);
        this.addNeutralLoss.setText("Add");
        this.addNeutralLoss.setToolTipText("Add a neutral loss");
        this.addNeutralLoss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationDialog.this.addNeutralLossActionPerformed(evt);
            }
        });
        GroupLayout neutralLossesPanelLayout = new GroupLayout(this.neutralLossesPanel);
        this.neutralLossesPanel.setLayout(neutralLossesPanelLayout);
        neutralLossesPanelLayout.setHorizontalGroup(neutralLossesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(neutralLossesPanelLayout.createSequentialGroup().addContainerGap().addGroup(neutralLossesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addNeutralLoss, -2, 90, -2).addComponent(this.removeNeutralLoss, -2, 90, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.neutralLossesJScrollPane, -1, 515, Short.MAX_VALUE).addContainerGap()));
        neutralLossesPanelLayout.setVerticalGroup(neutralLossesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(neutralLossesPanelLayout.createSequentialGroup().addContainerGap().addGroup(neutralLossesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.neutralLossesJScrollPane, -2, 0, Short.MAX_VALUE).addGroup(neutralLossesPanelLayout.createSequentialGroup().addComponent(this.addNeutralLoss).addGap(0, 0, 0).addComponent(this.removeNeutralLoss).addGap(0, 68, Short.MAX_VALUE))).addContainerGap()));
        this.neutralLossesAndReportIonsTabbedPane.addTab("Neutral Losses", this.neutralLossesPanel);
        this.reporterIonsPanel.setOpaque(false);
        this.reporterIonsTable.setModel(new ReporterIonsTable());
        this.reporterIonsTable.setSelectionMode(0);
        this.reporterIonsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationDialog.this.reporterIonsTableMouseReleased(evt);
            }
        });
        this.reporterIonsJScrollPane.setViewportView(this.reporterIonsTable);
        this.addReporterIon.setText("Add");
        this.addReporterIon.setToolTipText("Add a reporter ion");
        this.addReporterIon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationDialog.this.addReporterIonActionPerformed(evt);
            }
        });
        this.removerReporterIon.setText("Remove");
        this.removerReporterIon.setToolTipText("Remove the selected reporter ion");
        this.removerReporterIon.setEnabled(false);
        this.removerReporterIon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationDialog.this.removerReporterIonActionPerformed(evt);
            }
        });
        GroupLayout reporterIonsPanelLayout = new GroupLayout(this.reporterIonsPanel);
        this.reporterIonsPanel.setLayout(reporterIonsPanelLayout);
        reporterIonsPanelLayout.setHorizontalGroup(reporterIonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterIonsPanelLayout.createSequentialGroup().addContainerGap().addGroup(reporterIonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.addReporterIon, -1, -1, Short.MAX_VALUE).addComponent(this.removerReporterIon, -2, 90, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.reporterIonsJScrollPane, -1, 515, Short.MAX_VALUE).addContainerGap()));
        reporterIonsPanelLayout.setVerticalGroup(reporterIonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterIonsPanelLayout.createSequentialGroup().addContainerGap().addGroup(reporterIonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.reporterIonsJScrollPane, -1, 124, Short.MAX_VALUE).addGroup(reporterIonsPanelLayout.createSequentialGroup().addComponent(this.addReporterIon).addGap(0, 0, 0).addComponent(this.removerReporterIon))).addContainerGap()));
        this.neutralLossesAndReportIonsTabbedPane.addTab("Reporter Ions", this.reporterIonsPanel);
        this.neutralLossesAndReportIonsTabbedPane.setSelectedIndex(1);
        GroupLayout reporterIonsAndNeutralLossesPanelLayout = new GroupLayout(this.reporterIonsAndNeutralLossesPanel);
        this.reporterIonsAndNeutralLossesPanel.setLayout(reporterIonsAndNeutralLossesPanelLayout);
        reporterIonsAndNeutralLossesPanelLayout.setHorizontalGroup(reporterIonsAndNeutralLossesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterIonsAndNeutralLossesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.neutralLossesAndReportIonsTabbedPane).addContainerGap()));
        reporterIonsAndNeutralLossesPanelLayout.setVerticalGroup(reporterIonsAndNeutralLossesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterIonsAndNeutralLossesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.neutralLossesAndReportIonsTabbedPane)));
        this.unimodMappingPanel.setBorder(BorderFactory.createTitledBorder("Unimod and PSI-MOD Mapping"));
        this.unimodMappingPanel.setOpaque(false);
        this.cvTermSplitPane.setDividerLocation(300);
        this.cvTermSplitPane.setDividerSize(0);
        this.cvTermSplitPane.setResizeWeight(0.5);
        this.unimodPanel.setOpaque(false);
        this.unimodNameJTextField.setEditable(false);
        this.unimodNameJTextField.setHorizontalAlignment(0);
        this.unimodNameJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ModificationDialog.this.unimodNameJTextFieldKeyReleased(evt);
            }
        });
        this.unimodAccessionJTextField.setEditable(false);
        this.unimodAccessionJTextField.setHorizontalAlignment(0);
        this.unimodAccessionJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ModificationDialog.this.unimodAccessionJTextFieldKeyReleased(evt);
            }
        });
        this.unimodLinkLabel.setText("<html><a href>See: unimod.org</a></html>");
        this.unimodLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationDialog.this.unimodLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationDialog.this.unimodLinkLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationDialog.this.unimodLinkLabelMouseReleased(evt);
            }
        });
        this.unimodLabel.setFont(new Font("sansserif", 1, 12));
        this.unimodLabel.setText("Unimod");
        this.unimodNameLabel.setText("PSI-MS Name");
        this.unimodAccessionLabel.setText("Accession");
        GroupLayout unimodPanelLayout = new GroupLayout(this.unimodPanel);
        this.unimodPanel.setLayout(unimodPanelLayout);
        unimodPanelLayout.setHorizontalGroup(unimodPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(unimodPanelLayout.createSequentialGroup().addContainerGap().addGroup(unimodPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(unimodPanelLayout.createSequentialGroup().addComponent(this.unimodLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(unimodPanelLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(unimodPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.unimodAccessionLabel, -2, 84, -2).addComponent(this.unimodNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(unimodPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, unimodPanelLayout.createSequentialGroup().addGap(0, 109, Short.MAX_VALUE).addComponent(this.unimodLinkLabel, -2, -1, -2)).addComponent(this.unimodNameJTextField).addComponent(this.unimodAccessionJTextField)))).addContainerGap()));
        unimodPanelLayout.setVerticalGroup(unimodPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(unimodPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.unimodLabel).addGroup(unimodPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.unimodAccessionJTextField, -2, -1, -2).addComponent(this.unimodAccessionLabel)).addGap(0, 0, 0).addGroup(unimodPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.unimodNameLabel).addComponent(this.unimodNameJTextField, -2, -1, -2)).addGap(0, 0, 0).addComponent(this.unimodLinkLabel, -2, -1, -2).addContainerGap()));
        this.cvTermSplitPane.setLeftComponent(this.unimodPanel);
        this.psiModPanel.setOpaque(false);
        this.psiModLinkLabel.setText("<html><a href>See: ebi.ac.uk/ols/ontologies/mod</a></html>");
        this.psiModLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationDialog.this.psiModLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationDialog.this.psiModLinkLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationDialog.this.psiModLinkLabelMouseReleased(evt);
            }
        });
        this.psiModAccessionJTextField.setEditable(false);
        this.psiModAccessionJTextField.setHorizontalAlignment(0);
        this.psiModAccessionJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ModificationDialog.this.psiModAccessionJTextFieldKeyReleased(evt);
            }
        });
        this.psiModLabel.setFont(new Font("sansserif", 1, 12));
        this.psiModLabel.setText("PSI-MOD");
        this.psiModNameJTextField.setEditable(false);
        this.psiModNameJTextField.setHorizontalAlignment(0);
        this.psiModNameJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ModificationDialog.this.psiModNameJTextFieldKeyReleased(evt);
            }
        });
        this.psiModNameLabel.setText("Name");
        this.psiModAccessionLabel.setText("Accession");
        GroupLayout psiModPanelLayout = new GroupLayout(this.psiModPanel);
        this.psiModPanel.setLayout(psiModPanelLayout);
        psiModPanelLayout.setHorizontalGroup(psiModPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psiModPanelLayout.createSequentialGroup().addContainerGap().addGroup(psiModPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psiModPanelLayout.createSequentialGroup().addComponent(this.psiModLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(psiModPanelLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(psiModPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(psiModPanelLayout.createSequentialGroup().addGroup(psiModPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.psiModAccessionLabel, -2, 84, -2).addComponent(this.psiModNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(psiModPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.psiModAccessionJTextField, -1, 203, Short.MAX_VALUE).addComponent(this.psiModNameJTextField))).addComponent(this.psiModLinkLabel, -2, -1, -2)))).addContainerGap()));
        psiModPanelLayout.setVerticalGroup(psiModPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psiModPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psiModLabel).addGap(0, 0, 0).addGroup(psiModPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psiModAccessionJTextField, -2, -1, -2).addComponent(this.psiModAccessionLabel)).addGap(0, 0, 0).addGroup(psiModPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psiModNameLabel).addComponent(this.psiModNameJTextField, -2, -1, -2)).addGap(0, 0, 0).addComponent(this.psiModLinkLabel, -2, -1, -2).addContainerGap()));
        this.cvTermSplitPane.setRightComponent(this.psiModPanel);
        GroupLayout unimodMappingPanelLayout = new GroupLayout(this.unimodMappingPanel);
        this.unimodMappingPanel.setLayout(unimodMappingPanelLayout);
        unimodMappingPanelLayout.setHorizontalGroup(unimodMappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(unimodMappingPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cvTermSplitPane).addContainerGap()));
        unimodMappingPanelLayout.setVerticalGroup(unimodMappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cvTermSplitPane));
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.helpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.propertiesPanel, -1, -1, Short.MAX_VALUE)).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.unimodMappingPanel, -1, -1, Short.MAX_VALUE)).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.reporterIonsAndNeutralLossesPanel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.propertiesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reporterIonsAndNeutralLossesPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unimodMappingPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.backgroundPanel, -1, 681, Short.MAX_VALUE).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, 606, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            if (this.editable) {
                boolean cvTermOk = true;
                if (!this.unimodNameJTextField.getText().trim().isEmpty()) {
                    try {
                        Integer.valueOf(this.unimodAccessionJTextField.getText().trim());
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(this, "Please provide the Unimod accession number as an integer.", "Unimod Accession", 2);
                        cvTermOk = false;
                        this.unimodAccessionLabel.setForeground(Color.RED);
                        this.unimodAccessionLabel.setToolTipText("Please provide the Unimod accession number as an integer");
                        this.unimodAccessionJTextField.setToolTipText("Please provide the Unimod accession number as an integer");
                    }
                } else {
                    cvTermOk = false;
                    int option = JOptionPane.showConfirmDialog(this, "Adding a mapping to Unimod is strongly recommended. This\nis for example mandatory when exporting data to mzIdentML.\n\nContinue without such a mapping?", "Unimod Mapping", 1, 2);
                    if (option != 0) {
                        return;
                    }
                }
                CvTerm unimodCvTerm = null;
                if (cvTermOk) {
                    int unimodAccession = Integer.valueOf(this.unimodAccessionJTextField.getText().trim());
                    unimodCvTerm = new CvTerm("UNIMOD", "UNIMOD:" + unimodAccession, this.unimodNameJTextField.getText().trim(), null);
                }
                cvTermOk = true;
                if (!this.psiModNameJTextField.getText().trim().isEmpty()) {
                    try {
                        Integer.valueOf(this.psiModAccessionJTextField.getText().trim());
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(this, "Please provide the PSI-MOD accession number as an integer.", "PSI-MOD Accession", 2);
                        cvTermOk = false;
                        this.psiModAccessionLabel.setForeground(Color.RED);
                        this.psiModAccessionLabel.setToolTipText("Please provide the PSI-MOD accession number as an integer");
                        this.psiModAccessionJTextField.setToolTipText("Please provide the PSI-MOD accession number as an integer");
                    }
                } else {
                    cvTermOk = false;
                }
                CvTerm psiModCvTerm = null;
                if (cvTermOk) {
                    int psiModAccession = Integer.valueOf(this.psiModAccessionJTextField.getText().trim());
                    psiModCvTerm = new CvTerm("MOD", "MOD:" + psiModAccession, this.psiModNameJTextField.getText().trim(), null);
                }
                Modification newModification = new Modification((ModificationType)((Object)this.typeCmb.getSelectedItem()), this.nameTxt.getText().trim(), this.nameShortTxt.getText().trim().toLowerCase(), this.atomChainAdded, this.atomChainRemoved, this.pattern, unimodCvTerm, psiModCvTerm, (ModificationCategory)((Object)this.categoryCmb.getSelectedItem()));
                newModification.setNeutralLosses(this.neutralLosses);
                newModification.setReporterIons(this.reporterIons);
                for (String modification : this.modificationFactory.getModifications()) {
                    int outcome;
                    Modification otherModification;
                    if (this.currentPtm != null && modification.equals(this.currentPtm.getName()) || !newModification.isSameAs(otherModification = this.modificationFactory.getModification(modification)) || (outcome = JOptionPane.showConfirmDialog(this, "The modification '" + modification + "' presents characteristics similar to your input.\nAre you sure you want to create this new modification?", "Modification Already Exists", 0)) != 1) continue;
                    return;
                }
                this.modificationFactory.addUserModification(newModification);
            }
            this.saveChanges();
            this.dispose();
        }
    }

    private void typeCmbActionPerformed(ActionEvent evt) {
        ModificationType tempModificationType = (ModificationType)((Object)this.typeCmb.getSelectedItem());
        if (tempModificationType == ModificationType.modaa || tempModificationType == ModificationType.modcaa_peptide || tempModificationType == ModificationType.modcaa_protein || tempModificationType == ModificationType.modnaa_peptide || tempModificationType == ModificationType.modnaa_protein) {
            this.patternTxt.setEnabled(true);
        } else {
            this.pattern = null;
            this.patternTxt.setText(null);
            this.patternTxt.setEnabled(false);
        }
        this.validateInput(false);
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/PtmDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), null, "New Modification - Help");
        this.setCursor(new Cursor(0));
    }

    private void addNeutralLossActionPerformed(ActionEvent evt) {
        this.neutralLosses.add(new NeutralLoss("new neutral loss", new AtomChain(), false, null, false));
        this.updateTables();
    }

    private void addReporterIonActionPerformed(ActionEvent evt) {
        this.reporterIons.add(new ReporterIon("New reporter ion", 0.0, false));
        this.updateTables();
    }

    private void removeNeutralLossActionPerformed(ActionEvent evt) {
        int row = this.neutralLossesTable.getSelectedRow();
        if (row != -1) {
            int index = this.neutralLossesTable.convertRowIndexToModel(row);
            this.neutralLosses.remove(index);
            this.updateTables();
        }
        this.removeNeutralLoss.setEnabled((row = this.neutralLossesTable.getSelectedRow()) != -1);
    }

    private void removerReporterIonActionPerformed(ActionEvent evt) {
        int row = this.reporterIonsTable.getSelectedRow();
        if (row != -1) {
            int index = this.reporterIonsTable.convertRowIndexToModel(row);
            this.reporterIons.remove(index);
            this.updateTables();
        }
        this.removerReporterIon.setEnabled((row = this.reporterIonsTable.getSelectedRow()) != -1);
    }

    private void neutralLossesTableMouseReleased(MouseEvent evt) {
        int row;
        NeutralLoss neutralLoss;
        AtomChain atomChain;
        AtomChainDialog atomChainDialog;
        int column;
        if (this.editable) {
            int row2 = this.neutralLossesTable.getSelectedRow();
            this.removeNeutralLoss.setEnabled(row2 != -1);
        }
        if (evt != null && evt.getButton() == 1 && evt.getClickCount() == 2 && this.editable && ((column = this.neutralLossesTable.columnAtPoint(evt.getPoint())) == 2 || column == 3) && !(atomChainDialog = new AtomChainDialog(this, atomChain = (neutralLoss = this.neutralLosses.get(row = this.neutralLossesTable.rowAtPoint(evt.getPoint()))).getComposition(), new AtomChain(), true)).isCanceled()) {
            atomChain = atomChainDialog.getAtomChainAdded();
            if (atomChain.size() > 0) {
                neutralLoss.setComposition(atomChain);
            }
            this.updateTables();
        }
    }

    private void reporterIonsTableMouseReleased(MouseEvent evt) {
        int row;
        ReporterIon reporterIon;
        AtomChain atomChain;
        AtomChainDialog atomChainDialog;
        int column;
        if (this.editable) {
            int row2 = this.reporterIonsTable.getSelectedRow();
            this.removerReporterIon.setEnabled(row2 != -1);
        }
        if (evt != null && evt.getButton() == 1 && evt.getClickCount() == 2 && this.editable && ((column = this.reporterIonsTable.columnAtPoint(evt.getPoint())) == 2 || column == 3) && !(atomChainDialog = new AtomChainDialog(this, atomChain = (reporterIon = this.reporterIons.get(row = this.reporterIonsTable.rowAtPoint(evt.getPoint()))).getAtomicComposition(), new AtomChain(), true)).isCanceled()) {
            atomChain = atomChainDialog.getAtomChainAdded();
            if (atomChain.size() > 0) {
                reporterIon.setAtomicComposition(atomChain);
            }
            this.updateTables();
        }
    }

    private void patternTxtMouseReleased(MouseEvent evt) {
        AminoAcidPatternDialog dialog;
        if (this.editable && this.patternTxt.isEnabled() && evt.getButton() == 1 && !(dialog = new AminoAcidPatternDialog(null, this.pattern, this.editable)).isCanceled()) {
            this.pattern = dialog.getPattern();
            this.patternTxt.setText(this.pattern.toString());
            this.validateInput(false);
        }
    }

    private void nameTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void unimodLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void unimodLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void unimodLinkLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.unimod.org");
        this.setCursor(new Cursor(0));
    }

    private void unimodAccessionJTextFieldKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void unimodNameJTextFieldKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void nameShortTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void compositionTxtMouseReleased(MouseEvent evt) {
        if (this.editable) {
            AtomChainDialog atomChainDialog = new AtomChainDialog(this, this.atomChainAdded, this.atomChainRemoved, false);
            if (!atomChainDialog.isCanceled()) {
                this.atomChainAdded = atomChainDialog.getAtomChainAdded();
                this.atomChainRemoved = atomChainDialog.getAtomChainRemoved();
                String addition = "";
                if (this.atomChainAdded.size() > 0) {
                    addition = this.atomChainAdded.toString();
                }
                String deletion = "";
                if (this.atomChainRemoved.size() > 0) {
                    deletion = "-" + this.atomChainRemoved.toString();
                }
                String temp = addition + " " + deletion;
                this.compositionTxt.setText(temp.trim());
            }
            this.validateInput(false);
            this.updateMass();
        }
    }

    private void psiModNameJTextFieldKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void psiModAccessionJTextFieldKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void psiModLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void psiModLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void psiModLinkLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.ebi.ac.uk/ols/ontologies/mod");
        this.setCursor(new Cursor(0));
    }

    private void updateModMappingText(CvTerm uniModCvTerm, CvTerm psiModCvTerm) {
        if (uniModCvTerm != null) {
            this.unimodAccessionJTextField.setText(uniModCvTerm.getAccession().substring("Unimod:".length()));
            this.unimodNameJTextField.setText(uniModCvTerm.getName());
            this.unimodNameJTextField.setCaretPosition(0);
        }
        if (psiModCvTerm != null) {
            this.psiModAccessionJTextField.setText(psiModCvTerm.getAccession().substring("MOD:".length()));
            this.psiModNameJTextField.setText(psiModCvTerm.getName());
            this.psiModNameJTextField.setCaretPosition(0);
        }
    }

    private void updateTables() {
        ((DefaultTableModel)this.neutralLossesTable.getModel()).fireTableDataChanged();
        ((DefaultTableModel)this.reporterIonsTable.getModel()).fireTableDataChanged();
        this.validateInput(false);
    }

    private void saveChanges() {
        try {
            this.modificationFactory.saveFactory();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "An error occurred while saving the modification.", "Saving Error", 2);
        }
    }

    private class ReporterIonsTable
    extends DefaultTableModel {
        private ReporterIonsTable() {
        }

        @Override
        public int getRowCount() {
            return ModificationDialog.this.reporterIons.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Composition";
                }
                case 3: {
                    return "Mass";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return ((ReporterIon)ModificationDialog.this.reporterIons.get(row)).getName();
                }
                case 2: {
                    ReporterIon reporterIon = (ReporterIon)ModificationDialog.this.reporterIons.get(row);
                    if (reporterIon.getAtomicComposition() != null) {
                        return reporterIon.getAtomicComposition().toString();
                    }
                    return "";
                }
                case 3: {
                    ReporterIon reporterIon = (ReporterIon)ModificationDialog.this.reporterIons.get(row);
                    return reporterIon.getTheoreticMz(1);
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1 && ModificationDialog.this.editable;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            int index = ModificationDialog.this.reporterIonsTable.convertRowIndexToModel(row);
            ReporterIon reporterIon = (ReporterIon)ModificationDialog.this.reporterIons.get(index);
            if (column == 1) {
                reporterIon.setName((String)aValue);
            }
        }
    }

    private class NeutralLossesTable
    extends DefaultTableModel {
        private NeutralLossesTable() {
        }

        @Override
        public int getRowCount() {
            return ModificationDialog.this.neutralLosses.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Composition";
                }
                case 3: {
                    return "Mass";
                }
                case 4: {
                    return "Fixed";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return ((NeutralLoss)((ModificationDialog)ModificationDialog.this).neutralLosses.get((int)row)).name;
                }
                case 2: {
                    NeutralLoss neutralLoss = (NeutralLoss)ModificationDialog.this.neutralLosses.get(row);
                    if (neutralLoss.getComposition() != null) {
                        return neutralLoss.getComposition().toString();
                    }
                    return "";
                }
                case 3: {
                    NeutralLoss neutralLoss = (NeutralLoss)ModificationDialog.this.neutralLosses.get(row);
                    return neutralLoss.getMass();
                }
                case 4: {
                    return ((NeutralLoss)ModificationDialog.this.neutralLosses.get(row)).isFixed();
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return (columnIndex == 1 || columnIndex == 4) && ModificationDialog.this.editable;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            int index = ModificationDialog.this.neutralLossesTable.convertRowIndexToModel(row);
            NeutralLoss neutralLoss = (NeutralLoss)ModificationDialog.this.neutralLosses.get(index);
            if (column == 1) {
                String newName = aValue.toString();
                NeutralLoss newLoss = new NeutralLoss(newName, neutralLoss.getComposition(), neutralLoss.isFixed());
                ModificationDialog.this.neutralLosses.set(index, newLoss);
            } else if (column == 4) {
                neutralLoss.setFixed((Boolean)aValue);
            }
        }
    }
}

