/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.modification;

import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidPattern;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.modification.ModificationDialog;
import com.compomics.util.pride.CvTerm;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.HtmlLinksRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerColorTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;

public class ModificationsDialog
extends JDialog {
    private final ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private final Color sparklineColor = new Color(110, 196, 97);
    private final String selectedRowHtmlTagFontColor = "#FFFFFF";
    private final String notSelectedRowHtmlTagFontColor = "#0101DF";
    private ArrayList<String> defaultModsTableToolTips;
    private ArrayList<String> userModsTableToolTips;
    private final ArrayList<Integer> searchPossibilities = new ArrayList();
    private int searchCurrentSelection = 0;
    private final String searchWelcomeText = "(name or mass)";
    private JButton addUserModification;
    private JTable defaultModificationsTable;
    private JPanel defaultModsPanel;
    private JPopupMenu defaultModsPopupMenu;
    private JScrollPane defaultModsScrollPane;
    private JButton deleteUserModification;
    private JButton editUserModification;
    private JMenuItem editUserPtmJMenuItem;
    private JLabel exportDefaultModsLabel;
    private JLabel exportUserModsLabel;
    private JLabel findJLabel;
    private JPanel modificationsEditorPanel;
    private JButton modificationsHelpJButton;
    private JSplitPane modificationsSplitPane;
    private JButton okButton;
    private JLabel searchIndexLabel;
    private JTextField searchInputTxt;
    private JButton searchNextButton;
    private JButton searchPreviousButton;
    private JTable userModificationsTable;
    private JPanel userModsPanel;
    private JPopupMenu userModsPopupMenu;
    private JScrollPane userModsScrollPane;
    private JMenuItem viewDefaultModsJMenuItem;

    public ModificationsDialog(Frame parentFrame, boolean modal) {
        super(parentFrame, modal);
        this.initComponents();
        this.setUpTables();
        this.searchInputTxt.setText("(name or mass)");
        this.searchIndexLabel.setText("");
        this.searchPreviousButton.setEnabled(false);
        this.searchNextButton.setEnabled(false);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    private void setUpTables() {
        this.defaultModificationsTable.setAutoCreateRowSorter(true);
        this.userModificationsTable.setAutoCreateRowSorter(true);
        this.defaultModsScrollPane.getViewport().setOpaque(false);
        this.userModsScrollPane.getViewport().setOpaque(false);
        this.defaultModificationsTable.getTableHeader().setReorderingAllowed(false);
        this.userModificationsTable.getTableHeader().setReorderingAllowed(false);
        this.defaultModificationsTable.getColumn(" ").setMaxWidth(50);
        this.defaultModificationsTable.getColumn(" ").setMinWidth(50);
        this.userModificationsTable.getColumn(" ").setMaxWidth(50);
        this.userModificationsTable.getColumn(" ").setMinWidth(50);
        this.defaultModificationsTable.getColumn("Short").setMaxWidth(100);
        this.defaultModificationsTable.getColumn("Short").setMinWidth(100);
        this.userModificationsTable.getColumn("Short").setMaxWidth(100);
        this.userModificationsTable.getColumn("Short").setMinWidth(100);
        this.defaultModificationsTable.getColumn("Residues").setMaxWidth(100);
        this.defaultModificationsTable.getColumn("Residues").setMinWidth(100);
        this.userModificationsTable.getColumn("Residues").setMaxWidth(100);
        this.userModificationsTable.getColumn("Residues").setMinWidth(100);
        this.defaultModificationsTable.getColumn("Type").setMaxWidth(50);
        this.defaultModificationsTable.getColumn("Type").setMinWidth(50);
        this.userModificationsTable.getColumn("Type").setMaxWidth(50);
        this.userModificationsTable.getColumn("Type").setMinWidth(50);
        this.defaultModificationsTable.getColumn("Unimod").setMaxWidth(100);
        this.defaultModificationsTable.getColumn("Unimod").setMinWidth(100);
        this.userModificationsTable.getColumn("Unimod").setMaxWidth(100);
        this.userModificationsTable.getColumn("Unimod").setMinWidth(100);
        this.defaultModificationsTable.getColumn("PSI-MOD").setMaxWidth(100);
        this.defaultModificationsTable.getColumn("PSI-MOD").setMinWidth(100);
        this.userModificationsTable.getColumn("PSI-MOD").setMaxWidth(100);
        this.userModificationsTable.getColumn("PSI-MOD").setMinWidth(100);
        HashMap<Integer, Color> modificationTypeColorMap = new HashMap<Integer, Color>();
        modificationTypeColorMap.put(ModificationType.modaa.index, this.sparklineColor);
        modificationTypeColorMap.put(ModificationType.modc_protein.index, Color.CYAN);
        modificationTypeColorMap.put(ModificationType.modcaa_protein.index, Color.MAGENTA);
        modificationTypeColorMap.put(ModificationType.modc_peptide.index, Color.RED);
        modificationTypeColorMap.put(ModificationType.modcaa_peptide.index, Color.ORANGE);
        modificationTypeColorMap.put(ModificationType.modn_protein.index, Color.YELLOW);
        modificationTypeColorMap.put(ModificationType.modnaa_protein.index, Color.PINK);
        modificationTypeColorMap.put(ModificationType.modn_peptide.index, Color.BLUE);
        modificationTypeColorMap.put(ModificationType.modnaa_protein.index, Color.GRAY);
        HashMap<Integer, String> modificationTypeTooltipMap = new HashMap<Integer, String>();
        for (ModificationType modType : ModificationType.values()) {
            modificationTypeTooltipMap.put(modType.index, modType.shortName);
        }
        this.defaultModificationsTable.getColumn("Type").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.lightGray, modificationTypeColorMap, modificationTypeTooltipMap));
        this.userModificationsTable.getColumn("Type").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.lightGray, modificationTypeColorMap, modificationTypeTooltipMap));
        this.defaultModificationsTable.getColumn("Unimod").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer("#FFFFFF", "#0101DF"));
        this.userModificationsTable.getColumn("Unimod").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer("#FFFFFF", "#0101DF"));
        this.defaultModificationsTable.getColumn("PSI-MOD").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer("#FFFFFF", "#0101DF"));
        this.userModificationsTable.getColumn("PSI-MOD").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer("#FFFFFF", "#0101DF"));
        this.updateMassSparklines();
        this.defaultModsTableToolTips = new ArrayList();
        this.defaultModsTableToolTips.add(null);
        this.defaultModsTableToolTips.add("Modification Name");
        this.defaultModsTableToolTips.add("Modification Short Name");
        this.defaultModsTableToolTips.add("Modification Mass Change");
        this.defaultModsTableToolTips.add("Modification Type");
        this.defaultModsTableToolTips.add("Affected Residues");
        this.defaultModsTableToolTips.add("Modification Category");
        this.defaultModsTableToolTips.add("Unimod Mapping");
        this.defaultModsTableToolTips.add("PSI-MOD Mapping");
        this.userModsTableToolTips = new ArrayList();
        this.userModsTableToolTips.add(null);
        this.userModsTableToolTips.add("Modification Name");
        this.userModsTableToolTips.add("Modification Short Name");
        this.userModsTableToolTips.add("Modification Mass Change");
        this.userModsTableToolTips.add("Modification Type");
        this.userModsTableToolTips.add("Affected Residues");
        this.userModsTableToolTips.add("Modification Category");
        this.userModsTableToolTips.add("Unimod Mapping");
        this.userModsTableToolTips.add("PSI-MOD Mapping");
        ((TitledBorder)this.defaultModsPanel.getBorder()).setTitle("Default Modifications (" + this.defaultModificationsTable.getRowCount() + ")");
        ((TitledBorder)this.userModsPanel.getBorder()).setTitle("User Modifications (" + this.userModificationsTable.getRowCount() + ")");
    }

    private void updateMassSparklines() {
        int i;
        double maxMassChange = 0.0;
        for (i = 0; i < this.defaultModificationsTable.getRowCount(); ++i) {
            if (!(Math.abs((Double)this.defaultModificationsTable.getValueAt(i, this.defaultModificationsTable.getColumn("Mass").getModelIndex())) > maxMassChange)) continue;
            maxMassChange = Math.abs((Double)this.defaultModificationsTable.getValueAt(i, this.defaultModificationsTable.getColumn("Mass").getModelIndex()));
        }
        for (i = 0; i < this.userModificationsTable.getRowCount(); ++i) {
            if (!(Math.abs((Double)this.userModificationsTable.getValueAt(i, this.userModificationsTable.getColumn("Mass").getModelIndex())) > maxMassChange)) continue;
            maxMassChange = Math.abs((Double)this.userModificationsTable.getValueAt(i, this.userModificationsTable.getColumn("Mass").getModelIndex()));
        }
        this.defaultModificationsTable.getColumn("Mass").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(-maxMassChange), Double.valueOf(maxMassChange)));
        ((JSparklinesBarChartTableCellRenderer)this.defaultModificationsTable.getColumn("Mass").getCellRenderer()).showNumberAndChart(true, 57, new DecimalFormat("0.0000"));
        this.userModificationsTable.getColumn("Mass").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(-maxMassChange), Double.valueOf(maxMassChange)));
        ((JSparklinesBarChartTableCellRenderer)this.userModificationsTable.getColumn("Mass").getCellRenderer()).showNumberAndChart(true, 57, new DecimalFormat("0.0000"));
    }

    private void initComponents() {
        this.defaultModsPopupMenu = new JPopupMenu();
        this.viewDefaultModsJMenuItem = new JMenuItem();
        this.userModsPopupMenu = new JPopupMenu();
        this.editUserPtmJMenuItem = new JMenuItem();
        this.modificationsEditorPanel = new JPanel();
        this.modificationsSplitPane = new JSplitPane();
        this.defaultModsPanel = new JPanel();
        this.defaultModsScrollPane = new JScrollPane();
        this.defaultModificationsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)ModificationsDialog.this.defaultModsTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.searchIndexLabel = new JLabel();
        this.searchNextButton = new JButton();
        this.searchPreviousButton = new JButton();
        this.searchInputTxt = new JTextField();
        this.findJLabel = new JLabel();
        this.exportDefaultModsLabel = new JLabel();
        this.userModsPanel = new JPanel();
        this.userModsScrollPane = new JScrollPane();
        this.userModificationsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)ModificationsDialog.this.userModsTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.deleteUserModification = new JButton();
        this.editUserModification = new JButton();
        this.addUserModification = new JButton();
        this.exportUserModsLabel = new JLabel();
        this.okButton = new JButton();
        this.modificationsHelpJButton = new JButton();
        this.viewDefaultModsJMenuItem.setText("View");
        this.viewDefaultModsJMenuItem.setToolTipText("View Details");
        this.viewDefaultModsJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsDialog.this.viewDefaultModsJMenuItemActionPerformed(evt);
            }
        });
        this.defaultModsPopupMenu.add(this.viewDefaultModsJMenuItem);
        this.editUserPtmJMenuItem.setText("Edit");
        this.editUserPtmJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsDialog.this.editUserPtmJMenuItemActionPerformed(evt);
            }
        });
        this.userModsPopupMenu.add(this.editUserPtmJMenuItem);
        this.setDefaultCloseOperation(0);
        this.setTitle("Modification Details");
        this.setMinimumSize(new Dimension(500, 500));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ModificationsDialog.this.formWindowClosing(evt);
            }
        });
        this.modificationsEditorPanel.setBackground(new Color(230, 230, 230));
        this.modificationsSplitPane.setBorder(null);
        this.modificationsSplitPane.setDividerLocation(380);
        this.modificationsSplitPane.setDividerSize(-1);
        this.modificationsSplitPane.setOrientation(0);
        this.modificationsSplitPane.setResizeWeight(0.65);
        this.defaultModsPanel.setBorder(BorderFactory.createTitledBorder("Default Modifications"));
        this.defaultModsPanel.setOpaque(false);
        this.defaultModificationsTable.setModel(new DefaultModificationTable());
        this.defaultModificationsTable.setSelectionMode(0);
        this.defaultModificationsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ModificationsDialog.this.defaultModificationsTableMouseMoved(evt);
            }
        });
        this.defaultModificationsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ModificationsDialog.this.defaultModificationsTableMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsDialog.this.defaultModificationsTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationsDialog.this.defaultModificationsTableMouseReleased(evt);
            }
        });
        this.defaultModsScrollPane.setViewportView(this.defaultModificationsTable);
        this.searchIndexLabel.setFont(this.searchIndexLabel.getFont().deriveFont(this.searchIndexLabel.getFont().getStyle() | 2));
        this.searchIndexLabel.setHorizontalAlignment(0);
        this.searchIndexLabel.setText(" ");
        this.searchNextButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/next_grey.png")));
        this.searchNextButton.setToolTipText("Next");
        this.searchNextButton.setBorderPainted(false);
        this.searchNextButton.setContentAreaFilled(false);
        this.searchNextButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/next.png")));
        this.searchNextButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsDialog.this.searchNextButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsDialog.this.searchNextButtonMouseExited(evt);
            }
        });
        this.searchNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsDialog.this.searchNextButtonActionPerformed(evt);
            }
        });
        this.searchPreviousButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/previous_grey.png")));
        this.searchPreviousButton.setToolTipText("Previous");
        this.searchPreviousButton.setBorder(null);
        this.searchPreviousButton.setBorderPainted(false);
        this.searchPreviousButton.setContentAreaFilled(false);
        this.searchPreviousButton.setIconTextGap(0);
        this.searchPreviousButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/previous.png")));
        this.searchPreviousButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsDialog.this.searchPreviousButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsDialog.this.searchPreviousButtonMouseExited(evt);
            }
        });
        this.searchPreviousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsDialog.this.searchPreviousButtonActionPerformed(evt);
            }
        });
        this.searchInputTxt.setForeground(new Color(204, 204, 204));
        this.searchInputTxt.setHorizontalAlignment(0);
        this.searchInputTxt.setText("(name or mass)");
        this.searchInputTxt.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.searchInputTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationsDialog.this.searchInputTxtMouseReleased(evt);
            }
        });
        this.searchInputTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ModificationsDialog.this.searchInputTxtKeyReleased(evt);
            }
        });
        this.findJLabel.setText("Find:");
        this.exportDefaultModsLabel.setText("<html><a href>Export to file</a></html>");
        this.exportDefaultModsLabel.setToolTipText("Export to tab delimited text file");
        this.exportDefaultModsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsDialog.this.exportDefaultModsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsDialog.this.exportDefaultModsLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationsDialog.this.exportDefaultModsLabelMouseReleased(evt);
            }
        });
        GroupLayout defaultModsPanelLayout = new GroupLayout(this.defaultModsPanel);
        this.defaultModsPanel.setLayout(defaultModsPanelLayout);
        defaultModsPanelLayout.setHorizontalGroup(defaultModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, defaultModsPanelLayout.createSequentialGroup().addContainerGap().addGroup(defaultModsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.defaultModsScrollPane, -1, 973, Short.MAX_VALUE).addGroup(defaultModsPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.exportDefaultModsLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.findJLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchInputTxt, -2, 205, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchPreviousButton, -2, 15, -2).addGap(0, 0, 0).addComponent(this.searchNextButton, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchIndexLabel, -2, 97, -2))).addContainerGap()));
        defaultModsPanelLayout.setVerticalGroup(defaultModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, defaultModsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.defaultModsScrollPane, -1, 308, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(defaultModsPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.findJLabel).addComponent(this.searchInputTxt, -2, -1, -2).addComponent(this.searchIndexLabel).addComponent(this.searchPreviousButton, -2, 15, -2).addComponent(this.searchNextButton, -2, 15, -2).addComponent(this.exportDefaultModsLabel, -2, -1, -2)).addContainerGap()));
        this.modificationsSplitPane.setTopComponent(this.defaultModsPanel);
        this.userModsPanel.setBorder(BorderFactory.createTitledBorder("User Modifications"));
        this.userModsPanel.setOpaque(false);
        this.userModificationsTable.setModel(new UserModificationTable());
        this.userModificationsTable.setSelectionMode(0);
        this.userModificationsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ModificationsDialog.this.userModificationsTableMouseMoved(evt);
            }
        });
        this.userModificationsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ModificationsDialog.this.userModificationsTableMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsDialog.this.userModificationsTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationsDialog.this.userModificationsTableMouseReleased(evt);
            }
        });
        this.userModsScrollPane.setViewportView(this.userModificationsTable);
        this.deleteUserModification.setText("Delete");
        this.deleteUserModification.setToolTipText("Delete a user defined modification");
        this.deleteUserModification.setEnabled(false);
        this.deleteUserModification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsDialog.this.deleteUserModificationActionPerformed(evt);
            }
        });
        this.editUserModification.setText("Edit");
        this.editUserModification.setToolTipText("Edit a user defined modification");
        this.editUserModification.setEnabled(false);
        this.editUserModification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsDialog.this.editUserModificationActionPerformed(evt);
            }
        });
        this.addUserModification.setText("Add");
        this.addUserModification.setToolTipText("Add a new user defined modification");
        this.addUserModification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsDialog.this.addUserModificationActionPerformed(evt);
            }
        });
        this.exportUserModsLabel.setText("<html><a href>Export to file</a></html>");
        this.exportUserModsLabel.setToolTipText("Export to tab delimited text file");
        this.exportUserModsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsDialog.this.exportUserModsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsDialog.this.exportUserModsLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationsDialog.this.exportUserModsLabelMouseReleased(evt);
            }
        });
        GroupLayout userModsPanelLayout = new GroupLayout(this.userModsPanel);
        this.userModsPanel.setLayout(userModsPanelLayout);
        userModsPanelLayout.setHorizontalGroup(userModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(userModsPanelLayout.createSequentialGroup().addContainerGap().addGroup(userModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userModsScrollPane, -1, 973, Short.MAX_VALUE).addGroup(userModsPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.exportUserModsLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.addUserModification, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editUserModification, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteUserModification, -2, 65, -2))).addContainerGap()));
        userModsPanelLayout.setVerticalGroup(userModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, userModsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.userModsScrollPane, -1, 169, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(userModsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.deleteUserModification, -1, -1, Short.MAX_VALUE).addComponent(this.editUserModification, -1, -1, Short.MAX_VALUE).addGroup(userModsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addUserModification, -1, -1, Short.MAX_VALUE).addComponent(this.exportUserModsLabel, -2, -1, -2))).addContainerGap()));
        this.modificationsSplitPane.setRightComponent(this.userModsPanel);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.modificationsHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.modificationsHelpJButton.setToolTipText("Help");
        this.modificationsHelpJButton.setBorder(null);
        this.modificationsHelpJButton.setBorderPainted(false);
        this.modificationsHelpJButton.setContentAreaFilled(false);
        this.modificationsHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsDialog.this.modificationsHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsDialog.this.modificationsHelpJButtonMouseExited(evt);
            }
        });
        this.modificationsHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsDialog.this.modificationsHelpJButtonActionPerformed(evt);
            }
        });
        GroupLayout modificationsEditorPanelLayout = new GroupLayout(this.modificationsEditorPanel);
        this.modificationsEditorPanel.setLayout(modificationsEditorPanelLayout);
        modificationsEditorPanelLayout.setHorizontalGroup(modificationsEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modificationsEditorPanelLayout.createSequentialGroup().addContainerGap().addGroup(modificationsEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modificationsSplitPane).addGroup(modificationsEditorPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.modificationsHelpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton))).addContainerGap()));
        modificationsEditorPanelLayout.setVerticalGroup(modificationsEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modificationsEditorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.modificationsSplitPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(modificationsEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.okButton).addComponent(this.modificationsHelpJButton, -2, 23, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1025, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modificationsEditorPanel, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 673, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.modificationsEditorPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0))));
        this.pack();
    }

    private void defaultModificationsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void defaultModificationsTableMouseReleased(MouseEvent evt) {
        int row = this.defaultModificationsTable.rowAtPoint(evt.getPoint());
        int column = this.defaultModificationsTable.columnAtPoint(evt.getPoint());
        if (!(row == -1 || column != this.defaultModificationsTable.getColumn("Unimod").getModelIndex() && column != this.defaultModificationsTable.getColumn("PSI-MOD").getModelIndex() || column != this.defaultModificationsTable.getColumn("Unimod").getModelIndex() && column != this.defaultModificationsTable.getColumn("PSI-MOD").getModelIndex() || evt.getButton() != 1 || this.defaultModificationsTable.getValueAt(row, column) == null || ((String)this.defaultModificationsTable.getValueAt(row, column)).lastIndexOf("<a href=\"") == -1)) {
            String link = (String)this.defaultModificationsTable.getValueAt(row, column);
            link = link.substring(link.indexOf("\"") + 1);
            link = link.substring(0, link.indexOf("\""));
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL(link);
            this.setCursor(new Cursor(0));
        }
    }

    private void defaultModificationsTableMouseMoved(MouseEvent evt) {
        int row = this.defaultModificationsTable.rowAtPoint(evt.getPoint());
        int column = this.defaultModificationsTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if ((column == this.defaultModificationsTable.getColumn("Unimod").getModelIndex() || column == this.defaultModificationsTable.getColumn("PSI-MOD").getModelIndex()) && this.defaultModificationsTable.getValueAt(row, column) != null) {
                String tempValue = (String)this.defaultModificationsTable.getValueAt(row, column);
                if (tempValue.lastIndexOf("<a href=\"") != -1) {
                    this.setCursor(new Cursor(12));
                } else {
                    this.setCursor(new Cursor(0));
                }
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void searchNextButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void searchNextButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void searchNextButtonActionPerformed(ActionEvent evt) {
        this.searchCurrentSelection = this.searchCurrentSelection == this.searchPossibilities.size() - 1 ? 0 : ++this.searchCurrentSelection;
        this.updateModSelection();
    }

    private void searchPreviousButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void searchPreviousButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void searchPreviousButtonActionPerformed(ActionEvent evt) {
        this.searchCurrentSelection = this.searchCurrentSelection == 0 ? this.searchPossibilities.size() - 1 : --this.searchCurrentSelection;
        this.updateModSelection();
    }

    private void searchInputTxtMouseReleased(MouseEvent evt) {
        if (this.searchInputTxt.getText().equals("(name or mass)")) {
            this.searchInputTxt.selectAll();
        }
    }

    private void searchInputTxtKeyReleased(KeyEvent evt) {
        if (!this.searchInputTxt.getText().equalsIgnoreCase("(name or mass)")) {
            this.searchInputTxt.setForeground(Color.black);
        } else {
            this.searchInputTxt.setForeground(new Color(204, 204, 204));
        }
        if (evt.getKeyCode() == 39 && this.searchNextButton.isEnabled()) {
            this.searchNextButtonActionPerformed(null);
        } else if (evt.getKeyCode() == 37 & this.searchPreviousButton.isEnabled()) {
            this.searchPreviousButtonActionPerformed(null);
        } else {
            ArrayList<Integer> toAdd = new ArrayList<Integer>();
            this.searchPossibilities.clear();
            this.searchCurrentSelection = 0;
            String input = this.searchInputTxt.getText().trim().toLowerCase();
            if (!input.isEmpty()) {
                for (int i = 0; i < this.modificationFactory.getDefaultModifications().size(); ++i) {
                    String modName = this.modificationFactory.getDefaultModifications().get(i);
                    String mass = this.modificationFactory.getModification(modName).getMass() + "";
                    if (mass.startsWith(input)) {
                        this.searchPossibilities.add(i);
                        continue;
                    }
                    if (!modName.toLowerCase().contains(input)) continue;
                    toAdd.add(i);
                }
                this.searchPossibilities.addAll(toAdd);
            }
        }
        if (this.searchPossibilities.size() > 1) {
            this.searchPreviousButton.setEnabled(true);
            this.searchNextButton.setEnabled(true);
            this.searchIndexLabel.setForeground(Color.BLACK);
            this.updateModSelection();
        } else if (this.searchPossibilities.size() == 1) {
            this.searchPreviousButton.setEnabled(false);
            this.searchNextButton.setEnabled(false);
            this.searchIndexLabel.setForeground(Color.BLACK);
            this.updateModSelection();
        } else {
            this.searchPreviousButton.setEnabled(false);
            this.searchNextButton.setEnabled(false);
            this.searchIndexLabel.setForeground(Color.RED);
            this.searchIndexLabel.setText("(no match)");
        }
    }

    private void userModificationsTableMouseClicked(MouseEvent evt) {
        String modificationName;
        Modification modification;
        ModificationDialog modificationDialog;
        if (evt.getButton() == 3) {
            this.userModificationsTable.setRowSelectionInterval(this.userModificationsTable.rowAtPoint(evt.getPoint()), this.userModificationsTable.rowAtPoint(evt.getPoint()));
            this.editUserModification.setEnabled(true);
            this.deleteUserModification.setEnabled(true);
            this.userModsPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        } else if (evt.getClickCount() == 2 && this.userModificationsTable.getSelectedRow() != -1 && !(modificationDialog = new ModificationDialog(this, modification = this.modificationFactory.getModification(modificationName = (String)this.userModificationsTable.getValueAt(this.userModificationsTable.getSelectedRow(), this.userModificationsTable.getColumn("Name").getModelIndex())), true)).isCanceled()) {
            this.updateModifications();
        }
    }

    private void userModificationsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void userModificationsTableMouseReleased(MouseEvent evt) {
        this.editUserModification.setEnabled(this.userModificationsTable.getSelectedColumnCount() > 0);
        this.deleteUserModification.setEnabled(this.userModificationsTable.getSelectedColumnCount() > 0);
        int row = this.userModificationsTable.rowAtPoint(evt.getPoint());
        int column = this.userModificationsTable.columnAtPoint(evt.getPoint());
        if (!(row == -1 || column != this.defaultModificationsTable.getColumn("Unimod").getModelIndex() && column != this.defaultModificationsTable.getColumn("PSI-MOD").getModelIndex() || column != this.defaultModificationsTable.getColumn("Unimod").getModelIndex() && column != this.defaultModificationsTable.getColumn("PSI-MOD").getModelIndex() || evt.getButton() != 1 || ((String)this.userModificationsTable.getValueAt(row, column)).lastIndexOf("<a href=\"") == -1)) {
            String link = (String)this.userModificationsTable.getValueAt(row, column);
            link = link.substring(link.indexOf("\"") + 1);
            link = link.substring(0, link.indexOf("\""));
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL(link);
            this.setCursor(new Cursor(0));
        }
    }

    private void userModificationsTableMouseMoved(MouseEvent evt) {
        int row = this.userModificationsTable.rowAtPoint(evt.getPoint());
        int column = this.userModificationsTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if ((column == this.defaultModificationsTable.getColumn("Unimod").getModelIndex() || column == this.defaultModificationsTable.getColumn("PSI-MOD").getModelIndex()) && this.userModificationsTable.getValueAt(row, column) != null) {
                String tempValue = (String)this.userModificationsTable.getValueAt(row, column);
                if (tempValue.lastIndexOf("<a href=\"") != -1) {
                    this.setCursor(new Cursor(12));
                } else {
                    this.setCursor(new Cursor(0));
                }
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void deleteUserModificationActionPerformed(ActionEvent evt) {
        int row = this.userModificationsTable.getSelectedRow();
        String modificationName = (String)this.userModificationsTable.getValueAt(row, this.userModificationsTable.getColumn("Name").getModelIndex());
        int value = JOptionPane.showConfirmDialog(this, "Are you sure that you want to delete '" + modificationName + "'?", "Delete Modification?", 0);
        if (value == 0) {
            this.modificationFactory.removeUserPtm(modificationName);
            this.updateModifications();
        }
    }

    private void editUserModificationActionPerformed(ActionEvent evt) {
        int row = this.userModificationsTable.getSelectedRow();
        String modificationName = (String)this.userModificationsTable.getValueAt(row, this.userModificationsTable.getColumn("Name").getModelIndex());
        Modification modification = this.modificationFactory.getModification(modificationName);
        ModificationDialog modificationDialog = new ModificationDialog(this, modification, true);
        if (!modificationDialog.isCanceled()) {
            this.updateModifications();
        }
    }

    private void addUserModificationActionPerformed(ActionEvent evt) {
        if (this.modificationFactory.getUserModifications().size() < 30) {
            ModificationDialog modificationDialog = new ModificationDialog(this, null, true);
            if (!modificationDialog.isCanceled()) {
                this.updateModifications();
            }
        } else {
            JOptionPane.showMessageDialog(this, "In order to ensure compatibility with OMSSA, only 30 user modifications can be implemented. Please delete unused modifications.", "Too many modifications", 2);
        }
    }

    private void modificationsHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void modificationsHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void modificationsHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/ModificationEditor.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), "Modifications - Help", 500, 10);
        this.setCursor(new Cursor(0));
    }

    private void viewDefaultModsJMenuItemActionPerformed(ActionEvent evt) {
        String modificationName = (String)this.defaultModificationsTable.getValueAt(this.defaultModificationsTable.getSelectedRow(), this.defaultModificationsTable.getColumn("Name").getModelIndex());
        Modification modification = this.modificationFactory.getModification(modificationName);
        ModificationDialog modificationDialog = new ModificationDialog(this, modification, true);
        if (!modificationDialog.isCanceled()) {
            this.updateModifications();
        }
    }

    private void editUserPtmJMenuItemActionPerformed(ActionEvent evt) {
        String modificationName = (String)this.userModificationsTable.getValueAt(this.userModificationsTable.getSelectedRow(), this.userModificationsTable.getColumn("Name").getModelIndex());
        Modification modification = this.modificationFactory.getModification(modificationName);
        ModificationDialog modificationDialog = new ModificationDialog(this, modification, true);
        if (!modificationDialog.isCanceled()) {
            this.updateModifications();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        try {
            this.modificationFactory.saveFactory();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "An error occurred while saving the modification.", "Saving Error", 2);
        }
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.formWindowClosing(null);
    }

    private void exportDefaultModsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportDefaultModsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportDefaultModsLabelMouseReleased(MouseEvent evt) {
        File selectedFile = FileChooserUtil.getUserSelectedFile(this, ".txt", "Tab separated text file (.txt)", "Export...", "user.home", "default modifications.txt", false);
        if (selectedFile != null) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(selectedFile));
                Util.tableToFile(this.defaultModificationsTable, "\t", null, true, writer);
                writer.close();
                JOptionPane.showMessageDialog(this, "Data copied to file:\n" + selectedFile.getAbsolutePath(), "Data Exported.", 1);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "An error occurred when exporting the table content.", "Export Failed", 0);
                e.printStackTrace();
            }
        }
    }

    private void exportUserModsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportUserModsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportUserModsLabelMouseReleased(MouseEvent evt) {
        File selectedFile = FileChooserUtil.getUserSelectedFile(this, ".txt", "Tab separated text file (.txt)", "Export...", "user.home", "user modifications.txt", false);
        if (selectedFile != null) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(selectedFile));
                Util.tableToFile(this.userModificationsTable, "\t", null, true, writer);
                writer.close();
                JOptionPane.showMessageDialog(this, "Data copied to file:\n" + selectedFile.getAbsolutePath(), "Data Exported.", 1);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "An error occurred when exporting the table content.", "Export Failed", 0);
                e.printStackTrace();
            }
        }
    }

    private void defaultModificationsTableMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.defaultModificationsTable.setRowSelectionInterval(this.defaultModificationsTable.rowAtPoint(evt.getPoint()), this.defaultModificationsTable.rowAtPoint(evt.getPoint()));
            this.defaultModsPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        } else if (evt.getClickCount() == 2 && this.defaultModificationsTable.getSelectedRow() != -1) {
            String modificationName = (String)this.defaultModificationsTable.getValueAt(this.defaultModificationsTable.getSelectedRow(), this.defaultModificationsTable.getColumn("Name").getModelIndex());
            Modification modification = this.modificationFactory.getModification(modificationName);
            new ModificationDialog(this, modification, false);
        }
    }

    public String getOlsAccessionLink(String modAccession) {
        String modAccessionInLink = modAccession.replaceAll(":", "_");
        String accessionNumberWithLink = "<html><a href=\"https://www.ebi.ac.uk/ols/ontologies/mod/terms?iri=http%3A%2F%2Fpurl.obolibrary.org%2Fobo%2F" + modAccessionInLink + "\"\"><font color=\"" + "#FFFFFF" + "\">" + modAccession + "</font></a></html>";
        return accessionNumberWithLink;
    }

    public String getUniModAccessionLink(String unimodAccession) {
        String accessionNumber = unimodAccession.substring("Unimod:".length());
        String accessionNumberWithLink = "<html><a href=\"http://www.unimod.org/modifications_view.php?editid1=" + accessionNumber + "\"\"><font color=\"" + "#FFFFFF" + "\">" + unimodAccession + "</font></a></html>";
        return accessionNumberWithLink;
    }

    public void updateModifications() {
        DefaultTableModel dm = (DefaultTableModel)this.defaultModificationsTable.getModel();
        dm.fireTableDataChanged();
        dm = (DefaultTableModel)this.userModificationsTable.getModel();
        dm.fireTableDataChanged();
        this.editUserModification.setEnabled(this.userModificationsTable.getSelectedColumnCount() > 0);
        this.deleteUserModification.setEnabled(this.userModificationsTable.getSelectedColumnCount() > 0);
        this.updateMassSparklines();
        ((TitledBorder)this.userModsPanel.getBorder()).setTitle("User Modifications (" + this.userModificationsTable.getRowCount() + ")");
        this.userModsPanel.revalidate();
        this.userModsPanel.repaint();
    }

    public void updateModSelection() {
        int row = this.defaultModificationsTable.convertRowIndexToView(this.searchPossibilities.get(this.searchCurrentSelection));
        this.defaultModificationsTable.setRowSelectionInterval(row, row);
        this.searchIndexLabel.setText("(" + (this.searchCurrentSelection + 1) + " of " + this.searchPossibilities.size() + ")");
        this.defaultModificationsTable.scrollRectToVisible(this.defaultModificationsTable.getCellRect(row, 0, false));
    }

    private class UserModificationTable
    extends DefaultTableModel {
        private UserModificationTable() {
        }

        @Override
        public int getRowCount() {
            return ModificationsDialog.this.modificationFactory.getUserModifications().size();
        }

        @Override
        public int getColumnCount() {
            return 9;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Short";
                }
                case 3: {
                    return "Mass";
                }
                case 4: {
                    return "Type";
                }
                case 5: {
                    return "Residues";
                }
                case 6: {
                    return "Category";
                }
                case 7: {
                    return "Unimod";
                }
                case 8: {
                    return "PSI-MOD";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            String name = ModificationsDialog.this.modificationFactory.getUserModificationsOrdered().get(row);
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return name;
                }
                case 2: {
                    return ModificationsDialog.this.modificationFactory.getModification(name).getShortName();
                }
                case 3: {
                    return ModificationsDialog.this.modificationFactory.getModification(name).getMass();
                }
                case 4: {
                    ModificationType modificationType = ModificationsDialog.this.modificationFactory.getModification(name).getModificationType();
                    if (modificationType != null) {
                        return modificationType.index;
                    }
                    return null;
                }
                case 5: {
                    String residues = "";
                    AminoAcidPattern aminoAcidPattern = ModificationsDialog.this.modificationFactory.getModification(name).getPattern();
                    if (aminoAcidPattern != null) {
                        for (Character residue : aminoAcidPattern.getAminoAcidsAtTarget()) {
                            if (!residues.equals("")) {
                                residues = residues + ", ";
                            }
                            residues = residues + residue;
                        }
                    }
                    return residues;
                }
                case 6: {
                    return ModificationsDialog.this.modificationFactory.getModification(name).getCategory();
                }
                case 7: {
                    CvTerm cvTerm = ModificationsDialog.this.modificationFactory.getModification(name).getUnimodCvTerm();
                    if (cvTerm != null) {
                        return ModificationsDialog.this.getUniModAccessionLink(cvTerm.getAccession());
                    }
                    return null;
                }
                case 8: {
                    CvTerm cvTerm = ModificationsDialog.this.modificationFactory.getModification(name).getPsiModCvTerm();
                    if (cvTerm != null) {
                        return ModificationsDialog.this.getOlsAccessionLink(cvTerm.getAccession());
                    }
                    return null;
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return Double.valueOf(0.0).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    private class DefaultModificationTable
    extends DefaultTableModel {
        private DefaultModificationTable() {
        }

        @Override
        public int getRowCount() {
            return ModificationsDialog.this.modificationFactory.getDefaultModifications().size();
        }

        @Override
        public int getColumnCount() {
            return 9;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Short";
                }
                case 3: {
                    return "Mass";
                }
                case 4: {
                    return "Type";
                }
                case 5: {
                    return "Residues";
                }
                case 6: {
                    return "Category";
                }
                case 7: {
                    return "Unimod";
                }
                case 8: {
                    return "PSI-MOD";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            String name = ModificationsDialog.this.modificationFactory.getDefaultModificationsOrdered().get(row);
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return name;
                }
                case 2: {
                    return ModificationsDialog.this.modificationFactory.getModification(name).getShortName();
                }
                case 3: {
                    return ModificationsDialog.this.modificationFactory.getModification(name).getMass();
                }
                case 4: {
                    ModificationType modificationType = ModificationsDialog.this.modificationFactory.getModification(name).getModificationType();
                    if (modificationType != null) {
                        return modificationType.index;
                    }
                    return null;
                }
                case 5: {
                    String residues = "";
                    AminoAcidPattern aminoAcidPattern = ModificationsDialog.this.modificationFactory.getModification(name).getPattern();
                    if (aminoAcidPattern != null) {
                        for (Character residue : aminoAcidPattern.getAminoAcidsAtTarget()) {
                            if (!residues.equals("")) {
                                residues = residues + ", ";
                            }
                            residues = residues + residue;
                        }
                    }
                    return residues;
                }
                case 6: {
                    return ModificationsDialog.this.modificationFactory.getModification(name).getCategory();
                }
                case 7: {
                    CvTerm cvTerm = ModificationsDialog.this.modificationFactory.getModification(name).getUnimodCvTerm();
                    if (cvTerm != null) {
                        return ModificationsDialog.this.getUniModAccessionLink(cvTerm.getAccession());
                    }
                    return null;
                }
                case 8: {
                    CvTerm cvTerm = ModificationsDialog.this.modificationFactory.getModification(name).getPsiModCvTerm();
                    if (cvTerm != null) {
                        return ModificationsDialog.this.getOlsAccessionLink(cvTerm.getAccession());
                    }
                    return null;
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return Double.valueOf(0.0).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

