/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.advanced;

import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.identification.advanced.GeneParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class BackgroundSpeciesDialog
extends JDialog {
    private Frame parentFrame;
    private boolean canceled = false;
    private GeneParameters genePreferences;
    private FastaSummary fastaSummary;
    private SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
    private HashMap<String, Integer> speciesMap;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JButton helpJButton;
    private JPanel mappingPanel;
    private JButton okButton;
    private JComboBox speciesCmb;
    private JLabel speciesLabel;

    public BackgroundSpeciesDialog() {
    }

    public BackgroundSpeciesDialog(JFrame parentFrame, GeneParameters genePreferences, FastaSummary fastaSummary) {
        super((Frame)parentFrame, true);
        this.parentFrame = parentFrame;
        this.genePreferences = genePreferences;
        this.fastaSummary = fastaSummary;
        this.initComponents();
        this.setUpGui();
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public BackgroundSpeciesDialog(JDialog owner, Frame parentFrame, GeneParameters genePreferences, FastaSummary fastaSummary) {
        super((Dialog)owner, true);
        this.parentFrame = parentFrame;
        this.genePreferences = genePreferences;
        this.fastaSummary = fastaSummary;
        this.initComponents();
        this.setUpGui();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.speciesCmb.setRenderer(new AlignedListCellRenderer(0));
        Vector<String> availableSpecies = new Vector<String>();
        this.speciesMap = new HashMap();
        int selectedIndex = 0;
        try {
            TreeMap<String, Integer> speciesOccurrence = this.fastaSummary.speciesOccurrence;
            for (Map.Entry<String, Integer> entry : speciesOccurrence.entrySet()) {
                Integer occurrence;
                String uniprotTaxonomy = entry.getKey();
                if (uniprotTaxonomy.equals("Unknown") || (occurrence = entry.getValue()) == null) continue;
                try {
                    Integer taxon = this.speciesFactory.getUniprotTaxonomy().getId(uniprotTaxonomy, true);
                    if (taxon == null) continue;
                    if (this.genePreferences.getBackgroundSpecies() != null && this.genePreferences.getBackgroundSpecies().intValue() == taxon.intValue()) {
                        selectedIndex = availableSpecies.size();
                    }
                    String tempSpecies = this.speciesFactory.getName(taxon) + " (" + occurrence + ")";
                    availableSpecies.add(tempSpecies);
                    this.speciesMap.put(tempSpecies, taxon);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.speciesCmb.setModel(new DefaultComboBoxModel(availableSpecies));
        if (!availableSpecies.isEmpty()) {
            this.speciesCmb.setSelectedIndex(selectedIndex);
        }
    }

    public GeneParameters getGeneParameters() {
        return this.genePreferences;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.mappingPanel = new JPanel();
        this.speciesLabel = new JLabel();
        this.speciesCmb = new JComboBox();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.helpJButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Gene Annotation");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                BackgroundSpeciesDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.mappingPanel.setBorder(BorderFactory.createTitledBorder("Background Species"));
        this.mappingPanel.setOpaque(false);
        this.speciesLabel.setText("Species");
        GroupLayout mappingPanelLayout = new GroupLayout(this.mappingPanel);
        this.mappingPanel.setLayout(mappingPanelLayout);
        mappingPanelLayout.setHorizontalGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mappingPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.speciesLabel).addGap(18, 18, 18).addComponent(this.speciesCmb, -2, 358, -2).addContainerGap()));
        mappingPanelLayout.setVerticalGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mappingPanelLayout.createSequentialGroup().addContainerGap().addGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.speciesLabel).addComponent(this.speciesCmb, -2, -1, -2)).addContainerGap()));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackgroundSpeciesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackgroundSpeciesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.setFocusable(false);
        this.helpJButton.setHorizontalTextPosition(0);
        this.helpJButton.setVerticalTextPosition(3);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                BackgroundSpeciesDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                BackgroundSpeciesDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackgroundSpeciesDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.mappingPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.mappingPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.okButton).addComponent(this.cancelButton).addComponent(this.helpJButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.speciesCmb.getSelectedIndex() != -1) {
            this.genePreferences.setBackgroundSpecies(this.speciesMap.get((String)this.speciesCmb.getSelectedItem()));
        }
        this.dispose();
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.okButtonActionPerformed(null);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelButtonActionPerformed(null);
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.parentFrame, this.getClass().getResource("/helpFiles/GeneAnnotationPreferences.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Gene Annotation - Help");
        this.setCursor(new Cursor(0));
    }
}

