/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.advanced;

import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.identification.advanced.GeneParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class GeneParametersDialog
extends JDialog {
    private Frame parentFrame;
    private boolean canceled = false;
    private boolean editable;
    private GeneParameters genePreferences;
    private JComboBox autoUpdateCmb;
    private JLabel autoUpdateLabel;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JButton helpJButton;
    private JPanel mappingPanel;
    private JButton okButton;
    private JComboBox useMappingCmb;
    private JLabel useMappingLabel;

    public GeneParametersDialog() {
    }

    public GeneParametersDialog(JFrame parentFrame, GeneParameters genePreferences, SearchParameters searchParameters, boolean editable) {
        super((Frame)parentFrame, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.genePreferences = genePreferences;
        this.initComponents();
        this.setUpGui();
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public GeneParametersDialog(JDialog owner, Frame parentFrame, GeneParameters genePreferences, SearchParameters searchParameters, boolean editable) {
        super((Dialog)owner, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.genePreferences = genePreferences;
        this.initComponents();
        this.setUpGui();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.useMappingCmb.setRenderer(new AlignedListCellRenderer(0));
        this.autoUpdateCmb.setRenderer(new AlignedListCellRenderer(0));
        this.useMappingCmb.setEnabled(this.editable);
        this.autoUpdateCmb.setEnabled(this.editable);
        if (this.genePreferences.getUseGeneMapping().booleanValue()) {
            this.useMappingCmb.setSelectedIndex(0);
        } else {
            this.useMappingCmb.setSelectedIndex(1);
        }
        if (this.genePreferences.getAutoUpdate().booleanValue()) {
            this.autoUpdateCmb.setSelectedIndex(0);
        } else {
            this.autoUpdateCmb.setSelectedIndex(1);
        }
    }

    public GeneParameters getGeneParameters() {
        this.genePreferences.setUseGeneMapping(this.useMappingCmb.getSelectedIndex() == 0);
        this.genePreferences.setAutoUpdate(this.autoUpdateCmb.getSelectedIndex() == 0);
        return this.genePreferences;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.mappingPanel = new JPanel();
        this.useMappingLabel = new JLabel();
        this.useMappingCmb = new JComboBox();
        this.autoUpdateLabel = new JLabel();
        this.autoUpdateCmb = new JComboBox();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.helpJButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Gene Annotation");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GeneParametersDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.mappingPanel.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.mappingPanel.setOpaque(false);
        this.useMappingLabel.setText("Use Mapping");
        this.useMappingCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.autoUpdateLabel.setText("Auto Update");
        this.autoUpdateCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        GroupLayout mappingPanelLayout = new GroupLayout(this.mappingPanel);
        this.mappingPanel.setLayout(mappingPanelLayout);
        mappingPanelLayout.setHorizontalGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mappingPanelLayout.createSequentialGroup().addContainerGap().addGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useMappingLabel).addComponent(this.autoUpdateLabel)).addGap(18, 18, 18).addGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useMappingCmb, 0, 364, Short.MAX_VALUE).addComponent(this.autoUpdateCmb, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        mappingPanelLayout.setVerticalGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mappingPanelLayout.createSequentialGroup().addContainerGap().addGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.useMappingLabel).addComponent(this.useMappingCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoUpdateLabel).addComponent(this.autoUpdateCmb, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.setFocusable(false);
        this.helpJButton.setHorizontalTextPosition(0);
        this.helpJButton.setVerticalTextPosition(3);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                GeneParametersDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                GeneParametersDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneParametersDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.mappingPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.mappingPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.okButton).addComponent(this.cancelButton).addComponent(this.helpJButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.okButtonActionPerformed(null);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelButtonActionPerformed(null);
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.parentFrame, this.getClass().getResource("/helpFiles/GeneAnnotationPreferences.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Gene Annotation - Help");
        this.setCursor(new Cursor(0));
    }
}

