/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.algorithm;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.parameters.identification.AlgorithmParametersDialog;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.identification.tool_specific.DirecTagParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class DirecTagParametersDialog
extends JDialog
implements AlgorithmParametersDialog {
    private boolean canceled = false;
    private boolean editable;
    private JComboBox adjustPrecursorMassCmb;
    private JLabel adjustPrecursorMassLabel;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JLabel complementScoreWeightLabel;
    private JTextField complementScoreWeightTextField;
    private JLabel complementToleranceLabel;
    private JTextField complementToleranceTextField;
    private JLabel deisotopingModeLabel;
    private JTextField deisptopingModeTextField;
    private JPanel directTagPanel;
    private JLabel duplicateSpectraLabel;
    private JComboBox duplicateSpectraPerChargeCmb;
    private JLabel intensityScoreWeightLabel;
    private JTextField intensityScoreWeightTextField;
    private JLabel isotopeToleranceLabel;
    private JTextField isotopeToleranceTextField;
    private JLabel maxPeakCountLabel;
    private JTextField maxPeakCountTextField;
    private JLabel maxPrecursorAdjustmentLabel;
    private JTextField maxPrecursorAdjustmentTextField;
    private JLabel maxTagCountLabel;
    private JSpinner maxTagCountSpinner;
    private JLabel minPrecursorAdjustmentLabel;
    private JTextField minPrecursorAdjustmentTextField;
    private JLabel mzFidelityScoreWeightLabel;
    private JTextField mzFidelityScoreWeightTextField;
    private JLabel numVariableModsLabel;
    private JTextField numVariableModsTextField;
    private JLabel numberOfChargeStatesLabel;
    private JTextField numberOfChargeStatesTextField;
    private JLabel numberOfIntensityClassesLabel;
    private JTextField numberOfIntensityClassesTextField;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JLabel outputSuffixLabel;
    private JTextField outputSuffixTextField;
    private JLabel precursorAdjustmentStepLabel;
    private JTextField precursorAdjustmentStepTextField;
    private JLabel tagLengthLabel;
    private JTextField tagLengthTextField;
    private JLabel ticCutoffLabel;
    private JTextField ticCutoffTextField;
    private JComboBox useSpectrumChargeStateCmb;
    private JLabel useSpectrumChargeStateLabel;

    public DirecTagParametersDialog() {
    }

    public DirecTagParametersDialog(Frame parent, DirecTagParameters direcTagParameters, boolean editable) {
        super(parent, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(direcTagParameters);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public DirecTagParametersDialog(Dialog owner, Frame parent, DirecTagParameters direcTagParameters, boolean editable) {
        super(owner, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(direcTagParameters);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.duplicateSpectraPerChargeCmb.setRenderer(new AlignedListCellRenderer(0));
        this.adjustPrecursorMassCmb.setRenderer(new AlignedListCellRenderer(0));
        this.useSpectrumChargeStateCmb.setRenderer(new AlignedListCellRenderer(0));
        this.tagLengthTextField.setEditable(this.editable);
        this.tagLengthTextField.setEnabled(this.editable);
        this.numVariableModsTextField.setEditable(this.editable);
        this.numVariableModsTextField.setEnabled(this.editable);
        this.numberOfChargeStatesTextField.setEditable(this.editable);
        this.numberOfChargeStatesTextField.setEnabled(this.editable);
        this.duplicateSpectraPerChargeCmb.setEnabled(this.editable);
        this.isotopeToleranceTextField.setEditable(this.editable);
        this.isotopeToleranceTextField.setEnabled(this.editable);
        this.deisptopingModeTextField.setEditable(this.editable);
        this.deisptopingModeTextField.setEnabled(this.editable);
        this.numberOfIntensityClassesTextField.setEditable(this.editable);
        this.numberOfIntensityClassesTextField.setEnabled(this.editable);
        this.outputSuffixTextField.setEditable(this.editable);
        this.outputSuffixTextField.setEnabled(this.editable);
        this.ticCutoffTextField.setEditable(this.editable);
        this.ticCutoffTextField.setEnabled(this.editable);
        this.complementToleranceTextField.setEditable(this.editable);
        this.complementToleranceTextField.setEnabled(this.editable);
        this.precursorAdjustmentStepTextField.setEditable(this.editable);
        this.precursorAdjustmentStepTextField.setEnabled(this.editable);
        this.minPrecursorAdjustmentTextField.setEditable(this.editable);
        this.minPrecursorAdjustmentTextField.setEnabled(this.editable);
        this.maxPrecursorAdjustmentTextField.setEditable(this.editable);
        this.maxPrecursorAdjustmentTextField.setEnabled(this.editable);
        this.intensityScoreWeightTextField.setEditable(this.editable);
        this.intensityScoreWeightTextField.setEnabled(this.editable);
        this.mzFidelityScoreWeightTextField.setEditable(this.editable);
        this.mzFidelityScoreWeightTextField.setEnabled(this.editable);
        this.complementScoreWeightTextField.setEditable(this.editable);
        this.complementScoreWeightTextField.setEnabled(this.editable);
    }

    private void populateGUI(DirecTagParameters direcTagParameters) {
        this.tagLengthTextField.setText(String.valueOf(direcTagParameters.getTagLength()));
        this.numVariableModsTextField.setText(String.valueOf(direcTagParameters.getMaxDynamicMods()));
        this.numberOfChargeStatesTextField.setText(String.valueOf(direcTagParameters.getNumChargeStates()));
        if (direcTagParameters.isDuplicateSpectra()) {
            this.duplicateSpectraPerChargeCmb.setSelectedIndex(0);
        } else {
            this.duplicateSpectraPerChargeCmb.setSelectedIndex(1);
        }
        this.deisptopingModeTextField.setText(String.valueOf(direcTagParameters.getDeisotopingMode()));
        this.isotopeToleranceTextField.setText(String.valueOf(direcTagParameters.getIsotopeMzTolerance()));
        this.numberOfIntensityClassesTextField.setText(String.valueOf(direcTagParameters.getNumIntensityClasses()));
        this.outputSuffixTextField.setText(String.valueOf(direcTagParameters.getOutputSuffix()));
        this.maxPeakCountTextField.setText(String.valueOf(direcTagParameters.getMaxPeakCount()));
        this.ticCutoffTextField.setText(String.valueOf(direcTagParameters.getTicCutoffPercentage()));
        this.complementToleranceTextField.setText(String.valueOf(direcTagParameters.getComplementMzTolerance()));
        this.precursorAdjustmentStepTextField.setText(String.valueOf(direcTagParameters.getPrecursorAdjustmentStep()));
        this.minPrecursorAdjustmentTextField.setText(String.valueOf(direcTagParameters.getMinPrecursorAdjustment()));
        this.maxPrecursorAdjustmentTextField.setText(String.valueOf(direcTagParameters.getMaxPrecursorAdjustment()));
        this.intensityScoreWeightTextField.setText(String.valueOf(direcTagParameters.getIntensityScoreWeight()));
        this.mzFidelityScoreWeightTextField.setText(String.valueOf(direcTagParameters.getMzFidelityScoreWeight()));
        this.complementScoreWeightTextField.setText(String.valueOf(direcTagParameters.getComplementScoreWeight()));
        this.maxTagCountSpinner.setValue(direcTagParameters.getMaxTagCount());
        if (direcTagParameters.isAdjustPrecursorMass()) {
            this.adjustPrecursorMassCmb.setSelectedIndex(0);
        } else {
            this.adjustPrecursorMassCmb.setSelectedIndex(1);
        }
        if (direcTagParameters.isUseChargeStateFromMS()) {
            this.useSpectrumChargeStateCmb.setSelectedIndex(0);
        } else {
            this.useSpectrumChargeStateCmb.setSelectedIndex(1);
        }
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.okButton = new JButton();
        this.directTagPanel = new JPanel();
        this.numberOfChargeStatesLabel = new JLabel();
        this.duplicateSpectraLabel = new JLabel();
        this.deisotopingModeLabel = new JLabel();
        this.isotopeToleranceLabel = new JLabel();
        this.complementToleranceLabel = new JLabel();
        this.tagLengthLabel = new JLabel();
        this.numVariableModsLabel = new JLabel();
        this.intensityScoreWeightLabel = new JLabel();
        this.mzFidelityScoreWeightLabel = new JLabel();
        this.complementScoreWeightLabel = new JLabel();
        this.numberOfChargeStatesTextField = new JTextField();
        this.ticCutoffLabel = new JLabel();
        this.maxPeakCountTextField = new JTextField();
        this.maxPeakCountLabel = new JLabel();
        this.numberOfIntensityClassesTextField = new JTextField();
        this.numberOfIntensityClassesLabel = new JLabel();
        this.minPrecursorAdjustmentLabel = new JLabel();
        this.minPrecursorAdjustmentTextField = new JTextField();
        this.maxPrecursorAdjustmentLabel = new JLabel();
        this.maxPrecursorAdjustmentTextField = new JTextField();
        this.precursorAdjustmentStepLabel = new JLabel();
        this.precursorAdjustmentStepTextField = new JTextField();
        this.outputSuffixLabel = new JLabel();
        this.outputSuffixTextField = new JTextField();
        this.duplicateSpectraPerChargeCmb = new JComboBox();
        this.deisptopingModeTextField = new JTextField();
        this.isotopeToleranceTextField = new JTextField();
        this.complementToleranceTextField = new JTextField();
        this.tagLengthTextField = new JTextField();
        this.numVariableModsTextField = new JTextField();
        this.intensityScoreWeightTextField = new JTextField();
        this.mzFidelityScoreWeightTextField = new JTextField();
        this.complementScoreWeightTextField = new JTextField();
        this.ticCutoffTextField = new JTextField();
        this.maxTagCountLabel = new JLabel();
        this.maxTagCountSpinner = new JSpinner();
        this.adjustPrecursorMassLabel = new JLabel();
        this.adjustPrecursorMassCmb = new JComboBox();
        this.useSpectrumChargeStateLabel = new JLabel();
        this.useSpectrumChargeStateCmb = new JComboBox();
        this.cancelButton = new JButton();
        this.openDialogHelpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("DirecTag Advanced Settings");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DirecTagParametersDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirecTagParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.directTagPanel.setBorder(BorderFactory.createTitledBorder("DirecTag Settings"));
        this.directTagPanel.setOpaque(false);
        this.numberOfChargeStatesLabel.setText("Number of Charge States");
        this.duplicateSpectraLabel.setText("Duplicate Spectra per Charge");
        this.deisotopingModeLabel.setText("Deisptoping Mode");
        this.isotopeToleranceLabel.setText("Isotope MZ Tolerance (Da)");
        this.complementToleranceLabel.setText("Complement MZ Tolerance (Da)");
        this.tagLengthLabel.setText("Tag Length");
        this.numVariableModsLabel.setText("Max Number of Variable PTMs");
        this.intensityScoreWeightLabel.setText("Intensity Score Weight");
        this.mzFidelityScoreWeightLabel.setText("MZ Fidelity Score Weight");
        this.complementScoreWeightLabel.setText("Complement Score Weight");
        this.numberOfChargeStatesTextField.setHorizontalAlignment(0);
        this.numberOfChargeStatesTextField.setText("3");
        this.numberOfChargeStatesTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DirecTagParametersDialog.this.numberOfChargeStatesTextFieldKeyPressed(evt);
            }
        });
        this.ticCutoffLabel.setText("TIC Cutoff Percentage");
        this.maxPeakCountTextField.setHorizontalAlignment(0);
        this.maxPeakCountTextField.setText("400");
        this.maxPeakCountTextField.setEnabled(false);
        this.maxPeakCountTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DirecTagParametersDialog.this.maxPeakCountTextFieldKeyReleased(evt);
            }
        });
        this.maxPeakCountLabel.setText("Max Peak Count");
        this.numberOfIntensityClassesTextField.setHorizontalAlignment(0);
        this.numberOfIntensityClassesTextField.setText("3");
        this.numberOfIntensityClassesTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DirecTagParametersDialog.this.numberOfIntensityClassesTextFieldKeyReleased(evt);
            }
        });
        this.numberOfIntensityClassesLabel.setText("Number of Intensity Classes");
        this.minPrecursorAdjustmentLabel.setText("Min Precursor Adjustment");
        this.minPrecursorAdjustmentTextField.setHorizontalAlignment(0);
        this.minPrecursorAdjustmentTextField.setText("-2.5");
        this.minPrecursorAdjustmentTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DirecTagParametersDialog.this.minPrecursorAdjustmentTextFieldKeyReleased(evt);
            }
        });
        this.maxPrecursorAdjustmentLabel.setText("Max Precursor Adjustment");
        this.maxPrecursorAdjustmentTextField.setHorizontalAlignment(0);
        this.maxPrecursorAdjustmentTextField.setText("2.5");
        this.maxPrecursorAdjustmentTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DirecTagParametersDialog.this.maxPrecursorAdjustmentTextFieldKeyReleased(evt);
            }
        });
        this.precursorAdjustmentStepLabel.setText("Precursor Adjustment Step");
        this.precursorAdjustmentStepTextField.setHorizontalAlignment(0);
        this.precursorAdjustmentStepTextField.setText("0.1");
        this.precursorAdjustmentStepTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DirecTagParametersDialog.this.precursorAdjustmentStepTextFieldKeyReleased(evt);
            }
        });
        this.outputSuffixLabel.setText("Output Suffix");
        this.outputSuffixTextField.setHorizontalAlignment(0);
        this.outputSuffixTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DirecTagParametersDialog.this.outputSuffixTextFieldKeyReleased(evt);
            }
        });
        this.duplicateSpectraPerChargeCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.deisptopingModeTextField.setHorizontalAlignment(0);
        this.deisptopingModeTextField.setText("0");
        this.deisptopingModeTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DirecTagParametersDialog.this.deisptopingModeTextFieldKeyReleased(evt);
            }
        });
        this.isotopeToleranceTextField.setHorizontalAlignment(0);
        this.isotopeToleranceTextField.setText("0.25");
        this.isotopeToleranceTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DirecTagParametersDialog.this.isotopeToleranceTextFieldKeyReleased(evt);
            }
        });
        this.complementToleranceTextField.setHorizontalAlignment(0);
        this.complementToleranceTextField.setText("0.5");
        this.complementToleranceTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DirecTagParametersDialog.this.complementToleranceTextFieldKeyReleased(evt);
            }
        });
        this.tagLengthTextField.setHorizontalAlignment(0);
        this.tagLengthTextField.setText("3");
        this.tagLengthTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DirecTagParametersDialog.this.tagLengthTextFieldKeyReleased(evt);
            }
        });
        this.numVariableModsTextField.setHorizontalAlignment(0);
        this.numVariableModsTextField.setText("2");
        this.numVariableModsTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DirecTagParametersDialog.this.numVariableModsTextFieldKeyReleased(evt);
            }
        });
        this.intensityScoreWeightTextField.setHorizontalAlignment(0);
        this.intensityScoreWeightTextField.setText("1");
        this.intensityScoreWeightTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DirecTagParametersDialog.this.intensityScoreWeightTextFieldKeyReleased(evt);
            }
        });
        this.mzFidelityScoreWeightTextField.setHorizontalAlignment(0);
        this.mzFidelityScoreWeightTextField.setText("1");
        this.mzFidelityScoreWeightTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DirecTagParametersDialog.this.mzFidelityScoreWeightTextFieldKeyReleased(evt);
            }
        });
        this.complementScoreWeightTextField.setHorizontalAlignment(0);
        this.complementScoreWeightTextField.setText("1");
        this.complementScoreWeightTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DirecTagParametersDialog.this.complementScoreWeightTextFieldKeyReleased(evt);
            }
        });
        this.ticCutoffTextField.setHorizontalAlignment(0);
        this.ticCutoffTextField.setText("85");
        this.ticCutoffTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DirecTagParametersDialog.this.ticCutoffTextFieldKeyReleased(evt);
            }
        });
        this.maxTagCountLabel.setText("Max Tag Count");
        this.maxTagCountSpinner.setModel(new SpinnerNumberModel(10, 1, 2000, 1));
        this.adjustPrecursorMassLabel.setText("Adjust Precursor Mass");
        this.adjustPrecursorMassCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.adjustPrecursorMassCmb.setEnabled(false);
        this.useSpectrumChargeStateLabel.setText("Use Spectrum Charge State");
        this.useSpectrumChargeStateCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        GroupLayout directTagPanelLayout = new GroupLayout(this.directTagPanel);
        this.directTagPanel.setLayout(directTagPanelLayout);
        directTagPanelLayout.setHorizontalGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(directTagPanelLayout.createSequentialGroup().addContainerGap().addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(directTagPanelLayout.createSequentialGroup().addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(directTagPanelLayout.createSequentialGroup().addGap(198, 198, 198).addComponent(this.tagLengthTextField, -2, 130, -2)).addComponent(this.tagLengthLabel, -2, 180, -2).addGroup(directTagPanelLayout.createSequentialGroup().addComponent(this.numVariableModsLabel, -2, 180, -2).addGap(18, 18, 18).addComponent(this.numVariableModsTextField, -2, 130, -2)).addGroup(directTagPanelLayout.createSequentialGroup().addComponent(this.numberOfChargeStatesLabel, -2, 180, -2).addGap(18, 18, 18).addComponent(this.numberOfChargeStatesTextField, -2, 130, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(directTagPanelLayout.createSequentialGroup().addComponent(this.ticCutoffLabel, -2, 180, -2).addGap(18, 18, 18).addComponent(this.ticCutoffTextField, -2, 130, -2)).addGroup(GroupLayout.Alignment.LEADING, directTagPanelLayout.createSequentialGroup().addComponent(this.precursorAdjustmentStepLabel, -2, 180, -2).addGap(18, 18, 18).addComponent(this.precursorAdjustmentStepTextField, -2, 130, -2)).addGroup(directTagPanelLayout.createSequentialGroup().addComponent(this.complementToleranceLabel, -2, 180, -2).addGap(18, 18, 18).addComponent(this.complementToleranceTextField, -2, 130, -2)))).addGroup(directTagPanelLayout.createSequentialGroup().addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, directTagPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.duplicateSpectraLabel, -2, 180, -2).addGap(18, 18, 18).addComponent(this.duplicateSpectraPerChargeCmb, -2, 130, -2).addGap(52, 52, 52)).addGroup(directTagPanelLayout.createSequentialGroup().addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(directTagPanelLayout.createSequentialGroup().addComponent(this.isotopeToleranceLabel, -2, 180, -2).addGap(18, 18, 18).addComponent(this.isotopeToleranceTextField, -2, 130, -2)).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, directTagPanelLayout.createSequentialGroup().addComponent(this.numberOfIntensityClassesLabel, -2, 180, -2).addGap(18, 18, 18).addComponent(this.numberOfIntensityClassesTextField, -2, 130, -2)).addGroup(GroupLayout.Alignment.TRAILING, directTagPanelLayout.createSequentialGroup().addComponent(this.outputSuffixLabel, -2, 180, -2).addGap(18, 18, 18).addComponent(this.outputSuffixTextField, -2, 130, -2)).addGroup(GroupLayout.Alignment.TRAILING, directTagPanelLayout.createSequentialGroup().addComponent(this.deisotopingModeLabel, -2, 180, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.deisptopingModeTextField, -2, 130, -2))).addGroup(directTagPanelLayout.createSequentialGroup().addComponent(this.maxPeakCountLabel, -2, 180, -2).addGap(18, 18, 18).addComponent(this.maxPeakCountTextField, -2, 130, -2)).addGroup(directTagPanelLayout.createSequentialGroup().addComponent(this.maxTagCountLabel, -2, 180, -2).addGap(18, 18, 18).addComponent(this.maxTagCountSpinner, -2, 130, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE))).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(directTagPanelLayout.createSequentialGroup().addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minPrecursorAdjustmentLabel, -2, 180, -2).addComponent(this.maxPrecursorAdjustmentLabel, -2, 180, -2)).addGap(18, 18, 18).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minPrecursorAdjustmentTextField, -2, 130, -2).addComponent(this.maxPrecursorAdjustmentTextField, -2, 130, -2))).addGroup(GroupLayout.Alignment.TRAILING, directTagPanelLayout.createSequentialGroup().addComponent(this.complementScoreWeightLabel, -2, 180, -2).addGap(18, 18, 18).addComponent(this.complementScoreWeightTextField, -2, 130, -2)).addGroup(GroupLayout.Alignment.TRAILING, directTagPanelLayout.createSequentialGroup().addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.mzFidelityScoreWeightLabel, -2, 180, -2).addComponent(this.intensityScoreWeightLabel, -2, 180, -2)).addGap(18, 18, 18).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.intensityScoreWeightTextField, -2, 130, -2).addComponent(this.mzFidelityScoreWeightTextField, -2, 130, -2))).addGroup(GroupLayout.Alignment.TRAILING, directTagPanelLayout.createSequentialGroup().addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.adjustPrecursorMassLabel, -2, 180, -2).addComponent(this.useSpectrumChargeStateLabel, -2, 180, -2)).addGap(18, 18, 18).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useSpectrumChargeStateCmb, -2, 130, -2).addComponent(this.adjustPrecursorMassCmb, -2, 130, -2)))))).addContainerGap(-1, Short.MAX_VALUE)));
        directTagPanelLayout.setVerticalGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(directTagPanelLayout.createSequentialGroup().addContainerGap().addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(directTagPanelLayout.createSequentialGroup().addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ticCutoffTextField, -2, -1, -2).addComponent(this.ticCutoffLabel)).addGap(6, 6, 6).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.complementToleranceLabel).addComponent(this.complementToleranceTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.precursorAdjustmentStepLabel).addComponent(this.precursorAdjustmentStepTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPrecursorAdjustmentLabel).addComponent(this.minPrecursorAdjustmentTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxPrecursorAdjustmentLabel).addComponent(this.maxPrecursorAdjustmentTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.intensityScoreWeightLabel).addComponent(this.intensityScoreWeightTextField, -2, -1, -2))).addGroup(directTagPanelLayout.createSequentialGroup().addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tagLengthLabel).addComponent(this.tagLengthTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numVariableModsLabel).addComponent(this.numVariableModsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numberOfChargeStatesLabel).addComponent(this.numberOfChargeStatesTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.duplicateSpectraLabel).addComponent(this.duplicateSpectraPerChargeCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.isotopeToleranceTextField, -2, -1, -2).addComponent(this.isotopeToleranceLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deisptopingModeTextField, -2, -1, -2).addComponent(this.deisotopingModeLabel)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(directTagPanelLayout.createSequentialGroup().addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numberOfIntensityClassesTextField, -2, -1, -2).addComponent(this.numberOfIntensityClassesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputSuffixLabel).addComponent(this.outputSuffixTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxPeakCountLabel).addComponent(this.maxPeakCountTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxTagCountSpinner, -2, -1, -2).addComponent(this.maxTagCountLabel))).addGroup(directTagPanelLayout.createSequentialGroup().addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mzFidelityScoreWeightLabel).addComponent(this.mzFidelityScoreWeightTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.complementScoreWeightLabel).addComponent(this.complementScoreWeightTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.adjustPrecursorMassCmb, -2, -1, -2).addComponent(this.adjustPrecursorMassLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(directTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.useSpectrumChargeStateCmb, -2, -1, -2).addComponent(this.useSpectrumChargeStateLabel)))).addContainerGap(-1, Short.MAX_VALUE)));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirecTagParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Open the DirecTag web page");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                DirecTagParametersDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DirecTagParametersDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirecTagParametersDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.directTagPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.directTagPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void numberOfChargeStatesTextFieldKeyPressed(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void maxPeakCountTextFieldKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void numberOfIntensityClassesTextFieldKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void minPrecursorAdjustmentTextFieldKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void maxPrecursorAdjustmentTextFieldKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void precursorAdjustmentStepTextFieldKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void outputSuffixTextFieldKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void deisptopingModeTextFieldKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void isotopeToleranceTextFieldKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void complementToleranceTextFieldKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void tagLengthTextFieldKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void numVariableModsTextFieldKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void intensityScoreWeightTextFieldKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void mzFidelityScoreWeightTextFieldKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void complementScoreWeightTextFieldKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void ticCutoffTextFieldKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        boolean valid = this.validateParametersInput(true);
        if (valid) {
            this.dispose();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://fenchurch.mc.vanderbilt.edu/bumbershoot/directag/");
        this.setCursor(new Cursor(0));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelButtonActionPerformed(null);
    }

    public boolean validateParametersInput(boolean showMessage) {
        boolean valid = true;
        valid = GuiUtilities.validateIntegerInput(this, this.tagLengthLabel, this.tagLengthTextField, "tag length", "Tag Length Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.numVariableModsLabel, this.numVariableModsTextField, "number of variable modifications", "Variable Modifications Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.numberOfChargeStatesLabel, this.numberOfChargeStatesTextField, "number of charge states", "Charge States Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.deisotopingModeLabel, this.deisptopingModeTextField, "deisotoping mode", "Deisotoping Mode Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.isotopeToleranceLabel, this.isotopeToleranceTextField, "isotope tolerance", "Isotope Tolerance Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.numberOfIntensityClassesLabel, this.numberOfIntensityClassesTextField, "number of intensity classes", "Intensity Classes Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.maxPeakCountLabel, this.maxPeakCountTextField, "maximum peak count", "Max Peak Count Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.ticCutoffLabel, this.ticCutoffTextField, "TIC cutoff", "TIC Cutoff Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.complementToleranceLabel, this.complementToleranceTextField, "complement tolerance", "Complement Tolerance Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.precursorAdjustmentStepLabel, this.precursorAdjustmentStepTextField, "precursor adjustment step", "Precursor Adjustment Step Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.minPrecursorAdjustmentLabel, this.minPrecursorAdjustmentTextField, "minimum precursor adjustment", "Minimum Precursor Adjustment Error", false, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.maxPrecursorAdjustmentLabel, this.maxPrecursorAdjustmentTextField, "maximum precursor adjustment", "Maximum Precursor Adjustment Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.intensityScoreWeightLabel, this.intensityScoreWeightTextField, "intensity score weight", "Intensity Score Waight Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.mzFidelityScoreWeightLabel, this.mzFidelityScoreWeightTextField, "mz fidelity score weight", "MZ Fidelity Score Weight Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.complementScoreWeightLabel, this.complementScoreWeightTextField, "complement score weight", "Complement Score Weight Error", true, showMessage, valid);
        this.okButton.setEnabled(valid);
        return valid;
    }

    public DirecTagParameters getInput() {
        DirecTagParameters direcTagParameters = new DirecTagParameters();
        direcTagParameters.setTagLength(Integer.parseInt(this.tagLengthTextField.getText()));
        direcTagParameters.setMaxDynamicMods(Integer.parseInt(this.numVariableModsTextField.getText()));
        direcTagParameters.setNumChargeStates(Integer.parseInt(this.numberOfChargeStatesTextField.getText()));
        direcTagParameters.setDuplicateSpectra(this.duplicateSpectraPerChargeCmb.getSelectedIndex() == 0);
        direcTagParameters.setDeisotopingMode(Integer.parseInt(this.deisptopingModeTextField.getText()));
        direcTagParameters.setIsotopeMzTolerance(Double.parseDouble(this.isotopeToleranceTextField.getText()));
        direcTagParameters.setNumIntensityClasses(Integer.parseInt(this.numberOfIntensityClassesTextField.getText()));
        direcTagParameters.setOutputSuffix(this.outputSuffixTextField.getText());
        direcTagParameters.setMaxPeakCount(Integer.parseInt(this.maxPeakCountTextField.getText()));
        direcTagParameters.setTicCutoffPercentage(Double.parseDouble(this.ticCutoffTextField.getText()));
        direcTagParameters.setComplementMzTolerance(Double.parseDouble(this.complementToleranceTextField.getText()));
        direcTagParameters.setPrecursorAdjustmentStep(Double.parseDouble(this.precursorAdjustmentStepTextField.getText()));
        direcTagParameters.setMinPrecursorAdjustment(Double.parseDouble(this.minPrecursorAdjustmentTextField.getText()));
        direcTagParameters.setMaxPrecursorAdjustment(Double.parseDouble(this.maxPrecursorAdjustmentTextField.getText()));
        direcTagParameters.setIntensityScoreWeight(Double.parseDouble(this.intensityScoreWeightTextField.getText()));
        direcTagParameters.setMzFidelityScoreWeight(Double.parseDouble(this.mzFidelityScoreWeightTextField.getText()));
        direcTagParameters.setComplementScoreWeight(Double.parseDouble(this.complementScoreWeightTextField.getText()));
        direcTagParameters.setMaxTagCount((Integer)this.maxTagCountSpinner.getValue());
        direcTagParameters.setAdjustPrecursorMass(this.adjustPrecursorMassCmb.getSelectedIndex() == 0);
        direcTagParameters.setUseChargeStateFromMS(this.useSpectrumChargeStateCmb.getSelectedIndex() == 0);
        return direcTagParameters;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public IdentificationAlgorithmParameter getParameters() {
        return this.getInput();
    }
}

