/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.algorithm;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.parameters.identification.AlgorithmParametersDialog;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.identification.tool_specific.MsAmandaParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class MsAmandaParametersDialog
extends JDialog
implements AlgorithmParametersDialog {
    private boolean cancelled = false;
    private boolean editable;
    private JPanel advancedSearchSettingsPanel;
    private JLabel advancedSettingsWarningLabel;
    private JPanel backgroundPanel;
    private JButton closeButton;
    private JComboBox decoyDatabaseCmb;
    private JLabel decoyDatabaseLabel;
    private JComboBox instrumentCmb;
    private JLabel instrumentLabel;
    private JComboBox maxModPerPeptideCmb;
    private JLabel maxModPerPeptideLabel;
    private JComboBox maxNeutralLossesPerPeptideCmb;
    private JLabel maxNeutralLossesPerPeptideLabel;
    private JTextField maxPeptideLengthTxt;
    private JComboBox maxPotentialModSitePerPeptideCmb;
    private JLabel maxPotentialModSitePerPeptideLabel;
    private JLabel maxProteinsLoadedLabel;
    private JTextField maxProteinsLoadedTxt;
    private JComboBox maxPtmNeutalLossesPerPeptideCmb;
    private JLabel maxPtmNeutalLossesPerPeptideLabel;
    private JLabel maxRankLabel;
    private JTextField maxRankTxt;
    private JLabel maxSpectraLoadedLabel;
    private JTextField maxSpectraLoadedTxt;
    private JComboBox maxVariableModPerPeptideCmb;
    private JLabel maxVariableModPerPeptideLabel;
    private JTextField minPeptideLengthTxt;
    private JComboBox monoIsotopicCmb;
    private JLabel monoIsotopicLabel;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JComboBox outputFormatCmb;
    private JLabel outputFormatLabel;
    private JLabel peptideLengthDividerLabel;
    private JLabel peptideLengthLabel;
    private JComboBox performDeisotopingCmb;
    private JLabel performDeisotopingLabel;
    private JComboBox rankTargetAndDecoySeparatelyCmb;
    private JLabel rankTargetAndDecoySeparatelyLabel;

    public MsAmandaParametersDialog() {
    }

    public MsAmandaParametersDialog(Frame parent, MsAmandaParameters msAmandaParameters, boolean editable) {
        super(parent, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(msAmandaParameters);
        this.validateInput(false);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public MsAmandaParametersDialog(Dialog owner, Frame parent, MsAmandaParameters msAmandaParameters, boolean editable) {
        super(owner, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(msAmandaParameters);
        this.validateInput(false);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.decoyDatabaseCmb.setRenderer(new AlignedListCellRenderer(0));
        this.rankTargetAndDecoySeparatelyCmb.setRenderer(new AlignedListCellRenderer(0));
        this.instrumentCmb.setRenderer(new AlignedListCellRenderer(0));
        this.monoIsotopicCmb.setRenderer(new AlignedListCellRenderer(0));
        this.performDeisotopingCmb.setRenderer(new AlignedListCellRenderer(0));
        this.maxModPerPeptideCmb.setRenderer(new AlignedListCellRenderer(0));
        this.maxVariableModPerPeptideCmb.setRenderer(new AlignedListCellRenderer(0));
        this.maxPotentialModSitePerPeptideCmb.setRenderer(new AlignedListCellRenderer(0));
        this.maxNeutralLossesPerPeptideCmb.setRenderer(new AlignedListCellRenderer(0));
        this.maxPtmNeutalLossesPerPeptideCmb.setRenderer(new AlignedListCellRenderer(0));
        this.outputFormatCmb.setRenderer(new AlignedListCellRenderer(0));
        this.decoyDatabaseCmb.setEnabled(this.editable);
        this.rankTargetAndDecoySeparatelyCmb.setEnabled(this.editable);
        this.instrumentCmb.setEnabled(this.editable);
        this.monoIsotopicCmb.setEnabled(this.editable);
        this.maxRankTxt.setEditable(this.editable);
        this.maxRankTxt.setEnabled(this.editable);
        this.performDeisotopingCmb.setEnabled(this.editable);
        this.maxModPerPeptideCmb.setEnabled(this.editable);
        this.maxVariableModPerPeptideCmb.setEnabled(this.editable);
        this.maxPotentialModSitePerPeptideCmb.setEnabled(this.editable);
        this.maxNeutralLossesPerPeptideCmb.setEnabled(this.editable);
        this.maxPtmNeutalLossesPerPeptideCmb.setEnabled(this.editable);
        this.minPeptideLengthTxt.setEnabled(this.editable);
        this.maxPeptideLengthTxt.setEnabled(this.editable);
        this.maxProteinsLoadedTxt.setEnabled(this.editable);
        this.maxSpectraLoadedTxt.setEnabled(this.editable);
    }

    private void populateGUI(MsAmandaParameters msAmandaParameters) {
        if (msAmandaParameters.generateDecoy()) {
            this.decoyDatabaseCmb.setSelectedIndex(0);
        } else {
            this.decoyDatabaseCmb.setSelectedIndex(1);
        }
        if (msAmandaParameters.reportBothBestHitsForTD()) {
            this.rankTargetAndDecoySeparatelyCmb.setSelectedIndex(0);
        } else {
            this.rankTargetAndDecoySeparatelyCmb.setSelectedIndex(1);
        }
        this.instrumentCmb.setSelectedItem(msAmandaParameters.getInstrumentID());
        this.maxRankTxt.setText(msAmandaParameters.getMaxRank().toString());
        if (msAmandaParameters.isMonoIsotopic()) {
            this.monoIsotopicCmb.setSelectedIndex(0);
        } else {
            this.monoIsotopicCmb.setSelectedIndex(1);
        }
        if (msAmandaParameters.isPerformDeisotoping()) {
            this.performDeisotopingCmb.setSelectedIndex(0);
        } else {
            this.performDeisotopingCmb.setSelectedIndex(1);
        }
        this.maxModPerPeptideCmb.setSelectedIndex(msAmandaParameters.getMaxModifications());
        this.maxVariableModPerPeptideCmb.setSelectedIndex(msAmandaParameters.getMaxVariableModifications());
        this.maxPotentialModSitePerPeptideCmb.setSelectedIndex(msAmandaParameters.getMaxModificationSites());
        this.maxNeutralLossesPerPeptideCmb.setSelectedIndex(msAmandaParameters.getMaxNeutralLosses());
        this.maxPtmNeutalLossesPerPeptideCmb.setSelectedIndex(msAmandaParameters.getMaxNeutralLossesPerModification());
        this.minPeptideLengthTxt.setText(msAmandaParameters.getMinPeptideLength().toString());
        this.maxPeptideLengthTxt.setText(msAmandaParameters.getMaxPeptideLength().toString());
        this.maxProteinsLoadedTxt.setText(msAmandaParameters.getMaxLoadedProteins().toString());
        this.maxSpectraLoadedTxt.setText(msAmandaParameters.getMaxLoadedSpectra().toString());
        if (msAmandaParameters.getOutputFormat().equalsIgnoreCase("csv")) {
            this.outputFormatCmb.setSelectedIndex(0);
        } else {
            this.outputFormatCmb.setSelectedIndex(1);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public IdentificationAlgorithmParameter getParameters() {
        return this.getInput();
    }

    public MsAmandaParameters getInput() {
        MsAmandaParameters result = new MsAmandaParameters();
        result.setGenerateDecoyDatabase(this.decoyDatabaseCmb.getSelectedIndex() == 0);
        result.setReportBothBestHitsForTD(this.rankTargetAndDecoySeparatelyCmb.getSelectedIndex() == 0);
        result.setInstrumentID((String)this.instrumentCmb.getSelectedItem());
        String input = this.maxRankTxt.getText().trim();
        if (!input.equals("")) {
            result.setMaxRank(Integer.valueOf(input));
        }
        result.setMonoIsotopic(this.monoIsotopicCmb.getSelectedIndex() == 0);
        result.setPerformDeisotoping(this.performDeisotopingCmb.getSelectedIndex() == 0);
        result.setMaxModifications(this.maxModPerPeptideCmb.getSelectedIndex());
        result.setMaxVariableModifications(this.maxVariableModPerPeptideCmb.getSelectedIndex());
        result.setMaxModificationSites(this.maxPotentialModSitePerPeptideCmb.getSelectedIndex());
        result.setMaxNeutralLosses(this.maxNeutralLossesPerPeptideCmb.getSelectedIndex());
        result.setMaxNeutralLossesPerModification(this.maxPtmNeutalLossesPerPeptideCmb.getSelectedIndex());
        input = this.minPeptideLengthTxt.getText().trim();
        if (!input.equals("")) {
            result.setMinPeptideLength(Integer.valueOf(input));
        }
        if (!(input = this.maxPeptideLengthTxt.getText().trim()).equals("")) {
            result.setMaxPeptideLength(Integer.valueOf(input));
        }
        if (!(input = this.maxProteinsLoadedTxt.getText().trim()).equals("")) {
            result.setMaxLoadedProteins(Integer.valueOf(input));
        }
        if (!(input = this.maxSpectraLoadedTxt.getText().trim()).equals("")) {
            result.setMaxLoadedSpectra(Integer.valueOf(input));
        }
        result.setOutputFormat((String)this.outputFormatCmb.getSelectedItem());
        return result;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.advancedSearchSettingsPanel = new JPanel();
        this.instrumentCmb = new JComboBox();
        this.decoyDatabaseCmb = new JComboBox();
        this.decoyDatabaseLabel = new JLabel();
        this.instrumentLabel = new JLabel();
        this.maxRankLabel = new JLabel();
        this.maxRankTxt = new JTextField();
        this.monoIsotopicLabel = new JLabel();
        this.monoIsotopicCmb = new JComboBox();
        this.performDeisotopingLabel = new JLabel();
        this.performDeisotopingCmb = new JComboBox();
        this.maxModPerPeptideLabel = new JLabel();
        this.maxModPerPeptideCmb = new JComboBox();
        this.maxVariableModPerPeptideLabel = new JLabel();
        this.maxVariableModPerPeptideCmb = new JComboBox();
        this.maxPotentialModSitePerPeptideLabel = new JLabel();
        this.maxPotentialModSitePerPeptideCmb = new JComboBox();
        this.maxNeutralLossesPerPeptideLabel = new JLabel();
        this.maxNeutralLossesPerPeptideCmb = new JComboBox();
        this.maxPtmNeutalLossesPerPeptideLabel = new JLabel();
        this.maxPtmNeutalLossesPerPeptideCmb = new JComboBox();
        this.peptideLengthLabel = new JLabel();
        this.minPeptideLengthTxt = new JTextField();
        this.maxProteinsLoadedLabel = new JLabel();
        this.maxProteinsLoadedTxt = new JTextField();
        this.maxSpectraLoadedLabel = new JLabel();
        this.maxSpectraLoadedTxt = new JTextField();
        this.outputFormatLabel = new JLabel();
        this.outputFormatCmb = new JComboBox();
        this.peptideLengthDividerLabel = new JLabel();
        this.maxPeptideLengthTxt = new JTextField();
        this.rankTargetAndDecoySeparatelyLabel = new JLabel();
        this.rankTargetAndDecoySeparatelyCmb = new JComboBox();
        this.okButton = new JButton();
        this.closeButton = new JButton();
        this.openDialogHelpJButton = new JButton();
        this.advancedSettingsWarningLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("MS Amanda Advanced Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.advancedSearchSettingsPanel.setBorder(BorderFactory.createTitledBorder("Search Settings"));
        this.advancedSearchSettingsPanel.setOpaque(false);
        this.instrumentCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"b, y", "b, y, -H2O, -NH3", "a, b, y, -H2O, -NH3, Imm", "a, b, y, -H2O, -NH3", "a, b, y", "a, b, y, Imm", "a, b, y, z, -H2O, -NH3, Imm", "c, y, z+1, z+2", "b, c, y, z+1, z+2", "b, y, INT", "b, y, INT, Imm", "a, b, y, INT", "a, b, y, INT, IMM", "a, b, y, INT, IMM, -H2O", "a, b, y, INT, IMM, -H2O, -NH3", "a, b, y, INT, IMM, -NH3"}));
        this.decoyDatabaseCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.decoyDatabaseCmb.setSelectedIndex(1);
        this.decoyDatabaseLabel.setText("Generate Decoy Database");
        this.instrumentLabel.setText("Fragment Ion Types");
        this.maxRankLabel.setText("Max Rank");
        this.maxRankTxt.setHorizontalAlignment(0);
        this.maxRankTxt.setText("1");
        this.maxRankTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsAmandaParametersDialog.this.maxRankTxtKeyReleased(evt);
            }
        });
        this.monoIsotopicLabel.setText("Monoisotopic");
        this.monoIsotopicCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.performDeisotopingLabel.setText("Perform Deisotoping");
        this.performDeisotopingCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.maxModPerPeptideLabel.setText("Max PTM Duplicates per Peptide");
        this.maxModPerPeptideLabel.setToolTipText("Max number of occurrences of a specific modification on a peptide");
        this.maxModPerPeptideCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}));
        this.maxModPerPeptideCmb.setSelectedIndex(3);
        this.maxModPerPeptideCmb.setToolTipText("Max number of occurrences of a specific modification on a peptide");
        this.maxVariableModPerPeptideLabel.setText("Max Variable PTMs per Peptide");
        this.maxVariableModPerPeptideLabel.setToolTipText("Max number of variable modifications per peptide");
        this.maxVariableModPerPeptideCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}));
        this.maxVariableModPerPeptideCmb.setSelectedIndex(4);
        this.maxVariableModPerPeptideCmb.setToolTipText("Max number of variable modifications per peptide");
        this.maxPotentialModSitePerPeptideLabel.setText("Max Potential PTM sites per PTM");
        this.maxPotentialModSitePerPeptideLabel.setToolTipText("Max number of potential modification sites per modification per peptide");
        this.maxPotentialModSitePerPeptideCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"}));
        this.maxPotentialModSitePerPeptideCmb.setSelectedIndex(6);
        this.maxPotentialModSitePerPeptideCmb.setToolTipText("Max number of potential modification sites per modification per peptide");
        this.maxNeutralLossesPerPeptideLabel.setText("Max Neutral Losses per Peptide");
        this.maxNeutralLossesPerPeptideLabel.setToolTipText("Max number of water and ammonia losses per peptide");
        this.maxNeutralLossesPerPeptideCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5"}));
        this.maxNeutralLossesPerPeptideCmb.setSelectedIndex(1);
        this.maxNeutralLossesPerPeptideCmb.setToolTipText("Max number of water and ammonia losses per peptide");
        this.maxPtmNeutalLossesPerPeptideLabel.setText("Max PTM Neutral Losses per Peptide");
        this.maxPtmNeutalLossesPerPeptideLabel.setToolTipText("Max number identical modification specific losses per peptide");
        this.maxPtmNeutalLossesPerPeptideCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5"}));
        this.maxPtmNeutalLossesPerPeptideCmb.setSelectedIndex(1);
        this.maxPtmNeutalLossesPerPeptideCmb.setToolTipText("Max number identical modification specific losses per peptide");
        this.peptideLengthLabel.setText("Peptide Length (min - max)");
        this.minPeptideLengthTxt.setHorizontalAlignment(0);
        this.minPeptideLengthTxt.setText("8");
        this.minPeptideLengthTxt.setToolTipText("Minimum peptide length");
        this.minPeptideLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsAmandaParametersDialog.this.minPeptideLengthTxtKeyReleased(evt);
            }
        });
        this.maxProteinsLoadedLabel.setText("Max Proteins Loaded into Memory");
        this.maxProteinsLoadedLabel.setToolTipText("Max number of proteins loaded into memory (1000-500000)");
        this.maxProteinsLoadedTxt.setHorizontalAlignment(0);
        this.maxProteinsLoadedTxt.setText("100000");
        this.maxProteinsLoadedTxt.setToolTipText("Max number of proteins loaded into memory (1000-500000)");
        this.maxProteinsLoadedTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsAmandaParametersDialog.this.maxProteinsLoadedTxtKeyReleased(evt);
            }
        });
        this.maxSpectraLoadedLabel.setText("Max Spectra Loaded into Memory");
        this.maxSpectraLoadedLabel.setToolTipText("Max number of spectra loaded into memory (1000-500000)");
        this.maxSpectraLoadedTxt.setHorizontalAlignment(0);
        this.maxSpectraLoadedTxt.setText("2000");
        this.maxSpectraLoadedTxt.setToolTipText("Max number of spectra loaded into memory (1000-500000)");
        this.maxSpectraLoadedTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsAmandaParametersDialog.this.maxSpectraLoadedTxtKeyReleased(evt);
            }
        });
        this.outputFormatLabel.setText("Output Format");
        this.outputFormatCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"csv", "mzIdentML"}));
        this.peptideLengthDividerLabel.setHorizontalAlignment(0);
        this.peptideLengthDividerLabel.setText("-");
        this.maxPeptideLengthTxt.setHorizontalAlignment(0);
        this.maxPeptideLengthTxt.setText("30");
        this.maxPeptideLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsAmandaParametersDialog.this.maxPeptideLengthTxtKeyReleased(evt);
            }
        });
        this.rankTargetAndDecoySeparatelyLabel.setText("Rank Target and Decoy Separately");
        this.rankTargetAndDecoySeparatelyCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        GroupLayout advancedSearchSettingsPanelLayout = new GroupLayout(this.advancedSearchSettingsPanel);
        this.advancedSearchSettingsPanel.setLayout(advancedSearchSettingsPanelLayout);
        advancedSearchSettingsPanelLayout.setHorizontalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.instrumentLabel, -2, 220, -2).addComponent(this.decoyDatabaseLabel, -2, 220, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.instrumentCmb, 0, -1, Short.MAX_VALUE).addComponent(this.decoyDatabaseCmb, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE))).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.maxRankLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxRankTxt)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.monoIsotopicLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.monoIsotopicCmb, 0, -1, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.performDeisotopingLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.performDeisotopingCmb, 0, -1, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.maxModPerPeptideLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxModPerPeptideCmb, 0, -1, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.maxVariableModPerPeptideLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxVariableModPerPeptideCmb, 0, -1, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.maxPotentialModSitePerPeptideLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxPotentialModSitePerPeptideCmb, 0, -1, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.maxNeutralLossesPerPeptideLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxNeutralLossesPerPeptideCmb, 0, -1, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.maxPtmNeutalLossesPerPeptideLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxPtmNeutalLossesPerPeptideCmb, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.peptideLengthLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minPeptideLengthTxt, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.peptideLengthDividerLabel, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxPeptideLengthTxt, -2, 77, -2)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.maxProteinsLoadedLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxProteinsLoadedTxt)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.maxSpectraLoadedLabel, -2, 220, -2).addComponent(this.outputFormatLabel, -2, 200, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputFormatCmb, 0, -1, Short.MAX_VALUE).addComponent(this.maxSpectraLoadedTxt))).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.rankTargetAndDecoySeparatelyLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rankTargetAndDecoySeparatelyCmb, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        advancedSearchSettingsPanelLayout.linkSize(0, this.maxPeptideLengthTxt, this.minPeptideLengthTxt);
        advancedSearchSettingsPanelLayout.setVerticalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.decoyDatabaseLabel).addComponent(this.decoyDatabaseCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rankTargetAndDecoySeparatelyLabel).addComponent(this.rankTargetAndDecoySeparatelyCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.instrumentCmb, -2, -1, -2).addComponent(this.instrumentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.monoIsotopicLabel).addComponent(this.monoIsotopicCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxRankLabel).addComponent(this.maxRankTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.performDeisotopingLabel).addComponent(this.performDeisotopingCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxModPerPeptideCmb, -2, -1, -2).addComponent(this.maxModPerPeptideLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxVariableModPerPeptideCmb, -2, -1, -2).addComponent(this.maxVariableModPerPeptideLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxPotentialModSitePerPeptideCmb, -2, -1, -2).addComponent(this.maxPotentialModSitePerPeptideLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxNeutralLossesPerPeptideCmb, -2, -1, -2).addComponent(this.maxNeutralLossesPerPeptideLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxPtmNeutalLossesPerPeptideCmb, -2, -1, -2).addComponent(this.maxPtmNeutalLossesPerPeptideLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPeptideLengthTxt, -2, -1, -2).addComponent(this.peptideLengthLabel).addComponent(this.maxPeptideLengthTxt, -2, -1, -2).addComponent(this.peptideLengthDividerLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxProteinsLoadedTxt, -2, -1, -2).addComponent(this.maxProteinsLoadedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxSpectraLoadedTxt, -2, -1, -2).addComponent(this.maxSpectraLoadedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputFormatLabel).addComponent(this.outputFormatCmb, -2, -1, -2)).addContainerGap()));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsAmandaParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsAmandaParametersDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MsAmandaParametersDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MsAmandaParametersDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsAmandaParametersDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.advancedSettingsWarningLabel.setText("Click to open the MS Amanda help page.");
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.advancedSearchSettingsPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton).addGap(18, 18, 18).addComponent(this.advancedSettingsWarningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.advancedSearchSettingsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.advancedSettingsWarningLabel).addComponent(this.okButton).addComponent(this.closeButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            this.dispose();
        }
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://ms.imp.ac.at/?goto=msamanda");
        this.setCursor(new Cursor(0));
    }

    private void maxRankTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minPeptideLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxProteinsLoadedTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxSpectraLoadedTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPeptideLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    public boolean validateInput(boolean showMessage) {
        Integer value2;
        boolean valid = true;
        valid = GuiUtilities.validateIntegerInput(this, this.maxRankLabel, this.maxRankTxt, "number of spectrum matches", "Number Spectrum Matches Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.peptideLengthLabel, this.minPeptideLengthTxt, "minimum peptide length", "Minimum Peptide Length Error", false, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.peptideLengthLabel, this.maxPeptideLengthTxt, "maximum peptide length", "Maximum Peptide Length Error", false, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.maxProteinsLoadedLabel, this.maxProteinsLoadedTxt, "maximum number of proteins loaded into memory", "Maximum Proteins Loaded into Memory Error", true, showMessage, valid);
        if (valid = GuiUtilities.validateIntegerInput(this, this.maxSpectraLoadedLabel, this.maxSpectraLoadedTxt, "maximum number of spectra loaded into memory", "Maximum Spectra Loaded into Memory Error", true, showMessage, valid)) {
            try {
                value2 = Integer.valueOf(this.maxProteinsLoadedTxt.getText());
                if (value2 < 1000 || value2 > 500000) {
                    if (showMessage && valid) {
                        JOptionPane.showMessageDialog(this, "Please select an integer in the range (1000 - 500 000) for Max Proteins Loaded into Memory.", "Max Proteins Loaded into Memory Error", 2);
                    }
                    valid = false;
                    this.maxProteinsLoadedLabel.setForeground(Color.RED);
                    this.maxProteinsLoadedLabel.setToolTipText("Please select an integer in the range (1000 - 500 000)");
                }
            }
            catch (NumberFormatException value2) {
                // empty catch block
            }
        }
        if (valid) {
            try {
                value2 = Integer.valueOf(this.maxSpectraLoadedTxt.getText());
                if (value2 < 1000 || value2 > 500000) {
                    if (showMessage && valid) {
                        JOptionPane.showMessageDialog(this, "Please select an integer in the range (1000 - 500 000) for Max Spectra Loaded into Memory.", "Max Spectra Loaded into Memory Error", 2);
                    }
                    valid = false;
                    this.maxProteinsLoadedLabel.setForeground(Color.RED);
                    this.maxProteinsLoadedLabel.setToolTipText("Please select an integer in the range (1000 - 500 000)");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.okButton.setEnabled(valid);
        return valid;
    }
}

