/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.algorithm;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.parameters.identification.AlgorithmParametersDialog;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.identification.tool_specific.MsgfParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class MsgfParametersDialog
extends JDialog
implements AlgorithmParametersDialog {
    private boolean cancelled = false;
    private boolean editable;
    private JComboBox additionalOutputCmb;
    private JLabel additionalOutputLabel;
    private JPanel advancedSearchSettingsPanel;
    private JLabel advancedSettingsWarningLabel;
    private JPanel backgroundPanel;
    private JButton closeButton;
    private JComboBox decoyDatabaseCmb;
    private JLabel decoyDatabaseLabel;
    private JComboBox fragmentationMethodCmb;
    private JLabel fragmentationMethodLabel;
    private JComboBox instrumentCmb;
    private JLabel instrumentLabel;
    private JTextField maxPepLengthTxt;
    private JLabel maxPtmsLabel;
    private JTextField maxPtmsTxt;
    private JTextField minPepLengthTxt;
    private JLabel numberMatchesLabel;
    private JTextField numberMatchesTxt;
    private JLabel numberOfTasksLabel;
    private JTextField numberOfTasksTxt;
    private JLabel numberTerminiLabel;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JLabel peptideLengthDividerLabel;
    private JLabel peptideLengthLabel;
    private JComboBox protocolCmb;
    private JLabel protocolLabel;
    private JComboBox terminiCmb;

    public MsgfParametersDialog(Frame parent, MsgfParameters msgfParameters, boolean editable) {
        super(parent, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(msgfParameters);
        this.validateInput(false);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public MsgfParametersDialog(Dialog owner, Frame parent, MsgfParameters msgfParameters, boolean editable) {
        super(owner, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(msgfParameters);
        this.validateInput(false);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.decoyDatabaseCmb.setRenderer(new AlignedListCellRenderer(0));
        this.instrumentCmb.setRenderer(new AlignedListCellRenderer(0));
        this.fragmentationMethodCmb.setRenderer(new AlignedListCellRenderer(0));
        this.protocolCmb.setRenderer(new AlignedListCellRenderer(0));
        this.additionalOutputCmb.setRenderer(new AlignedListCellRenderer(0));
        this.terminiCmb.setRenderer(new AlignedListCellRenderer(0));
        this.decoyDatabaseCmb.setEnabled(this.editable);
        this.instrumentCmb.setEnabled(this.editable);
        this.fragmentationMethodCmb.setEnabled(this.editable);
        this.protocolCmb.setEnabled(this.editable);
        this.terminiCmb.setEnabled(this.editable);
        this.minPepLengthTxt.setEditable(this.editable);
        this.minPepLengthTxt.setEnabled(this.editable);
        this.maxPepLengthTxt.setEditable(this.editable);
        this.maxPepLengthTxt.setEnabled(this.editable);
        this.maxPtmsTxt.setEditable(this.editable);
        this.maxPtmsTxt.setEnabled(this.editable);
        this.numberMatchesTxt.setEditable(this.editable);
        this.numberMatchesTxt.setEnabled(this.editable);
        this.additionalOutputCmb.setEnabled(this.editable);
    }

    private void populateGUI(MsgfParameters msgfParameters) {
        if (msgfParameters.searchDecoyDatabase()) {
            this.decoyDatabaseCmb.setSelectedIndex(0);
        } else {
            this.decoyDatabaseCmb.setSelectedIndex(1);
        }
        this.instrumentCmb.setSelectedIndex(msgfParameters.getInstrumentID());
        this.fragmentationMethodCmb.setSelectedIndex(msgfParameters.getFragmentationType());
        this.protocolCmb.setSelectedIndex(msgfParameters.getProtocol());
        if (msgfParameters.getMinPeptideLength() != null) {
            this.minPepLengthTxt.setText(msgfParameters.getMinPeptideLength() + "");
        }
        if (msgfParameters.getMaxPeptideLength() != null) {
            this.maxPepLengthTxt.setText(msgfParameters.getMaxPeptideLength() + "");
        }
        if (msgfParameters.getNumberOfSpectrumMatches() != null) {
            this.numberMatchesTxt.setText(msgfParameters.getNumberOfSpectrumMatches() + "");
        }
        if (msgfParameters.isAdditionalOutput()) {
            this.additionalOutputCmb.setSelectedIndex(0);
        } else {
            this.additionalOutputCmb.setSelectedIndex(1);
        }
        if (msgfParameters.getNumberTolerableTermini() != null) {
            this.terminiCmb.setSelectedIndex(msgfParameters.getNumberTolerableTermini());
        }
        if (msgfParameters.getNumberOfModificationsPerPeptide() != null) {
            this.maxPtmsTxt.setText(msgfParameters.getNumberOfModificationsPerPeptide() + "");
        }
        if (msgfParameters.getNumberOfTasks() != null) {
            this.numberOfTasksTxt.setText(msgfParameters.getNumberOfTasks() + "");
        } else {
            this.numberOfTasksTxt.setText("default");
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public IdentificationAlgorithmParameter getParameters() {
        return this.getInput();
    }

    public MsgfParameters getInput() {
        MsgfParameters result = new MsgfParameters();
        result.setSearchDecoyDatabase(this.decoyDatabaseCmb.getSelectedIndex() == 0);
        result.setInstrumentID(this.instrumentCmb.getSelectedIndex());
        result.setFragmentationType(this.fragmentationMethodCmb.getSelectedIndex());
        result.setProtocol(this.protocolCmb.getSelectedIndex());
        String input = this.minPepLengthTxt.getText().trim();
        if (!input.equals("")) {
            result.setMinPeptideLength(Integer.valueOf(input));
        }
        if (!(input = this.maxPepLengthTxt.getText().trim()).equals("")) {
            result.setMaxPeptideLength(Integer.valueOf(input));
        }
        if (!(input = this.numberMatchesTxt.getText().trim()).equals("")) {
            result.setNumberOfSpectrumMarches(Integer.valueOf(input));
        }
        result.setAdditionalOutput(this.additionalOutputCmb.getSelectedIndex() == 0);
        result.setNumberTolerableTermini(this.terminiCmb.getSelectedIndex());
        input = this.maxPtmsTxt.getText().trim();
        if (!input.equals("")) {
            result.setNumberOfModificationsPerPeptide(Integer.valueOf(input));
        }
        if (!(input = this.numberOfTasksTxt.getText().trim()).equals("") && !this.numberOfTasksTxt.getText().trim().equalsIgnoreCase("default")) {
            result.setNumberOfTasks(Integer.valueOf(input));
        } else {
            result.setNumberOfTasks(null);
        }
        return result;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.advancedSearchSettingsPanel = new JPanel();
        this.instrumentCmb = new JComboBox();
        this.decoyDatabaseCmb = new JComboBox();
        this.decoyDatabaseLabel = new JLabel();
        this.instrumentLabel = new JLabel();
        this.fragmentationMethodLabel = new JLabel();
        this.fragmentationMethodCmb = new JComboBox();
        this.protocolLabel = new JLabel();
        this.protocolCmb = new JComboBox();
        this.minPepLengthTxt = new JTextField();
        this.peptideLengthDividerLabel = new JLabel();
        this.maxPepLengthTxt = new JTextField();
        this.peptideLengthLabel = new JLabel();
        this.numberMatchesLabel = new JLabel();
        this.numberMatchesTxt = new JTextField();
        this.additionalOutputLabel = new JLabel();
        this.additionalOutputCmb = new JComboBox();
        this.numberTerminiLabel = new JLabel();
        this.maxPtmsLabel = new JLabel();
        this.maxPtmsTxt = new JTextField();
        this.terminiCmb = new JComboBox();
        this.numberOfTasksLabel = new JLabel();
        this.numberOfTasksTxt = new JTextField();
        this.okButton = new JButton();
        this.closeButton = new JButton();
        this.openDialogHelpJButton = new JButton();
        this.advancedSettingsWarningLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("MS-GF+ Advanced Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.advancedSearchSettingsPanel.setBorder(BorderFactory.createTitledBorder("Search Settings"));
        this.advancedSearchSettingsPanel.setOpaque(false);
        this.instrumentCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Low-res LCQ/LTQ", "Orbitrap/FTICR", "TOF", "Q-Exactive"}));
        this.instrumentCmb.setSelectedIndex(3);
        this.instrumentCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsgfParametersDialog.this.instrumentCmbActionPerformed(evt);
            }
        });
        this.decoyDatabaseCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.decoyDatabaseCmb.setSelectedIndex(1);
        this.decoyDatabaseLabel.setText("Search Decoy Database");
        this.instrumentLabel.setText("MS/MS Detector");
        this.fragmentationMethodLabel.setText("Fragmentation Method");
        this.fragmentationMethodCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Automatic", "CID", "ETD", "HCD", "UVPD"}));
        this.fragmentationMethodCmb.setSelectedIndex(3);
        this.protocolLabel.setText("Protocol");
        this.protocolCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Automatic", "Phosphorylation", "iTRAQ", "iTRAQPhospho", "TMT", "Standard"}));
        this.minPepLengthTxt.setHorizontalAlignment(0);
        this.minPepLengthTxt.setText("8");
        this.minPepLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsgfParametersDialog.this.minPepLengthTxtKeyReleased(evt);
            }
        });
        this.peptideLengthDividerLabel.setHorizontalAlignment(0);
        this.peptideLengthDividerLabel.setText("-");
        this.maxPepLengthTxt.setHorizontalAlignment(0);
        this.maxPepLengthTxt.setText("40");
        this.maxPepLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsgfParametersDialog.this.maxPepLengthTxtKeyReleased(evt);
            }
        });
        this.peptideLengthLabel.setText("Peptide Length (min - max)");
        this.numberMatchesLabel.setText("Number of Spectrum Matches");
        this.numberMatchesTxt.setHorizontalAlignment(0);
        this.numberMatchesTxt.setText("10");
        this.numberMatchesTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsgfParametersDialog.this.numberMatchesTxtKeyReleased(evt);
            }
        });
        this.additionalOutputLabel.setText("Additional Output");
        this.additionalOutputCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.additionalOutputCmb.setSelectedIndex(1);
        this.numberTerminiLabel.setText("Enzymatic Terminals");
        this.maxPtmsLabel.setText("Max Variable PTMs per Peptide");
        this.maxPtmsTxt.setHorizontalAlignment(0);
        this.maxPtmsTxt.setText("2");
        this.maxPtmsTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsgfParametersDialog.this.maxPtmsTxtKeyReleased(evt);
            }
        });
        this.terminiCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"None Required", "At Least One", "Both"}));
        this.terminiCmb.setSelectedIndex(2);
        this.numberOfTasksLabel.setText("Number of Tasks");
        this.numberOfTasksTxt.setHorizontalAlignment(0);
        this.numberOfTasksTxt.setText("default");
        this.numberOfTasksTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsgfParametersDialog.this.numberOfTasksTxtKeyReleased(evt);
            }
        });
        GroupLayout advancedSearchSettingsPanelLayout = new GroupLayout(this.advancedSearchSettingsPanel);
        this.advancedSearchSettingsPanel.setLayout(advancedSearchSettingsPanelLayout);
        advancedSearchSettingsPanelLayout.setHorizontalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.instrumentLabel, -2, 200, -2).addComponent(this.decoyDatabaseLabel, -2, 200, -2).addComponent(this.fragmentationMethodLabel, -2, 200, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fragmentationMethodCmb, 0, -1, Short.MAX_VALUE).addComponent(this.instrumentCmb, 0, -1, Short.MAX_VALUE).addComponent(this.decoyDatabaseCmb, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE))).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.protocolLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.protocolCmb, 0, -1, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.numberMatchesLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numberMatchesTxt)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.peptideLengthLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minPepLengthTxt, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideLengthDividerLabel, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxPepLengthTxt, -2, 77, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.additionalOutputLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.additionalOutputCmb, 0, -1, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.numberTerminiLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.terminiCmb, 0, -1, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.maxPtmsLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxPtmsTxt)).addGroup(GroupLayout.Alignment.TRAILING, advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.numberOfTasksLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numberOfTasksTxt))).addContainerGap()));
        advancedSearchSettingsPanelLayout.linkSize(0, this.maxPepLengthTxt, this.minPepLengthTxt);
        advancedSearchSettingsPanelLayout.setVerticalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.decoyDatabaseLabel).addComponent(this.decoyDatabaseCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.instrumentCmb, -2, -1, -2).addComponent(this.instrumentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fragmentationMethodCmb, -2, -1, -2).addComponent(this.fragmentationMethodLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.protocolCmb, -2, -1, -2).addComponent(this.protocolLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numberTerminiLabel).addComponent(this.terminiCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPepLengthTxt, -2, -1, -2).addComponent(this.maxPepLengthTxt, -2, -1, -2).addComponent(this.peptideLengthDividerLabel).addComponent(this.peptideLengthLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxPtmsLabel).addComponent(this.maxPtmsTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numberMatchesLabel).addComponent(this.numberMatchesTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.additionalOutputLabel).addComponent(this.additionalOutputCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numberOfTasksLabel).addComponent(this.numberOfTasksTxt, -2, -1, -2)).addContainerGap()));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsgfParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsgfParametersDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MsgfParametersDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MsgfParametersDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsgfParametersDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.advancedSettingsWarningLabel.setText("Click to open the MS-GF+ help page");
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.advancedSearchSettingsPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton).addGap(18, 18, 18).addComponent(this.advancedSettingsWarningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.advancedSearchSettingsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.advancedSettingsWarningLabel).addComponent(this.okButton).addComponent(this.closeButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            this.dispose();
        }
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://msgfplus.github.io/msgfplus/MSGFPlus.html");
        this.setCursor(new Cursor(0));
    }

    private void minPepLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPepLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void numberMatchesTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPtmsTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void instrumentCmbActionPerformed(ActionEvent evt) {
        String selectedValue = (String)this.instrumentCmb.getSelectedItem();
        if (selectedValue.equals("Q-Exactive") || selectedValue.equals("Orbitrap/FTICR")) {
            this.fragmentationMethodCmb.setSelectedItem("HCD");
        } else {
            this.fragmentationMethodCmb.setSelectedItem("Automatic");
        }
    }

    private void numberOfTasksTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    public boolean validateInput(boolean showMessage) {
        boolean valid = true;
        valid = GuiUtilities.validateIntegerInput(this, this.peptideLengthLabel, this.minPepLengthTxt, "minimum peptide length", "Peptide Length Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.peptideLengthLabel, this.maxPepLengthTxt, "maximum peptide length", "Peptide Length Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.numberMatchesLabel, this.numberMatchesTxt, "number of spectrum matches", "Number Spectrum Matches Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.maxPtmsLabel, this.maxPtmsTxt, "max number of PTMs per peptide", "Peptide PTM Error", true, showMessage, valid);
        if (!this.numberOfTasksTxt.getText().trim().equals("") && !this.numberOfTasksTxt.getText().trim().equalsIgnoreCase("default")) {
            valid = GuiUtilities.validateIntegerInput(this, this.numberOfTasksLabel, this.numberOfTasksTxt, "number of tasks", "Number of Tasks Error", false, showMessage, valid);
        } else {
            this.numberOfTasksLabel.setForeground(Color.BLACK);
            this.numberOfTasksLabel.setToolTipText(null);
        }
        this.okButton.setEnabled(valid);
        return valid;
    }
}

