/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.algorithm;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.gui.parameters.identification.AlgorithmParametersDialog;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.identification.tool_specific.PepnovoParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class PepNovoParametersDialog
extends JDialog
implements AlgorithmParametersDialog {
    private boolean canceled = false;
    private boolean editable;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JComboBox correctPrecursorMassCmb;
    private JLabel correctPrecursorMassLabel;
    private JComboBox estimateChargeCmb;
    private JLabel estimateChargeLabel;
    private JLabel hitListLengthLabel;
    private JSpinner hitListLengthSpinner;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JPanel pepNovoPanel;

    public PepNovoParametersDialog() {
    }

    public PepNovoParametersDialog(Frame parent, PepnovoParameters pepNovoParameters, boolean editable) {
        super(parent, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(pepNovoParameters);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public PepNovoParametersDialog(Dialog owner, Frame parent, PepnovoParameters pepnovoParameters, boolean editable) {
        super(owner, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(pepnovoParameters);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.correctPrecursorMassCmb.setRenderer(new AlignedListCellRenderer(0));
        this.estimateChargeCmb.setRenderer(new AlignedListCellRenderer(0));
    }

    private void populateGUI(PepnovoParameters pepnovoParameters) {
        this.hitListLengthSpinner.setValue(pepnovoParameters.getHitListLength());
        if (pepnovoParameters.isCorrectPrecursorMass().booleanValue()) {
            this.correctPrecursorMassCmb.setSelectedIndex(1);
        } else {
            this.correctPrecursorMassCmb.setSelectedIndex(0);
        }
        if (pepnovoParameters.isEstimateCharge().booleanValue()) {
            this.estimateChargeCmb.setSelectedIndex(1);
        } else {
            this.estimateChargeCmb.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.pepNovoPanel = new JPanel();
        this.hitListLengthLabel = new JLabel();
        this.hitListLengthSpinner = new JSpinner();
        this.correctPrecursorMassLabel = new JLabel();
        this.correctPrecursorMassCmb = new JComboBox();
        this.estimateChargeLabel = new JLabel();
        this.estimateChargeCmb = new JComboBox();
        this.openDialogHelpJButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("PepNovo+ Advanced Settings");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PepNovoParametersDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.pepNovoPanel.setBorder(BorderFactory.createTitledBorder("PepNovo+ Settings"));
        this.pepNovoPanel.setOpaque(false);
        this.hitListLengthLabel.setText("Hit List Length");
        this.hitListLengthSpinner.setModel(new SpinnerNumberModel(10, 1, 2000, 1));
        this.correctPrecursorMassLabel.setText("Correct Precursor Mass");
        this.correctPrecursorMassCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.estimateChargeLabel.setText("Estimate Charge");
        this.estimateChargeCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        GroupLayout pepNovoPanelLayout = new GroupLayout(this.pepNovoPanel);
        this.pepNovoPanel.setLayout(pepNovoPanelLayout);
        pepNovoPanelLayout.setHorizontalGroup(pepNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pepNovoPanelLayout.createSequentialGroup().addContainerGap().addGroup(pepNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pepNovoPanelLayout.createSequentialGroup().addGroup(pepNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.correctPrecursorMassLabel, -2, 180, -2).addComponent(this.estimateChargeLabel, -2, 180, -2)).addGap(18, 18, 18).addGroup(pepNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.estimateChargeCmb, -2, 130, -2).addComponent(this.correctPrecursorMassCmb, -2, 130, -2))).addGroup(GroupLayout.Alignment.TRAILING, pepNovoPanelLayout.createSequentialGroup().addComponent(this.hitListLengthLabel, -2, 180, -2).addGap(18, 18, 18).addComponent(this.hitListLengthSpinner, -2, 130, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        pepNovoPanelLayout.setVerticalGroup(pepNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pepNovoPanelLayout.createSequentialGroup().addContainerGap().addGroup(pepNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hitListLengthSpinner, -2, -1, -2).addComponent(this.hitListLengthLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pepNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.correctPrecursorMassCmb, -2, -1, -2).addComponent(this.correctPrecursorMassLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pepNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.estimateChargeCmb, -2, -1, -2).addComponent(this.estimateChargeLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Open the PepNovo+ web page");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PepNovoParametersDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PepNovoParametersDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PepNovoParametersDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PepNovoParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PepNovoParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.pepNovoPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.pepNovoPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        boolean valid = this.validateParametersInput(true);
        if (valid) {
            this.dispose();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://proteomics.ucsd.edu/Software/PepNovo/");
        this.setCursor(new Cursor(0));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelButtonActionPerformed(null);
    }

    public boolean validateParametersInput(boolean showMessage) {
        boolean valid = true;
        this.okButton.setEnabled(valid);
        return valid;
    }

    public PepnovoParameters getInput() {
        PepnovoParameters pepNovoParameters = new PepnovoParameters();
        pepNovoParameters.setHitListLength((Integer)this.hitListLengthSpinner.getValue());
        pepNovoParameters.setCorrectPrecursorMass(this.correctPrecursorMassCmb.getSelectedIndex() == 1);
        pepNovoParameters.setEstimateCharge(this.estimateChargeCmb.getSelectedIndex() == 0);
        return pepNovoParameters;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public IdentificationAlgorithmParameter getParameters() {
        return this.getInput();
    }
}

