/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.algorithm;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.modification.ModificationsDialog;
import com.compomics.util.gui.parameters.identification.AlgorithmParametersDialog;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.tool_specific.XtandemParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.NimbusCheckBoxRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesColorTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;

public class XTandemParametersDialog
extends JDialog
implements AlgorithmParametersDialog {
    private ModificationParameters modificationProfile;
    private double fragmentIonMassAccuracyInDa;
    private boolean cancelled = false;
    private ArrayList<String> modificationTableToolTips;
    private ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private boolean modProfileChanged = false;
    private boolean editable;
    private JPanel advancedSearchSettingsPanel;
    private JLabel advancedSettingsWarningLabel;
    private JPanel backgroundPanel;
    private JButton closeButton;
    private JLabel dynamicRangeLbl;
    private JTextField dynamicRangeTxt;
    private JLabel eValueLbl;
    private JTextField eValueTxt;
    private JSeparator jSeparator1;
    private JTextField maxEValueRefineTxt;
    private JLabel maxEValueRefinmentLbl;
    private JLabel minFragMzLbl;
    private JTextField minFragmentMzTxt;
    private JLabel minPeaksLbl;
    private JTextField minPeaksTxt;
    private JLabel minPrecMassLbl;
    private JTextField minPrecMassTxt;
    private JLabel modificationComplexityLbl;
    private JTextField modificationComplexityTxt;
    private JScrollPane modificationsJScrollPane;
    private JTable modificationsTable;
    private JLabel nPeaksLbl;
    private JTextField nPeaksTxt;
    private JComboBox noiseSuppressionCmb;
    private JLabel noiseSuppressionLabel;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JButton openModificationSettingsJButton;
    private JComboBox outputHistogramsCmb;
    private JLabel outputHistogramsLabel;
    private JComboBox outputProteinsCmb;
    private JLabel outputProteinsLabel;
    private JComboBox outputResultsCmb;
    private JLabel outputResultsLabel;
    private JComboBox outputSequencesCmb;
    private JLabel outputSequencesLabel;
    private JPanel outputSettingsPanel;
    private JComboBox outputSpectraCmb;
    private JLabel outputSpectraLabel;
    private JComboBox parentMonoisotopicMassIsotopeErrorCmb;
    private JLabel parentMonoisotopicMassIsotopeErrorLabel;
    private JLabel pointMutationLabel;
    private JComboBox pointMutationsCmb;
    private JComboBox potentialModificationsCmb;
    private JComboBox quickAcetylCmb;
    private JLabel quickAcetylLabel;
    private JComboBox quickPyroCmb;
    private JLabel quickPyroLabel;
    private JComboBox refinementCmb;
    private JLabel refinementLabel;
    private JPanel refinementModificationsJPanel;
    private JLabel refinementModificationsLabel;
    private JPanel refinementSettingsPanel;
    private JComboBox semiEnzymaticCmb;
    private JLabel semiEnzymaticLabel;
    private JLabel skylinePathValueLbl;
    private JTextField skylineTxt;
    private JComboBox snapsCmb;
    private JLabel snapsLabel;
    private JPanel spectrumImportSettingsPanel;
    private JComboBox spectrumSynthesisCmb;
    private JLabel spectrumSynthesisLabel;
    private JComboBox stpBiasCmb;
    private JLabel stpBiasLabel;
    private JTabbedPane tabbedPane;
    private JComboBox unanticipatedCleavageCmb;
    private JLabel unanticipatedCleavageLabel;
    private JLabel usePotentialModsLabel;

    public XTandemParametersDialog() {
    }

    public XTandemParametersDialog(Frame parent, XtandemParameters xtandemParameters, ModificationParameters modificationProfile, double fragmentIonMassAccuracyInDa, boolean editable) {
        super(parent, true);
        this.modificationProfile = new ModificationParameters(modificationProfile);
        this.fragmentIonMassAccuracyInDa = fragmentIonMassAccuracyInDa;
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(xtandemParameters);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public XTandemParametersDialog(Dialog owner, Frame parent, XtandemParameters xtandemParameters, ModificationParameters modificationProfile, double fragmentIonMassAccuracyInDa, boolean editable) {
        super(owner, true);
        this.modificationProfile = new ModificationParameters(modificationProfile);
        this.fragmentIonMassAccuracyInDa = fragmentIonMassAccuracyInDa;
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(xtandemParameters);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.noiseSuppressionCmb.setRenderer(new AlignedListCellRenderer(0));
        this.quickAcetylCmb.setRenderer(new AlignedListCellRenderer(0));
        this.quickPyroCmb.setRenderer(new AlignedListCellRenderer(0));
        this.stpBiasCmb.setRenderer(new AlignedListCellRenderer(0));
        this.outputProteinsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.outputSequencesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.outputSpectraCmb.setRenderer(new AlignedListCellRenderer(0));
        this.outputHistogramsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.refinementCmb.setRenderer(new AlignedListCellRenderer(0));
        this.unanticipatedCleavageCmb.setRenderer(new AlignedListCellRenderer(0));
        this.semiEnzymaticCmb.setRenderer(new AlignedListCellRenderer(0));
        this.potentialModificationsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.pointMutationsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.snapsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.spectrumSynthesisCmb.setRenderer(new AlignedListCellRenderer(0));
        this.outputResultsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.parentMonoisotopicMassIsotopeErrorCmb.setRenderer(new AlignedListCellRenderer(0));
        this.modificationTableToolTips = new ArrayList();
        this.modificationTableToolTips.add(null);
        this.modificationTableToolTips.add("Modification Name");
        this.modificationTableToolTips.add("Modification Mass");
        this.modificationTableToolTips.add("Variable Refinement Modification");
        this.modificationTableToolTips.add("Fixed Refinement Modification");
        this.modificationsJScrollPane.getViewport().setOpaque(false);
        this.modificationsTable.getTableHeader().setReorderingAllowed(false);
        this.setAllModificationTableProperties();
        this.dynamicRangeTxt.setEditable(this.editable);
        this.dynamicRangeTxt.setEnabled(this.editable);
        this.nPeaksTxt.setEditable(this.editable);
        this.nPeaksTxt.setEnabled(this.editable);
        this.minFragmentMzTxt.setEditable(this.editable);
        this.minFragmentMzTxt.setEnabled(this.editable);
        this.minPeaksTxt.setEditable(this.editable);
        this.minPeaksTxt.setEnabled(this.editable);
        this.noiseSuppressionCmb.setEnabled(this.editable);
        this.minPrecMassTxt.setEditable(this.editable);
        this.minPrecMassTxt.setEnabled(this.editable);
        this.quickAcetylCmb.setEnabled(this.editable);
        this.quickPyroCmb.setEnabled(this.editable);
        this.stpBiasCmb.setEnabled(this.editable);
        this.eValueTxt.setEditable(this.editable);
        this.eValueTxt.setEnabled(this.editable);
        this.outputProteinsCmb.setEnabled(this.editable);
        this.outputSequencesCmb.setEnabled(this.editable);
        this.outputSpectraCmb.setEnabled(this.editable);
        this.outputHistogramsCmb.setEnabled(this.editable);
        this.skylineTxt.setEditable(this.editable);
        this.skylineTxt.setEnabled(this.editable);
        this.refinementCmb.setEnabled(this.editable);
        this.maxEValueRefineTxt.setEditable(this.editable);
        this.maxEValueRefineTxt.setEnabled(this.editable);
        this.unanticipatedCleavageCmb.setEnabled(this.editable);
        this.semiEnzymaticCmb.setEnabled(this.editable);
        this.potentialModificationsCmb.setEnabled(this.editable);
        this.pointMutationsCmb.setEnabled(this.editable);
        this.snapsCmb.setEnabled(this.editable);
        this.spectrumSynthesisCmb.setEnabled(this.editable);
        this.modificationComplexityTxt.setEnabled(this.editable);
    }

    private void setAllModificationTableProperties() {
        this.modificationsTable.getColumn(" ").setCellRenderer((TableCellRenderer)new JSparklinesColorTableCellRenderer());
        this.modificationsTable.getColumn(" ").setMaxWidth(35);
        this.modificationsTable.getColumn(" ").setMinWidth(35);
        this.modificationsTable.getColumn("Mass").setMaxWidth(100);
        this.modificationsTable.getColumn("Mass").setMinWidth(100);
        this.modificationsTable.getColumn("F").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        this.modificationsTable.getColumn("V").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        this.modificationsTable.getColumn("F").setMaxWidth(30);
        this.modificationsTable.getColumn("F").setMinWidth(30);
        this.modificationsTable.getColumn("V").setMaxWidth(30);
        this.modificationsTable.getColumn("V").setMinWidth(30);
    }

    private void populateGUI(XtandemParameters xtandemParameters) {
        this.dynamicRangeTxt.setText(xtandemParameters.getDynamicRange() + "");
        this.nPeaksTxt.setText(xtandemParameters.getnPeaks() + "");
        this.minFragmentMzTxt.setText(xtandemParameters.getMinFragmentMz() + "");
        this.minPeaksTxt.setText(xtandemParameters.getMinPeaksPerSpectrum() + "");
        if (xtandemParameters.isUseNoiseSuppression()) {
            this.noiseSuppressionCmb.setSelectedIndex(0);
            this.minPrecMassTxt.setEnabled(true);
        } else {
            this.noiseSuppressionCmb.setSelectedIndex(1);
            this.minPrecMassTxt.setEnabled(false);
        }
        this.minPrecMassTxt.setText(xtandemParameters.getMinPrecursorMass() + "");
        if (xtandemParameters.getParentMonoisotopicMassIsotopeError()) {
            this.parentMonoisotopicMassIsotopeErrorCmb.setSelectedIndex(0);
        } else {
            this.parentMonoisotopicMassIsotopeErrorCmb.setSelectedIndex(1);
        }
        if (xtandemParameters.isProteinQuickAcetyl()) {
            this.quickAcetylCmb.setSelectedIndex(0);
        } else {
            this.quickAcetylCmb.setSelectedIndex(1);
        }
        if (xtandemParameters.isQuickPyrolidone()) {
            this.quickPyroCmb.setSelectedIndex(0);
        } else {
            this.quickPyroCmb.setSelectedIndex(1);
        }
        if (xtandemParameters.isStpBias()) {
            this.stpBiasCmb.setSelectedIndex(0);
        } else {
            this.stpBiasCmb.setSelectedIndex(1);
        }
        if (xtandemParameters.isRefine()) {
            this.refinementCmb.setSelectedIndex(0);
            this.maxEValueRefineTxt.setEnabled(true);
            this.unanticipatedCleavageCmb.setEnabled(true);
            this.semiEnzymaticCmb.setEnabled(true);
            this.potentialModificationsCmb.setEnabled(true);
            this.pointMutationsCmb.setEnabled(true);
            this.snapsCmb.setEnabled(true);
            this.spectrumSynthesisCmb.setEnabled(true);
        } else {
            this.refinementCmb.setSelectedIndex(1);
            this.maxEValueRefineTxt.setEnabled(false);
            this.unanticipatedCleavageCmb.setEnabled(false);
            this.semiEnzymaticCmb.setEnabled(false);
            this.potentialModificationsCmb.setEnabled(false);
            this.pointMutationsCmb.setEnabled(false);
            this.snapsCmb.setEnabled(false);
            this.spectrumSynthesisCmb.setEnabled(false);
        }
        this.maxEValueRefineTxt.setText(xtandemParameters.getMaximumExpectationValueRefinement() + "");
        if (xtandemParameters.isRefineUnanticipatedCleavages()) {
            this.unanticipatedCleavageCmb.setSelectedIndex(0);
        } else {
            this.unanticipatedCleavageCmb.setSelectedIndex(1);
        }
        if (xtandemParameters.isRefineSemi()) {
            this.semiEnzymaticCmb.setSelectedIndex(0);
        } else {
            this.semiEnzymaticCmb.setSelectedIndex(1);
        }
        if (xtandemParameters.isPotentialModificationsForFullRefinment()) {
            this.potentialModificationsCmb.setSelectedIndex(0);
        } else {
            this.potentialModificationsCmb.setSelectedIndex(1);
        }
        if (xtandemParameters.isRefinePointMutations()) {
            this.pointMutationsCmb.setSelectedIndex(0);
        } else {
            this.pointMutationsCmb.setSelectedIndex(1);
        }
        if (xtandemParameters.isRefineSnaps()) {
            this.snapsCmb.setSelectedIndex(0);
        } else {
            this.snapsCmb.setSelectedIndex(1);
        }
        if (xtandemParameters.isRefineSpectrumSynthesis()) {
            this.spectrumSynthesisCmb.setSelectedIndex(0);
        } else {
            this.spectrumSynthesisCmb.setSelectedIndex(1);
        }
        this.eValueTxt.setText(xtandemParameters.getMaxEValue() + "");
        if (xtandemParameters.isOutputProteins()) {
            this.outputProteinsCmb.setSelectedIndex(0);
            this.outputSequencesCmb.setEnabled(true);
            if (xtandemParameters.isOutputSequences()) {
                this.outputSequencesCmb.setSelectedIndex(0);
            } else {
                this.outputSequencesCmb.setSelectedIndex(1);
            }
        } else {
            this.outputProteinsCmb.setSelectedIndex(1);
            this.outputSequencesCmb.setEnabled(false);
            this.outputSequencesCmb.setSelectedIndex(1);
        }
        this.outputResultsCmb.setSelectedItem(xtandemParameters.getOutputResults());
        if (xtandemParameters.isOutputSpectra()) {
            this.outputSpectraCmb.setSelectedIndex(0);
        } else {
            this.outputSpectraCmb.setSelectedIndex(1);
        }
        if (xtandemParameters.isOutputHistograms()) {
            this.outputHistogramsCmb.setSelectedIndex(0);
        } else {
            this.outputHistogramsCmb.setSelectedIndex(1);
        }
        if (xtandemParameters.getSkylinePath() != null) {
            this.skylineTxt.setText(xtandemParameters.getSkylinePath() + "");
        }
        this.modificationComplexityTxt.setText(xtandemParameters.getProteinPtmComplexity() + "");
        this.updateModificationList();
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public IdentificationAlgorithmParameter getParameters() {
        return this.getInput();
    }

    public XtandemParameters getInput() {
        XtandemParameters result = new XtandemParameters();
        String input = this.dynamicRangeTxt.getText().trim();
        if (!input.equals("")) {
            result.setDynamicRange(Double.valueOf(input));
        }
        if (!(input = this.nPeaksTxt.getText().trim()).equals("")) {
            result.setnPeaks(Integer.valueOf(input));
        }
        if (!(input = this.minFragmentMzTxt.getText().trim()).equals("")) {
            result.setMinFragmentMz(Double.valueOf(input));
        }
        if (!(input = this.minPeaksTxt.getText().trim()).equals("")) {
            result.setMinPeaksPerSpectrum(Integer.valueOf(input));
        }
        result.setUseNoiseSuppression(this.noiseSuppressionCmb.getSelectedIndex() == 0);
        input = this.minPrecMassTxt.getText().trim();
        if (!input.equals("")) {
            result.setMinPrecursorMass(Double.valueOf(input));
        }
        result.setParentMonoisotopicMassIsotopeError(this.parentMonoisotopicMassIsotopeErrorCmb.getSelectedIndex() == 0);
        result.setProteinQuickAcetyl(this.quickAcetylCmb.getSelectedIndex() == 0);
        result.setQuickPyrolidone(this.quickPyroCmb.getSelectedIndex() == 0);
        result.setStpBias(this.stpBiasCmb.getSelectedIndex() == 0);
        result.setRefine(this.refinementCmb.getSelectedIndex() == 0);
        input = this.maxEValueRefineTxt.getText().trim();
        if (!input.equals("")) {
            result.setMaximumExpectationValueRefinement(Double.valueOf(input));
        }
        result.setRefineUnanticipatedCleavages(this.unanticipatedCleavageCmb.getSelectedIndex() == 0);
        result.setRefineSemi(this.semiEnzymaticCmb.getSelectedIndex() == 0);
        result.setPotentialModificationsForFullRefinment(this.potentialModificationsCmb.getSelectedIndex() == 0);
        result.setRefinePointMutations(this.pointMutationsCmb.getSelectedIndex() == 0);
        result.setRefineSnaps(this.snapsCmb.getSelectedIndex() == 0);
        result.setRefineSpectrumSynthesis(this.spectrumSynthesisCmb.getSelectedIndex() == 0);
        input = this.eValueTxt.getText().trim();
        if (!input.equals("")) {
            result.setMaxEValue(Double.valueOf(input));
        }
        result.setOutputResults((String)this.outputResultsCmb.getSelectedItem());
        result.setOutputProteins(this.outputProteinsCmb.getSelectedIndex() == 0);
        result.setOutputSequences(this.outputSequencesCmb.getSelectedIndex() == 0);
        result.setOutputSpectra(this.outputSpectraCmb.getSelectedIndex() == 0);
        result.setOutputHistograms(this.outputHistogramsCmb.getSelectedIndex() == 0);
        input = this.skylineTxt.getText().trim();
        if (!input.equals("")) {
            result.setSkylinePath(input);
        }
        if (!(input = this.modificationComplexityTxt.getText().trim()).equals("")) {
            result.setProteinPtmComplexity(Double.valueOf(input));
        }
        return result;
    }

    public ModificationParameters getModificationProfile() {
        return this.modificationProfile;
    }

    public boolean modProfileEdited() {
        return this.modProfileChanged;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.spectrumImportSettingsPanel = new JPanel();
        this.dynamicRangeLbl = new JLabel();
        this.dynamicRangeTxt = new JTextField();
        this.nPeaksTxt = new JTextField();
        this.nPeaksLbl = new JLabel();
        this.minFragMzLbl = new JLabel();
        this.minFragmentMzTxt = new JTextField();
        this.minPeaksLbl = new JLabel();
        this.minPeaksTxt = new JTextField();
        this.minPrecMassLbl = new JLabel();
        this.minPrecMassTxt = new JTextField();
        this.noiseSuppressionCmb = new JComboBox();
        this.noiseSuppressionLabel = new JLabel();
        this.parentMonoisotopicMassIsotopeErrorLabel = new JLabel();
        this.parentMonoisotopicMassIsotopeErrorCmb = new JComboBox();
        this.advancedSearchSettingsPanel = new JPanel();
        this.quickPyroCmb = new JComboBox();
        this.quickAcetylCmb = new JComboBox();
        this.quickAcetylLabel = new JLabel();
        this.quickPyroLabel = new JLabel();
        this.stpBiasLabel = new JLabel();
        this.stpBiasCmb = new JComboBox();
        this.modificationComplexityLbl = new JLabel();
        this.modificationComplexityTxt = new JTextField();
        this.outputSettingsPanel = new JPanel();
        this.eValueLbl = new JLabel();
        this.eValueTxt = new JTextField();
        this.outputSequencesLabel = new JLabel();
        this.outputSequencesCmb = new JComboBox();
        this.outputProteinsCmb = new JComboBox();
        this.outputProteinsLabel = new JLabel();
        this.outputSpectraLabel = new JLabel();
        this.outputSpectraCmb = new JComboBox();
        this.skylineTxt = new JTextField();
        this.skylinePathValueLbl = new JLabel();
        this.outputHistogramsCmb = new JComboBox();
        this.outputHistogramsLabel = new JLabel();
        this.outputResultsLabel = new JLabel();
        this.outputResultsCmb = new JComboBox();
        this.refinementSettingsPanel = new JPanel();
        this.refinementCmb = new JComboBox();
        this.refinementLabel = new JLabel();
        this.semiEnzymaticLabel = new JLabel();
        this.semiEnzymaticCmb = new JComboBox();
        this.maxEValueRefineTxt = new JTextField();
        this.maxEValueRefinmentLbl = new JLabel();
        this.pointMutationLabel = new JLabel();
        this.pointMutationsCmb = new JComboBox();
        this.snapsLabel = new JLabel();
        this.snapsCmb = new JComboBox();
        this.spectrumSynthesisCmb = new JComboBox();
        this.spectrumSynthesisLabel = new JLabel();
        this.unanticipatedCleavageCmb = new JComboBox();
        this.unanticipatedCleavageLabel = new JLabel();
        this.usePotentialModsLabel = new JLabel();
        this.potentialModificationsCmb = new JComboBox();
        this.refinementModificationsJPanel = new JPanel();
        this.refinementModificationsLabel = new JLabel();
        this.openModificationSettingsJButton = new JButton();
        this.modificationsJScrollPane = new JScrollPane();
        this.modificationsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)XTandemParametersDialog.this.modificationTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.openDialogHelpJButton = new JButton();
        this.advancedSettingsWarningLabel = new JLabel();
        this.okButton = new JButton();
        this.closeButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle("X!Tandem Advanced Settings");
        this.setMinimumSize(new Dimension(600, 550));
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.tabbedPane.setBackground(new Color(230, 230, 230));
        this.tabbedPane.setOpaque(true);
        this.spectrumImportSettingsPanel.setBackground(new Color(230, 230, 230));
        this.dynamicRangeLbl.setText("Spectrum Dynamic Range    (?)");
        this.dynamicRangeLbl.setToolTipText("Open X!Tandem parameter details");
        this.dynamicRangeLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.dynamicRangeLblMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.dynamicRangeLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.dynamicRangeLblMouseExited(evt);
            }
        });
        this.dynamicRangeTxt.setHorizontalAlignment(0);
        this.dynamicRangeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                XTandemParametersDialog.this.dynamicRangeTxtKeyReleased(evt);
            }
        });
        this.nPeaksTxt.setHorizontalAlignment(0);
        this.nPeaksTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                XTandemParametersDialog.this.nPeaksTxtKeyReleased(evt);
            }
        });
        this.nPeaksLbl.setText("Number of Peaks    (?)");
        this.nPeaksLbl.setToolTipText("Open X!Tandem parameter details");
        this.nPeaksLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.nPeaksLblMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.nPeaksLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.nPeaksLblMouseExited(evt);
            }
        });
        this.minFragMzLbl.setText("Minimum Fragment m/z    (?)");
        this.minFragMzLbl.setToolTipText("Open X!Tandem parameter details");
        this.minFragMzLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.minFragMzLblMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.minFragMzLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.minFragMzLblMouseExited(evt);
            }
        });
        this.minFragmentMzTxt.setHorizontalAlignment(0);
        this.minFragmentMzTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                XTandemParametersDialog.this.minFragmentMzTxtKeyReleased(evt);
            }
        });
        this.minPeaksLbl.setText("Minimum Peaks    (?)");
        this.minPeaksLbl.setToolTipText("Open X!Tandem parameter details");
        this.minPeaksLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.minPeaksLblMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.minPeaksLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.minPeaksLblMouseExited(evt);
            }
        });
        this.minPeaksTxt.setHorizontalAlignment(0);
        this.minPeaksTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                XTandemParametersDialog.this.minPeaksTxtKeyReleased(evt);
            }
        });
        this.minPrecMassLbl.setText("Minimum Precursor Mass    (?)");
        this.minPrecMassLbl.setToolTipText("Open X!Tandem parameter details");
        this.minPrecMassLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.minPrecMassLblMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.minPrecMassLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.minPrecMassLblMouseExited(evt);
            }
        });
        this.minPrecMassTxt.setHorizontalAlignment(0);
        this.minPrecMassTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                XTandemParametersDialog.this.minPrecMassTxtKeyReleased(evt);
            }
        });
        this.noiseSuppressionCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.noiseSuppressionCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemParametersDialog.this.noiseSuppressionCmbActionPerformed(evt);
            }
        });
        this.noiseSuppressionLabel.setText("Noise Suppression    (?)");
        this.noiseSuppressionLabel.setToolTipText("Open X!Tandem parameter details");
        this.noiseSuppressionLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.noiseSuppressionLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.noiseSuppressionLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.noiseSuppressionLabelMouseReleased(evt);
            }
        });
        this.parentMonoisotopicMassIsotopeErrorLabel.setText("Parent Isotope Expansion (?)");
        this.parentMonoisotopicMassIsotopeErrorLabel.setToolTipText("Open X!Tandem parameter details");
        this.parentMonoisotopicMassIsotopeErrorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.parentMonoisotopicMassIsotopeErrorLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.parentMonoisotopicMassIsotopeErrorLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.parentMonoisotopicMassIsotopeErrorLabelMouseReleased(evt);
            }
        });
        this.parentMonoisotopicMassIsotopeErrorCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        GroupLayout spectrumImportSettingsPanelLayout = new GroupLayout(this.spectrumImportSettingsPanel);
        this.spectrumImportSettingsPanel.setLayout(spectrumImportSettingsPanelLayout);
        spectrumImportSettingsPanelLayout.setHorizontalGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, spectrumImportSettingsPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(spectrumImportSettingsPanelLayout.createSequentialGroup().addComponent(this.parentMonoisotopicMassIsotopeErrorLabel, -2, 265, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.parentMonoisotopicMassIsotopeErrorCmb, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, spectrumImportSettingsPanelLayout.createSequentialGroup().addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minPrecMassLbl, -2, 265, -2).addComponent(this.noiseSuppressionLabel, -2, 265, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minPrecMassTxt).addComponent(this.noiseSuppressionCmb, 0, 294, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.LEADING, spectrumImportSettingsPanelLayout.createSequentialGroup().addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.dynamicRangeLbl, -2, 265, -2).addComponent(this.nPeaksLbl, -2, 265, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nPeaksTxt).addComponent(this.dynamicRangeTxt))).addGroup(GroupLayout.Alignment.LEADING, spectrumImportSettingsPanelLayout.createSequentialGroup().addComponent(this.minPeaksLbl, -2, 265, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minPeaksTxt)).addGroup(GroupLayout.Alignment.LEADING, spectrumImportSettingsPanelLayout.createSequentialGroup().addComponent(this.minFragMzLbl, -2, 265, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minFragmentMzTxt))).addGap(25, 25, 25)));
        spectrumImportSettingsPanelLayout.setVerticalGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumImportSettingsPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dynamicRangeLbl).addComponent(this.dynamicRangeTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nPeaksTxt, -2, -1, -2).addComponent(this.nPeaksLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minFragmentMzTxt, -2, -1, -2).addComponent(this.minFragMzLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPeaksTxt, -2, -1, -2).addComponent(this.minPeaksLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.noiseSuppressionCmb, -2, -1, -2).addComponent(this.noiseSuppressionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPrecMassTxt, -2, -1, -2).addComponent(this.minPrecMassLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.parentMonoisotopicMassIsotopeErrorCmb, -2, -1, -2).addComponent(this.parentMonoisotopicMassIsotopeErrorLabel)).addContainerGap(230, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Spectrum Import", this.spectrumImportSettingsPanel);
        this.advancedSearchSettingsPanel.setBackground(new Color(230, 230, 230));
        this.quickPyroCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.quickPyroCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemParametersDialog.this.quickPyroCmbActionPerformed(evt);
            }
        });
        this.quickAcetylCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.quickAcetylCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemParametersDialog.this.quickAcetylCmbActionPerformed(evt);
            }
        });
        this.quickAcetylLabel.setText("Quick Acetyl    (?)");
        this.quickAcetylLabel.setToolTipText("Open X!Tandem parameter details");
        this.quickAcetylLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.quickAcetylLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.quickAcetylLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.quickAcetylLabelMouseReleased(evt);
            }
        });
        this.quickPyroLabel.setText("Quick Pyrolidone    (?)");
        this.quickPyroLabel.setToolTipText("Open X!Tandem parameter details");
        this.quickPyroLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.quickPyroLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.quickPyroLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.quickPyroLabelMouseExited(evt);
            }
        });
        this.stpBiasLabel.setText("stP bias    (?)");
        this.stpBiasLabel.setToolTipText("Open X!Tandem parameter details");
        this.stpBiasLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.stpBiasLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.stpBiasLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.stpBiasLabelMouseReleased(evt);
            }
        });
        this.stpBiasCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.modificationComplexityLbl.setText("PTM Complexity    (?)");
        this.modificationComplexityLbl.setToolTipText("Open X!Tandem parameter details");
        this.modificationComplexityLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.modificationComplexityLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.modificationComplexityLblMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.modificationComplexityLblMouseReleased(evt);
            }
        });
        this.modificationComplexityTxt.setHorizontalAlignment(0);
        this.modificationComplexityTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                XTandemParametersDialog.this.modificationComplexityTxtKeyReleased(evt);
            }
        });
        GroupLayout advancedSearchSettingsPanelLayout = new GroupLayout(this.advancedSearchSettingsPanel);
        this.advancedSearchSettingsPanel.setLayout(advancedSearchSettingsPanelLayout);
        advancedSearchSettingsPanelLayout.setHorizontalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.modificationComplexityLbl, -2, 265, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modificationComplexityTxt)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.quickPyroLabel, -2, 265, -2).addComponent(this.quickAcetylLabel, -2, 265, -2).addComponent(this.stpBiasLabel, -2, 265, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.quickPyroCmb, 0, 294, Short.MAX_VALUE).addComponent(this.stpBiasCmb, 0, -1, Short.MAX_VALUE).addComponent(this.quickAcetylCmb, 0, -1, Short.MAX_VALUE)))).addGap(25, 25, 25)));
        advancedSearchSettingsPanelLayout.setVerticalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.quickAcetylLabel).addComponent(this.quickAcetylCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.quickPyroCmb, -2, -1, -2).addComponent(this.quickPyroLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stpBiasCmb, -2, -1, -2).addComponent(this.stpBiasLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.modificationComplexityLbl).addComponent(this.modificationComplexityTxt, -2, -1, -2)).addContainerGap(314, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Advanced Search", this.advancedSearchSettingsPanel);
        this.outputSettingsPanel.setBackground(new Color(230, 230, 230));
        this.eValueLbl.setText("E-value Cutoff    (?)");
        this.eValueLbl.setToolTipText("Open X!Tandem parameter details");
        this.eValueLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.eValueLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.eValueLblMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.eValueLblMouseReleased(evt);
            }
        });
        this.eValueTxt.setHorizontalAlignment(0);
        this.eValueTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                XTandemParametersDialog.this.eValueTxtKeyReleased(evt);
            }
        });
        this.outputSequencesLabel.setText("Output Sequences    (?)");
        this.outputSequencesLabel.setToolTipText("Open X!Tandem parameter details");
        this.outputSequencesLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.outputSequencesLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.outputSequencesLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.outputSequencesLabelMouseReleased(evt);
            }
        });
        this.outputSequencesCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.outputProteinsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.outputProteinsCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemParametersDialog.this.outputProteinsCmbActionPerformed(evt);
            }
        });
        this.outputProteinsLabel.setText("Output Proteins    (?)");
        this.outputProteinsLabel.setToolTipText("Open X!Tandem parameter details");
        this.outputProteinsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.outputProteinsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.outputProteinsLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.outputProteinsLabelMouseReleased(evt);
            }
        });
        this.outputSpectraLabel.setText("Output Spectra    (?)");
        this.outputSpectraLabel.setToolTipText("Open X!Tandem parameter details");
        this.outputSpectraLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.outputSpectraLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.outputSpectraLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.outputSpectraLabelMouseReleased(evt);
            }
        });
        this.outputSpectraCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.skylineTxt.setHorizontalAlignment(0);
        this.skylinePathValueLbl.setText("Skyline Path    (?)");
        this.skylinePathValueLbl.setToolTipText("Open X!Tandem parameter details");
        this.skylinePathValueLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.skylinePathValueLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.skylinePathValueLblMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.skylinePathValueLblMouseReleased(evt);
            }
        });
        this.outputHistogramsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.outputHistogramsLabel.setText("Output Histograms    (?)");
        this.outputHistogramsLabel.setToolTipText("Open X!Tandem parameter details");
        this.outputHistogramsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.outputHistogramsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.outputHistogramsLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.outputHistogramsLabelMouseReleased(evt);
            }
        });
        this.outputResultsLabel.setText("Output Results    (?)");
        this.outputResultsLabel.setToolTipText("Open X!Tandem parameter details");
        this.outputResultsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.outputResultsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.outputResultsLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.outputResultsLabelMouseReleased(evt);
            }
        });
        this.outputResultsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"all", "valid", "stochastic"}));
        this.outputResultsCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemParametersDialog.this.outputResultsCmbActionPerformed(evt);
            }
        });
        GroupLayout outputSettingsPanelLayout = new GroupLayout(this.outputSettingsPanel);
        this.outputSettingsPanel.setLayout(outputSettingsPanelLayout);
        outputSettingsPanelLayout.setHorizontalGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, outputSettingsPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.eValueLbl, -2, 265, -2).addComponent(this.outputResultsLabel, -2, 265, -2).addComponent(this.outputProteinsLabel, -2, 265, -2).addComponent(this.outputSequencesLabel, -2, 265, -2).addComponent(this.outputSpectraLabel, -2, 265, -2).addComponent(this.skylinePathValueLbl, -2, 265, -2).addComponent(this.outputHistogramsLabel, -2, 265, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputResultsCmb, 0, -1, Short.MAX_VALUE).addComponent(this.eValueTxt).addComponent(this.skylineTxt).addComponent(this.outputProteinsCmb, GroupLayout.Alignment.TRAILING, 0, 294, Short.MAX_VALUE).addComponent(this.outputSequencesCmb, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.outputSpectraCmb, 0, -1, Short.MAX_VALUE).addComponent(this.outputHistogramsCmb, 0, -1, Short.MAX_VALUE)).addGap(25, 25, 25)));
        outputSettingsPanelLayout.setVerticalGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputSettingsPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputResultsLabel).addComponent(this.outputResultsCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.eValueLbl).addComponent(this.eValueTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputProteinsLabel).addComponent(this.outputProteinsCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputSequencesCmb, -2, -1, -2).addComponent(this.outputSequencesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputSpectraCmb, -2, -1, -2).addComponent(this.outputSpectraLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputHistogramsCmb, -2, -1, -2).addComponent(this.outputHistogramsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.skylinePathValueLbl).addComponent(this.skylineTxt, -2, -1, -2)).addContainerGap(236, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Output", this.outputSettingsPanel);
        this.refinementSettingsPanel.setBackground(new Color(230, 230, 230));
        this.refinementCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.refinementCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemParametersDialog.this.refinementCmbActionPerformed(evt);
            }
        });
        this.refinementLabel.setText("Refinement    (?)");
        this.refinementLabel.setToolTipText("Open X!Tandem parameter details");
        this.refinementLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.refinementLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.refinementLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.refinementLabelMouseReleased(evt);
            }
        });
        this.semiEnzymaticLabel.setText("Semi-Enzymatic Cleavage    (?)");
        this.semiEnzymaticLabel.setToolTipText("Open X!Tandem parameter details");
        this.semiEnzymaticLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.semiEnzymaticLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.semiEnzymaticLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.semiEnzymaticLabelMouseExited(evt);
            }
        });
        this.semiEnzymaticCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.maxEValueRefineTxt.setHorizontalAlignment(0);
        this.maxEValueRefineTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                XTandemParametersDialog.this.maxEValueRefineTxtKeyReleased(evt);
            }
        });
        this.maxEValueRefinmentLbl.setText("Maximum Valid Expectation Value    (?)");
        this.maxEValueRefinmentLbl.setToolTipText("Open X!Tandem parameter details");
        this.maxEValueRefinmentLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.maxEValueRefinmentLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.maxEValueRefinmentLblMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.maxEValueRefinmentLblMouseReleased(evt);
            }
        });
        this.pointMutationLabel.setText("Point Mutations    (?)");
        this.pointMutationLabel.setToolTipText("Open X!Tandem parameter details");
        this.pointMutationLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.pointMutationLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.pointMutationLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.pointMutationLabelMouseExited(evt);
            }
        });
        this.pointMutationsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.snapsLabel.setText("snAPs    (?)");
        this.snapsLabel.setToolTipText("Open X!Tandem parameter details");
        this.snapsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.snapsLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.snapsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.snapsLabelMouseExited(evt);
            }
        });
        this.snapsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.spectrumSynthesisCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.spectrumSynthesisLabel.setText("Spectrum Synthesis    (?)");
        this.spectrumSynthesisLabel.setToolTipText("Open X!Tandem parameter details");
        this.spectrumSynthesisLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.spectrumSynthesisLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.spectrumSynthesisLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.spectrumSynthesisLabelMouseExited(evt);
            }
        });
        this.unanticipatedCleavageCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.unanticipatedCleavageLabel.setText("Unanticipated Cleavage    (?)");
        this.unanticipatedCleavageLabel.setToolTipText("Open X!Tandem parameter details");
        this.unanticipatedCleavageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.unanticipatedCleavageLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.unanticipatedCleavageLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.unanticipatedCleavageLabelMouseExited(evt);
            }
        });
        this.usePotentialModsLabel.setText("Potential Modifications for Full Refinement    (?)");
        this.usePotentialModsLabel.setToolTipText("Open X!Tandem parameter details");
        this.usePotentialModsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.usePotentialModsLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.usePotentialModsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.usePotentialModsLabelMouseExited(evt);
            }
        });
        this.potentialModificationsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.refinementModificationsJPanel.setOpaque(false);
        this.refinementModificationsLabel.setText("Refinement Modifications    (?)");
        this.refinementModificationsLabel.setToolTipText("Open X!Tandem parameter details");
        this.refinementModificationsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.refinementModificationsLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.refinementModificationsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.refinementModificationsLabelMouseExited(evt);
            }
        });
        this.openModificationSettingsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.openModificationSettingsJButton.setToolTipText("Edit Modifications");
        this.openModificationSettingsJButton.setBorder(null);
        this.openModificationSettingsJButton.setBorderPainted(false);
        this.openModificationSettingsJButton.setContentAreaFilled(false);
        this.openModificationSettingsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.openModificationSettingsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.openModificationSettingsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.openModificationSettingsJButtonMouseExited(evt);
            }
        });
        this.openModificationSettingsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemParametersDialog.this.openModificationSettingsJButtonActionPerformed(evt);
            }
        });
        this.modificationsJScrollPane.setPreferredSize(new Dimension(100, 60));
        this.modificationsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Name", "Mass", "V", "F"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class, Double.class, Boolean.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.modificationsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                XTandemParametersDialog.this.modificationsTableMouseMoved(evt);
            }
        });
        this.modificationsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.modificationsTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemParametersDialog.this.modificationsTableMouseReleased(evt);
            }
        });
        this.modificationsJScrollPane.setViewportView(this.modificationsTable);
        GroupLayout refinementModificationsJPanelLayout = new GroupLayout(this.refinementModificationsJPanel);
        this.refinementModificationsJPanel.setLayout(refinementModificationsJPanelLayout);
        refinementModificationsJPanelLayout.setHorizontalGroup(refinementModificationsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(refinementModificationsJPanelLayout.createSequentialGroup().addComponent(this.refinementModificationsLabel, -1, 296, Short.MAX_VALUE).addGap(246, 246, 246).addComponent(this.openModificationSettingsJButton).addGap(2, 2, 2)).addComponent(this.modificationsJScrollPane, -1, -1, Short.MAX_VALUE));
        refinementModificationsJPanelLayout.setVerticalGroup(refinementModificationsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(refinementModificationsJPanelLayout.createSequentialGroup().addGroup(refinementModificationsJPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.refinementModificationsLabel).addComponent(this.openModificationSettingsJButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modificationsJScrollPane, -1, 145, Short.MAX_VALUE).addContainerGap()));
        GroupLayout refinementSettingsPanelLayout = new GroupLayout(this.refinementSettingsPanel);
        this.refinementSettingsPanel.setLayout(refinementSettingsPanelLayout);
        refinementSettingsPanelLayout.setHorizontalGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(refinementSettingsPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.refinementModificationsJPanel, -1, -1, Short.MAX_VALUE).addGroup(refinementSettingsPanelLayout.createSequentialGroup().addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.refinementLabel, -2, 265, -2).addComponent(this.maxEValueRefinmentLbl, -2, 265, -2).addComponent(this.unanticipatedCleavageLabel, -2, 265, -2).addComponent(this.semiEnzymaticLabel, -2, 265, -2).addComponent(this.usePotentialModsLabel, -2, 265, -2).addComponent(this.pointMutationLabel, -2, 265, -2).addComponent(this.snapsLabel, -2, 265, -2).addComponent(this.spectrumSynthesisLabel, -2, 265, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spectrumSynthesisCmb, 0, -1, Short.MAX_VALUE).addComponent(this.snapsCmb, 0, -1, Short.MAX_VALUE).addComponent(this.pointMutationsCmb, 0, -1, Short.MAX_VALUE).addComponent(this.potentialModificationsCmb, 0, -1, Short.MAX_VALUE).addComponent(this.semiEnzymaticCmb, 0, -1, Short.MAX_VALUE).addComponent(this.unanticipatedCleavageCmb, 0, -1, Short.MAX_VALUE).addComponent(this.maxEValueRefineTxt).addComponent(this.refinementCmb, 0, -1, Short.MAX_VALUE)))).addGap(25, 25, 25)));
        refinementSettingsPanelLayout.setVerticalGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(refinementSettingsPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.refinementCmb, -2, -1, -2).addComponent(this.refinementLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxEValueRefineTxt, -2, -1, -2).addComponent(this.maxEValueRefinmentLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.unanticipatedCleavageCmb, -2, -1, -2).addComponent(this.unanticipatedCleavageLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.semiEnzymaticCmb, -2, -1, -2).addComponent(this.semiEnzymaticLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.potentialModificationsCmb, -2, -1, -2).addComponent(this.usePotentialModsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pointMutationsCmb, -2, -1, -2).addComponent(this.pointMutationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.snapsCmb, -2, -1, -2).addComponent(this.snapsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spectrumSynthesisCmb, -2, -1, -2).addComponent(this.spectrumSynthesisLabel)).addGap(18, 18, 18).addComponent(this.refinementModificationsJPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.tabbedPane.addTab("Refinement", this.refinementSettingsPanel);
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemParametersDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemParametersDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemParametersDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.advancedSettingsWarningLabel.setText("Note: The advanced settings are for expert use only. See the help for details.");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemParametersDialog.this.closeButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1)).addGroup(GroupLayout.Alignment.LEADING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane)).addGroup(GroupLayout.Alignment.LEADING, backgroundPanelLayout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.openDialogHelpJButton).addGap(18, 18, 18).addComponent(this.advancedSettingsWarningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.okButton).addComponent(this.closeButton).addComponent(this.advancedSettingsWarningLabel)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            this.dispose();
        }
    }

    private void outputProteinsCmbActionPerformed(ActionEvent evt) {
        if (this.outputProteinsCmb.getSelectedIndex() == 0) {
            this.outputSequencesCmb.setEnabled(true);
        } else {
            this.outputSequencesCmb.setSelectedIndex(1);
            this.outputSequencesCmb.setEnabled(false);
        }
    }

    private void eValueTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxEValueRefineTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void refinementCmbActionPerformed(ActionEvent evt) {
        if (this.refinementCmb.getSelectedIndex() == 0) {
            this.maxEValueRefineTxt.setEnabled(true);
            this.unanticipatedCleavageCmb.setEnabled(true);
            this.semiEnzymaticCmb.setEnabled(true);
            this.potentialModificationsCmb.setEnabled(true);
            this.pointMutationsCmb.setEnabled(true);
            this.snapsCmb.setEnabled(true);
            this.spectrumSynthesisCmb.setEnabled(true);
        } else {
            this.maxEValueRefineTxt.setEnabled(false);
            this.unanticipatedCleavageCmb.setEnabled(false);
            this.semiEnzymaticCmb.setEnabled(false);
            this.potentialModificationsCmb.setEnabled(false);
            this.pointMutationsCmb.setEnabled(false);
            this.snapsCmb.setEnabled(false);
            this.spectrumSynthesisCmb.setEnabled(false);
        }
    }

    private void quickAcetylCmbActionPerformed(ActionEvent evt) {
        if (this.quickAcetylCmb.getSelectedIndex() == 0) {
            for (String modName : this.modificationProfile.getFixedModifications()) {
                Modification modification = this.modificationFactory.getModification(modName);
                if (modification.getModificationType() != ModificationType.modn_peptide && modification.getModificationType() != ModificationType.modnaa_peptide && modification.getModificationType() != ModificationType.modn_protein && modification.getModificationType() != ModificationType.modnaa_protein || !(Math.abs(modification.getMass() - 42.010565) < this.fragmentIonMassAccuracyInDa)) continue;
                JOptionPane.showMessageDialog(this, "The quick acetyl option might conflict with " + modName + ".", "Modification Conflict", 0);
                this.quickAcetylCmb.setSelectedIndex(1);
                break;
            }
        }
    }

    private void quickPyroCmbActionPerformed(ActionEvent evt) {
        if (this.quickPyroCmb.getSelectedIndex() == 0) {
            for (String modName : this.modificationProfile.getFixedModifications()) {
                Modification modification = this.modificationFactory.getModification(modName);
                if (modification.getModificationType() != ModificationType.modn_peptide && modification.getModificationType() != ModificationType.modnaa_peptide && modification.getModificationType() != ModificationType.modn_protein && modification.getModificationType() != ModificationType.modnaa_protein || !(Math.abs(modification.getMass() + 17.026549) < this.fragmentIonMassAccuracyInDa)) continue;
                JOptionPane.showMessageDialog(this, "The quick pyrolidone option might conflict with " + modName + ".", "Modification Conflict", 0);
                this.quickAcetylCmb.setSelectedIndex(1);
                break;
            }
        }
    }

    private void noiseSuppressionCmbActionPerformed(ActionEvent evt) {
        if (this.noiseSuppressionCmb.getSelectedIndex() == 0) {
            this.minPrecMassTxt.setEnabled(true);
        } else {
            this.minPrecMassTxt.setEnabled(false);
        }
    }

    private void minPrecMassTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minPeaksTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minFragmentMzTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void nPeaksTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void dynamicRangeTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void dynamicRangeLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void dynamicRangeLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void dynamicRangeLblMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/sdr.html");
        this.setCursor(new Cursor(0));
    }

    private void minFragMzLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void minFragMzLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void minFragMzLblMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/smfmz.html");
        this.setCursor(new Cursor(0));
    }

    private void nPeaksLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void nPeaksLblMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/stp.html");
        this.setCursor(new Cursor(0));
    }

    private void nPeaksLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void minPeaksLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void minPeaksLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void minPeaksLblMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/smp.html");
        this.setCursor(new Cursor(0));
    }

    private void noiseSuppressionLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void noiseSuppressionLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void noiseSuppressionLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/suns.html");
        this.setCursor(new Cursor(0));
    }

    private void minPrecMassLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void minPrecMassLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void minPrecMassLblMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/smpmh.html");
        this.setCursor(new Cursor(0));
    }

    private void quickAcetylLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void quickAcetylLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void quickAcetylLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/pqa.html");
        this.setCursor(new Cursor(0));
    }

    private void quickPyroLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void quickPyroLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void quickPyroLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/pqp.html");
        this.setCursor(new Cursor(0));
    }

    private void stpBiasLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void stpBiasLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void stpBiasLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/pstpb.html");
        this.setCursor(new Cursor(0));
    }

    private void eValueLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void eValueLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void eValueLblMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/omvev.html");
        this.setCursor(new Cursor(0));
    }

    private void outputProteinsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void outputProteinsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void outputProteinsLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/oprot.html");
        this.setCursor(new Cursor(0));
    }

    private void outputSequencesLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void outputSequencesLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void outputSequencesLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/osequ.html");
        this.setCursor(new Cursor(0));
    }

    private void outputSpectraLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void outputSpectraLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void outputSpectraLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/ospec.html");
        this.setCursor(new Cursor(0));
    }

    private void outputHistogramsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void outputHistogramsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void outputHistogramsLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/ohist.html");
        this.setCursor(new Cursor(0));
    }

    private void skylinePathValueLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void skylinePathValueLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void skylinePathValueLblMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/ssp.html");
        this.setCursor(new Cursor(0));
    }

    private void refinementLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void refinementLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void refinementLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/refine.html");
        this.setCursor(new Cursor(0));
    }

    private void maxEValueRefinmentLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void maxEValueRefinmentLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void maxEValueRefinmentLblMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/refmvev.html");
        this.setCursor(new Cursor(0));
    }

    private void unanticipatedCleavageLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void unanticipatedCleavageLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void unanticipatedCleavageLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/ruc.html");
        this.setCursor(new Cursor(0));
    }

    private void semiEnzymaticLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void semiEnzymaticLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void semiEnzymaticLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/rcsemi.html");
        this.setCursor(new Cursor(0));
    }

    private void usePotentialModsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void usePotentialModsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void usePotentialModsLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/rupmffr.html");
        this.setCursor(new Cursor(0));
    }

    private void pointMutationLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void pointMutationLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void pointMutationLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/rpm.html");
        this.setCursor(new Cursor(0));
    }

    private void snapsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void snapsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void snapsLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/rsaps.html");
        this.setCursor(new Cursor(0));
    }

    private void spectrumSynthesisLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void spectrumSynthesisLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void spectrumSynthesisLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/rss.html");
        this.setCursor(new Cursor(0));
    }

    private void modificationsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void modificationsTableMouseReleased(MouseEvent evt) {
        int row = this.modificationsTable.rowAtPoint(evt.getPoint());
        int column = this.modificationsTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == this.modificationsTable.getColumn(" ").getModelIndex()) {
                Color newColor = JColorChooser.showDialog(this, "Pick a Color", (Color)this.modificationsTable.getValueAt(row, column));
                if (newColor != null) {
                    this.modificationFactory.setColor((String)this.modificationsTable.getValueAt(row, 1), newColor.getRGB());
                    this.modificationsTable.setValueAt(newColor, row, 0);
                    ((DefaultTableModel)this.modificationsTable.getModel()).fireTableDataChanged();
                    this.modificationsTable.repaint();
                }
            } else if (column == this.modificationsTable.getColumn("V").getModelIndex() && this.modificationsTable.getValueAt(row, column) != null) {
                boolean selected = (Boolean)this.modificationsTable.getValueAt(row, column);
                String modificationName = (String)this.modificationsTable.getValueAt(row, 1);
                if (selected) {
                    if (!this.modificationProfile.getRefinementVariableModifications().contains(modificationName)) {
                        this.modificationProfile.addRefinementVariableModification(this.modificationFactory.getModification(modificationName));
                        this.modProfileChanged = true;
                    }
                } else {
                    this.modificationProfile.removeRefinementVariableModification(modificationName);
                    this.modProfileChanged = true;
                }
                this.updateModificationList();
                if (row < this.modificationsTable.getRowCount()) {
                    this.modificationsTable.setRowSelectionInterval(row, row);
                } else if (row - 1 < this.modificationsTable.getRowCount() && row >= 0) {
                    this.modificationsTable.setRowSelectionInterval(row - 1, row - 1);
                }
            } else if (column == this.modificationsTable.getColumn("F").getModelIndex() && this.modificationsTable.getValueAt(row, column) != null) {
                boolean selected = (Boolean)this.modificationsTable.getValueAt(row, column);
                String modificationName = (String)this.modificationsTable.getValueAt(row, 1);
                if (selected) {
                    if (!this.modificationProfile.getRefinementFixedModifications().contains(modificationName)) {
                        this.modificationProfile.addRefinementFixedModification(this.modificationFactory.getModification(modificationName));
                        this.modProfileChanged = true;
                    }
                } else {
                    this.modificationProfile.removeRefinementFixedModification(modificationName);
                    this.modProfileChanged = true;
                }
                this.updateModificationList();
                if (row < this.modificationsTable.getRowCount()) {
                    this.modificationsTable.setRowSelectionInterval(row, row);
                } else if (row - 1 < this.modificationsTable.getRowCount() && row >= 0) {
                    this.modificationsTable.setRowSelectionInterval(row - 1, row - 1);
                }
            }
        }
    }

    private void modificationsTableMouseMoved(MouseEvent evt) {
        int row = this.modificationsTable.rowAtPoint(evt.getPoint());
        int column = this.modificationsTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == this.modificationsTable.getColumn(" ").getModelIndex()) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void openModificationSettingsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openModificationSettingsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openModificationSettingsJButtonActionPerformed(ActionEvent evt) {
        new ModificationsDialog((Frame)this.getParent(), true);
        this.updateModificationList();
    }

    private void refinementModificationsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void refinementModificationsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void refinementModificationsLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/refpmm.html");
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/XTandemSettingsDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")), "X! Tandem - Help", 500, 50);
        this.setCursor(new Cursor(0));
    }

    private void outputResultsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void outputResultsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void outputResultsLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/api/oresu.html");
        this.setCursor(new Cursor(0));
    }

    private void outputResultsCmbActionPerformed(ActionEvent evt) {
        this.eValueTxt.setEnabled(!((String)this.outputResultsCmb.getSelectedItem()).equalsIgnoreCase("all"));
    }

    private void modificationComplexityLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void modificationComplexityLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void modificationComplexityLblMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/TANDEM/release.html");
        this.setCursor(new Cursor(0));
    }

    private void modificationComplexityTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void parentMonoisotopicMassIsotopeErrorLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void parentMonoisotopicMassIsotopeErrorLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void parentMonoisotopicMassIsotopeErrorLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.thegpm.org/tandem/api/spmmie.html");
        this.setCursor(new Cursor(0));
    }

    public boolean validateInput(boolean showMessage) {
        boolean valid = true;
        valid = GuiUtilities.validateDoubleInput(this, this.eValueLbl, this.eValueTxt, "e-value cutoff", "E-value Cutoff Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.dynamicRangeLbl, this.dynamicRangeTxt, "dynamic range cutoff", "Dynamic Range Cutoff Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.nPeaksLbl, this.nPeaksTxt, "number of peaks", "Number of Peaks Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.minFragMzLbl, this.minFragmentMzTxt, "minimal fragment m/z", "Minimal Fragment MZ Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.minPeaksLbl, this.minPeaksTxt, "minimal number of peaks", "Minimal Number of Peaks Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.minPrecMassLbl, this.minPrecMassTxt, "minimal precursor mass", "Minimal Precursor Mass Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.maxEValueRefinmentLbl, this.maxEValueRefineTxt, "maximal e-value for the refinement", "Maximal Refinement E-Value Error", true, showMessage, valid);
        if (valid = GuiUtilities.validateDoubleInput(this, this.modificationComplexityLbl, this.modificationComplexityTxt, "PTM complexity", "PTM Complexity Error", true, showMessage, valid)) {
            try {
                Double value = Double.valueOf(this.modificationComplexityTxt.getText());
                if (value > 12.0) {
                    if (showMessage && valid) {
                        JOptionPane.showMessageDialog(this, "Please select a number in the range (0.0-12.0) for Modification complexity.", "Modification Complexity Error", 2);
                    }
                    valid = false;
                    this.modificationComplexityLbl.setForeground(Color.RED);
                    this.modificationComplexityLbl.setToolTipText("Please select a number in the range (0.0-12.0)");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.okButton.setEnabled(valid);
        return valid;
    }

    private void updateModificationList() {
        ArrayList<String> allModificationsList = this.modificationFactory.getModifications();
        Object[] allModificationsAsArray = new String[allModificationsList.size()];
        for (int i = 0; i < allModificationsList.size(); ++i) {
            allModificationsAsArray[i] = allModificationsList.get(i);
        }
        Arrays.sort(allModificationsAsArray);
        this.modificationsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Name", "Mass", "V", "F"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class, Double.class, Boolean.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex] && XTandemParametersDialog.this.editable;
            }
        });
        for (Object mod : allModificationsAsArray) {
            ((DefaultTableModel)this.modificationsTable.getModel()).addRow(new Object[]{new Color(this.modificationFactory.getColor((String)mod)), mod, this.modificationFactory.getModification((String)mod).getMass(), this.modificationProfile.getRefinementVariableModifications().contains(mod), this.modificationProfile.getRefinementFixedModifications().contains(mod)});
        }
        ((DefaultTableModel)this.modificationsTable.getModel()).fireTableDataChanged();
        this.modificationsTable.repaint();
        double maxMass = Double.MIN_VALUE;
        double minMass = Double.MAX_VALUE;
        for (String modification : this.modificationFactory.getModifications()) {
            if (this.modificationFactory.getModification(modification).getMass() > maxMass) {
                maxMass = this.modificationFactory.getModification(modification).getMass();
            }
            if (!(this.modificationFactory.getModification(modification).getMass() < minMass)) continue;
            minMass = this.modificationFactory.getModification(modification).getMass();
        }
        this.setAllModificationTableProperties();
        this.modificationsTable.getColumn("Mass").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(minMass), Double.valueOf(maxMass)));
        ((JSparklinesBarChartTableCellRenderer)this.modificationsTable.getColumn("Mass").getCellRenderer()).showNumberAndChart(true, 50);
        if (this.modificationsTable.getRowCount() > 0) {
            this.modificationsTable.setRowSelectionInterval(0, 0);
        }
    }
}

