/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.search;

import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationCategory;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.modification.ModificationsDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.io.file.LastSelectedFolder;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.CometParameters;
import com.compomics.util.parameters.identification.tool_specific.MsgfParameters;
import com.compomics.util.parameters.identification.tool_specific.MyriMatchParameters;
import com.compomics.util.parameters.identification.tool_specific.XtandemParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesColorTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;

public class SearchParametersDialog
extends JDialog {
    private EnzymeFactory enzymeFactory = EnzymeFactory.getInstance();
    private String[] forwardIons = new String[]{"a", "b", "c"};
    private String[] rewindIons = new String[]{"x", "y", "z"};
    private ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private SearchParameters searchParameters;
    private ArrayList<String> modificationTableToolTips;
    private Frame parentFrame;
    private Image normalIcon;
    private Image waitingIcon;
    private int keyPressedCounter = 0;
    private String currentPtmSearchString = "";
    private int waitingTime = 500;
    private boolean canceled = false;
    private boolean editable;
    private final LastSelectedFolder lastSelectedFolder;
    public static String TITLED_BORDER_HORIZONTAL_PADDING = "";
    private Double refMass;
    private UtilitiesUserParameters utilitiesUserParameters = null;
    private JButton addFixedModification;
    private JButton addVariableModification;
    private JPanel availableModsPanel;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JComboBox digestionCmb;
    private JLabel digestionLabel;
    private JLabel enzymeLabel;
    private JComboBox enzymesCmb;
    private JLabel fixedModificationsLabel;
    private JScrollPane fixedModsJScrollPane;
    private JPanel fixedModsPanel;
    private JTable fixedModsTable;
    private JComboBox fragmentIon1Cmb;
    private JComboBox fragmentIon2Cmb;
    private JTextField fragmentIonAccuracyTxt;
    private JLabel fragmentIonLbl;
    private JLabel fragmentIonType1Lbl;
    private JComboBox fragmentIonUnit;
    private JTextField isotopeMaxTxt;
    private JTextField isotopeMinTxt;
    private JLabel isotopeRangeLabel;
    private JLabel isotopesLbl;
    private JLabel maxMissedCleavagesLabel;
    private JTextField maxMissedCleavagesTxt;
    private JTextField maxPrecursorChargeTxt;
    private JTextField minPrecursorChargeTxt;
    private JSplitPane modificationTypesSplitPane;
    private JScrollPane modificationsJScrollPane;
    private JLayeredPane modificationsLayeredPane;
    private JComboBox modificationsListCombo;
    private JPanel modificationsPanel;
    private JTable modificationsTable;
    private JButton okButton;
    private JButton openDialogHelpJButton1;
    private JButton openModificationSettingsJButton;
    private JLabel precursorChargeLbl;
    private JLabel precursorChargeRangeLabel;
    private JTextField precursorIonAccuracyTxt;
    private JLabel precursorIonLbl;
    private JComboBox precursorIonUnit;
    private JPanel proteaseAndFragmentationPanel;
    private JButton removeFixedModification;
    private JButton removeVariableModification;
    private JComboBox specificityComboBox;
    private JLabel specificityLabel;
    private JLabel variableModificationsLabel;
    private JScrollPane variableModsJScrollPane;
    private JPanel variableModsPanel;
    private JTable variableModsTable;

    public SearchParametersDialog() {
        this.lastSelectedFolder = null;
    }

    public SearchParametersDialog(Frame parentFrame, SearchParameters searchParameters, Image normalIcon, Image waitingIcon, boolean setVisible, boolean modal, LastSelectedFolder lastSelectedFolder, String settingsName, boolean editable) {
        super(parentFrame, modal);
        this.parentFrame = parentFrame;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.lastSelectedFolder = lastSelectedFolder;
        this.editable = editable;
        if (searchParameters == null) {
            this.searchParameters = new SearchParameters();
            this.searchParameters.setDigestionParameters(DigestionParameters.getDefaultParameters());
        } else {
            this.searchParameters = searchParameters;
        }
        this.loadUserPreferences();
        this.initComponents();
        this.setUpGUI();
        this.formComponentResized(null);
        this.setLocationRelativeTo(parentFrame);
        String dialogTitle = "Spectrum Matching";
        if (settingsName != null && settingsName.length() > 0) {
            dialogTitle = dialogTitle + " - " + settingsName;
        }
        this.setTitle(dialogTitle);
        if (setVisible) {
            this.setVisible(true);
        }
    }

    public SearchParametersDialog(Dialog owner, Frame parentFrame, SearchParameters searchParameters, Image normalIcon, Image waitingIcon, boolean setVisible, boolean modal, LastSelectedFolder lastSelectedFolder, String settingsName, boolean editable) {
        super(owner, modal);
        this.parentFrame = parentFrame;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.lastSelectedFolder = lastSelectedFolder;
        this.editable = editable;
        if (searchParameters == null) {
            this.searchParameters = new SearchParameters();
            this.searchParameters.setDigestionParameters(DigestionParameters.getDefaultParameters());
        } else {
            this.searchParameters = searchParameters;
        }
        this.loadUserPreferences();
        this.initComponents();
        this.setUpGUI();
        this.formComponentResized(null);
        this.setLocationRelativeTo(owner);
        String dialogTitle = "Spectrum Matching";
        if (settingsName != null && settingsName.length() > 0) {
            dialogTitle = dialogTitle + " - " + settingsName;
        }
        this.setTitle(dialogTitle);
        if (setVisible) {
            this.setVisible(true);
        }
    }

    private void loadUserPreferences() {
        try {
            this.utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setUpGUI() {
        this.setScreenProps();
        this.validateParametersInput(false);
        this.refMass = this.searchParameters.getRefMass();
        this.digestionCmb.setEnabled(this.editable);
        this.enzymesCmb.setEnabled(this.editable && (DigestionParameters.CleavageParameter)((Object)this.digestionCmb.getSelectedItem()) == DigestionParameters.CleavageParameter.enzyme);
        this.specificityComboBox.setEnabled(this.editable && (DigestionParameters.CleavageParameter)((Object)this.digestionCmb.getSelectedItem()) == DigestionParameters.CleavageParameter.enzyme);
        this.precursorIonAccuracyTxt.setEditable(this.editable);
        this.precursorIonUnit.setEnabled(this.editable);
        this.fragmentIon1Cmb.setEnabled(this.editable);
        this.fragmentIon2Cmb.setEnabled(this.editable);
        this.fragmentIonUnit.setEnabled(this.editable);
        this.maxMissedCleavagesTxt.setEditable(this.editable);
        this.fragmentIonAccuracyTxt.setEditable(this.editable);
        this.minPrecursorChargeTxt.setEditable(this.editable);
        this.maxPrecursorChargeTxt.setEditable(this.editable);
        this.isotopeMinTxt.setEditable(this.editable);
        this.isotopeMaxTxt.setEditable(this.editable);
        this.addFixedModification.setEnabled(this.editable);
        this.removeFixedModification.setEnabled(this.editable);
        this.addVariableModification.setEnabled(this.editable);
        this.removeVariableModification.setEnabled(this.editable);
        this.modificationTypesSplitPane.setDividerLocation(0.5);
        this.fixedModsTable.getTableHeader().setReorderingAllowed(false);
        this.variableModsTable.getTableHeader().setReorderingAllowed(false);
        this.modificationsTable.getTableHeader().setReorderingAllowed(false);
        this.modificationsListCombo.setRenderer(new AlignedListCellRenderer(0));
        this.enzymesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.digestionCmb.setRenderer(new AlignedListCellRenderer(0));
        this.fragmentIon1Cmb.setRenderer(new AlignedListCellRenderer(0));
        this.fragmentIon2Cmb.setRenderer(new AlignedListCellRenderer(0));
        this.precursorIonUnit.setRenderer(new AlignedListCellRenderer(0));
        this.fragmentIonUnit.setRenderer(new AlignedListCellRenderer(0));
        this.specificityComboBox.setRenderer(new AlignedListCellRenderer(0));
        ((TitledBorder)this.modificationsPanel.getBorder()).setTitle(TITLED_BORDER_HORIZONTAL_PADDING + "Modifications" + TITLED_BORDER_HORIZONTAL_PADDING);
        ((TitledBorder)this.proteaseAndFragmentationPanel.getBorder()).setTitle(TITLED_BORDER_HORIZONTAL_PADDING + "Protease & Fragmentation" + TITLED_BORDER_HORIZONTAL_PADDING);
        this.fixedModsJScrollPane.getViewport().setOpaque(false);
        this.variableModsJScrollPane.getViewport().setOpaque(false);
        this.modificationsJScrollPane.getViewport().setOpaque(false);
        this.fixedModsTable.getColumn(" ").setCellRenderer((TableCellRenderer)new JSparklinesColorTableCellRenderer());
        this.variableModsTable.getColumn(" ").setCellRenderer((TableCellRenderer)new JSparklinesColorTableCellRenderer());
        this.fixedModsTable.getColumn(" ").setMaxWidth(35);
        this.fixedModsTable.getColumn(" ").setMinWidth(35);
        this.variableModsTable.getColumn(" ").setMaxWidth(35);
        this.variableModsTable.getColumn(" ").setMinWidth(35);
        this.fixedModsTable.getColumn("Mass").setMaxWidth(100);
        this.fixedModsTable.getColumn("Mass").setMinWidth(100);
        this.variableModsTable.getColumn("Mass").setMaxWidth(100);
        this.variableModsTable.getColumn("Mass").setMinWidth(100);
        this.modificationTableToolTips = new ArrayList();
        this.modificationTableToolTips.add(null);
        this.modificationTableToolTips.add("Modification Name");
        this.modificationTableToolTips.add("Modification Mass");
        this.modificationTableToolTips.add("<html>Included in the list of the<br>Most Used Modifications</html>");
        this.setAllModificationTableProperties();
        this.updateModificationList();
    }

    private void setAllModificationTableProperties() {
        this.modificationsTable.getColumn(" ").setCellRenderer((TableCellRenderer)new JSparklinesColorTableCellRenderer());
        this.modificationsTable.getColumn(" ").setMaxWidth(35);
        this.modificationsTable.getColumn(" ").setMinWidth(35);
        this.modificationsTable.getColumn("Mass").setMaxWidth(100);
        this.modificationsTable.getColumn("Mass").setMinWidth(100);
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.proteaseAndFragmentationPanel = new JPanel();
        this.enzymeLabel = new JLabel();
        this.enzymesCmb = new JComboBox();
        this.maxMissedCleavagesLabel = new JLabel();
        this.maxMissedCleavagesTxt = new JTextField();
        this.precursorIonLbl = new JLabel();
        this.precursorIonAccuracyTxt = new JTextField();
        this.precursorIonUnit = new JComboBox();
        this.fragmentIonLbl = new JLabel();
        this.fragmentIonAccuracyTxt = new JTextField();
        this.fragmentIonType1Lbl = new JLabel();
        this.fragmentIon1Cmb = new JComboBox();
        this.fragmentIon2Cmb = new JComboBox();
        this.precursorChargeLbl = new JLabel();
        this.minPrecursorChargeTxt = new JTextField();
        this.maxPrecursorChargeTxt = new JTextField();
        this.precursorChargeRangeLabel = new JLabel();
        this.isotopesLbl = new JLabel();
        this.isotopeMinTxt = new JTextField();
        this.isotopeRangeLabel = new JLabel();
        this.isotopeMaxTxt = new JTextField();
        this.fragmentIonUnit = new JComboBox();
        this.digestionLabel = new JLabel();
        this.digestionCmb = new JComboBox();
        this.specificityLabel = new JLabel();
        this.specificityComboBox = new JComboBox();
        this.modificationsLayeredPane = new JLayeredPane();
        this.modificationsPanel = new JPanel();
        this.modificationTypesSplitPane = new JSplitPane();
        this.fixedModsPanel = new JPanel();
        this.fixedModificationsLabel = new JLabel();
        this.addFixedModification = new JButton();
        this.removeFixedModification = new JButton();
        this.fixedModsJScrollPane = new JScrollPane();
        this.fixedModsTable = new JTable(){

            @Override
            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                super.changeSelection(rowIndex, columnIndex, !extend, extend);
            }
        };
        this.variableModsPanel = new JPanel();
        this.variableModificationsLabel = new JLabel();
        this.addVariableModification = new JButton();
        this.removeVariableModification = new JButton();
        this.variableModsJScrollPane = new JScrollPane();
        this.variableModsTable = new JTable(){

            @Override
            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                super.changeSelection(rowIndex, columnIndex, !extend, extend);
            }
        };
        this.availableModsPanel = new JPanel();
        this.modificationsListCombo = new JComboBox();
        this.modificationsJScrollPane = new JScrollPane();
        this.modificationsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)SearchParametersDialog.this.modificationTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }

            @Override
            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                super.changeSelection(rowIndex, columnIndex, !extend, extend);
            }
        };
        this.openModificationSettingsJButton = new JButton();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.openDialogHelpJButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Spectrum Matching");
        this.setMinimumSize(new Dimension(700, 650));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SearchParametersDialog.this.formComponentResized(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SearchParametersDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.proteaseAndFragmentationPanel.setBorder(BorderFactory.createTitledBorder("Enzyme & Fragmentation"));
        this.proteaseAndFragmentationPanel.setOpaque(false);
        this.enzymeLabel.setText("Enzyme");
        this.enzymesCmb.setMaximumRowCount(15);
        this.enzymesCmb.setModel(new DefaultComboBoxModel<String>(this.loadEnzymes()));
        this.enzymesCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchParametersDialog.this.enzymesCmbActionPerformed(evt);
            }
        });
        this.maxMissedCleavagesLabel.setText("Max Missed Cleavages");
        this.maxMissedCleavagesTxt.setHorizontalAlignment(0);
        this.maxMissedCleavagesTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchParametersDialog.this.maxMissedCleavagesTxtKeyReleased(evt);
            }
        });
        this.precursorIonLbl.setText("Precursor Tolerance");
        this.precursorIonAccuracyTxt.setHorizontalAlignment(0);
        this.precursorIonAccuracyTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchParametersDialog.this.precursorIonAccuracyTxtKeyReleased(evt);
            }
        });
        this.precursorIonUnit.setModel(new DefaultComboBoxModel<String>(new String[]{"ppm", "Da"}));
        this.fragmentIonLbl.setText("Fragment Tolerance");
        this.fragmentIonAccuracyTxt.setHorizontalAlignment(0);
        this.fragmentIonAccuracyTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchParametersDialog.this.fragmentIonAccuracyTxtKeyReleased(evt);
            }
        });
        this.fragmentIonType1Lbl.setText("Fragment Ion Types");
        this.fragmentIon1Cmb.setModel(new DefaultComboBoxModel<String>(this.forwardIons));
        this.fragmentIon2Cmb.setModel(new DefaultComboBoxModel<String>(this.rewindIons));
        this.precursorChargeLbl.setText("Precursor Charge");
        this.minPrecursorChargeTxt.setHorizontalAlignment(0);
        this.minPrecursorChargeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchParametersDialog.this.minPrecursorChargeTxtKeyReleased(evt);
            }
        });
        this.maxPrecursorChargeTxt.setHorizontalAlignment(0);
        this.maxPrecursorChargeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchParametersDialog.this.maxPrecursorChargeTxtKeyReleased(evt);
            }
        });
        this.precursorChargeRangeLabel.setText("-");
        this.isotopesLbl.setText("Isotopes");
        this.isotopeMinTxt.setHorizontalAlignment(0);
        this.isotopeMinTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchParametersDialog.this.isotopeMinTxtKeyReleased(evt);
            }
        });
        this.isotopeRangeLabel.setText("-");
        this.isotopeMaxTxt.setHorizontalAlignment(0);
        this.isotopeMaxTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchParametersDialog.this.isotopeMaxTxtActionPerformed(evt);
            }
        });
        this.isotopeMaxTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchParametersDialog.this.isotopeMaxTxtKeyReleased(evt);
            }
        });
        this.fragmentIonUnit.setModel(new DefaultComboBoxModel<String>(new String[]{"ppm", "Da"}));
        this.digestionLabel.setText("Digestion");
        this.digestionCmb.setMaximumRowCount(15);
        this.digestionCmb.setModel(new DefaultComboBoxModel<DigestionParameters.CleavageParameter>(DigestionParameters.CleavageParameter.values()));
        this.digestionCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchParametersDialog.this.digestionCmbActionPerformed(evt);
            }
        });
        this.specificityLabel.setText("Specificity");
        this.specificityComboBox.setModel(new DefaultComboBoxModel<DigestionParameters.Specificity>(DigestionParameters.Specificity.values()));
        GroupLayout proteaseAndFragmentationPanelLayout = new GroupLayout(this.proteaseAndFragmentationPanel);
        this.proteaseAndFragmentationPanel.setLayout(proteaseAndFragmentationPanelLayout);
        proteaseAndFragmentationPanelLayout.setHorizontalGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteaseAndFragmentationPanelLayout.createSequentialGroup().addContainerGap().addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.enzymeLabel).addComponent(this.fragmentIonType1Lbl).addComponent(this.maxMissedCleavagesLabel).addComponent(this.specificityLabel).addComponent(this.digestionLabel)).addGap(26, 26, 26).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.digestionCmb, 0, 209, Short.MAX_VALUE).addComponent(this.enzymesCmb, 0, 209, Short.MAX_VALUE).addComponent(this.maxMissedCleavagesTxt, GroupLayout.Alignment.TRAILING, -1, 209, Short.MAX_VALUE).addGroup(proteaseAndFragmentationPanelLayout.createSequentialGroup().addComponent(this.fragmentIon1Cmb, 0, 95, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.fragmentIon2Cmb, 0, 96, Short.MAX_VALUE)).addComponent(this.specificityComboBox, 0, 209, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 75, Short.MAX_VALUE).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.precursorChargeLbl).addComponent(this.isotopesLbl).addComponent(this.precursorIonLbl).addComponent(this.fragmentIonLbl)).addGap(18, 18, 18).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.precursorIonAccuracyTxt, -1, 122, Short.MAX_VALUE).addComponent(this.fragmentIonAccuracyTxt, -1, 122, Short.MAX_VALUE).addComponent(this.minPrecursorChargeTxt, -1, 122, Short.MAX_VALUE).addComponent(this.isotopeMinTxt, -1, 122, Short.MAX_VALUE)).addGap(5, 5, 5).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.precursorChargeRangeLabel).addComponent(this.isotopeRangeLabel)).addGap(5, 5, 5).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.precursorIonUnit, GroupLayout.Alignment.TRAILING, 0, 122, Short.MAX_VALUE).addComponent(this.fragmentIonUnit, GroupLayout.Alignment.TRAILING, 0, 122, Short.MAX_VALUE).addComponent(this.maxPrecursorChargeTxt, GroupLayout.Alignment.TRAILING, -1, 122, Short.MAX_VALUE).addComponent(this.isotopeMaxTxt, GroupLayout.Alignment.TRAILING, -1, 122, Short.MAX_VALUE)).addContainerGap()));
        proteaseAndFragmentationPanelLayout.setVerticalGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteaseAndFragmentationPanelLayout.createSequentialGroup().addGap(8, 8, 8).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteaseAndFragmentationPanelLayout.createSequentialGroup().addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.precursorIonLbl).addComponent(this.precursorIonAccuracyTxt, -2, -1, -2).addComponent(this.precursorIonUnit, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fragmentIonLbl).addComponent(this.fragmentIonAccuracyTxt, -2, -1, -2).addComponent(this.fragmentIonUnit, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPrecursorChargeTxt, -2, -1, -2).addComponent(this.precursorChargeRangeLabel)).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxPrecursorChargeTxt, -2, -1, -2).addComponent(this.precursorChargeLbl))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.isotopesLbl).addComponent(this.isotopeMinTxt, -2, -1, -2).addComponent(this.isotopeMaxTxt, -2, -1, -2).addComponent(this.isotopeRangeLabel))).addGroup(proteaseAndFragmentationPanelLayout.createSequentialGroup().addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.digestionLabel).addComponent(this.digestionCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enzymeLabel).addComponent(this.enzymesCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.specificityLabel).addComponent(this.specificityComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxMissedCleavagesTxt, -2, -1, -2).addComponent(this.maxMissedCleavagesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fragmentIon1Cmb, -2, -1, -2).addComponent(this.fragmentIon2Cmb, -2, -1, -2).addComponent(this.fragmentIonType1Lbl)))).addContainerGap(-1, Short.MAX_VALUE)));
        this.modificationsPanel.setBorder(BorderFactory.createTitledBorder("Modifications"));
        this.modificationsPanel.setOpaque(false);
        this.modificationTypesSplitPane.setBorder(null);
        this.modificationTypesSplitPane.setDividerSize(0);
        this.modificationTypesSplitPane.setOrientation(0);
        this.modificationTypesSplitPane.setResizeWeight(0.5);
        this.modificationTypesSplitPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SearchParametersDialog.this.modificationTypesSplitPaneComponentResized(evt);
            }
        });
        this.fixedModsPanel.setOpaque(false);
        this.fixedModificationsLabel.setFont(this.fixedModificationsLabel.getFont().deriveFont(this.fixedModificationsLabel.getFont().getStyle() | 2));
        this.fixedModificationsLabel.setText("Fixed Modifications");
        this.addFixedModification.setText("<<");
        this.addFixedModification.setToolTipText("Add as fixed modification");
        this.addFixedModification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchParametersDialog.this.addFixedModificationActionPerformed(evt);
            }
        });
        this.removeFixedModification.setText(">>");
        this.removeFixedModification.setToolTipText("Remove as fixed modification");
        this.removeFixedModification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchParametersDialog.this.removeFixedModificationActionPerformed(evt);
            }
        });
        this.fixedModsJScrollPane.setPreferredSize(new Dimension(100, 60));
        this.fixedModsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Name", "Mass"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class, Double.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.fixedModsTable.setMinimumSize(new Dimension(0, 0));
        this.fixedModsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                SearchParametersDialog.this.fixedModsTableMouseMoved(evt);
            }
        });
        this.fixedModsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchParametersDialog.this.fixedModsTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SearchParametersDialog.this.fixedModsTableMouseReleased(evt);
            }
        });
        this.fixedModsJScrollPane.setViewportView(this.fixedModsTable);
        GroupLayout fixedModsPanelLayout = new GroupLayout(this.fixedModsPanel);
        this.fixedModsPanel.setLayout(fixedModsPanelLayout);
        fixedModsPanelLayout.setHorizontalGroup(fixedModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fixedModsPanelLayout.createSequentialGroup().addGroup(fixedModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fixedModsPanelLayout.createSequentialGroup().addComponent(this.fixedModificationsLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 242, Short.MAX_VALUE)).addGroup(fixedModsPanelLayout.createSequentialGroup().addComponent(this.fixedModsJScrollPane, -1, -1, Short.MAX_VALUE).addGap(7, 7, 7))).addGroup(fixedModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.removeFixedModification, -2, 54, -2).addComponent(this.addFixedModification, -2, 54, -2))));
        fixedModsPanelLayout.setVerticalGroup(fixedModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fixedModsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fixedModificationsLabel).addGap(6, 6, 6).addGroup(fixedModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fixedModsPanelLayout.createSequentialGroup().addComponent(this.addFixedModification).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeFixedModification).addContainerGap(57, Short.MAX_VALUE)).addComponent(this.fixedModsJScrollPane, -1, -1, Short.MAX_VALUE))));
        this.modificationTypesSplitPane.setLeftComponent(this.fixedModsPanel);
        this.variableModsPanel.setOpaque(false);
        this.variableModificationsLabel.setFont(this.variableModificationsLabel.getFont().deriveFont(this.variableModificationsLabel.getFont().getStyle() | 2));
        this.variableModificationsLabel.setText("Variable Modifications");
        this.addVariableModification.setText("<<");
        this.addVariableModification.setToolTipText("Add as variable modification");
        this.addVariableModification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchParametersDialog.this.addVariableModificationActionPerformed(evt);
            }
        });
        this.removeVariableModification.setText(">>");
        this.removeVariableModification.setToolTipText("Remove as variable modification");
        this.removeVariableModification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchParametersDialog.this.removeVariableModificationActionPerformed(evt);
            }
        });
        this.variableModsJScrollPane.setPreferredSize(new Dimension(100, 60));
        this.variableModsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Name", "Mass"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class, Double.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.variableModsTable.setMinimumSize(new Dimension(0, 0));
        this.variableModsTable.setName("");
        this.variableModsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                SearchParametersDialog.this.variableModsTableMouseMoved(evt);
            }
        });
        this.variableModsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchParametersDialog.this.variableModsTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SearchParametersDialog.this.variableModsTableMouseReleased(evt);
            }
        });
        this.variableModsJScrollPane.setViewportView(this.variableModsTable);
        GroupLayout variableModsPanelLayout = new GroupLayout(this.variableModsPanel);
        this.variableModsPanel.setLayout(variableModsPanelLayout);
        variableModsPanelLayout.setHorizontalGroup(variableModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.variableModificationsLabel).addGroup(GroupLayout.Alignment.TRAILING, variableModsPanelLayout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.variableModsJScrollPane, -1, 339, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(variableModsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.addVariableModification, -2, 54, -2).addComponent(this.removeVariableModification, -2, 54, -2))));
        variableModsPanelLayout.setVerticalGroup(variableModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(variableModsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.variableModificationsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(variableModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(variableModsPanelLayout.createSequentialGroup().addComponent(this.addVariableModification).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeVariableModification).addContainerGap(57, Short.MAX_VALUE)).addComponent(this.variableModsJScrollPane, -1, -1, Short.MAX_VALUE))));
        this.modificationTypesSplitPane.setRightComponent(this.variableModsPanel);
        this.availableModsPanel.setOpaque(false);
        this.modificationsListCombo.setMaximumRowCount(10);
        this.modificationsListCombo.setModel(new DefaultComboBoxModel<ModificationCategory>(ModificationCategory.values()));
        this.modificationsListCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchParametersDialog.this.modificationsListComboActionPerformed(evt);
            }
        });
        this.modificationsJScrollPane.setPreferredSize(new Dimension(100, 60));
        this.modificationsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Name", "Mass"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class, Double.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.modificationsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                SearchParametersDialog.this.modificationsTableMouseMoved(evt);
            }
        });
        this.modificationsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchParametersDialog.this.modificationsTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SearchParametersDialog.this.modificationsTableMouseReleased(evt);
            }
        });
        this.modificationsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchParametersDialog.this.modificationsTableKeyReleased(evt);
            }
        });
        this.modificationsJScrollPane.setViewportView(this.modificationsTable);
        this.openModificationSettingsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.openModificationSettingsJButton.setToolTipText("Edit Modifications");
        this.openModificationSettingsJButton.setBorder(null);
        this.openModificationSettingsJButton.setBorderPainted(false);
        this.openModificationSettingsJButton.setContentAreaFilled(false);
        this.openModificationSettingsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.openModificationSettingsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchParametersDialog.this.openModificationSettingsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchParametersDialog.this.openModificationSettingsJButtonMouseExited(evt);
            }
        });
        this.openModificationSettingsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchParametersDialog.this.openModificationSettingsJButtonActionPerformed(evt);
            }
        });
        GroupLayout availableModsPanelLayout = new GroupLayout(this.availableModsPanel);
        this.availableModsPanel.setLayout(availableModsPanelLayout);
        availableModsPanelLayout.setHorizontalGroup(availableModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modificationsJScrollPane, -1, 372, Short.MAX_VALUE).addGroup(availableModsPanelLayout.createSequentialGroup().addComponent(this.modificationsListCombo, 0, 318, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openModificationSettingsJButton).addGap(2, 2, 2)));
        availableModsPanelLayout.setVerticalGroup(availableModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(availableModsPanelLayout.createSequentialGroup().addGroup(availableModsPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.modificationsListCombo, -2, -1, -2).addComponent(this.openModificationSettingsJButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modificationsJScrollPane, -1, -1, Short.MAX_VALUE)));
        GroupLayout modificationsPanelLayout = new GroupLayout(this.modificationsPanel);
        this.modificationsPanel.setLayout(modificationsPanelLayout);
        modificationsPanelLayout.setHorizontalGroup(modificationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modificationsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.modificationTypesSplitPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.availableModsPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        modificationsPanelLayout.setVerticalGroup(modificationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modificationsPanelLayout.createSequentialGroup().addGroup(modificationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modificationTypesSplitPane).addComponent(this.availableModsPanel, -2, -1, Short.MAX_VALUE)).addContainerGap()));
        this.modificationsLayeredPane.add(this.modificationsPanel);
        this.modificationsPanel.setBounds(0, 0, 820, 342);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.openDialogHelpJButton1.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton1.setToolTipText("Help");
        this.openDialogHelpJButton1.setBorder(null);
        this.openDialogHelpJButton1.setBorderPainted(false);
        this.openDialogHelpJButton1.setContentAreaFilled(false);
        this.openDialogHelpJButton1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchParametersDialog.this.openDialogHelpJButton1MouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchParametersDialog.this.openDialogHelpJButton1MouseExited(evt);
            }
        });
        this.openDialogHelpJButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchParametersDialog.this.openDialogHelpJButton1ActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.modificationsLayeredPane).addComponent(this.proteaseAndFragmentationPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.modificationsLayeredPane, -1, 346, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.proteaseAndFragmentationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton1).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void addFixedModificationActionPerformed(ActionEvent evt) {
        int nSelected = this.fixedModsTable.getRowCount();
        int nNew = this.modificationsTable.getSelectedRows().length;
        String[] fixedModifications = new String[nSelected + nNew];
        int cpt = 0;
        for (int i = 0; i < nSelected; ++i) {
            fixedModifications[cpt] = (String)this.fixedModsTable.getValueAt(i, 1);
            ++cpt;
        }
        for (int selectedRow : this.modificationsTable.getSelectedRows()) {
            String name = (String)this.modificationsTable.getValueAt(selectedRow, 1);
            boolean found = false;
            for (int i = 0; i < this.fixedModsTable.getModel().getRowCount(); ++i) {
                if (!((String)this.fixedModsTable.getValueAt(i, 1)).equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            fixedModifications[cpt] = name;
            ++cpt;
        }
        DefaultTableModel fixedModel = (DefaultTableModel)this.fixedModsTable.getModel();
        fixedModel.getDataVector().removeAllElements();
        for (String fixedMod : fixedModifications) {
            ((DefaultTableModel)this.fixedModsTable.getModel()).addRow(new Object[]{new Color(this.searchParameters.getModificationParameters().getColor(fixedMod)), fixedMod, this.modificationFactory.getModification(fixedMod).getMass()});
        }
        ((DefaultTableModel)this.fixedModsTable.getModel()).fireTableDataChanged();
        this.fixedModsTable.repaint();
        this.fixedModificationsLabel.setText("Fixed Modifications (" + fixedModifications.length + ")");
        this.updateModificationList();
    }

    private void removeFixedModificationActionPerformed(ActionEvent evt) {
        int nSelected = this.fixedModsTable.getRowCount();
        int nToRemove = this.fixedModsTable.getSelectedRows().length;
        String[] fixedModifications = new String[nSelected - nToRemove];
        int cpt = 0;
        for (int i = 0; i < this.fixedModsTable.getRowCount(); ++i) {
            boolean found = false;
            int[] nArray = this.fixedModsTable.getSelectedRows();
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                int selectedRow = nArray[j];
                if (!((String)this.fixedModsTable.getValueAt(i, 1)).equals((String)this.fixedModsTable.getValueAt(selectedRow, 1))) continue;
                found = true;
                break;
            }
            if (found) continue;
            fixedModifications[cpt] = (String)this.fixedModsTable.getValueAt(i, 1);
            ++cpt;
        }
        DefaultTableModel fixedModel = (DefaultTableModel)this.fixedModsTable.getModel();
        fixedModel.getDataVector().removeAllElements();
        for (String fixedMod : fixedModifications) {
            ((DefaultTableModel)this.fixedModsTable.getModel()).addRow(new Object[]{new Color(this.searchParameters.getModificationParameters().getColor(fixedMod)), fixedMod, this.modificationFactory.getModification(fixedMod).getMass()});
        }
        ((DefaultTableModel)this.fixedModsTable.getModel()).fireTableDataChanged();
        this.fixedModsTable.repaint();
        this.fixedModificationsLabel.setText("Fixed Modifications (" + fixedModifications.length + ")");
        this.updateModificationList();
    }

    private void addVariableModificationActionPerformed(ActionEvent evt) {
        int nSelected = this.variableModsTable.getRowCount();
        int nNew = this.modificationsTable.getSelectedRows().length;
        String[] variableModifications = new String[nSelected + nNew];
        int cpt = 0;
        for (int i = 0; i < nSelected; ++i) {
            variableModifications[cpt] = (String)this.variableModsTable.getValueAt(i, 1);
            ++cpt;
        }
        for (int selectedRow : this.modificationsTable.getSelectedRows()) {
            String name = (String)this.modificationsTable.getValueAt(selectedRow, 1);
            boolean found = false;
            for (int i = 0; i < this.variableModsTable.getRowCount(); ++i) {
                if (!((String)this.variableModsTable.getValueAt(i, 1)).equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            variableModifications[cpt] = name;
            ++cpt;
        }
        DefaultTableModel variableModel = (DefaultTableModel)this.variableModsTable.getModel();
        variableModel.getDataVector().removeAllElements();
        for (String variabledMod : variableModifications) {
            ((DefaultTableModel)this.variableModsTable.getModel()).addRow(new Object[]{new Color(this.searchParameters.getModificationParameters().getColor(variabledMod)), variabledMod, this.modificationFactory.getModification(variabledMod).getMass()});
        }
        ((DefaultTableModel)this.variableModsTable.getModel()).fireTableDataChanged();
        this.variableModsTable.repaint();
        this.variableModificationsLabel.setText("Variable Modifications (" + variableModifications.length + ")");
        if (variableModifications.length > 6) {
            JOptionPane.showMessageDialog(this, "It is not recommended to use more than 6 variable modifications in the same search.", "Warning", 2);
        }
        this.updateModificationList();
    }

    private void removeVariableModificationActionPerformed(ActionEvent evt) {
        int nSelected = this.variableModsTable.getRowCount();
        int nToRemove = this.variableModsTable.getSelectedRows().length;
        String[] variableModifications = new String[nSelected - nToRemove];
        int cpt = 0;
        for (int i = 0; i < this.variableModsTable.getRowCount(); ++i) {
            boolean found = false;
            int[] nArray = this.variableModsTable.getSelectedRows();
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                int selectedRow = nArray[j];
                if (!((String)this.variableModsTable.getValueAt(i, 1)).equals((String)this.variableModsTable.getValueAt(selectedRow, 1))) continue;
                found = true;
                break;
            }
            if (found) continue;
            variableModifications[cpt] = (String)this.variableModsTable.getValueAt(i, 1);
            ++cpt;
        }
        DefaultTableModel variableModel = (DefaultTableModel)this.variableModsTable.getModel();
        variableModel.getDataVector().removeAllElements();
        for (String variabledMod : variableModifications) {
            ((DefaultTableModel)this.variableModsTable.getModel()).addRow(new Object[]{new Color(this.searchParameters.getModificationParameters().getColor(variabledMod)), variabledMod, this.modificationFactory.getModification(variabledMod).getMass()});
        }
        ((DefaultTableModel)this.variableModsTable.getModel()).fireTableDataChanged();
        this.variableModsTable.repaint();
        this.variableModificationsLabel.setText("Variable Modifications (" + variableModifications.length + ")");
        this.updateModificationList();
    }

    private void modificationTypesSplitPaneComponentResized(ComponentEvent evt) {
        this.modificationTypesSplitPane.setDividerLocation(0.5);
    }

    private void modificationsListComboActionPerformed(ActionEvent evt) {
        this.updateModificationList();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void formComponentResized(ComponentEvent evt) {
        this.modificationsLayeredPane.getComponent(0).setBounds(0, 0, this.modificationsLayeredPane.getWidth(), this.modificationsLayeredPane.getHeight());
        this.modificationsLayeredPane.revalidate();
        this.modificationsLayeredPane.repaint();
    }

    private void fixedModsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void fixedModsTableMouseMoved(MouseEvent evt) {
        int row = this.fixedModsTable.rowAtPoint(evt.getPoint());
        int column = this.fixedModsTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            String modificationName = (String)this.fixedModsTable.getValueAt(row, this.fixedModsTable.getColumn("Name").getModelIndex());
            Modification modification = this.modificationFactory.getModification(modificationName);
            this.fixedModsTable.setToolTipText(modification.getHtmlTooltip());
            if (column == this.fixedModsTable.getColumn(" ").getModelIndex()) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else {
            this.fixedModsTable.setToolTipText(null);
        }
    }

    private void fixedModsTableMouseReleased(MouseEvent evt) {
        Color newColor;
        int row = this.fixedModsTable.rowAtPoint(evt.getPoint());
        int column = this.fixedModsTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column == this.fixedModsTable.getColumn(" ").getModelIndex() && (newColor = JColorChooser.showDialog(this, "Pick a Color", (Color)this.fixedModsTable.getValueAt(row, column))) != null) {
            this.searchParameters.getModificationParameters().setColor((String)this.fixedModsTable.getValueAt(row, 1), newColor.getRGB());
            this.fixedModsTable.setValueAt(newColor, row, 0);
            ((DefaultTableModel)this.fixedModsTable.getModel()).fireTableDataChanged();
            this.fixedModsTable.repaint();
        }
        this.enableAddRemoveButtons();
    }

    private void modificationsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void modificationsTableMouseMoved(MouseEvent evt) {
        int row = this.modificationsTable.rowAtPoint(evt.getPoint());
        int column = this.modificationsTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            String modificationName = (String)this.modificationsTable.getValueAt(row, this.modificationsTable.getColumn("Name").getModelIndex());
            Modification modification = this.modificationFactory.getModification(modificationName);
            this.modificationsTable.setToolTipText(modification.getHtmlTooltip());
            if (column == this.modificationsTable.getColumn(" ").getModelIndex()) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else {
            this.modificationsTable.setToolTipText(null);
        }
    }

    private void modificationsTableMouseReleased(MouseEvent evt) {
        int row = this.modificationsTable.rowAtPoint(evt.getPoint());
        int column = this.modificationsTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            Color newColor;
            if (column == this.modificationsTable.getColumn(" ").getModelIndex() && (newColor = JColorChooser.showDialog(this, "Pick a Color", (Color)this.modificationsTable.getValueAt(row, column))) != null) {
                this.modificationFactory.setColor((String)this.modificationsTable.getValueAt(row, 1), newColor.getRGB());
                this.modificationsTable.setValueAt(newColor, row, 0);
                ((DefaultTableModel)this.modificationsTable.getModel()).fireTableDataChanged();
                this.modificationsTable.repaint();
            }
            this.enableAddRemoveButtons();
        }
    }

    private void variableModsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void variableModsTableMouseMoved(MouseEvent evt) {
        int row = this.variableModsTable.rowAtPoint(evt.getPoint());
        int column = this.variableModsTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            String modificationName = (String)this.variableModsTable.getValueAt(row, this.variableModsTable.getColumn("Name").getModelIndex());
            Modification modification = this.modificationFactory.getModification(modificationName);
            this.variableModsTable.setToolTipText(modification.getHtmlTooltip());
            if (column == this.variableModsTable.getColumn(" ").getModelIndex()) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else {
            this.variableModsTable.setToolTipText(null);
        }
    }

    private void variableModsTableMouseReleased(MouseEvent evt) {
        Color newColor;
        int row = this.variableModsTable.rowAtPoint(evt.getPoint());
        int column = this.variableModsTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column == this.variableModsTable.getColumn(" ").getModelIndex() && (newColor = JColorChooser.showDialog(this, "Pick a Color", (Color)this.variableModsTable.getValueAt(row, column))) != null) {
            this.searchParameters.getModificationParameters().setColor((String)this.variableModsTable.getValueAt(row, 1), newColor.getRGB());
            this.variableModsTable.setValueAt(newColor, row, 0);
            ((DefaultTableModel)this.variableModsTable.getModel()).fireTableDataChanged();
            this.variableModsTable.repaint();
        }
        this.enableAddRemoveButtons();
    }

    private void openModificationSettingsJButtonActionPerformed(ActionEvent evt) {
        new ModificationsDialog(this.parentFrame, true);
        this.updateModificationList();
    }

    private void openModificationSettingsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openModificationSettingsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButton1ActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/SearchSettingsDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), this.normalIcon, "Spectrum Matching - Help", 500, 100);
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButton1MouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButton1MouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void modificationsTableKeyReleased(KeyEvent evt) {
        char currentChar = evt.getKeyChar();
        if (Character.isLetterOrDigit(currentChar) || Character.isWhitespace(currentChar)) {
            ++this.keyPressedCounter;
            this.currentPtmSearchString = this.currentPtmSearchString + currentChar;
            new Thread("FindThread"){

                @Override
                public synchronized void run() {
                    try {
                        this.wait(SearchParametersDialog.this.waitingTime);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    try {
                        if (SearchParametersDialog.this.keyPressedCounter == 1) {
                            for (int i = 0; i < SearchParametersDialog.this.modificationsTable.getRowCount(); ++i) {
                                String currentPtmName = ((String)SearchParametersDialog.this.modificationsTable.getValueAt(i, SearchParametersDialog.this.modificationsTable.getColumn("Name").getModelIndex())).toLowerCase();
                                if (!currentPtmName.startsWith(SearchParametersDialog.this.currentPtmSearchString.toLowerCase())) continue;
                                SearchParametersDialog.this.modificationsTable.scrollRectToVisible(SearchParametersDialog.this.modificationsTable.getCellRect(i, i, false));
                                SearchParametersDialog.this.modificationsTable.repaint();
                                SearchParametersDialog.this.modificationsTable.setRowSelectionInterval(i, i);
                                SearchParametersDialog.this.modificationsTable.repaint();
                                break;
                            }
                            SearchParametersDialog.this.keyPressedCounter = 0;
                            SearchParametersDialog.this.currentPtmSearchString = "";
                        } else {
                            SearchParametersDialog.this.keyPressedCounter--;
                        }
                    }
                    catch (Exception e) {
                        SearchParametersDialog.this.keyPressedCounter = 0;
                        SearchParametersDialog.this.currentPtmSearchString = "";
                        SearchParametersDialog.this.modificationsTable.repaint();
                    }
                }
            }.start();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelButtonActionPerformed(null);
    }

    private void isotopeMaxTxtKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void isotopeMaxTxtActionPerformed(ActionEvent evt) {
        this.validateParametersInput(false);
    }

    private void isotopeMinTxtKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void maxPrecursorChargeTxtKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void minPrecursorChargeTxtKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void fragmentIonAccuracyTxtKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void precursorIonAccuracyTxtKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void maxMissedCleavagesTxtKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void enzymesCmbActionPerformed(ActionEvent evt) {
        this.validateParametersInput(false);
    }

    private void digestionCmbActionPerformed(ActionEvent evt) {
        this.enzymesCmb.setEnabled((DigestionParameters.CleavageParameter)((Object)this.digestionCmb.getSelectedItem()) == DigestionParameters.CleavageParameter.enzyme);
        this.maxMissedCleavagesTxt.setEnabled((DigestionParameters.CleavageParameter)((Object)this.digestionCmb.getSelectedItem()) == DigestionParameters.CleavageParameter.enzyme);
        this.specificityComboBox.setEnabled((DigestionParameters.CleavageParameter)((Object)this.digestionCmb.getSelectedItem()) == DigestionParameters.CleavageParameter.enzyme);
        if ((DigestionParameters.CleavageParameter)((Object)this.digestionCmb.getSelectedItem()) != DigestionParameters.CleavageParameter.enzyme) {
            this.enzymesCmb.setSelectedIndex(0);
        }
        this.validateParametersInput(false);
    }

    private String[] loadEnzymes() {
        ArrayList<String> tempEnzymes = this.enzymeFactory.getSortedEnzymeNames();
        String[] enzymes = new String[tempEnzymes.size() + 1];
        enzymes[0] = "--- Select ---";
        for (int i = 0; i < tempEnzymes.size(); ++i) {
            enzymes[i + 1] = tempEnzymes.get(i);
        }
        return enzymes;
    }

    /*
     * WARNING - void declaration
     */
    private void setScreenProps() {
        Integer ionSearched;
        DigestionParameters digestionPreferences;
        ArrayList<String> missingPtms = new ArrayList<String>();
        ModificationParameters modificationProfile = this.searchParameters.getModificationParameters();
        if (modificationProfile != null) {
            ArrayList<String> fixedMods = modificationProfile.getFixedModifications();
            for (String modificationName : fixedMods) {
                if (this.modificationFactory.containsModification(modificationName)) continue;
                missingPtms.add(modificationName);
            }
            for (String missing : missingPtms) {
                fixedMods.remove(missing);
            }
            if (!missingPtms.isEmpty()) {
                if (missingPtms.size() == 1) {
                    JOptionPane.showMessageDialog(this, "The following modification is currently not recognized by SearchGUI: " + (String)missingPtms.get(0) + ".\nPlease import it in the Modification Editor.", "Modification Not Found", 2);
                } else {
                    String output = "The following modifications are currently not recognized by SearchGUI:\n";
                    boolean first = true;
                    for (String modification : missingPtms) {
                        if (first) {
                            first = false;
                        } else {
                            output = output + ", ";
                        }
                        output = output + modification;
                    }
                    output = output + ".\nPlease import them in the Modification Editor.";
                    JOptionPane.showMessageDialog(this, output, "Modification Not Found", 2);
                }
            }
            DefaultTableModel fixedModel = (DefaultTableModel)this.fixedModsTable.getModel();
            fixedModel.getDataVector().removeAllElements();
            for (String string : fixedMods) {
                ((DefaultTableModel)this.fixedModsTable.getModel()).addRow(new Object[]{new Color(this.searchParameters.getModificationParameters().getColor(string)), string, this.modificationFactory.getModification(string).getMass()});
            }
            ((DefaultTableModel)this.fixedModsTable.getModel()).fireTableDataChanged();
            this.fixedModsTable.repaint();
            this.fixedModificationsLabel.setText("Fixed Modifications (" + fixedMods.size() + ")");
            ArrayList<String> variableMods = modificationProfile.getVariableModifications();
            for (String modificationName : variableMods) {
                if (this.modificationFactory.containsModification(modificationName)) continue;
                missingPtms.add(modificationName);
            }
            for (String missing : missingPtms) {
                variableMods.remove(missing);
            }
            if (!missingPtms.isEmpty()) {
                if (missingPtms.size() == 1) {
                    JOptionPane.showMessageDialog(this, "The following modification is currently not recognized by SearchGUI: " + (String)missingPtms.get(0) + ".\nPlease import it in the Modification Editor.", "Modification Not Found", 2);
                } else {
                    void var6_14;
                    String string = "The following modifications are currently not recognized by SearchGUI:\n";
                    boolean first = true;
                    for (String modification : missingPtms) {
                        void var6_16;
                        if (first) {
                            first = false;
                        } else {
                            String string2 = (String)var6_14 + ", ";
                        }
                        String string3 = (String)var6_16 + modification;
                    }
                    String string4 = (String)var6_14 + ".\nPlease import them in the Modification Editor.";
                    JOptionPane.showMessageDialog(this, string4, "Modification Not Found", 2);
                }
            }
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.variableModsTable.getModel();
            defaultTableModel.getDataVector().removeAllElements();
            for (String variableMod : variableMods) {
                ((DefaultTableModel)this.variableModsTable.getModel()).addRow(new Object[]{new Color(this.searchParameters.getModificationParameters().getColor(variableMod)), variableMod, this.modificationFactory.getModification(variableMod).getMass()});
            }
            ((DefaultTableModel)this.variableModsTable.getModel()).fireTableDataChanged();
            this.variableModsTable.repaint();
            this.variableModificationsLabel.setText("Variable Modifications (" + variableMods.size() + ")");
            this.updateModificationList();
        }
        if ((digestionPreferences = this.searchParameters.getDigestionParameters()).getCleavageParameter() != null) {
            this.digestionCmb.setSelectedItem((Object)digestionPreferences.getCleavageParameter());
        }
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
            if (digestionPreferences.hasEnzymes()) {
                Enzyme enzyme = digestionPreferences.getEnzymes().get(0);
                String enzymeName = enzyme.getName();
                this.enzymesCmb.setSelectedItem(enzymeName);
                Integer n = digestionPreferences.getnMissedCleavages(enzymeName);
                if (n != null) {
                    this.maxMissedCleavagesTxt.setText(n + "");
                } else {
                    this.maxMissedCleavagesTxt.setText("Not set");
                }
                this.specificityComboBox.setSelectedItem((Object)digestionPreferences.getSpecificity(enzymeName));
            } else {
                this.enzymesCmb.setSelectedIndex(0);
            }
        }
        this.digestionCmbActionPerformed(null);
        if (this.searchParameters.getForwardIons() != null && !this.searchParameters.getForwardIons().isEmpty()) {
            ionSearched = this.searchParameters.getForwardIons().get(0);
            this.fragmentIon1Cmb.setSelectedItem(PeptideFragmentIon.getSubTypeAsString(ionSearched));
        }
        if (this.searchParameters.getRewindIons() != null && !this.searchParameters.getRewindIons().isEmpty()) {
            ionSearched = this.searchParameters.getRewindIons().get(0);
            this.fragmentIon2Cmb.setSelectedItem(PeptideFragmentIon.getSubTypeAsString(ionSearched));
        }
        if (this.searchParameters.getPrecursorAccuracy() > 0.0) {
            this.precursorIonAccuracyTxt.setText(this.searchParameters.getPrecursorAccuracy() + "");
        }
        if (this.searchParameters.getPrecursorAccuracyType() != null) {
            if (this.searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.PPM) {
                this.precursorIonUnit.setSelectedItem("ppm");
            } else if (this.searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.DA) {
                this.precursorIonUnit.setSelectedItem("Da");
            }
        }
        if (this.searchParameters.getFragmentIonAccuracy() > 0.0) {
            this.fragmentIonAccuracyTxt.setText(this.searchParameters.getFragmentIonAccuracy() + "");
        }
        if (this.searchParameters.getFragmentAccuracyType() != null) {
            if (this.searchParameters.getFragmentAccuracyType() == SearchParameters.MassAccuracyType.PPM) {
                this.fragmentIonUnit.setSelectedItem("ppm");
            } else if (this.searchParameters.getFragmentAccuracyType() == SearchParameters.MassAccuracyType.DA) {
                this.fragmentIonUnit.setSelectedItem("Da");
            }
        }
        if (this.searchParameters.getMinChargeSearched() > 0) {
            this.minPrecursorChargeTxt.setText(this.searchParameters.getMinChargeSearched() + "");
        }
        if (this.searchParameters.getMaxChargeSearched() > 0) {
            this.maxPrecursorChargeTxt.setText(this.searchParameters.getMaxChargeSearched() + "");
        }
        if (this.searchParameters.getMinIsotopicCorrection() >= 0) {
            this.isotopeMinTxt.setText(this.searchParameters.getMinIsotopicCorrection() + "");
        }
        if (this.searchParameters.getMaxIsotopicCorrection() >= 0) {
            this.isotopeMaxTxt.setText(this.searchParameters.getMaxIsotopicCorrection() + "");
        }
    }

    public boolean validateParametersInput(boolean showMessage) {
        boolean valid = true;
        this.enzymeLabel.setForeground(Color.BLACK);
        this.maxMissedCleavagesLabel.setForeground(Color.BLACK);
        this.enzymeLabel.setToolTipText(null);
        this.maxMissedCleavagesLabel.setToolTipText(null);
        valid = GuiUtilities.validateDoubleInput(this, this.precursorIonLbl, this.precursorIonAccuracyTxt, "precursor mass tolerance", "Precursor Mass Tolerance Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.fragmentIonLbl, this.fragmentIonAccuracyTxt, "fragment mass tolerance", "Fragment Mass Tolerance Error", true, showMessage, valid);
        boolean lowerChargeValid = GuiUtilities.validateIntegerInput(this, this.precursorChargeLbl, this.minPrecursorChargeTxt, "lower bound for the precursor charge", "Precursor Charge Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.precursorChargeLbl, this.maxPrecursorChargeTxt, "upper bound for the precursor charge", "Precursor Charge Error", true, showMessage, valid);
        if (!lowerChargeValid) {
            GuiUtilities.validateIntegerInput(this, this.precursorChargeLbl, this.minPrecursorChargeTxt, "lower bound for the precursor charge", "Precursor Charge Error", true, showMessage, valid);
        }
        boolean lowerBoundValid = GuiUtilities.validateIntegerInput(this, this.isotopesLbl, this.isotopeMinTxt, "lower bound for the precursor isotope", "Precursor Isotope Error", false, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.isotopesLbl, this.isotopeMaxTxt, "upper bound for the precursor isotope", "Precursor Isotope Error", false, showMessage, valid);
        if (!lowerBoundValid) {
            GuiUtilities.validateIntegerInput(this, this.isotopesLbl, this.isotopeMinTxt, "lower bound for the precursor isotope", "Precursor Isotope Error", false, showMessage, valid);
        }
        try {
            int chargeLowerBound = Integer.parseInt(this.minPrecursorChargeTxt.getText().trim());
            int chargeUpperBound = Integer.parseInt(this.maxPrecursorChargeTxt.getText().trim());
            if (chargeUpperBound < chargeLowerBound) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "The minimum precursor charge must be lower than or equal to the maximum precursor charge.", "Precursor Charge Error", 2);
                }
                valid = false;
                this.precursorChargeLbl.setForeground(Color.RED);
                this.precursorChargeLbl.setToolTipText("Minimum precursor charge > Maximum precursor charge!");
            }
        }
        catch (NumberFormatException chargeLowerBound) {
            // empty catch block
        }
        try {
            int isotopeLowerBound = Integer.parseInt(this.isotopeMinTxt.getText().trim());
            int isotopeUpperBound = Integer.parseInt(this.isotopeMaxTxt.getText().trim());
            if (isotopeUpperBound < isotopeLowerBound) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "The minimum precursor isotope must be lower than or equal to the maximum precursor isotope.", "Precursor Isotope Error", 2);
                }
                valid = false;
                this.isotopesLbl.setForeground(Color.RED);
                this.isotopesLbl.setToolTipText("Minimum precursor isotope > Maximum precursor isotope!");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if ((DigestionParameters.CleavageParameter)((Object)this.digestionCmb.getSelectedItem()) == DigestionParameters.CleavageParameter.enzyme && this.enzymesCmb.getSelectedIndex() == 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "Please select an enzyme.", "Enzyme Error", 2);
            }
            valid = false;
            this.enzymeLabel.setForeground(Color.RED);
            this.enzymeLabel.setToolTipText("No enzyme selected!");
        }
        if ((DigestionParameters.CleavageParameter)((Object)this.digestionCmb.getSelectedItem()) == DigestionParameters.CleavageParameter.enzyme) {
            valid = GuiUtilities.validateIntegerInput(this, this.maxMissedCleavagesLabel, this.maxMissedCleavagesTxt, "number of allowed missed cleavages", "Missed Cleavages Error", true, showMessage, valid);
        }
        this.okButton.setEnabled(valid);
        return valid;
    }

    public SearchParameters getSearchParameters() {
        DigestionParameters.CleavageParameter cleavagePreference;
        MsgfParameters msgfParameters;
        Object modName;
        int i;
        SearchParameters tempSearchParameters = new SearchParameters(this.searchParameters);
        DigestionParameters digestionPreferences = new DigestionParameters();
        digestionPreferences.setCleavageParameter((DigestionParameters.CleavageParameter)((Object)this.digestionCmb.getSelectedItem()));
        if ((DigestionParameters.CleavageParameter)((Object)this.digestionCmb.getSelectedItem()) == DigestionParameters.CleavageParameter.enzyme) {
            Enzyme enzyme = this.enzymeFactory.getEnzyme(this.enzymesCmb.getSelectedItem().toString());
            digestionPreferences.addEnzyme(enzyme);
            String enzymeName = enzyme.getName();
            digestionPreferences.setSpecificity(enzymeName, (DigestionParameters.Specificity)((Object)this.specificityComboBox.getSelectedItem()));
            digestionPreferences.setnMissedCleavages(enzymeName, Integer.valueOf(this.maxMissedCleavagesTxt.getText().trim()));
        }
        tempSearchParameters.setDigestionParameters(digestionPreferences);
        tempSearchParameters.setPrecursorAccuracy(Double.valueOf(this.precursorIonAccuracyTxt.getText().trim()));
        if (this.precursorIonUnit.getSelectedIndex() == 0) {
            tempSearchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.PPM);
        } else {
            tempSearchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.DA);
        }
        tempSearchParameters.setFragmentIonAccuracy(Double.valueOf(this.fragmentIonAccuracyTxt.getText().trim()));
        if (this.fragmentIonUnit.getSelectedIndex() == 0) {
            tempSearchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.PPM);
        } else {
            tempSearchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.DA);
        }
        double fragmentIonToleranceDa = tempSearchParameters.getFragmentIonAccuracyInDaltons(this.refMass);
        boolean acetylConflict = false;
        boolean pyroConflict = false;
        ModificationParameters modificationProfile = new ModificationParameters();
        for (i = 0; i < this.fixedModsTable.getRowCount(); ++i) {
            modName = (String)this.fixedModsTable.getValueAt(i, 1);
            Modification modification = this.modificationFactory.getModification((String)modName);
            Color modificationColor = (Color)this.fixedModsTable.getValueAt(i, 0);
            modificationProfile.addFixedModification(modification);
            modificationProfile.addRefinementFixedModification(modification);
            modificationProfile.setColor((String)modName, modificationColor.getRGB());
            if ((modification.getModificationType() == ModificationType.modn_peptide || modification.getModificationType() == ModificationType.modnaa_peptide || modification.getModificationType() == ModificationType.modn_protein || modification.getModificationType() == ModificationType.modnaa_protein) && Math.abs(modification.getMass() - 42.010565) < fragmentIonToleranceDa) {
                acetylConflict = true;
            }
            if (modification.getModificationType() != ModificationType.modn_peptide && modification.getModificationType() != ModificationType.modnaa_peptide && modification.getModificationType() != ModificationType.modn_protein && modification.getModificationType() != ModificationType.modnaa_protein || !(Math.abs(modification.getMass() + 17.026549) < fragmentIonToleranceDa)) continue;
            pyroConflict = true;
        }
        for (i = 0; i < this.variableModsTable.getRowCount(); ++i) {
            modName = (String)this.variableModsTable.getValueAt(i, 1);
            Color modificationColor = (Color)this.variableModsTable.getValueAt(i, 0);
            modificationProfile.addVariableModification(this.modificationFactory.getModification((String)modName));
            modificationProfile.setColor((String)modName, modificationColor.getRGB());
        }
        ArrayList<String> variableRefinemetModifications = tempSearchParameters.getModificationParameters().getRefinementVariableModifications();
        for (String varRefinementMod : variableRefinemetModifications) {
            Modification modification = this.modificationFactory.getModification(varRefinementMod);
            modificationProfile.addRefinementVariableModification(modification);
        }
        tempSearchParameters.setModificationParameters(modificationProfile);
        ArrayList<Integer> selectedForwardIons = new ArrayList<Integer>(1);
        Integer ionType = PeptideFragmentIon.getIonType(this.fragmentIon1Cmb.getSelectedItem().toString().trim());
        selectedForwardIons.add(ionType);
        tempSearchParameters.setForwardIons(selectedForwardIons);
        ArrayList<Integer> selectedRewindIons = new ArrayList<Integer>(1);
        ionType = PeptideFragmentIon.getIonType(this.fragmentIon2Cmb.getSelectedItem().toString().trim());
        selectedRewindIons.add(ionType);
        tempSearchParameters.setRewindIons(selectedRewindIons);
        tempSearchParameters.setFragmentIonAccuracy(Double.valueOf(this.fragmentIonAccuracyTxt.getText().trim()));
        int charge = Integer.valueOf(this.minPrecursorChargeTxt.getText().trim());
        tempSearchParameters.setMinChargeSearched(charge);
        charge = Integer.valueOf(this.maxPrecursorChargeTxt.getText().trim());
        tempSearchParameters.setMaxChargeSearched(charge);
        Integer minIsotope = Integer.valueOf(this.isotopeMinTxt.getText());
        tempSearchParameters.setMinIsotopicCorrection(minIsotope);
        Integer maxIsotope = Integer.valueOf(this.isotopeMaxTxt.getText());
        tempSearchParameters.setMaxIsotopicCorrection(maxIsotope);
        XtandemParameters xtandemParameters = (XtandemParameters)this.searchParameters.getIdentificationAlgorithmParameter(Advocate.xtandem.getIndex());
        if (xtandemParameters == null) {
            xtandemParameters = new XtandemParameters();
            this.searchParameters.setIdentificationAlgorithmParameter(Advocate.xtandem.getIndex(), xtandemParameters);
        }
        xtandemParameters.setProteinQuickAcetyl(!acetylConflict);
        xtandemParameters.setQuickPyrolidone(!pyroConflict);
        CometParameters cometParameters = (CometParameters)this.searchParameters.getIdentificationAlgorithmParameter(Advocate.comet.getIndex());
        if (cometParameters == null) {
            cometParameters = new CometParameters();
            this.searchParameters.setIdentificationAlgorithmParameter(Advocate.comet.getIndex(), cometParameters);
        }
        double binoffset = tempSearchParameters.getFragmentIonAccuracyInDaltons(this.refMass) / 2.0;
        cometParameters.setFragmentBinOffset(binoffset);
        if (maxIsotope > 0) {
            cometParameters.setIsotopeCorrection(1);
        } else {
            cometParameters.setIsotopeCorrection(0);
        }
        if ((DigestionParameters.CleavageParameter)((Object)this.digestionCmb.getSelectedItem()) == DigestionParameters.CleavageParameter.enzyme) {
            DigestionParameters.Specificity specificity = (DigestionParameters.Specificity)((Object)this.specificityComboBox.getSelectedItem());
            switch (specificity) {
                case specific: {
                    cometParameters.setEnzymeType(2);
                    break;
                }
                case semiSpecific: {
                    cometParameters.setEnzymeType(1);
                    break;
                }
                case specificNTermOnly: {
                    cometParameters.setEnzymeType(8);
                    break;
                }
                case specificCTermOnly: {
                    cometParameters.setEnzymeType(9);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Specificity " + (Object)((Object)specificity) + " not supported.");
                }
            }
        }
        if ((msgfParameters = (MsgfParameters)this.searchParameters.getIdentificationAlgorithmParameter(Advocate.msgf.getIndex())) == null) {
            msgfParameters = new MsgfParameters();
            this.searchParameters.setIdentificationAlgorithmParameter(Advocate.msgf.getIndex(), msgfParameters);
        }
        if ((cleavagePreference = (DigestionParameters.CleavageParameter)((Object)this.digestionCmb.getSelectedItem())) == DigestionParameters.CleavageParameter.enzyme) {
            DigestionParameters.Specificity specificity = (DigestionParameters.Specificity)((Object)this.specificityComboBox.getSelectedItem());
            switch (specificity) {
                case specific: {
                    msgfParameters.setNumberTolerableTermini(2);
                    break;
                }
                case semiSpecific: 
                case specificNTermOnly: 
                case specificCTermOnly: {
                    msgfParameters.setNumberTolerableTermini(1);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Specificity " + (Object)((Object)specificity) + " not supported.");
                }
            }
        } else if (cleavagePreference == DigestionParameters.CleavageParameter.unSpecific) {
            msgfParameters.setNumberTolerableTermini(0);
        }
        MyriMatchParameters myriMatchParameters = (MyriMatchParameters)this.searchParameters.getIdentificationAlgorithmParameter(Advocate.myriMatch.getIndex());
        if (myriMatchParameters == null) {
            myriMatchParameters = new MyriMatchParameters();
            this.searchParameters.setIdentificationAlgorithmParameter(Advocate.myriMatch.getIndex(), myriMatchParameters);
        }
        if (cleavagePreference == DigestionParameters.CleavageParameter.enzyme) {
            DigestionParameters.Specificity specificity = (DigestionParameters.Specificity)((Object)this.specificityComboBox.getSelectedItem());
            switch (specificity) {
                case specific: {
                    myriMatchParameters.setMinTerminiCleavages(2);
                    break;
                }
                case semiSpecific: 
                case specificNTermOnly: 
                case specificCTermOnly: {
                    myriMatchParameters.setMinTerminiCleavages(1);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Specificity " + (Object)((Object)specificity) + " not supported.");
                }
            }
        } else if (cleavagePreference == DigestionParameters.CleavageParameter.unSpecific) {
            myriMatchParameters.setMinTerminiCleavages(0);
        }
        return tempSearchParameters;
    }

    private void updateModificationList() {
        ArrayList<String> allModificationsList = this.modificationFactory.getModifications((ModificationCategory)((Object)this.modificationsListCombo.getSelectedItem()));
        int nFixed = this.fixedModsTable.getRowCount();
        int nVariable = this.variableModsTable.getRowCount();
        ArrayList<String> allModifications = new ArrayList<String>();
        for (String string : allModificationsList) {
            int j;
            boolean found = false;
            for (j = 0; j < nFixed; ++j) {
                if (!((String)this.fixedModsTable.getValueAt(j, 1)).equals(string)) continue;
                found = true;
                break;
            }
            if (!found) {
                for (j = 0; j < nVariable; ++j) {
                    if (!((String)this.variableModsTable.getValueAt(j, 1)).equals(string)) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            allModifications.add(string);
        }
        String[] allModificationsAsArray = (String[])allModifications.stream().sorted().toArray(String[]::new);
        this.modificationsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Name", "Mass"}){
            Class[] types;
            {
                this.types = new Class[]{Object.class, String.class, Double.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        for (String mod : allModificationsAsArray) {
            ((DefaultTableModel)this.modificationsTable.getModel()).addRow(new Object[]{new Color(this.modificationFactory.getColor(mod)), mod, this.modificationFactory.getModification(mod).getMass()});
        }
        ((DefaultTableModel)this.modificationsTable.getModel()).fireTableDataChanged();
        this.modificationsTable.repaint();
        double d = Double.MIN_VALUE;
        double minMass = Double.MAX_VALUE;
        for (String modification : this.modificationFactory.getModifications()) {
            if (this.modificationFactory.getModification(modification).getMass() > d) {
                d = this.modificationFactory.getModification(modification).getMass();
            }
            if (!(this.modificationFactory.getModification(modification).getMass() < minMass)) continue;
            minMass = this.modificationFactory.getModification(modification).getMass();
        }
        this.setAllModificationTableProperties();
        this.modificationsTable.getColumn("Mass").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(minMass), Double.valueOf(d)));
        ((JSparklinesBarChartTableCellRenderer)this.modificationsTable.getColumn("Mass").getCellRenderer()).showNumberAndChart(true, 50);
        this.fixedModsTable.getColumn("Mass").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(minMass), Double.valueOf(d)));
        ((JSparklinesBarChartTableCellRenderer)this.fixedModsTable.getColumn("Mass").getCellRenderer()).showNumberAndChart(true, 50);
        this.variableModsTable.getColumn("Mass").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(minMass), Double.valueOf(d)));
        ((JSparklinesBarChartTableCellRenderer)this.variableModsTable.getColumn("Mass").getCellRenderer()).showNumberAndChart(true, 50);
        if (this.modificationsTable.getRowCount() > 0) {
            this.modificationsTable.scrollRectToVisible(this.modificationsTable.getCellRect(0, 0, false));
            this.modificationsTable.requestFocus();
        }
        this.enableAddRemoveButtons();
    }

    private void enableAddRemoveButtons() {
        this.removeVariableModification.setEnabled(this.variableModsTable.getSelectedRow() != -1 && this.editable);
        this.addVariableModification.setEnabled(this.modificationsTable.getSelectedRow() != -1 && this.editable);
        this.removeFixedModification.setEnabled(this.fixedModsTable.getSelectedRow() != -1 && this.editable);
        this.addFixedModification.setEnabled(this.modificationsTable.getSelectedRow() != -1 && this.editable);
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

