/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.tools;

import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.tools.ProcessingParameters;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class ProcessingParametersDialog
extends JDialog {
    private boolean canceled = false;
    private boolean editable;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JSpinner nThreadsSpinner;
    private JButton okButton;
    private JLabel performanceLbl;
    private JPanel performancePanel;
    private JComboBox processingTypeCmb;
    private JLabel processingTypeLbl;
    private JPanel processingTypePanel;

    public ProcessingParametersDialog() {
    }

    public ProcessingParametersDialog(Frame parentFrame, ProcessingParameters processingPreferences, boolean editable) {
        super(parentFrame, true);
        this.initComponents();
        this.editable = editable;
        this.setUpGui();
        this.populateGUI(processingPreferences);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public ProcessingParametersDialog(Dialog owner, Frame parentFrame, ProcessingParameters processingPreferences, boolean editable) {
        super(owner, true);
        this.initComponents();
        this.editable = editable;
        this.setUpGui();
        this.populateGUI(processingPreferences);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.processingTypeCmb.setRenderer(new AlignedListCellRenderer(0));
        this.nThreadsSpinner.setEnabled(this.editable);
    }

    private void populateGUI(ProcessingParameters processingPreferences) {
        this.processingTypeCmb.setSelectedItem((Object)processingPreferences.getProcessingType());
        this.nThreadsSpinner.setModel(new SpinnerNumberModel((Number)processingPreferences.getnThreads(), Integer.valueOf(1), null, (Number)1));
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean validateInput() {
        return true;
    }

    public ProcessingParameters getProcessingParameters() {
        ProcessingParameters processingParameters = new ProcessingParameters();
        processingParameters.setProcessingType((ProcessingParameters.ProcessingType)((Object)this.processingTypeCmb.getSelectedItem()));
        processingParameters.setnThreads((Integer)this.nThreadsSpinner.getValue());
        return processingParameters;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.performancePanel = new JPanel();
        this.performanceLbl = new JLabel();
        this.nThreadsSpinner = new JSpinner();
        this.processingTypePanel = new JPanel();
        this.processingTypeLbl = new JLabel();
        this.processingTypeCmb = new JComboBox();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Processing Preferences");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.performancePanel.setBorder(BorderFactory.createTitledBorder("Performance Settings"));
        this.performancePanel.setOpaque(false);
        this.performanceLbl.setText("Number of Cores");
        this.nThreadsSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.nThreadsSpinner.setRequestFocusEnabled(false);
        GroupLayout performancePanelLayout = new GroupLayout(this.performancePanel);
        this.performancePanel.setLayout(performancePanelLayout);
        performancePanelLayout.setHorizontalGroup(performancePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(performancePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.performanceLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 67, Short.MAX_VALUE).addComponent(this.nThreadsSpinner, -2, 200, -2).addContainerGap()));
        performancePanelLayout.setVerticalGroup(performancePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(performancePanelLayout.createSequentialGroup().addContainerGap().addGroup(performancePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.performanceLbl).addComponent(this.nThreadsSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.processingTypePanel.setBorder(BorderFactory.createTitledBorder("Processing Type"));
        this.processingTypePanel.setOpaque(false);
        this.processingTypeLbl.setText("Execution");
        this.processingTypeCmb.setModel(new DefaultComboBoxModel<ProcessingParameters.ProcessingType>(ProcessingParameters.ProcessingType.values()));
        this.processingTypeCmb.setEnabled(false);
        GroupLayout processingTypePanelLayout = new GroupLayout(this.processingTypePanel);
        this.processingTypePanel.setLayout(processingTypePanelLayout);
        processingTypePanelLayout.setHorizontalGroup(processingTypePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(processingTypePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.processingTypeLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.processingTypeCmb, -2, 200, -2).addContainerGap()));
        processingTypePanelLayout.setVerticalGroup(processingTypePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(processingTypePanelLayout.createSequentialGroup().addContainerGap().addGroup(processingTypePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.processingTypeLbl).addComponent(this.processingTypeCmb, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProcessingParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProcessingParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.processingTypePanel, -1, -1, Short.MAX_VALUE).addComponent(this.performancePanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.processingTypePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.performancePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

