/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.spectrum;

import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DefaultXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;

public class MassErrorPlot
extends JPanel {
    private IonMatch[] annotations;
    private ChartPanel chartPanel;

    public MassErrorPlot() {
    }

    public MassErrorPlot(IonMatch[] annotations, Spectrum currentSpectrum, double massTolerance) throws InterruptedException {
        this(annotations, currentSpectrum, massTolerance, false);
    }

    public MassErrorPlot(IonMatch[] annotations, Spectrum currentSpectrum, double massTolerance, boolean useRelativeError) {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 2));
        this.annotations = annotations;
        if (annotations.length > 0) {
            boolean useIntensityGrading = false;
            DefaultXYDataset xyDataset = new DefaultXYDataset();
            ArrayList colors = new ArrayList();
            Arrays.stream(annotations).forEach(ionMatch -> {
                double[][] dataXY = new double[2][1];
                dataXY[0][0] = ionMatch.peakMz;
                dataXY[1][0] = useRelativeError ? ionMatch.getRelativeError() : ionMatch.getAbsoluteError();
                xyDataset.addSeries((Comparable)((Object)ionMatch.getPeakAnnotation(true)), dataXY);
                colors.add(SpectrumPanel.determineFragmentIonColor(ionMatch.ion, false));
            });
            JFreeChart chart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            XYPlot plot = chart.getXYPlot();
            DefaultXYItemRenderer renderer = new DefaultXYItemRenderer();
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
            for (int i = 0; i < colors.size(); ++i) {
                if (useIntensityGrading) {
                    renderer.setSeriesPaint(i, (Paint)colors.get(i));
                    renderer.setSeriesShape(i, renderer.getBaseShape());
                    continue;
                }
                renderer.setSeriesPaint(i, (Paint)colors.get(i));
                renderer.setSeriesShape(i, renderer.getBaseShape());
            }
            plot.setRenderer((XYItemRenderer)renderer);
            plot.getDomainAxis().setUpperMargin(0.0);
            plot.getDomainAxis().setLowerMargin(0.0);
            plot.getRangeAxis().setLowerBound(-massTolerance);
            plot.getRangeAxis().setUpperBound(massTolerance);
            plot.setRangeGridlinePaint((Paint)Color.black);
            ValueAxis domainAxis = plot.getDomainAxis();
            domainAxis.setRange(0.0, currentSpectrum.getMaxMz());
            plot.setDomainGridlinesVisible(false);
            chart.getPlot().setOutlineVisible(false);
            chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
            chart.setBackgroundPaint((Paint)Color.WHITE);
            this.chartPanel = new ChartPanel(chart);
            this.chartPanel.setBackground(Color.WHITE);
            this.add((Component)this.chartPanel);
        }
    }

    public int getNumberOfDataPointsInPlot() {
        return this.annotations.length;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }
}

