/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.compression;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzUtils {
    public static final int BUFFER_LENGTH = 1024;
    public static final String GZ_EXTENSION = ".gz";

    public static void gzFile(File file, boolean remove) {
        File gzFile = new File(file.getAbsoluteFile() + GZ_EXTENSION);
        GzUtils.gzFile(file, gzFile, remove);
    }

    public static void gzFile(File file, File gzFile, boolean remove) {
        try {
            char[] buffer = new char[1024];
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                FileOutputStream fileStream = new FileOutputStream(gzFile);
                GZIPOutputStream gzipStream = new GZIPOutputStream(fileStream);
                OutputStreamWriter encoder = new OutputStreamWriter((OutputStream)gzipStream, "UTF-8");
                try (BufferedWriter bw = new BufferedWriter(encoder);){
                    int read;
                    while ((read = reader.read(buffer)) != -1) {
                        bw.write(buffer, 0, read);
                    }
                }
            }
            if (remove) {
                file.delete();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void gunzipFile(File gzFile, boolean remove) {
        String gzFilePath = gzFile.getAbsolutePath();
        if (!gzFilePath.endsWith(GZ_EXTENSION)) {
            throw new IllegalArgumentException("Gz file expected to end with .gz");
        }
        File destinationFile = new File(gzFilePath.substring(0, gzFilePath.length() - GZ_EXTENSION.length()));
        GzUtils.gunzipFile(gzFile, destinationFile, remove);
    }

    public static void gunzipFile(File gzFile, File destinationFile, boolean remove) {
        try {
            char[] buffer = new char[1024];
            FileInputStream fileStream = new FileInputStream(gzFile);
            GZIPInputStream gzipStream = new GZIPInputStream(fileStream);
            InputStreamReader decoder = new InputStreamReader((InputStream)gzipStream, "UTF-8");
            try (BufferedReader reader = new BufferedReader(decoder);
                 BufferedWriter writer = new BufferedWriter(new FileWriter(destinationFile));){
                int read;
                while ((read = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, read);
                }
            }
            if (remove) {
                gzFile.delete();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

