/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.compression.SectionGzWriter;

import com.compomics.util.Util;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.io.flat.SimpleFileWriter;
import com.compomics.util.threading.SimpleSemaphore;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WriterBySection
implements AutoCloseable {
    public static final int CHAR_BUFFER_SIZE = 512;
    private final File tempFolder;
    private final String destinationFileName;
    private final ConcurrentHashMap<String, File> tempFileMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, SimpleFileWriter> tempWriterMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, SimpleSemaphore> semaphoreMap = new ConcurrentHashMap();
    private final SimpleFileWriter writer;
    private final SimpleSemaphore writerSemaphore = new SimpleSemaphore(1);
    public final boolean deleteTempFiles;
    public final boolean gzipTemp;

    public WriterBySection(File destinationFile, File tempFolder, boolean deleteTempFiles, boolean gzipTemp, boolean gzipDestination) throws FileNotFoundException, IOException {
        this.tempFolder = tempFolder;
        this.destinationFileName = IoUtil.getFileName(destinationFile);
        this.deleteTempFiles = deleteTempFiles;
        this.gzipTemp = gzipTemp;
        this.writer = new SimpleFileWriter(destinationFile, gzipDestination);
    }

    @Override
    public void close() {
        for (Map.Entry<String, SimpleSemaphore> entry : this.semaphoreMap.entrySet()) {
            String sectionName = entry.getKey();
            SimpleSemaphore simpleSemaphore = entry.getValue();
            simpleSemaphore.acquire();
            simpleSemaphore.release();
            if (!this.tempWriterMap.containsKey(sectionName)) continue;
            throw new IllegalArgumentException("Attempted to close the gz file writer before section " + sectionName + " is completed.");
        }
        this.writer.close();
    }

    public synchronized void registerSection(String sectionName) throws FileNotFoundException, IOException {
        if (Util.containsForbiddenCharacter(sectionName)) {
            throw new IllegalArgumentException("Invalid section name '" + sectionName + "'. Section names should not contain characters forbidden in file names.");
        }
        StringBuilder fileName = new StringBuilder();
        if (this.destinationFileName.endsWith(".gz")) {
            fileName.append(this.destinationFileName.substring(0, this.destinationFileName.length() - 3));
        } else {
            fileName.append(this.destinationFileName);
        }
        fileName.append('.').append(sectionName);
        if (this.gzipTemp) {
            fileName.append(".gz");
        }
        File tempFile = new File(this.tempFolder, fileName.toString());
        SimpleFileWriter tempWriter = new SimpleFileWriter(tempFile, this.gzipTemp);
        this.tempFileMap.put(sectionName, tempFile);
        this.tempWriterMap.put(sectionName, tempWriter);
        this.semaphoreMap.put(sectionName, new SimpleSemaphore(1));
    }

    public void sectionCompleted(String sectionName) {
        SimpleSemaphore sectionSemaphore = this.semaphoreMap.get(sectionName);
        sectionSemaphore.acquire();
        SimpleFileWriter tempWriter = this.tempWriterMap.get(sectionName);
        tempWriter.close();
        File tempFile = this.tempFileMap.get(sectionName);
        this.writerSemaphore.acquire();
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(tempFile);){
            int lengthRead = 512;
            char[] buffer = new char[lengthRead];
            while (lengthRead != -1) {
                lengthRead = reader.read(buffer);
                if (lengthRead <= 0) continue;
                this.writer.write(buffer, 0, lengthRead);
            }
        }
        this.writerSemaphore.release();
        if (this.deleteTempFiles) {
            tempFile.delete();
        }
        this.tempFileMap.remove(sectionName);
        this.tempWriterMap.remove(sectionName);
        sectionSemaphore.release();
    }

    public void newLine(String sectionName) {
        this.write(sectionName, Util.LINE_SEPARATOR);
    }

    public void write(String sectionName, String content) {
        SimpleSemaphore sectionSemaphore = this.semaphoreMap.get(sectionName);
        sectionSemaphore.acquire();
        SimpleFileWriter tempWriter = this.tempWriterMap.get(sectionName);
        tempWriter.write(content);
        sectionSemaphore.release();
    }

    public void write(String sectionName, char[] buffer, int offset, int length) {
        SimpleSemaphore sectionSemaphore = this.semaphoreMap.get(sectionName);
        sectionSemaphore.acquire();
        SimpleFileWriter tempWriter = this.tempWriterMap.get(sectionName);
        tempWriter.write(buffer, offset, length);
        sectionSemaphore.release();
    }
}

