/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.export.features.reporter;

import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.features.ReporterExportFeature;
import com.compomics.util.io.export.features.peptideshaker.PsProteinFeature;
import com.compomics.util.io.export.features.reporter.ReporterPeptideFeature;
import java.util.ArrayList;
import java.util.Arrays;

public enum ReporterProteinFeatures implements ReporterExportFeature
{
    raw_unique_ratio("Raw Unique Ratios", "The ratios of this protein group prior to normalization accounting only for peptides unique to this protein group.", true, false),
    unique_ratio("Unique Ratios", "The normalized ratios of this protein group accounting only for peptides unique to this group.", true, false),
    raw_shared_ratio("Raw Shared Ratios", "The ratios of this protein group prior to normalization accounting only for peptides shared with other protein groups.", true, false),
    shared_ratio("Shared Ratios", "The normalized ratios of this protein group accounting only for peptides shared with other protein groups.", true, false),
    raw_ratio("Raw Ratios", "The ratios of this protein group prior to normalization.", true, false),
    ratio("Ratios", "The normalized ratios of this protein group.", true, false),
    spread("Spread", "The spread of the peptide ratios of this protein group.", true, false);

    private String title;
    private String description;
    private boolean hasChannels;
    public static final String type = "Protein Reporter Quantification Summary";
    private final boolean advanced;

    private ReporterProteinFeatures(String title, String description, boolean hasChannels, boolean advanced) {
        this.title = title;
        this.description = description;
        this.hasChannels = hasChannels;
        this.advanced = advanced;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getFeatureFamily() {
        return type;
    }

    @Override
    public ArrayList<ExportFeature> getExportFeatures(boolean includeSubFeatures) {
        ArrayList<ExportFeature> result = PsProteinFeature.values()[0].getExportFeatures(includeSubFeatures);
        result.addAll(Arrays.asList(ReporterProteinFeatures.values()));
        if (includeSubFeatures) {
            result.addAll(ReporterPeptideFeature.values()[0].getExportFeatures(includeSubFeatures));
        }
        return result;
    }

    @Override
    public boolean hasChannels() {
        return this.hasChannels;
    }

    @Override
    public boolean isAdvanced() {
        return this.advanced;
    }
}

