/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification;

import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.identification.filtering.PeptideAssumptionFilter;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.parameters.DummyParameters;
import com.compomics.util.experiment.io.parameters.MarshallableParameter;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.json.marshallers.IdentificationParametersMarshaller;
import com.compomics.util.parameters.identification.advanced.FractionParameters;
import com.compomics.util.parameters.identification.advanced.GeneParameters;
import com.compomics.util.parameters.identification.advanced.IdMatchValidationParameters;
import com.compomics.util.parameters.identification.advanced.ModificationLocalizationParameters;
import com.compomics.util.parameters.identification.advanced.PeptideVariantsParameters;
import com.compomics.util.parameters.identification.advanced.ProteinInferenceParameters;
import com.compomics.util.parameters.identification.advanced.PsmScoringParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import java.io.File;
import java.io.IOException;

public class IdentificationParameters
extends ExperimentObject
implements MarshallableParameter {
    public static final String CURRENT_VERSION = "5.0.1";
    private String marshallableParameterType = null;
    public final String version = "5.0.1";
    private String name;
    private String description;
    private boolean defaultDescription = true;
    private SearchParameters searchParameters;
    private AnnotationParameters annotationParameters;
    private SequenceMatchingParameters sequenceMatchingParameters;
    private PeptideVariantsParameters peptideVariantsParameters;
    private GeneParameters geneParameters;
    private PsmScoringParameters psmScoringParameters;
    private PeptideAssumptionFilter peptideAssumptionFilter;
    private ModificationLocalizationParameters modificationLocalizationParameters;
    private ProteinInferenceParameters proteinInferenceParameters;
    private IdMatchValidationParameters idValidationParameters;
    private FractionParameters fractionParameters;
    private FastaParameters fastaParameters;

    public IdentificationParameters() {
    }

    public IdentificationParameters(SearchParameters searchParameters) {
        this.searchParameters = searchParameters;
        this.setParametersFromSearch(searchParameters);
    }

    public IdentificationParameters(String name, String description, SearchParameters searchParameters, AnnotationParameters annotationParameters, SequenceMatchingParameters sequenceMatchingParameters, PeptideVariantsParameters peptideVariantsParameters, GeneParameters geneParameters, PsmScoringParameters psmScoringParameters, PeptideAssumptionFilter peptideAssumptionFilter, ModificationLocalizationParameters ModificationLocalizationParameters2, ProteinInferenceParameters proteinInferenceParameters, IdMatchValidationParameters idValidationParameters, FractionParameters fractionParameters, FastaParameters fastaParameters) {
        this.name = name;
        this.description = description;
        this.searchParameters = searchParameters;
        this.annotationParameters = annotationParameters;
        this.sequenceMatchingParameters = sequenceMatchingParameters;
        this.peptideVariantsParameters = peptideVariantsParameters;
        this.geneParameters = geneParameters;
        this.psmScoringParameters = psmScoringParameters;
        this.peptideAssumptionFilter = peptideAssumptionFilter;
        this.modificationLocalizationParameters = ModificationLocalizationParameters2;
        this.proteinInferenceParameters = proteinInferenceParameters;
        this.idValidationParameters = idValidationParameters;
        this.fractionParameters = fractionParameters;
        this.fastaParameters = fastaParameters;
    }

    public SearchParameters getSearchParameters() {
        return this.searchParameters;
    }

    public void setSearchParameters(SearchParameters searchParameters) {
        this.searchParameters = searchParameters;
        if (this.defaultDescription || this.description == null || this.description.length() == 0) {
            this.setDescription(searchParameters.getShortDescription(), true);
        }
    }

    public static double getPpmTolerance(double daltonTolerance, double refMass) {
        return daltonTolerance / refMass * 1000000.0;
    }

    public static double getDaTolerance(double ppmTolerance, double refMass) {
        return ppmTolerance / 1000000.0 * refMass;
    }

    public AnnotationParameters getAnnotationParameters() {
        return this.annotationParameters;
    }

    public void setAnnotationParameters(AnnotationParameters annotationParameters) {
        this.annotationParameters = annotationParameters;
    }

    public PeptideAssumptionFilter getPeptideAssumptionFilter() {
        return this.peptideAssumptionFilter;
    }

    public void setPeptideAssumptionFilter(PeptideAssumptionFilter peptideAssumptionFilter) {
        this.peptideAssumptionFilter = peptideAssumptionFilter;
    }

    public PsmScoringParameters getPsmScoringParameters() {
        return this.psmScoringParameters;
    }

    public void setPsmScoringParameters(PsmScoringParameters psmScoringParameters) {
        this.psmScoringParameters = psmScoringParameters;
    }

    public ModificationLocalizationParameters getModificationLocalizationParameters() {
        return this.modificationLocalizationParameters;
    }

    public void setModificationLocalizationParameters(ModificationLocalizationParameters modificationLocalizationParameters) {
        this.modificationLocalizationParameters = modificationLocalizationParameters;
    }

    public SequenceMatchingParameters getSequenceMatchingParameters() {
        return this.sequenceMatchingParameters;
    }

    public void setSequenceMatchingParameters(SequenceMatchingParameters sequenceMatchingParameters) {
        this.sequenceMatchingParameters = sequenceMatchingParameters;
    }

    public PeptideVariantsParameters getPeptideVariantsParameters() {
        return this.peptideVariantsParameters;
    }

    public void setPeptideVariantsParameters(PeptideVariantsParameters peptideVariantsParameters) {
        this.peptideVariantsParameters = peptideVariantsParameters;
    }

    public IdMatchValidationParameters getIdValidationParameters() {
        return this.idValidationParameters;
    }

    public void setIdValidationParameters(IdMatchValidationParameters idValidationParameters) {
        this.idValidationParameters = idValidationParameters;
    }

    public ProteinInferenceParameters getProteinInferenceParameters() {
        return this.proteinInferenceParameters;
    }

    public void setProteinInferenceParameters(ProteinInferenceParameters proteinInferenceParameters) {
        this.proteinInferenceParameters = proteinInferenceParameters;
    }

    public GeneParameters getGeneParameters() {
        return this.geneParameters;
    }

    public void setGeneParameters(GeneParameters geneParameters) {
        this.geneParameters = geneParameters;
    }

    public FractionParameters getFractionParameters() {
        return this.fractionParameters;
    }

    public void setFractionParameters(FractionParameters fractionParameters) {
        this.fractionParameters = fractionParameters;
    }

    public FastaParameters getFastaParameters() {
        return this.fastaParameters;
    }

    public void setFastaParameters(FastaParameters fastaParameters) {
        this.fastaParameters = fastaParameters;
    }

    public static IdentificationParameters getIdentificationParameters(File identificationParametersFile) throws IOException {
        IdentificationParameters identificationParameters;
        Object savedObject;
        IdentificationParametersMarshaller jsonMarshaller = new IdentificationParametersMarshaller();
        Class expectedObjectType = DummyParameters.class;
        Object object = jsonMarshaller.fromJson(expectedObjectType, identificationParametersFile);
        DummyParameters dummyParameters = (DummyParameters)object;
        if (dummyParameters.version == null || !dummyParameters.version.equals(CURRENT_VERSION)) {
            throw new IllegalArgumentException("Version of parameters file " + identificationParametersFile + " not supported.");
        }
        if (dummyParameters.getType() == MarshallableParameter.Type.search_parameters) {
            expectedObjectType = SearchParameters.class;
            savedObject = jsonMarshaller.fromJson(expectedObjectType, identificationParametersFile);
        } else if (dummyParameters.getType() == MarshallableParameter.Type.identification_parameters) {
            expectedObjectType = IdentificationParameters.class;
            savedObject = jsonMarshaller.fromJson(expectedObjectType, identificationParametersFile);
        } else {
            throw new IllegalArgumentException("Parameters file " + identificationParametersFile + " not recognized.");
        }
        if (savedObject instanceof SearchParameters) {
            SearchParameters searchParameters = (SearchParameters)savedObject;
            identificationParameters = new IdentificationParameters(searchParameters);
            identificationParameters.setName(IoUtil.removeExtension(identificationParametersFile.getName()));
        } else if (savedObject instanceof IdentificationParameters) {
            identificationParameters = (IdentificationParameters)savedObject;
        } else {
            throw new UnsupportedOperationException("Parameters of type " + savedObject.getClass() + " not supported.");
        }
        identificationParameters.getSearchParameters().getDigestionParameters();
        return identificationParameters;
    }

    public static boolean supportedVersion(File identificationParametersFile) throws IOException {
        IdentificationParametersMarshaller jsonMarshaller = new IdentificationParametersMarshaller();
        Class<DummyParameters> expectedObjectType = DummyParameters.class;
        Object object = jsonMarshaller.fromJson(expectedObjectType, identificationParametersFile);
        DummyParameters dummyParameters = (DummyParameters)object;
        return dummyParameters.version != null && dummyParameters.version.equals(CURRENT_VERSION);
    }

    public static void saveIdentificationParameters(IdentificationParameters identificationParameters, File identificationParametersFile) throws IOException {
        IdentificationParametersMarshaller jsonMarshaller = new IdentificationParametersMarshaller();
        identificationParameters.setType();
        jsonMarshaller.saveObjectToJson(identificationParameters, identificationParametersFile);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getDefaultDescription() {
        return this.defaultDescription;
    }

    public void setDescription(String description, boolean automaticallyGenerated) {
        this.description = description;
        this.defaultDescription = automaticallyGenerated;
    }

    public void setParametersFromSearch(SearchParameters searchParameters) {
        this.setSearchParameters(searchParameters);
        this.annotationParameters = new AnnotationParameters();
        this.annotationParameters.addNeutralLoss(NeutralLoss.H2O);
        this.annotationParameters.addNeutralLoss(NeutralLoss.NH3);
        if (searchParameters != null) {
            this.annotationParameters.setParametersFromSearchParameters(searchParameters);
        }
        this.annotationParameters.setIntensityLimit(0.75);
        this.annotationParameters.setAutomaticAnnotation(true);
        this.peptideAssumptionFilter = new PeptideAssumptionFilter();
        if (searchParameters != null) {
            this.peptideAssumptionFilter.setFilterFromSearchParameters(searchParameters);
        }
        if (this.psmScoringParameters == null) {
            this.psmScoringParameters = new PsmScoringParameters();
        }
        if (this.modificationLocalizationParameters == null) {
            this.modificationLocalizationParameters = new ModificationLocalizationParameters();
        }
        if (this.sequenceMatchingParameters == null) {
            this.sequenceMatchingParameters = SequenceMatchingParameters.getDefaultSequenceMatching();
        }
        if (this.peptideVariantsParameters == null) {
            this.peptideVariantsParameters = new PeptideVariantsParameters();
        }
        if (this.geneParameters == null) {
            this.geneParameters = new GeneParameters();
        }
        if (this.proteinInferenceParameters == null) {
            this.proteinInferenceParameters = new ProteinInferenceParameters();
        }
        if (this.idValidationParameters == null) {
            this.idValidationParameters = new IdMatchValidationParameters();
        }
        if (this.fractionParameters == null) {
            this.fractionParameters = new FractionParameters();
        }
        if (this.fastaParameters == null) {
            this.fastaParameters = new FastaParameters();
        }
        if (searchParameters != null) {
            this.setDescription(searchParameters.getShortDescription(), true);
        }
    }

    @Override
    public void setType() {
        this.marshallableParameterType = MarshallableParameter.Type.identification_parameters.name();
    }

    @Override
    public MarshallableParameter.Type getType() {
        if (this.marshallableParameterType == null) {
            return null;
        }
        return MarshallableParameter.Type.valueOf(this.marshallableParameterType);
    }

    public boolean equals(IdentificationParameters otherIdentificationParameters) {
        if (otherIdentificationParameters == null) {
            return false;
        }
        if (!this.searchParameters.equals(otherIdentificationParameters.getSearchParameters())) {
            return false;
        }
        if (!this.annotationParameters.isSameAs(otherIdentificationParameters.getAnnotationParameters())) {
            return false;
        }
        if (!this.sequenceMatchingParameters.isSameAs(otherIdentificationParameters.getSequenceMatchingParameters())) {
            return false;
        }
        if (!this.getPeptideVariantsParameters().isSameAs(otherIdentificationParameters.getPeptideVariantsParameters())) {
            return false;
        }
        if (!this.geneParameters.equals(otherIdentificationParameters.getGeneParameters())) {
            return false;
        }
        if (!this.psmScoringParameters.equals(otherIdentificationParameters.getPsmScoringParameters())) {
            return false;
        }
        if (!this.peptideAssumptionFilter.isSameAs(otherIdentificationParameters.getPeptideAssumptionFilter())) {
            return false;
        }
        if (!this.modificationLocalizationParameters.equals(otherIdentificationParameters.getModificationLocalizationParameters())) {
            return false;
        }
        if (!this.proteinInferenceParameters.equals(otherIdentificationParameters.getProteinInferenceParameters())) {
            return false;
        }
        if (!this.fractionParameters.isSameAs(otherIdentificationParameters.getFractionParameters())) {
            return false;
        }
        if (!this.idValidationParameters.equals(otherIdentificationParameters.getIdValidationParameters())) {
            return false;
        }
        return this.fastaParameters.isSameAs(otherIdentificationParameters.getFastaParameters());
    }
}

