/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.advanced;

import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.Map;
import java.util.TreeMap;

public class GeneParameters
extends ExperimentObject {
    private Boolean autoUpdate;
    private Boolean useGeneMapping;
    private Integer backgroundSpecies;

    public GeneParameters() {
    }

    public GeneParameters(GeneParameters genePreferences) {
    }

    public Boolean getUseGeneMapping() {
        if (this.useGeneMapping == null) {
            this.useGeneMapping = true;
        }
        return this.useGeneMapping;
    }

    public void setUseGeneMapping(Boolean useGeneMapping) {
        this.useGeneMapping = useGeneMapping;
    }

    public Boolean getAutoUpdate() {
        if (this.autoUpdate == null) {
            this.autoUpdate = true;
        }
        return this.autoUpdate;
    }

    public void setAutoUpdate(Boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public boolean equals(GeneParameters genePreferences) {
        return this.getAutoUpdate().equals(genePreferences.getAutoUpdate());
    }

    public Integer getBackgroundSpecies() {
        return this.backgroundSpecies;
    }

    public void setBackgroundSpecies(Integer selectedBackgroundSpecies) {
        this.backgroundSpecies = selectedBackgroundSpecies;
    }

    public void setBackgroundSpeciesFromFastaSummary(FastaSummary fastaSummary) {
        SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
        try {
            TreeMap<String, Integer> speciesOccurrence = fastaSummary.speciesOccurrence;
            Integer occurrenceMax = null;
            for (Map.Entry<String, Integer> entry : speciesOccurrence.entrySet()) {
                String uniprotTaxonomy = entry.getKey();
                if (uniprotTaxonomy.equals("Unknown") || !this.getUseGeneMapping().booleanValue()) continue;
                Integer occurrence = entry.getValue();
                if (occurrenceMax != null && occurrence <= occurrenceMax) continue;
                occurrenceMax = occurrence;
                try {
                    Integer taxon = speciesFactory.getUniprotTaxonomy().getId(uniprotTaxonomy, true);
                    if (taxon == null) continue;
                    this.setBackgroundSpecies(taxon);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getShortDescription() {
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("Use Gene Mappings: ").append(this.getUseGeneMapping()).append(".").append(newLine);
        output.append("Update Gene Mappings: ").append(this.getAutoUpdate()).append(".").append(newLine);
        if (this.backgroundSpecies != null) {
            SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
            String speciesName = speciesFactory.getName(this.backgroundSpecies);
            output.append("Species: ").append(speciesName).append(".").append(newLine);
        } else {
            output.append("Species: ").append("(not selected)").append(newLine);
        }
        return output.toString();
    }
}

