/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.advanced;

import com.compomics.util.experiment.biology.variants.AaSubstitutionMatrix;
import com.compomics.util.experiment.identification.protein_inference.fm_index.SNPElement;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;
import java.util.HashMap;

public class PeptideVariantsParameters
extends ExperimentObject {
    private VariantType variantType = VariantType.NO_VARIANT;
    private int nVariants = 0;
    private int nAaDeletions = 0;
    private int nAaInsertions = 0;
    private int nAaSubstitutions = 0;
    private int nAaSwap = 0;
    private AaSubstitutionMatrix aaSubstitutionMatrix = AaSubstitutionMatrix.noSubstitution;
    private HashMap<String, ArrayList<SNPElement>> fixedVariants = new HashMap();

    public int getnAaDeletions() {
        return this.nAaDeletions;
    }

    public void setnAaDeletions(int nAaDeletions) {
        this.nAaDeletions = nAaDeletions;
    }

    public int getnAaInsertions() {
        return this.nAaInsertions;
    }

    public void setnAaInsertions(int nAaInsertions) {
        this.nAaInsertions = nAaInsertions;
    }

    public int getnAaSubstitutions() {
        return this.nAaSubstitutions;
    }

    public void setnAaSubstitutions(int nAaSubstitutions) {
        this.nAaSubstitutions = nAaSubstitutions;
    }

    public int getnAaSwap() {
        return this.nAaSwap;
    }

    public void setnAaSwap(int nAaSwap) {
        this.nAaSwap = nAaSwap;
    }

    public AaSubstitutionMatrix getAaSubstitutionMatrix() {
        return this.aaSubstitutionMatrix;
    }

    public void setAaSubstitutionMatrix(AaSubstitutionMatrix aaSubstitutionMatrix) {
        this.aaSubstitutionMatrix = aaSubstitutionMatrix;
    }

    public VariantType getVariantType() {
        return this.variantType;
    }

    public void setVatiantType(VariantType variantType) {
        this.variantType = variantType;
    }

    public int getnVariants() {
        return this.nVariants;
    }

    public void setnVariants(int nVariants) {
        this.nVariants = nVariants;
    }

    public boolean isSameAs(PeptideVariantsParameters peptideVariantsPreferences) {
        if (this.nAaDeletions != peptideVariantsPreferences.getnAaDeletions()) {
            return false;
        }
        if (this.nAaInsertions != peptideVariantsPreferences.getnAaInsertions()) {
            return false;
        }
        if (this.nAaSubstitutions != peptideVariantsPreferences.getnAaSubstitutions()) {
            return false;
        }
        if (this.nAaSwap != peptideVariantsPreferences.getnAaSwap()) {
            return false;
        }
        if (this.variantType != peptideVariantsPreferences.getVariantType()) {
            return false;
        }
        if (this.nVariants != peptideVariantsPreferences.getnVariants()) {
            return false;
        }
        return this.aaSubstitutionMatrix.isSameAs(peptideVariantsPreferences.getAaSubstitutionMatrix());
    }

    public String getShortDescription() {
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("#Variants: ").append(this.nVariants).append(".").append(newLine);
        if (this.variantType == VariantType.SPECIFIC) {
            output.append("AA Deletions: ").append(this.nAaDeletions).append(".").append(newLine);
            output.append("AA Insertions: ").append(this.nAaInsertions).append(".").append(newLine);
            output.append("AA Substitutions: ").append(this.nAaSubstitutions).append(".").append(newLine);
            output.append("AA Swap: ").append(this.nAaSwap).append(".").append(newLine);
            output.append("Substitution Matrix: ").append(this.aaSubstitutionMatrix.toString()).append(".").append(newLine);
        }
        return output.toString();
    }

    public static PeptideVariantsParameters getNoVariantPreferences() {
        PeptideVariantsParameters peptideVariantsPreferences = new PeptideVariantsParameters();
        peptideVariantsPreferences.setnVariants(0);
        peptideVariantsPreferences.setVatiantType(VariantType.NO_VARIANT);
        peptideVariantsPreferences.setAaSubstitutionMatrix(AaSubstitutionMatrix.noSubstitution);
        return peptideVariantsPreferences;
    }

    public HashMap<String, ArrayList<SNPElement>> getFixedVariants() {
        return this.fixedVariants;
    }

    public void setFixedVariants(HashMap<String, ArrayList<SNPElement>> fixedVariants) {
        this.fixedVariants = fixedVariants;
    }

    public static enum VariantType {
        NO_VARIANT,
        GENERIC,
        SPECIFIC,
        FIXED;

    }
}

