/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.search;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class DigestionParameters
extends ExperimentObject {
    private CleavageParameter cleavageParameter;
    private ArrayList<Enzyme> enzymes;
    private HashMap<String, Integer> nMissedCleavages;
    private HashMap<String, Specificity> specificity;

    public static DigestionParameters clone(DigestionParameters digestionParameters) {
        DigestionParameters clone = new DigestionParameters();
        clone.setCleavageParameter(digestionParameters.getCleavageParameter());
        if (digestionParameters.getCleavageParameter() == CleavageParameter.enzyme) {
            for (Enzyme enzyme : digestionParameters.getEnzymes()) {
                clone.addEnzyme(enzyme);
                String enzymeName = enzyme.getName();
                clone.setSpecificity(enzymeName, digestionParameters.getSpecificity(enzymeName));
                clone.setnMissedCleavages(enzymeName, digestionParameters.getnMissedCleavages(enzymeName));
            }
        }
        return clone;
    }

    public static DigestionParameters getDefaultParameters() {
        DigestionParameters digestionParameters = new DigestionParameters();
        digestionParameters.setCleavageParameter(CleavageParameter.enzyme);
        String enzymeName = "Trypsin";
        Enzyme trypsin = EnzymeFactory.getInstance().getEnzyme(enzymeName);
        if (trypsin != null) {
            digestionParameters.addEnzyme(trypsin);
            digestionParameters.setnMissedCleavages(enzymeName, 2);
        }
        return digestionParameters;
    }

    public boolean hasEnzymes() {
        return this.enzymes != null && !this.enzymes.isEmpty();
    }

    public ArrayList<Enzyme> getEnzymes() {
        return this.enzymes;
    }

    public void setEnzymes(ArrayList<Enzyme> enzymes) {
        this.enzymes = enzymes;
    }

    public void addEnzyme(Enzyme enzyme) {
        if (this.enzymes == null) {
            this.enzymes = new ArrayList(1);
        }
        this.enzymes.add(enzyme);
        this.setSpecificity(enzyme.getName(), Specificity.specific);
        this.setnMissedCleavages(enzyme.getName(), 0);
    }

    public void clear() {
        this.cleavageParameter = null;
        this.enzymes = null;
        this.nMissedCleavages = null;
        this.specificity = null;
    }

    public void clearEnzymes() {
        this.enzymes = null;
        this.nMissedCleavages = null;
        this.specificity = null;
    }

    public Integer getnMissedCleavages(String enzymeName) {
        if (this.nMissedCleavages == null) {
            return null;
        }
        return this.nMissedCleavages.get(enzymeName);
    }

    public void setnMissedCleavages(String enzymeName, int enzymeMissedCleavages) {
        if (this.nMissedCleavages == null) {
            this.nMissedCleavages = new HashMap(1);
        }
        this.nMissedCleavages.put(enzymeName, enzymeMissedCleavages);
    }

    public Specificity getSpecificity(String enzymeName) {
        if (this.specificity == null) {
            return null;
        }
        return this.specificity.get(enzymeName);
    }

    public void setSpecificity(String enzymeName, Specificity enzymeSpecificity) {
        if (this.specificity == null) {
            this.specificity = new HashMap(1);
        }
        this.specificity.put(enzymeName, enzymeSpecificity);
    }

    public CleavageParameter getCleavageParameter() {
        return this.cleavageParameter;
    }

    public void setCleavageParameter(CleavageParameter cleavageParameter) {
        this.cleavageParameter = cleavageParameter;
    }

    public String getShortDescription() {
        DigestionParameters defaultParameters = DigestionParameters.getDefaultParameters();
        StringBuilder stringBuilder = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        if (!defaultParameters.isSameAs(this)) {
            stringBuilder.append("Digestion: ");
            switch (this.cleavageParameter) {
                case wholeProtein: {
                    stringBuilder.append("Whole Protein").append(newLine);
                    break;
                }
                case unSpecific: {
                    stringBuilder.append("Unspecific").append(newLine);
                    break;
                }
                case enzyme: {
                    for (Enzyme enzyme1 : this.enzymes) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(newLine);
                        }
                        Enzyme enzyme = enzyme1;
                        String enzymeName = enzyme.getName();
                        stringBuilder.append(enzymeName).append(", ").append((Object)this.getSpecificity(enzymeName));
                        Integer nmc = this.getnMissedCleavages(enzymeName);
                        if (nmc == null) continue;
                        stringBuilder.append(", ").append(nmc).append(" missed cleavages");
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Description not implemented for cleavage parameter " + (Object)((Object)this.cleavageParameter) + ".");
                }
            }
            stringBuilder.append(".").append(newLine);
        }
        return stringBuilder.toString();
    }

    public boolean isSameAs(DigestionParameters otherDigestionParameters) {
        if (this.cleavageParameter != otherDigestionParameters.getCleavageParameter()) {
            return false;
        }
        ArrayList<Enzyme> otherEnzymes = otherDigestionParameters.getEnzymes();
        if (this.enzymes != null && otherEnzymes == null || this.enzymes == null && otherEnzymes != null) {
            return false;
        }
        if (this.enzymes != null && otherEnzymes != null) {
            if (this.enzymes.size() != otherEnzymes.size()) {
                return false;
            }
            ArrayList<String> enzymeNames = new ArrayList<String>(this.enzymes.size());
            for (Enzyme enzyme : this.enzymes) {
                enzymeNames.add(enzyme.getName());
            }
            ArrayList<String> otherNames = new ArrayList<String>(otherEnzymes.size());
            for (Enzyme enzyme : otherEnzymes) {
                otherNames.add(enzyme.getName());
            }
            if (!Util.sameLists(enzymeNames, otherNames)) {
                return false;
            }
            for (String enzymeName : enzymeNames) {
                if (this.getSpecificity(enzymeName) == otherDigestionParameters.getSpecificity(enzymeName) && this.getnMissedCleavages(enzymeName).equals(otherDigestionParameters.getnMissedCleavages(enzymeName))) continue;
                return false;
            }
        }
        return true;
    }

    public String getXTandemFormat() {
        switch (this.cleavageParameter) {
            case wholeProtein: {
                return "";
            }
            case unSpecific: {
                return "[X]|[X]";
            }
            case enzyme: {
                StringBuilder result = new StringBuilder();
                for (Enzyme enzyme : this.enzymes) {
                    if (result.length() > 0) {
                        result.append(",");
                    }
                    Specificity specificity = this.getSpecificity(enzyme.getName());
                    if (enzyme.getAminoAcidBefore().size() > 0) {
                        result.append("[");
                        for (Character aa : enzyme.getAminoAcidBefore()) {
                            result.append(aa);
                        }
                        result.append("]");
                    }
                    if (enzyme.getRestrictionBefore().size() > 0) {
                        result.append("{");
                        for (Character aa : enzyme.getRestrictionBefore()) {
                            result.append(aa);
                        }
                        result.append("}");
                    }
                    if (enzyme.getAminoAcidBefore().isEmpty() && enzyme.getRestrictionBefore().isEmpty()) {
                        result.append("[X]");
                    }
                    result.append("|");
                    if (enzyme.getAminoAcidAfter().size() > 0) {
                        result.append("[");
                        for (Character aa : enzyme.getAminoAcidAfter()) {
                            result.append(aa);
                        }
                        result.append("]");
                    }
                    if (enzyme.getRestrictionAfter().size() > 0) {
                        result.append("{");
                        for (Character aa : enzyme.getRestrictionAfter()) {
                            result.append(aa);
                        }
                        result.append("}");
                    }
                    if (!enzyme.getAminoAcidAfter().isEmpty() || !enzyme.getRestrictionAfter().isEmpty()) continue;
                    result.append("[X]");
                }
                return result.toString();
            }
        }
        throw new UnsupportedOperationException("X!Tandem format not implemented for cleavage parameter " + (Object)((Object)this.cleavageParameter) + ".");
    }

    /*
     * WARNING - void declaration
     */
    public String getMyriMatchFormat() {
        void var3_14;
        Object aa2;
        HashSet<Object> commonRestrictionAfter;
        String result = "[";
        for (Enzyme enzyme : this.enzymes) {
            if (enzyme.getAminoAcidBefore().size() > 0) {
                for (Character aa2 : enzyme.getAminoAcidBefore()) {
                    result = result + "|" + aa2;
                }
                result = result + " ";
                continue;
            }
            result = result + " ";
        }
        if (this.enzymes.size() == 1) {
            commonRestrictionAfter = this.enzymes.get(0).getRestrictionAfter();
        } else {
            commonRestrictionAfter = new HashSet();
            for (Object aa2 : this.enzymes.get(0).getRestrictionAfter()) {
                boolean missing = false;
                for (Enzyme enzyme2 : this.enzymes) {
                    if (enzyme2.getRestrictionAfter().contains(aa2)) continue;
                    missing = true;
                    break;
                }
                if (missing) continue;
                commonRestrictionAfter.add(aa2);
            }
        }
        if (commonRestrictionAfter.size() > 0) {
            void var3_7;
            String string = "";
            aa2 = AminoAcid.getUniqueAminoAcids();
            int missing = ((char[])aa2).length;
            for (int i = 0; i < missing; ++i) {
                void var3_9;
                Character aa3 = Character.valueOf(aa2[i]);
                if (commonRestrictionAfter.contains(aa3)) continue;
                if (!var3_7.isEmpty()) {
                    String string2 = (String)var3_7 + "|";
                }
                String string3 = (String)var3_9 + aa3;
            }
            result = result + (String)var3_7 + " ";
        } else {
            result = result + ". ";
        }
        if (this.enzymes.size() == 1) {
            HashSet<Character> hashSet = this.enzymes.get(0).getRestrictionBefore();
        } else {
            HashSet<Character> hashSet = new HashSet<Character>();
            aa2 = this.enzymes.get(0).getRestrictionBefore().iterator();
            while (aa2.hasNext()) {
                Character aa4 = (Character)aa2.next();
                boolean missing = false;
                for (Enzyme enzyme : this.enzymes) {
                    if (enzyme.getRestrictionBefore().contains(aa4)) continue;
                    missing = true;
                    break;
                }
                if (missing) continue;
                hashSet.add(aa4);
            }
        }
        if (var3_14.size() > 0) {
            String temp = "";
            char[] aa4 = AminoAcid.getUniqueAminoAcids();
            int missing = aa4.length;
            for (int i = 0; i < missing; ++i) {
                Character aa5 = Character.valueOf(aa4[i]);
                if (var3_14.contains(aa5)) continue;
                if (!temp.isEmpty()) {
                    temp = temp + "|";
                }
                temp = temp + aa5;
            }
            result = result + temp + " ";
        } else {
            result = result + ". ";
        }
        for (Enzyme enzyme : this.enzymes) {
            if (enzyme.getAminoAcidAfter().size() <= 0) continue;
            String temp = "";
            for (Character aa3 : enzyme.getAminoAcidAfter()) {
                if (!temp.isEmpty()) {
                    temp = temp + "|";
                }
                temp = temp + aa3;
            }
            result = result + temp + "|";
        }
        return result + "]";
    }

    public static enum CleavageParameter {
        enzyme(0, "Enzyme"),
        unSpecific(1, "Unspecific"),
        wholeProtein(2, "Whole Protein");

        public final int index;
        public final String name;

        private CleavageParameter(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public static CleavageParameter getCleavageParameters(int index) {
            for (CleavageParameter cleavageParameter : CleavageParameter.values()) {
                if (cleavageParameter.index != index) continue;
                return cleavageParameter;
            }
            throw new IllegalArgumentException("No cleavage parameter found for index " + index + ".");
        }

        public static String getCommandLineDescription() {
            StringBuilder stringBuilder = new StringBuilder();
            for (CleavageParameter cleavageParameter : CleavageParameter.values()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(cleavageParameter.index).append(": ").append(cleavageParameter.name);
            }
            return stringBuilder.toString();
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Specificity {
        specific(0, "Specific"),
        semiSpecific(1, "Semi-Specific"),
        specificNTermOnly(2, "N-term Specific"),
        specificCTermOnly(3, "C-term Specific");

        public final int index;
        public final String name;

        private Specificity(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public static Specificity getSpecificity(int index) {
            for (Specificity specificity : Specificity.values()) {
                if (specificity.index != index) continue;
                return specificity;
            }
            throw new IllegalArgumentException("No specificity found for index " + index + ".");
        }

        public static String getCommandLineDescription() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Specificity specificity : Specificity.values()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(specificity.index).append(": ").append(specificity.name);
            }
            return stringBuilder.toString();
        }

        public String toString() {
            return this.name;
        }
    }
}

