/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.search;

import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ModificationParameters
extends ExperimentObject {
    static final long serialVersionUID = 342611308111304721L;
    private ArrayList<String> fixedModifications = new ArrayList(0);
    private ArrayList<String> variableModifications = new ArrayList(0);
    private ArrayList<String> refinementVariableModifications = new ArrayList(0);
    private ArrayList<String> refinementFixedModifications = new ArrayList(0);
    private HashMap<String, Integer> colors = new HashMap(0);
    private HashMap<String, Modification> backUp = new HashMap(0);

    public ModificationParameters() {
    }

    public ModificationParameters(ModificationParameters modificationParameters) {
        this.fixedModifications = modificationParameters.getFixedModifications();
        this.variableModifications = modificationParameters.getVariableModifications();
        this.refinementFixedModifications = modificationParameters.getRefinementFixedModifications();
        this.refinementVariableModifications = modificationParameters.getRefinementVariableModifications();
        this.colors = modificationParameters.getColors();
        this.backUp = modificationParameters.getBackedUpModifications();
    }

    public ArrayList<String> getVariableModifications() {
        return this.variableModifications;
    }

    public ArrayList<String> getFixedModifications() {
        return this.fixedModifications;
    }

    public ArrayList<String> getRefinementVariableModifications() {
        return this.refinementVariableModifications;
    }

    public void clearVariableModifications() {
        this.variableModifications.clear();
    }

    public void clearFixedModifications() {
        this.fixedModifications.clear();
    }

    public void clearRefinementModifications() {
        this.refinementVariableModifications.clear();
    }

    public ArrayList<String> getRefinementFixedModifications() {
        return this.refinementFixedModifications;
    }

    public ArrayList<String> getAllModifications() {
        ArrayList result = Stream.concat(this.fixedModifications.stream(), this.variableModifications.stream()).distinct().collect(Collectors.toCollection(ArrayList::new));
        this.refinementFixedModifications.stream().filter(ptmName -> !result.contains(ptmName)).forEachOrdered(ptmName -> result.add(ptmName));
        this.refinementVariableModifications.stream().filter(ptmName -> !result.contains(ptmName)).forEachOrdered(ptmName -> result.add(ptmName));
        return result;
    }

    public ArrayList<String> getAllNotFixedModifications() {
        ArrayList result = Stream.concat(this.variableModifications.stream(), this.refinementVariableModifications.stream()).distinct().collect(Collectors.toCollection(ArrayList::new));
        this.refinementVariableModifications.stream().filter(ptmName -> !result.contains(ptmName)).forEachOrdered(ptmName -> result.add(ptmName));
        this.refinementFixedModifications.stream().filter(ptmName -> !this.fixedModifications.contains(ptmName) && !result.contains(ptmName)).forEachOrdered(ptmName -> result.add(ptmName));
        return result;
    }

    public void addVariableModification(Modification modification) {
        String modName = modification.getName();
        if (!this.variableModifications.contains(modName)) {
            this.variableModifications.add(modName);
        }
        Collections.sort(this.variableModifications);
        this.backUp.put(modName, modification);
    }

    public void addRefinementVariableModification(Modification modification) {
        String modName = modification.getName();
        if (!this.refinementVariableModifications.contains(modName)) {
            this.refinementVariableModifications.add(modName);
        }
        Collections.sort(this.refinementVariableModifications);
        this.backUp.put(modName, modification);
    }

    public void addRefinementFixedModification(Modification modification) {
        String modName = modification.getName();
        if (!this.refinementFixedModifications.contains(modName)) {
            this.refinementFixedModifications.add(modName);
        }
        Collections.sort(this.refinementFixedModifications);
        this.backUp.put(modName, modification);
    }

    public void addFixedModification(Modification modification) {
        String modName = modification.getName();
        if (!this.fixedModifications.contains(modName)) {
            this.fixedModifications.add(modName);
        }
        Collections.sort(this.fixedModifications);
        this.backUp.put(modName, modification);
    }

    public void setColor(String expectedModification, int color) {
        this.colors.put(expectedModification, color);
    }

    public int getColor(String modification) {
        Integer color = this.colors.get(modification);
        if (color == null) {
            ModificationFactory modificationFactory = ModificationFactory.getInstance();
            color = modificationFactory.getColor(modification);
            this.setColor(modification, color);
        }
        return color;
    }

    public HashMap<String, Integer> getColors() {
        return this.colors;
    }

    public Modification getModification(String modName) {
        return this.backUp.get(modName);
    }

    public HashMap<String, Modification> getBackedUpModifications() {
        return this.backUp;
    }

    public void removeVariableModification(String modificationName) {
        while (this.variableModifications.contains(modificationName)) {
            this.variableModifications.remove(modificationName);
        }
    }

    public void removeFixedModification(String modificationName) {
        while (this.fixedModifications.contains(modificationName)) {
            this.fixedModifications.remove(modificationName);
        }
    }

    public void removeRefinementVariableModification(String modificationName) {
        while (this.refinementVariableModifications.contains(modificationName)) {
            this.refinementVariableModifications.remove(modificationName);
        }
    }

    public void removeRefinementFixedModification(String modificationName) {
        while (this.refinementFixedModifications.contains(modificationName)) {
            this.refinementFixedModifications.remove(modificationName);
        }
    }

    public boolean contains(String modificationName) {
        return this.variableModifications.contains(modificationName) || this.fixedModifications.contains(modificationName) || this.refinementVariableModifications != null && this.refinementVariableModifications.contains(modificationName) || this.refinementFixedModifications != null && this.refinementFixedModifications.contains(modificationName);
    }

    public boolean equals(ModificationParameters otherProfile) {
        if (otherProfile == null) {
            return false;
        }
        if (!this.getVariableModifications().equals(otherProfile.getVariableModifications())) {
            return false;
        }
        if (!this.getFixedModifications().equals(otherProfile.getFixedModifications())) {
            return false;
        }
        if (!this.getRefinementVariableModifications().equals(otherProfile.getRefinementVariableModifications())) {
            return false;
        }
        if (!this.getRefinementFixedModifications().equals(otherProfile.getRefinementFixedModifications())) {
            return false;
        }
        if (this.colors.size() != otherProfile.colors.size()) {
            return false;
        }
        for (String tempKey : this.colors.keySet()) {
            if (!otherProfile.colors.containsKey(tempKey)) {
                return false;
            }
            if (this.colors.get(tempKey).equals(otherProfile.colors.get(tempKey))) continue;
            return false;
        }
        if (this.backUp.size() != otherProfile.backUp.size()) {
            return false;
        }
        for (String tempKey : this.backUp.keySet()) {
            if (otherProfile.backUp.containsKey(tempKey)) continue;
            return false;
        }
        return true;
    }
}

