/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.search;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.io.parameters.DummyParameters;
import com.compomics.util.experiment.io.parameters.MarshallableParameter;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;
import com.compomics.util.io.file.SerializationUtils;
import com.compomics.util.io.json.marshallers.IdentificationParametersMarshaller;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.tool_specific.AndromedaParameters;
import com.compomics.util.parameters.identification.tool_specific.CometParameters;
import com.compomics.util.parameters.identification.tool_specific.DirecTagParameters;
import com.compomics.util.parameters.identification.tool_specific.MetaMorpheusParameters;
import com.compomics.util.parameters.identification.tool_specific.MsAmandaParameters;
import com.compomics.util.parameters.identification.tool_specific.MsgfParameters;
import com.compomics.util.parameters.identification.tool_specific.MyriMatchParameters;
import com.compomics.util.parameters.identification.tool_specific.NovorParameters;
import com.compomics.util.parameters.identification.tool_specific.OmssaParameters;
import com.compomics.util.parameters.identification.tool_specific.PNovoParameters;
import com.compomics.util.parameters.identification.tool_specific.PepnovoParameters;
import com.compomics.util.parameters.identification.tool_specific.TideParameters;
import com.compomics.util.parameters.identification.tool_specific.XtandemParameters;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class SearchParameters
extends ExperimentObject
implements MarshallableParameter {
    private String marshallableParameterType = null;
    public final String version = "5.0.1";
    public static final String[] implementedForwardIons = new String[]{"a", "b", "c"};
    public static final String[] implementedRewindIons = new String[]{"x", "y", "z"};
    private MassAccuracyType precursorAccuracyType = MassAccuracyType.PPM;
    private MassAccuracyType fragmentAccuracyType = MassAccuracyType.PPM;
    private double precursorTolerance = 10.0;
    private double fragmentIonMZTolerance = 10.0;
    private ModificationParameters modificationParameters = new ModificationParameters();
    private DigestionParameters digestionParameters;
    private ArrayList<Integer> forwardIons;
    private ArrayList<Integer> rewindIons;
    private int minChargeSearched = 2;
    private int maxChargeSearched = 4;
    private int minIsotopicCorrection = 0;
    private int maxIsotopicCorrection = 1;
    private double refMass = 2000.0;
    public static final int preferredMaxVariableModifications = 6;
    public static final int preferredMinSequences = 1000;
    private HashMap<Integer, IdentificationAlgorithmParameter> algorithmParameters;
    private boolean flanking = false;

    public SearchParameters() {
        this.forwardIons = new ArrayList(1);
        this.forwardIons.add(1);
        this.rewindIons = new ArrayList(1);
        this.rewindIons.add(4);
        this.setDefaultAdvancedSettings();
    }

    public SearchParameters(SearchParameters searchParameters) {
        this.precursorAccuracyType = searchParameters.getPrecursorAccuracyType();
        this.fragmentAccuracyType = searchParameters.getFragmentAccuracyType();
        this.precursorTolerance = searchParameters.getPrecursorAccuracy();
        this.fragmentIonMZTolerance = searchParameters.getFragmentIonAccuracy();
        this.modificationParameters = new ModificationParameters(searchParameters.getModificationParameters());
        this.digestionParameters = searchParameters.getDigestionParameters();
        this.forwardIons = new ArrayList<Integer>(searchParameters.getForwardIons());
        this.rewindIons = new ArrayList<Integer>(searchParameters.getRewindIons());
        this.minChargeSearched = searchParameters.getMinChargeSearched();
        this.maxChargeSearched = searchParameters.getMaxChargeSearched();
        this.minIsotopicCorrection = searchParameters.getMinIsotopicCorrection();
        this.maxIsotopicCorrection = searchParameters.getMaxIsotopicCorrection();
        this.refMass = searchParameters.getRefMass();
        this.setDefaultAdvancedSettings(searchParameters);
    }

    public void setDefaultAdvancedSettings() {
        this.setDefaultAdvancedSettings(null);
    }

    public void setDefaultAdvancedSettings(SearchParameters searchParameters) {
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.omssa.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.omssa.getIndex(), new OmssaParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.omssa.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.omssa.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.xtandem.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.xtandem.getIndex(), new XtandemParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.xtandem.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.xtandem.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.msgf.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.msgf.getIndex(), new MsgfParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.msgf.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.msgf.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.msAmanda.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.msAmanda.getIndex(), new MsAmandaParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.msAmanda.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.msAmanda.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.myriMatch.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.myriMatch.getIndex(), new MyriMatchParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.myriMatch.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.myriMatch.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.comet.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.comet.getIndex(), new CometParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.comet.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.comet.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.tide.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.tide.getIndex(), new TideParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.tide.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.tide.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.andromeda.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.andromeda.getIndex(), new AndromedaParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.andromeda.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.andromeda.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.metaMorpheus.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.metaMorpheus.getIndex(), new MetaMorpheusParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.metaMorpheus.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.metaMorpheus.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.pepnovo.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.pepnovo.getIndex(), new PepnovoParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.pepnovo.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.pepnovo.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.direcTag.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.direcTag.getIndex(), new DirecTagParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.direcTag.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.direcTag.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.pNovo.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.pNovo.getIndex(), new PNovoParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.pNovo.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.pNovo.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.novor.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.novor.getIndex(), new NovorParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.novor.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.novor.getIndex()));
        }
    }

    public double getRefMass() {
        return this.refMass;
    }

    public void setRefMass(double refMass) {
        this.refMass = refMass;
    }

    public ModificationParameters getModificationParameters() {
        return this.modificationParameters;
    }

    public void setModificationParameters(ModificationParameters modificationParameters) {
        this.modificationParameters = modificationParameters;
    }

    public double getFragmentIonAccuracy() {
        return this.fragmentIonMZTolerance;
    }

    public double getFragmentIonAccuracyInDaltons() {
        return this.getFragmentIonAccuracyInDaltons(this.refMass);
    }

    public double getFragmentIonAccuracyInDaltons(double refMass) {
        switch (this.fragmentAccuracyType) {
            case DA: {
                return this.fragmentIonMZTolerance;
            }
            case PPM: {
                return this.fragmentIonMZTolerance * refMass / 1000000.0;
            }
        }
        throw new UnsupportedOperationException("Tolerance in " + (Object)((Object)this.fragmentAccuracyType) + " not implemented.");
    }

    public void setFragmentIonAccuracy(double fragmentIonMZTolerance) {
        this.fragmentIonMZTolerance = fragmentIonMZTolerance;
    }

    public DigestionParameters getDigestionParameters() {
        return this.digestionParameters;
    }

    public void setDigestionParameters(DigestionParameters digestionParameters) {
        this.digestionParameters = digestionParameters;
    }

    public ArrayList<Integer> getForwardIons() {
        return this.forwardIons;
    }

    public void setForwardIons(ArrayList<Integer> forwardIons) {
        this.forwardIons = forwardIons;
    }

    public ArrayList<Integer> getRewindIons() {
        return this.rewindIons;
    }

    public void setRewindIons(ArrayList<Integer> rewindIons) {
        this.rewindIons = rewindIons;
    }

    public static String[] getIons() {
        int n;
        String[] ions = new String[implementedForwardIons.length + implementedRewindIons.length];
        String[] stringArray = implementedForwardIons;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            String forwardIon1;
            ions[ions.length] = forwardIon1 = stringArray[n];
        }
        stringArray = implementedRewindIons;
        n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            String rewindIon1;
            ions[ions.length] = rewindIon1 = stringArray[n];
        }
        return ions;
    }

    public double getPrecursorAccuracy() {
        return this.precursorTolerance;
    }

    public void setPrecursorAccuracy(double precursorTolerance) {
        this.precursorTolerance = precursorTolerance;
    }

    public MassAccuracyType getPrecursorAccuracyType() {
        return this.precursorAccuracyType;
    }

    public void setPrecursorAccuracyType(MassAccuracyType precursorAccuracyType) {
        this.precursorAccuracyType = precursorAccuracyType;
    }

    public MassAccuracyType getFragmentAccuracyType() {
        return this.fragmentAccuracyType;
    }

    public void setFragmentAccuracyType(MassAccuracyType fragmentAccuracyType) {
        this.fragmentAccuracyType = fragmentAccuracyType;
    }

    public Boolean isPrecursorAccuracyTypePpm() {
        return this.getPrecursorAccuracyType() == MassAccuracyType.PPM;
    }

    public int getMaxChargeSearched() {
        return this.maxChargeSearched;
    }

    public void setMaxChargeSearched(int maxChargeSearched) {
        this.maxChargeSearched = maxChargeSearched;
    }

    public int getMinChargeSearched() {
        return this.minChargeSearched;
    }

    public void setMinChargeSearched(int minChargeSearched) {
        this.minChargeSearched = minChargeSearched;
    }

    public HashMap<Integer, IdentificationAlgorithmParameter> getAlgorithmSpecificParameters() {
        return this.algorithmParameters;
    }

    public IdentificationAlgorithmParameter getIdentificationAlgorithmParameter(int algorithmID) {
        if (this.algorithmParameters == null) {
            return null;
        }
        return this.algorithmParameters.get(algorithmID);
    }

    public void setIdentificationAlgorithmParameter(int algorithmID, IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (this.algorithmParameters == null) {
            this.algorithmParameters = new HashMap();
        }
        this.algorithmParameters.put(algorithmID, identificationAlgorithmParameter);
    }

    public Set<Integer> getAlgorithms() {
        if (this.algorithmParameters == null) {
            return new HashSet<Integer>(0);
        }
        return this.algorithmParameters.keySet();
    }

    public int getMinIsotopicCorrection() {
        return this.minIsotopicCorrection;
    }

    public void setMinIsotopicCorrection(int minIsotopicCorrection) {
        this.minIsotopicCorrection = minIsotopicCorrection;
    }

    public int getMaxIsotopicCorrection() {
        return this.maxIsotopicCorrection;
    }

    public void setMaxIsotopicCorrection(int maxIsotopicCorrection) {
        this.maxIsotopicCorrection = maxIsotopicCorrection;
    }

    public static SearchParameters getIdentificationParameters(File searchParametersFile) throws IOException, ClassNotFoundException {
        SearchParameters searchParameters;
        Object savedObject;
        block10: {
            try {
                IdentificationParametersMarshaller jsonMarshaller = new IdentificationParametersMarshaller();
                Class expectedObjectType = DummyParameters.class;
                Object object = jsonMarshaller.fromJson(expectedObjectType, searchParametersFile);
                DummyParameters dummyParameters = (DummyParameters)object;
                if (dummyParameters.getType() == MarshallableParameter.Type.search_parameters) {
                    expectedObjectType = SearchParameters.class;
                    savedObject = jsonMarshaller.fromJson(expectedObjectType, searchParametersFile);
                    break block10;
                }
                if (dummyParameters.getType() == MarshallableParameter.Type.identification_parameters) {
                    expectedObjectType = IdentificationParameters.class;
                    savedObject = jsonMarshaller.fromJson(expectedObjectType, searchParametersFile);
                    break block10;
                }
                throw new IllegalArgumentException("Parameters file " + searchParametersFile + " not recognized.");
            }
            catch (Exception e1) {
                try {
                    savedObject = SerializationUtils.readObject(searchParametersFile);
                }
                catch (Exception e2) {
                    e1.printStackTrace();
                    e2.printStackTrace();
                    throw new IllegalArgumentException("Parameters file " + searchParametersFile + " not recognized.");
                }
            }
        }
        if (savedObject instanceof SearchParameters) {
            searchParameters = (SearchParameters)savedObject;
        } else if (savedObject instanceof IdentificationParameters) {
            IdentificationParameters identificationParameters = (IdentificationParameters)savedObject;
            searchParameters = identificationParameters.getSearchParameters();
        } else {
            throw new UnsupportedOperationException("Parameters of type " + savedObject.getClass() + " not supported.");
        }
        return searchParameters;
    }

    public static void saveIdentificationParameters(SearchParameters searchParameters, File searchParametersFile) throws IOException {
        IdentificationParametersMarshaller jsonMarshaller = new IdentificationParametersMarshaller();
        searchParameters.setType();
        jsonMarshaller.saveObjectToJson(searchParameters, searchParametersFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIdentificationParametersAsTextFile(File file) throws IOException {
        try (FileWriter fw = new FileWriter(file);
             BufferedWriter bw = new BufferedWriter(fw);){
            bw.write(this.toString());
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String getShortDescription() {
        ArrayList<String> modifications;
        SearchParameters defaultParameters = new SearchParameters();
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        if (this.digestionParameters != null && !DigestionParameters.getDefaultParameters().equals(this.digestionParameters)) {
            output.append(this.digestionParameters.getShortDescription());
        }
        if (this.modificationParameters != null && !(modifications = this.modificationParameters.getFixedModifications()).isEmpty()) {
            output.append("Fixed: ");
            output.append(modifications.stream().sorted().collect(Collectors.joining(", ")));
            output.append(".").append(newLine);
        }
        if (this.modificationParameters != null && !(modifications = this.modificationParameters.getVariableModifications()).isEmpty()) {
            output.append("Variable: ");
            output.append(modifications.stream().sorted().collect(Collectors.joining(", ")));
            output.append(".").append(newLine);
        }
        if (this.precursorTolerance != defaultParameters.getPrecursorAccuracy() || this.getPrecursorAccuracyType() != defaultParameters.getPrecursorAccuracyType()) {
            output.append("Precursor Tolerance: ").append(this.precursorTolerance).append(" ").append((Object)this.precursorAccuracyType).append(".").append(newLine);
        }
        if (this.fragmentIonMZTolerance != defaultParameters.getFragmentIonAccuracy() || this.getFragmentAccuracyType() != defaultParameters.getFragmentAccuracyType()) {
            output.append("Fragment Tolerance: ").append(this.fragmentIonMZTolerance).append(" ").append((Object)this.fragmentAccuracyType).append(".").append(newLine);
        }
        if (!(this.forwardIons == null || this.rewindIons == null || Util.sameLists(this.forwardIons, defaultParameters.getForwardIons()) && Util.sameLists(this.rewindIons, defaultParameters.getRewindIons()))) {
            String ions1 = this.forwardIons.stream().sorted().map(ion -> PeptideFragmentIon.getSubTypeAsString(ion)).collect(Collectors.joining(","));
            String ions2 = this.rewindIons.stream().sorted().map(ion -> PeptideFragmentIon.getSubTypeAsString(ion)).collect(Collectors.joining(","));
            output.append("Ion Types: ").append(ions1).append(" and ").append(ions2).append(".").append(newLine);
        }
        if (this.minChargeSearched != defaultParameters.getMinChargeSearched() || this.maxChargeSearched != defaultParameters.getMaxChargeSearched()) {
            output.append("Charge: ").append(this.minChargeSearched).append("-").append(this.maxChargeSearched).append(".").append(newLine);
        }
        if (this.getMinIsotopicCorrection() != defaultParameters.getMinIsotopicCorrection() || this.getMaxIsotopicCorrection() != defaultParameters.getMaxIsotopicCorrection()) {
            output.append("Isotopic Correction: ").append(this.minIsotopicCorrection).append("-").append(this.maxIsotopicCorrection).append(".").append(newLine);
        }
        return output.toString();
    }

    public String toString(boolean html) {
        ArrayList<String> modifications;
        String newLine = html ? "<br>" : System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# General Search Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        if (this.digestionParameters.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
            ArrayList<Enzyme> enzymes = this.digestionParameters.getEnzymes();
            for (int i = 0; i < enzymes.size(); ++i) {
                Enzyme tempEnzyme = enzymes.get(i);
                String enzymeName = tempEnzyme.getName();
                output.append("ENZYME").append(i).append("=");
                output.append(enzymeName).append(", ").append((Object)this.digestionParameters.getSpecificity(enzymeName));
                int nmc = this.digestionParameters.getnMissedCleavages(enzymeName);
                output.append(", ").append(nmc).append(" missed cleavages");
                output.append(newLine);
            }
        } else {
            output.append("ENZYME").append("=").append(this.digestionParameters.getCleavageParameter().name);
        }
        output.append("FIXED_MODIFICATIONS=");
        if (this.modificationParameters != null) {
            modifications = this.modificationParameters.getFixedModifications();
            output.append(modifications.stream().sorted().collect(Collectors.joining(",")));
        }
        output.append(newLine);
        output.append("VARIABLE_MODIFICATIONS=");
        if (this.modificationParameters != null) {
            modifications = this.modificationParameters.getVariableModifications();
            output.append(modifications.stream().sorted().collect(Collectors.joining(",")));
        }
        output.append(newLine);
        output.append("REFINEMENT_FIXED_MODIFICATIONS=");
        if (this.modificationParameters != null && this.modificationParameters.getRefinementFixedModifications() != null) {
            modifications = this.modificationParameters.getRefinementFixedModifications();
            output.append(modifications.stream().sorted().collect(Collectors.joining(",")));
        }
        output.append(newLine);
        output.append("REFINEMENT_VARIABLE_MODIFICATIONS=");
        if (this.modificationParameters != null && this.modificationParameters.getRefinementVariableModifications() != null) {
            modifications = this.modificationParameters.getRefinementVariableModifications();
            output.append(modifications.stream().sorted().collect(Collectors.joining(",")));
        }
        output.append(newLine);
        output.append("PRECURSOR_MASS_TOLERANCE=");
        output.append(this.precursorTolerance);
        output.append(newLine);
        output.append("PRECURSOR_MASS_TOLERANCE_UNIT=");
        if (this.getPrecursorAccuracyType() == MassAccuracyType.PPM) {
            output.append("ppm");
        } else {
            output.append("Da");
        }
        output.append(newLine);
        output.append("FRAGMENT_MASS_TOLERANCE=");
        output.append(this.fragmentIonMZTolerance);
        output.append(newLine);
        output.append("FRAGMENT_MASS_TOLERANCE_UNIT=");
        if (this.getFragmentAccuracyType() == MassAccuracyType.PPM) {
            output.append("ppm");
        } else {
            output.append("Da");
        }
        output.append(newLine);
        output.append("PPM_TO_DA_CONVERSION_REF_MASS=");
        output.append(this.getRefMass());
        output.append(newLine);
        output.append("FORWARD_FRAGMENT_ION_TYPE=");
        String ions1 = this.forwardIons.stream().sorted().map(ion -> PeptideFragmentIon.getSubTypeAsString(ion)).collect(Collectors.joining(","));
        output.append(ions1);
        output.append(newLine);
        output.append("FRAGMENT_ION_TYPE_2=");
        String ions2 = this.rewindIons.stream().sorted().map(ion -> PeptideFragmentIon.getSubTypeAsString(ion)).collect(Collectors.joining(","));
        output.append(ions2);
        output.append(newLine);
        output.append("PRECURSOR_CHARGE_LOWER_BOUND=");
        output.append(this.minChargeSearched);
        output.append(newLine);
        output.append("PRECURSOR_CHARGE_UPPER_BOUND=");
        output.append(this.maxChargeSearched);
        output.append(newLine);
        output.append("ISOTOPIC_CORRECTION_LOWER_BOUND=");
        output.append(this.getMinIsotopicCorrection());
        output.append(newLine);
        output.append("ISOTOPIC_CORRECTION_UPPER_BOUND=");
        output.append(this.getMaxIsotopicCorrection());
        output.append(newLine);
        for (int index : this.algorithmParameters.keySet()) {
            output.append(newLine);
            output.append(newLine);
            output.append(this.algorithmParameters.get(index).toString(html));
        }
        return output.toString();
    }

    public boolean equals(SearchParameters otherSearchParameters) {
        if (otherSearchParameters == null) {
            return false;
        }
        if (this.getPrecursorAccuracyType() != otherSearchParameters.getPrecursorAccuracyType()) {
            return false;
        }
        if (this.getPrecursorAccuracy() != otherSearchParameters.getPrecursorAccuracy()) {
            return false;
        }
        if (!this.getFragmentAccuracyType().equals((Object)otherSearchParameters.getFragmentAccuracyType())) {
            return false;
        }
        if (this.getFragmentIonAccuracy() != otherSearchParameters.getFragmentIonAccuracy()) {
            return false;
        }
        if (this.getDigestionParameters() != null && otherSearchParameters.getDigestionParameters() == null || this.getDigestionParameters() == null && otherSearchParameters.getDigestionParameters() != null) {
            return false;
        }
        if (this.getDigestionParameters() != null && otherSearchParameters.getDigestionParameters() != null && !this.getDigestionParameters().isSameAs(otherSearchParameters.getDigestionParameters())) {
            return false;
        }
        if (this.forwardIons != null && otherSearchParameters.getForwardIons() == null || this.forwardIons == null && otherSearchParameters.getForwardIons() != null) {
            return false;
        }
        if (this.forwardIons != null && otherSearchParameters.getForwardIons() != null && !Util.sameLists(this.forwardIons, otherSearchParameters.getForwardIons())) {
            return false;
        }
        if (this.rewindIons != null && otherSearchParameters.getRewindIons() == null || this.rewindIons == null && otherSearchParameters.getRewindIons() != null) {
            return false;
        }
        if (this.rewindIons != null && otherSearchParameters.getRewindIons() != null && !Util.sameLists(this.rewindIons, otherSearchParameters.getRewindIons())) {
            return false;
        }
        if (this.getMinChargeSearched() != otherSearchParameters.getMinChargeSearched()) {
            return false;
        }
        if (this.getMaxChargeSearched() != otherSearchParameters.getMaxChargeSearched()) {
            return false;
        }
        if (this.getMinIsotopicCorrection() != otherSearchParameters.getMinIsotopicCorrection()) {
            return false;
        }
        if (this.getMaxIsotopicCorrection() != otherSearchParameters.getMaxIsotopicCorrection()) {
            return false;
        }
        if (!this.getModificationParameters().equals(otherSearchParameters.getModificationParameters())) {
            return false;
        }
        if (this.getAlgorithms().size() != otherSearchParameters.getAlgorithms().size()) {
            return false;
        }
        for (int se : this.getAlgorithms()) {
            IdentificationAlgorithmParameter otherParameter = otherSearchParameters.getIdentificationAlgorithmParameter(se);
            if (otherParameter == null) {
                return false;
            }
            IdentificationAlgorithmParameter thisParameter = this.getIdentificationAlgorithmParameter(se);
            if (otherParameter.equals(thisParameter)) continue;
            return false;
        }
        return true;
    }

    public void setFlanking(boolean flanking) {
        this.flanking = flanking;
    }

    public boolean getFlanking() {
        return this.flanking;
    }

    @Override
    public void setType() {
        this.marshallableParameterType = MarshallableParameter.Type.search_parameters.name();
    }

    @Override
    public MarshallableParameter.Type getType() {
        if (this.marshallableParameterType == null) {
            return null;
        }
        return MarshallableParameter.Type.valueOf(this.marshallableParameterType);
    }

    public static enum MassAccuracyType {
        PPM,
        DA;


        public String toString() {
            switch (this) {
                case PPM: {
                    return "ppm";
                }
                case DA: {
                    return "Da";
                }
            }
            throw new UnsupportedOperationException("Name of tolerance type " + this.name() + " not implemented.");
        }
    }
}

