/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.tool_specific;

import com.compomics.util.experiment.biology.modifications.ModificationCategory;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;
import java.util.ArrayList;
import java.util.Arrays;

public class MetaMorpheusParameters
extends ExperimentObject
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = 3692530126026333412L;
    private Integer minPeptideLength = 8;
    private Integer maxPeptideLength = 30;
    private MetaMorpheusSearchType searchType = MetaMorpheusSearchType.Classic;
    private Integer totalPartitions = 1;
    private MetaMorpheusDissociationType dissociationType = MetaMorpheusDissociationType.HCD;
    private Integer maxModsForPeptide = 2;
    private MetaMorpheusInitiatorMethionineBehaviorType initiatorMethionineBehavior = MetaMorpheusInitiatorMethionineBehaviorType.Variable;
    private Double scoreCutoff = 5.0;
    private boolean useDeltaScore = false;
    private MetaMorpheusFragmentationTerminusType fragmentationTerminus = MetaMorpheusFragmentationTerminusType.Both;
    private Double maxFragmentSize = 30000.0;
    private Integer minAllowedInternalFragmentLength = 0;
    private MetaMorpheusMassDiffAcceptorType massDiffAcceptorType = MetaMorpheusMassDiffAcceptorType.OneMM;
    private Boolean writeMzId = true;
    private Boolean writePepXml = false;
    private Boolean useProvidedPrecursorInfo = true;
    private Boolean doPrecursorDeconvolution = true;
    private Double deconvolutionIntensityRatio = 3.0;
    private Double deconvolutionMassTolerance = 4.0;
    private MetaMorpheusToleranceType deconvolutionMassToleranceType = MetaMorpheusToleranceType.PPM;
    private Boolean trimMs1Peaks = false;
    private Boolean trimMsMsPeaks = true;
    private Integer numberOfPeaksToKeepPerWindow = 200;
    private Double minAllowedIntensityRatioToBasePeak = 0.01;
    private Double windowWidthThomson = null;
    private Integer numberOfWindows = null;
    private Boolean normalizePeaksAcrossAllWindows = false;
    private Boolean modPeptidesAreDifferent = false;
    private Boolean noOneHitWonders = false;
    private Boolean searchTarget = true;
    private MetaMorpheusDecoyType decoyType = MetaMorpheusDecoyType.None;
    private Integer maxModificationIsoforms = 1024;
    private Integer minVariantDepth = 1;
    private Integer maxHeterozygousVariants = 4;
    private boolean runGptm = false;
    private ArrayList<ModificationCategory> gPtmCategories = new ArrayList<ModificationCategory>(Arrays.asList(ModificationCategory.Common_Biological, ModificationCategory.Common_Artifact, ModificationCategory.Metal));

    @Override
    public Advocate getAlgorithm() {
        return Advocate.metaMorpheus;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof MetaMorpheusParameters) {
            MetaMorpheusParameters metaMorpheusParameters = (MetaMorpheusParameters)identificationAlgorithmParameter;
            if (!this.minPeptideLength.equals(metaMorpheusParameters.getMinPeptideLength())) {
                return false;
            }
            if (!this.maxPeptideLength.equals(metaMorpheusParameters.getMaxPeptideLength())) {
                return false;
            }
            if (this.searchType != metaMorpheusParameters.getSearchType()) {
                return false;
            }
            if (!this.totalPartitions.equals(metaMorpheusParameters.getTotalPartitions())) {
                return false;
            }
            if (this.dissociationType != metaMorpheusParameters.getDissociationType()) {
                return false;
            }
            if (!this.maxModsForPeptide.equals(metaMorpheusParameters.getMaxModsForPeptide())) {
                return false;
            }
            if (this.initiatorMethionineBehavior != metaMorpheusParameters.getInitiatorMethionineBehavior()) {
                return false;
            }
            double diff = Math.abs(this.scoreCutoff - metaMorpheusParameters.getScoreCutoff());
            if (diff > 1.0E-13) {
                return false;
            }
            if (this.getUseDeltaScore() != metaMorpheusParameters.getUseDeltaScore()) {
                return false;
            }
            if (this.fragmentationTerminus != metaMorpheusParameters.getFragmentationTerminus()) {
                return false;
            }
            diff = Math.abs(this.maxFragmentSize - metaMorpheusParameters.getMaxFragmentSize());
            if (diff > 1.0E-13) {
                return false;
            }
            if (!this.getMinAllowedInternalFragmentLength().equals(metaMorpheusParameters.getMinAllowedInternalFragmentLength())) {
                return false;
            }
            if (this.massDiffAcceptorType != metaMorpheusParameters.getMassDiffAcceptorType()) {
                return false;
            }
            if (this.getWriteMzId() != metaMorpheusParameters.getWriteMzId()) {
                return false;
            }
            if (this.getWritePepXml() != metaMorpheusParameters.getWritePepXml()) {
                return false;
            }
            if (this.getUseProvidedPrecursorInfo() != metaMorpheusParameters.getUseProvidedPrecursorInfo()) {
                return false;
            }
            if (this.getDoPrecursorDeconvolution() != metaMorpheusParameters.getDoPrecursorDeconvolution()) {
                return false;
            }
            diff = Math.abs(this.deconvolutionIntensityRatio - metaMorpheusParameters.getDeconvolutionIntensityRatio());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.deconvolutionMassTolerance - metaMorpheusParameters.getDeconvolutionMassTolerance());
            if (diff > 1.0E-13) {
                return false;
            }
            if (this.deconvolutionMassToleranceType != metaMorpheusParameters.getDeconvolutionMassToleranceType()) {
                return false;
            }
            if (this.getTrimMs1Peaks() != metaMorpheusParameters.getTrimMs1Peaks()) {
                return false;
            }
            if (this.getTrimMsMsPeaks() != metaMorpheusParameters.getTrimMsMsPeaks()) {
                return false;
            }
            if (!this.numberOfPeaksToKeepPerWindow.equals(metaMorpheusParameters.getNumberOfPeaksToKeepPerWindow())) {
                return false;
            }
            diff = Math.abs(this.minAllowedIntensityRatioToBasePeak - metaMorpheusParameters.getMinAllowedIntensityRatioToBasePeak());
            if (diff > 1.0E-13) {
                return false;
            }
            if (this.windowWidthThomson != null && metaMorpheusParameters.getWindowWidthThomsons() == null || this.windowWidthThomson == null && metaMorpheusParameters.getWindowWidthThomsons() != null || this.windowWidthThomson != null && metaMorpheusParameters.getWindowWidthThomsons() != null && !this.windowWidthThomson.equals(metaMorpheusParameters.getWindowWidthThomsons())) {
                return false;
            }
            if (this.numberOfWindows != null && metaMorpheusParameters.getNumberOfWindows() == null || this.numberOfWindows == null && metaMorpheusParameters.getNumberOfWindows() != null || this.numberOfWindows != null && metaMorpheusParameters.getNumberOfWindows() != null && !this.numberOfWindows.equals(metaMorpheusParameters.getNumberOfWindows())) {
                return false;
            }
            if (this.getNormalizePeaksAcrossAllWindows() != metaMorpheusParameters.getNormalizePeaksAcrossAllWindows()) {
                return false;
            }
            if (this.getModPeptidesAreDifferent() != metaMorpheusParameters.getModPeptidesAreDifferent()) {
                return false;
            }
            if (this.getNoOneHitWonders() != metaMorpheusParameters.getNoOneHitWonders()) {
                return false;
            }
            if (this.getSearchTarget() != metaMorpheusParameters.getSearchTarget()) {
                return false;
            }
            if (this.decoyType != metaMorpheusParameters.getDecoyType()) {
                return false;
            }
            if (!this.maxModificationIsoforms.equals(metaMorpheusParameters.getMaxModificationIsoforms())) {
                return false;
            }
            if (!this.minVariantDepth.equals(metaMorpheusParameters.getMinVariantDepth())) {
                return false;
            }
            if (!this.maxHeterozygousVariants.equals(metaMorpheusParameters.getMaxHeterozygousVariants())) {
                return false;
            }
            if (this.runGptm != metaMorpheusParameters.runGptm()) {
                return false;
            }
            return this.gPtmCategories.equals(metaMorpheusParameters.getGPtmCategories());
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("MIN_PEPTIDE_LENGTH=");
        output.append(this.getMinPeptideLength());
        output.append(newLine);
        output.append("MAX_PEPTIDE_LENGTH=");
        output.append(this.getMaxPeptideLength());
        output.append(newLine);
        output.append("SEARCH_TYPE=");
        output.append((Object)this.getSearchType());
        output.append(newLine);
        output.append("NUM_PARTITIONS=");
        output.append(this.getTotalPartitions());
        output.append(newLine);
        output.append("DISSOCIATION_TYPE=");
        output.append((Object)this.getDissociationType());
        output.append(newLine);
        output.append("MAX_MODS_FOR_PEPTIDE=");
        output.append(this.getMaxModsForPeptide());
        output.append(newLine);
        output.append("INITIATOR_METHIONINE_BEHAVIOR=");
        output.append((Object)this.getInitiatorMethionineBehavior());
        output.append(newLine);
        output.append("SCORE_CUTOFF=");
        output.append(this.getScoreCutoff());
        output.append(newLine);
        output.append("USE_DELTA_SCORE=");
        output.append(this.getUseDeltaScore());
        output.append(newLine);
        output.append("FRAGMENTATION_TERMINUS=");
        output.append((Object)this.getFragmentationTerminus());
        output.append(newLine);
        output.append("MAX_FRAGMENTATION_SIZE=");
        output.append(this.getMaxFragmentSize());
        output.append(newLine);
        output.append("MIN_ALLOWED_INTERNAL_FRAGMENT_LENGTH=");
        output.append(this.getMinAllowedInternalFragmentLength());
        output.append(newLine);
        output.append("MASS_DIFF_ACCEPTOR_TYPE=");
        output.append((Object)this.getMassDiffAcceptorType());
        output.append(newLine);
        output.append("WRITE_MZID=");
        output.append(this.getWriteMzId());
        output.append(newLine);
        output.append("WRITE_PEPXML=");
        output.append(this.getWritePepXml());
        output.append(newLine);
        output.append("USE_PROVIDED_PRECURSOR=");
        output.append(this.getUseProvidedPrecursorInfo());
        output.append(newLine);
        output.append("DO_PREC_DECONVOLUTION=");
        output.append(this.getDoPrecursorDeconvolution());
        output.append(newLine);
        output.append("DECONVOLUTION_INT_RATIO=");
        output.append(this.getDeconvolutionIntensityRatio());
        output.append(newLine);
        output.append("DECONVOLUTION_MASS_TOL=");
        output.append(this.getDeconvolutionMassTolerance());
        output.append(newLine);
        output.append("DECONVOLUTION_MASS_TOL_TYPE=");
        output.append((Object)this.getDeconvolutionMassToleranceType());
        output.append(newLine);
        output.append("TRIM_MS1_PEAKS=");
        output.append(this.getTrimMs1Peaks());
        output.append(newLine);
        output.append("TRIM_MSMS_PEAKS=");
        output.append(this.getTrimMsMsPeaks());
        output.append(newLine);
        output.append("NUM_PEAKS_PER_WINDOWS=");
        output.append(this.getNumberOfPeaksToKeepPerWindow());
        output.append(newLine);
        output.append("MIN_ALLOWED_INT_RATIO_TO_BASE_PEAK=");
        output.append(this.getMinAllowedIntensityRatioToBasePeak());
        output.append(newLine);
        output.append("WINDOW_WITH_THOMPSON=");
        output.append(this.getWindowWidthThomsons());
        output.append(newLine);
        output.append("NUM_WINDOWS=");
        output.append(this.getNumberOfWindows());
        output.append(newLine);
        output.append("NORMALIZE_PEAKS_ACROSS_ALL_WINDOWS=");
        output.append(this.getNormalizePeaksAcrossAllWindows());
        output.append(newLine);
        output.append("MOD_PEPTIDES_ARE_DIFFERENT=");
        output.append(this.getModPeptidesAreDifferent());
        output.append(newLine);
        output.append("NO_ONE_HIT_WONDERS=");
        output.append(this.getNoOneHitWonders());
        output.append(newLine);
        output.append("SEARCH_TARGET=");
        output.append(this.getSearchTarget());
        output.append(newLine);
        output.append("DECOY_TYPE=");
        output.append((Object)this.getDecoyType());
        output.append(newLine);
        output.append("MAX_MOD_ISOFORMS=");
        output.append(this.getMaxModificationIsoforms());
        output.append(newLine);
        output.append("MIN_VARIANT_DEPTH=");
        output.append(this.getMinVariantDepth());
        output.append(newLine);
        output.append("MAX_HETROZYGOUS_VARIANTS=");
        output.append(this.getMaxHeterozygousVariants());
        output.append(newLine);
        output.append("RUN_GPTM=");
        output.append(this.runGptm());
        output.append(newLine);
        output.append("GPTMS=");
        String tempGPtmCategories = "";
        for (ModificationCategory tempCategory : this.gPtmCategories) {
            if (!tempGPtmCategories.isEmpty()) {
                tempGPtmCategories = tempGPtmCategories + ", ";
            }
            tempGPtmCategories = tempGPtmCategories + (Object)((Object)tempCategory);
        }
        output.append(tempGPtmCategories);
        output.append(newLine);
        return output.toString();
    }

    public Integer getMinPeptideLength() {
        return this.minPeptideLength;
    }

    public void setMinPeptideLength(Integer minPeptideLength) {
        this.minPeptideLength = minPeptideLength;
    }

    public Integer getMaxPeptideLength() {
        return this.maxPeptideLength;
    }

    public void setMaxPeptideLength(Integer maxPeptideLength) {
        this.maxPeptideLength = maxPeptideLength;
    }

    public MetaMorpheusSearchType getSearchType() {
        return this.searchType;
    }

    public void setSearchType(MetaMorpheusSearchType searchType) {
        this.searchType = searchType;
    }

    public Integer getTotalPartitions() {
        return this.totalPartitions;
    }

    public void setTotalPartitions(Integer totalPartitions) {
        this.totalPartitions = totalPartitions;
    }

    public MetaMorpheusDissociationType getDissociationType() {
        return this.dissociationType;
    }

    public void setDissociationType(MetaMorpheusDissociationType dissociationType) {
        this.dissociationType = dissociationType;
    }

    public Integer getMaxModsForPeptide() {
        return this.maxModsForPeptide;
    }

    public void setMaxModsForPeptide(Integer maxModsForPeptide) {
        this.maxModsForPeptide = maxModsForPeptide;
    }

    public MetaMorpheusInitiatorMethionineBehaviorType getInitiatorMethionineBehavior() {
        return this.initiatorMethionineBehavior;
    }

    public void setInitiatorMethionineBehavior(MetaMorpheusInitiatorMethionineBehaviorType initiatorMethionineBehavior) {
        this.initiatorMethionineBehavior = initiatorMethionineBehavior;
    }

    public Double getScoreCutoff() {
        return this.scoreCutoff;
    }

    public void setScoreCutoff(Double scoreCutoff) {
        this.scoreCutoff = scoreCutoff;
    }

    public boolean getUseDeltaScore() {
        return this.useDeltaScore;
    }

    public void setUseDeltaScore(boolean useDeltaScore) {
        this.useDeltaScore = useDeltaScore;
    }

    public MetaMorpheusFragmentationTerminusType getFragmentationTerminus() {
        return this.fragmentationTerminus;
    }

    public void setFragmentationTerminus(MetaMorpheusFragmentationTerminusType fragmentationTerminus) {
        this.fragmentationTerminus = fragmentationTerminus;
    }

    public Double getMaxFragmentSize() {
        return this.maxFragmentSize;
    }

    public void setMaxFragmentSize(Double maxFragmentSize) {
        this.maxFragmentSize = maxFragmentSize;
    }

    public Integer getMinAllowedInternalFragmentLength() {
        if (this.minAllowedInternalFragmentLength == null) {
            this.minAllowedInternalFragmentLength = 0;
        }
        return this.minAllowedInternalFragmentLength;
    }

    public void setMinAllowedInternalFragmentLength(Integer minAllowedInternalFragmentLength) {
        this.minAllowedInternalFragmentLength = minAllowedInternalFragmentLength;
    }

    public MetaMorpheusMassDiffAcceptorType getMassDiffAcceptorType() {
        return this.massDiffAcceptorType;
    }

    public void setMassDiffAcceptorType(MetaMorpheusMassDiffAcceptorType massDiffAcceptorType) {
        this.massDiffAcceptorType = massDiffAcceptorType;
    }

    public Boolean getWriteMzId() {
        return this.writeMzId;
    }

    public void setWriteMzId(Boolean writeMzId) {
        this.writeMzId = writeMzId;
    }

    public Boolean getWritePepXml() {
        return this.writePepXml;
    }

    public void setWritePepXml(Boolean writePepXml) {
        this.writePepXml = writePepXml;
    }

    public Boolean getUseProvidedPrecursorInfo() {
        return this.useProvidedPrecursorInfo;
    }

    public void setUseProvidedPrecursorInfo(Boolean useProvidedPrecursorInfo) {
        this.useProvidedPrecursorInfo = useProvidedPrecursorInfo;
    }

    public Boolean getDoPrecursorDeconvolution() {
        return this.doPrecursorDeconvolution;
    }

    public void setDoPrecursorDeconvolution(Boolean doPrecursorDeconvolution) {
        this.doPrecursorDeconvolution = doPrecursorDeconvolution;
    }

    public Double getDeconvolutionIntensityRatio() {
        return this.deconvolutionIntensityRatio;
    }

    public void setDeconvolutionIntensityRatio(Double deconvolutionIntensityRatio) {
        this.deconvolutionIntensityRatio = deconvolutionIntensityRatio;
    }

    public Double getDeconvolutionMassTolerance() {
        return this.deconvolutionMassTolerance;
    }

    public void setDeconvolutionMassTolerance(Double deconvolutionMassTolerance) {
        this.deconvolutionMassTolerance = deconvolutionMassTolerance;
    }

    public MetaMorpheusToleranceType getDeconvolutionMassToleranceType() {
        return this.deconvolutionMassToleranceType;
    }

    public void setDeconvolutionMassToleranceType(MetaMorpheusToleranceType deconvolutionMassToleranceType) {
        this.deconvolutionMassToleranceType = deconvolutionMassToleranceType;
    }

    public Boolean getTrimMs1Peaks() {
        return this.trimMs1Peaks;
    }

    public void setTrimMs1Peaks(Boolean trimMs1Peaks) {
        this.trimMs1Peaks = trimMs1Peaks;
    }

    public Boolean getTrimMsMsPeaks() {
        return this.trimMsMsPeaks;
    }

    public void setTrimMsMsPeaks(Boolean trimMsMsPeaks) {
        this.trimMsMsPeaks = trimMsMsPeaks;
    }

    public Integer getNumberOfPeaksToKeepPerWindow() {
        return this.numberOfPeaksToKeepPerWindow;
    }

    public void setNumberOfPeaksToKeepPerWindow(Integer numberOfPeaksToKeepPerWindow) {
        this.numberOfPeaksToKeepPerWindow = numberOfPeaksToKeepPerWindow;
    }

    public Double getMinAllowedIntensityRatioToBasePeak() {
        return this.minAllowedIntensityRatioToBasePeak;
    }

    public void setMinAllowedIntensityRatioToBasePeak(Double minAllowedIntensityRatioToBasePeak) {
        this.minAllowedIntensityRatioToBasePeak = minAllowedIntensityRatioToBasePeak;
    }

    public Double getWindowWidthThomsons() {
        return this.windowWidthThomson;
    }

    public void setWindowWidthThomsons(Double windowWidthThomsons) {
        this.windowWidthThomson = windowWidthThomsons;
    }

    public Integer getNumberOfWindows() {
        return this.numberOfWindows;
    }

    public void setNumberOfWindows(Integer numberOfWindows) {
        this.numberOfWindows = numberOfWindows;
    }

    public Boolean getNormalizePeaksAcrossAllWindows() {
        return this.normalizePeaksAcrossAllWindows;
    }

    public void setNormalizePeaksAcrossAllWindows(Boolean normalizePeaksAcrossAllWindows) {
        this.normalizePeaksAcrossAllWindows = normalizePeaksAcrossAllWindows;
    }

    public Boolean getModPeptidesAreDifferent() {
        return this.modPeptidesAreDifferent;
    }

    public void setModPeptidesAreDifferent(Boolean modPeptidesAreDifferent) {
        this.modPeptidesAreDifferent = modPeptidesAreDifferent;
    }

    public Boolean getNoOneHitWonders() {
        return this.noOneHitWonders;
    }

    public void setNoOneHitWonders(Boolean noOneHitWonders) {
        this.noOneHitWonders = noOneHitWonders;
    }

    public Boolean getSearchTarget() {
        return this.searchTarget;
    }

    public void setSearchTarget(Boolean searchTarget) {
        this.searchTarget = searchTarget;
    }

    public MetaMorpheusDecoyType getDecoyType() {
        return this.decoyType;
    }

    public void setDecoyType(MetaMorpheusDecoyType decoyType) {
        this.decoyType = decoyType;
    }

    public Integer getMaxModificationIsoforms() {
        return this.maxModificationIsoforms;
    }

    public void setMaxModificationIsoforms(Integer maxModificationIsoforms) {
        this.maxModificationIsoforms = maxModificationIsoforms;
    }

    public Integer getMinVariantDepth() {
        return this.minVariantDepth;
    }

    public void setMinVariantDepth(Integer minVariantDepth) {
        this.minVariantDepth = minVariantDepth;
    }

    public Integer getMaxHeterozygousVariants() {
        return this.maxHeterozygousVariants;
    }

    public void setMaxHeterozygousVariants(Integer maxHeterozygousVariants) {
        this.maxHeterozygousVariants = maxHeterozygousVariants;
    }

    public boolean runGptm() {
        return this.runGptm;
    }

    public void setRunGptm(boolean runGptm) {
        this.runGptm = runGptm;
    }

    public ArrayList<ModificationCategory> getGPtmCategories() {
        return this.gPtmCategories;
    }

    public void setGPtmCategories(ArrayList<ModificationCategory> gPtmCategories) {
        this.gPtmCategories = gPtmCategories;
    }

    public static enum MetaMorpheusToleranceType {
        PPM,
        Absolute;

    }

    public static enum MetaMorpheusMassDiffAcceptorType {
        Exact,
        OneMM,
        TwoMM,
        ThreeMM,
        PlusOrMinusThreeMM,
        ModOpen,
        Open;

    }

    public static enum MetaMorpheusFragmentationTerminusType {
        Both,
        N,
        C;

    }

    public static enum MetaMorpheusInitiatorMethionineBehaviorType {
        Undefined,
        Retain,
        Cleave,
        Variable;

    }

    public static enum MetaMorpheusDissociationType {
        HCD,
        CID,
        ECD,
        ETD;

    }

    public static enum MetaMorpheusSearchType {
        Classic,
        Modern,
        NonSpecific;

    }

    public static enum MetaMorpheusDecoyType {
        None,
        Reverse,
        Slide;

    }
}

