/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.tool_specific;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;

public class MsAmandaParameters
extends ExperimentObject
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = -8458620189315975268L;
    private boolean generateDecoy = false;
    private Boolean reportBothBestHitsForTD = true;
    private String instrumentID = "b, y";
    private Integer maxRank = 10;
    private boolean monoisotopic = true;
    private Boolean lowMemoryMode = true;
    private Boolean performDeisotoping = true;
    private Integer maxModifications = 3;
    private Integer maxVariableModifications = 4;
    private Integer maxModificationSites = 6;
    private Integer maxNeutralLosses = 1;
    private Integer maxNeutralLossesPerModification = 2;
    private Integer minPeptideLength = 8;
    private Integer maxPeptideLength = 30;
    private Integer maxLoadedProteins = 100000;
    private Integer maxLoadedSpectra = 2000;
    public static final int MAX_MS_AMANDA_FASTA_FILE_NAME_LENGTH = 80;
    private String outputFormat = "csv";

    @Override
    public Advocate getAlgorithm() {
        return Advocate.msAmanda;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof MsAmandaParameters) {
            MsAmandaParameters msAmandaParameters = (MsAmandaParameters)identificationAlgorithmParameter;
            if (this.generateDecoy != msAmandaParameters.generateDecoy()) {
                return false;
            }
            if (this.reportBothBestHitsForTD.booleanValue() != msAmandaParameters.reportBothBestHitsForTD()) {
                return false;
            }
            if (this.monoisotopic != msAmandaParameters.isMonoIsotopic()) {
                return false;
            }
            if (!this.instrumentID.equalsIgnoreCase(msAmandaParameters.getInstrumentID())) {
                return false;
            }
            if (!this.maxRank.equals(msAmandaParameters.getMaxRank())) {
                return false;
            }
            if (this.performDeisotoping.booleanValue() != msAmandaParameters.isPerformDeisotoping()) {
                return false;
            }
            if (!this.maxModifications.equals(msAmandaParameters.getMaxModifications())) {
                return false;
            }
            if (!this.maxVariableModifications.equals(msAmandaParameters.getMaxVariableModifications())) {
                return false;
            }
            if (!this.maxModificationSites.equals(msAmandaParameters.getMaxModificationSites())) {
                return false;
            }
            if (!this.maxNeutralLosses.equals(msAmandaParameters.getMaxNeutralLosses())) {
                return false;
            }
            if (!this.maxNeutralLossesPerModification.equals(msAmandaParameters.getMaxNeutralLossesPerModification())) {
                return false;
            }
            if (!this.minPeptideLength.equals(msAmandaParameters.getMinPeptideLength())) {
                return false;
            }
            if (!this.maxPeptideLength.equals(msAmandaParameters.getMaxPeptideLength())) {
                return false;
            }
            if (!this.maxLoadedProteins.equals(msAmandaParameters.getMaxLoadedProteins())) {
                return false;
            }
            if (!this.maxLoadedSpectra.equals(msAmandaParameters.getMaxLoadedSpectra())) {
                return false;
            }
            return this.getOutputFormat().equalsIgnoreCase(msAmandaParameters.getOutputFormat());
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("SEARCH_DECOY=");
        output.append(this.generateDecoy);
        output.append(newLine);
        output.append("REPORT_BOTH_BEST_HITS_FOR_TD=");
        output.append(this.reportBothBestHitsForTD);
        output.append(newLine);
        output.append("INSTRUMENT_ID=");
        output.append(this.instrumentID);
        output.append(newLine);
        output.append("MONOISOTOPIC=");
        output.append(this.monoisotopic);
        output.append(newLine);
        output.append("MAX_RANK=");
        output.append(this.maxRank);
        output.append(newLine);
        output.append("PERFORM_DEISOTOPING=");
        output.append(this.isPerformDeisotoping());
        output.append(newLine);
        output.append("MAX_MODIFICATIONS=");
        output.append(this.getMaxModifications());
        output.append(newLine);
        output.append("MAX_VARIABLE_MODIFICATIONS=");
        output.append(this.getMaxVariableModifications());
        output.append(newLine);
        output.append("MAX_MODIFICATIONS_SITES=");
        output.append(this.getMaxModificationSites());
        output.append(newLine);
        output.append("MAX_NEUTRAL_LOSSES=");
        output.append(this.getMaxNeutralLosses());
        output.append(newLine);
        output.append("MAX_NEUTRAL_LOSSES_PER_MODIFICATION=");
        output.append(this.getMaxNeutralLossesPerModification());
        output.append(newLine);
        output.append("MIN_PEPTIDE_LENGTH=");
        output.append(this.getMinPeptideLength());
        output.append(newLine);
        output.append("MAX_PEPTIDE_LENGTH=");
        output.append(this.getMaxPeptideLength());
        output.append(newLine);
        output.append("MAX_LOADED_PROTEINS=");
        output.append(this.getMaxLoadedProteins());
        output.append(newLine);
        output.append("MAX_LOADED_SPECTRA=");
        output.append(this.getMaxLoadedSpectra());
        output.append(newLine);
        output.append("OUTPUT_FORMAT=");
        output.append(this.outputFormat);
        output.append(newLine);
        return output.toString();
    }

    public boolean generateDecoy() {
        return this.generateDecoy;
    }

    public void setGenerateDecoyDatabase(boolean generateDecoy) {
        this.generateDecoy = generateDecoy;
    }

    public boolean isMonoIsotopic() {
        return this.monoisotopic;
    }

    public void setMonoIsotopic(boolean monoisotopic) {
        this.monoisotopic = monoisotopic;
    }

    public String getInstrumentID() {
        return this.instrumentID;
    }

    public void setInstrumentID(String instrumentID) {
        this.instrumentID = instrumentID;
    }

    public Integer getMaxRank() {
        return this.maxRank;
    }

    public void setMaxRank(Integer maxRank) {
        this.maxRank = maxRank;
    }

    public boolean isLowMemoryMode() {
        if (this.lowMemoryMode == null) {
            this.lowMemoryMode = true;
        }
        return this.lowMemoryMode;
    }

    public void setLowMemoryMode(boolean lowMemoryMode) {
        this.lowMemoryMode = lowMemoryMode;
    }

    public boolean isPerformDeisotoping() {
        if (this.performDeisotoping == null) {
            this.performDeisotoping = true;
        }
        return this.performDeisotoping;
    }

    public void setPerformDeisotoping(boolean performDeisotoping) {
        this.performDeisotoping = performDeisotoping;
    }

    public Integer getMaxModifications() {
        if (this.maxModifications == null) {
            this.maxModifications = 3;
        }
        return this.maxModifications;
    }

    public void setMaxModifications(Integer maxModifications) {
        this.maxModifications = maxModifications;
    }

    public Integer getMaxVariableModifications() {
        if (this.maxVariableModifications == null) {
            this.maxVariableModifications = 4;
        }
        return this.maxVariableModifications;
    }

    public void setMaxVariableModifications(Integer maxVariableModifications) {
        this.maxVariableModifications = maxVariableModifications;
    }

    public Integer getMaxModificationSites() {
        if (this.maxModificationSites == null) {
            this.maxModificationSites = 6;
        }
        return this.maxModificationSites;
    }

    public void setMaxModificationSites(Integer maxModificationSites) {
        this.maxModificationSites = maxModificationSites;
    }

    public Integer getMaxNeutralLosses() {
        if (this.maxNeutralLosses == null) {
            this.maxNeutralLosses = 1;
        }
        return this.maxNeutralLosses;
    }

    public void setMaxNeutralLosses(Integer maxNeutralLosses) {
        this.maxNeutralLosses = maxNeutralLosses;
    }

    public Integer getMaxNeutralLossesPerModification() {
        if (this.maxNeutralLossesPerModification == null) {
            this.maxNeutralLossesPerModification = 2;
        }
        return this.maxNeutralLossesPerModification;
    }

    public void setMaxNeutralLossesPerModification(Integer maxNeutralLossesPerModification) {
        this.maxNeutralLossesPerModification = maxNeutralLossesPerModification;
    }

    public Integer getMinPeptideLength() {
        if (this.minPeptideLength == null) {
            this.minPeptideLength = 6;
        }
        return this.minPeptideLength;
    }

    public void setMinPeptideLength(Integer minPeptideLength) {
        this.minPeptideLength = minPeptideLength;
    }

    public Integer getMaxPeptideLength() {
        if (this.maxPeptideLength == null) {
            this.maxPeptideLength = 30;
        }
        return this.maxPeptideLength;
    }

    public void setMaxPeptideLength(Integer maxPeptideLength) {
        this.maxPeptideLength = maxPeptideLength;
    }

    public Integer getMaxLoadedProteins() {
        if (this.maxLoadedProteins == null) {
            this.maxLoadedProteins = 100000;
        }
        return this.maxLoadedProteins;
    }

    public void setMaxLoadedProteins(Integer maxLoadedProteins) {
        this.maxLoadedProteins = maxLoadedProteins;
    }

    public Integer getMaxLoadedSpectra() {
        if (this.maxLoadedSpectra == null) {
            this.maxLoadedSpectra = 2000;
        }
        return this.maxLoadedSpectra;
    }

    public void setMaxLoadedSpectra(Integer maxLoadedSpectra) {
        this.maxLoadedSpectra = maxLoadedSpectra;
    }

    public String getOutputFormat() {
        if (this.outputFormat == null) {
            this.outputFormat = "csv";
        }
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public boolean reportBothBestHitsForTD() {
        if (this.reportBothBestHitsForTD == null) {
            this.reportBothBestHitsForTD = true;
        }
        return this.reportBothBestHitsForTD;
    }

    public void setReportBothBestHitsForTD(boolean reportBothBestHitsForTD) {
        this.reportBothBestHitsForTD = reportBothBestHitsForTD;
    }
}

