/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.pdbfinder.das.readers;

import com.compomics.util.pdbfinder.das.readers.AlignmentBlock;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;

public class DasAlignment {
    private JsonObject iAlignment;
    private String resolution = "";
    private String experiment_type = "";
    private String header = "";
    private String title = "";
    private String pdbAccession = "";
    private String spAccession = "";
    private AlignmentBlock[] alignmentBlocks;
    private String pdbGroup = "";

    public DasAlignment() {
    }

    public DasAlignment(JsonObject aDasAlignment) {
        try {
            this.iAlignment = aDasAlignment;
            this.experiment_type = this.iAlignment.get("experimental_method").getAsString();
            this.pdbAccession = this.iAlignment.get("pdb_id").getAsString();
            this.spAccession = this.iAlignment.get("chain_id").getAsString();
            this.title = this.getChainTitle(this.pdbAccession);
            int startSp = this.iAlignment.get("unp_start").getAsInt();
            int endSp = this.iAlignment.get("unp_end").getAsInt();
            int startPdb = this.iAlignment.get("start").getAsInt();
            int endPdb = this.iAlignment.get("end").getAsInt();
            AlignmentBlock align = new AlignmentBlock(startPdb, endPdb, startSp, endSp, this.pdbAccession, this.spAccession);
            Vector<AlignmentBlock> block = new Vector<AlignmentBlock>();
            block.add(align);
            this.alignmentBlocks = new AlignmentBlock[block.size()];
            block.toArray(this.alignmentBlocks);
        }
        catch (StringIndexOutOfBoundsException e) {
            System.out.println("Error in reading das - pdb alignment");
        }
    }

    public String getResolution() {
        return this.resolution;
    }

    public String getExperimentType() {
        return this.experiment_type;
    }

    public String getHeader() {
        return this.header;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPdbAccession() {
        return this.pdbAccession;
    }

    public String getSpAccession() {
        return this.spAccession;
    }

    public AlignmentBlock[] getAlignmentBlocks() {
        return this.alignmentBlocks;
    }

    public String getPdbGroup() {
        this.pdbGroup = this.pdbAccession.substring(this.pdbAccession.indexOf(".") + 1);
        this.pdbGroup = this.pdbGroup.toLowerCase();
        return this.pdbGroup;
    }

    private String getChainTitle(String aPdbAccession) {
        String lUrl = "https://www.ebi.ac.uk/pdbe/api/pdb/entry/summary/" + aPdbAccession + "";
        return this.readUrl(lUrl, aPdbAccession);
    }

    public String readUrl(String aUrl, String aPdbAccession) {
        try {
            int i;
            URL myURL = new URL(aUrl);
            StringBuilder input = new StringBuilder();
            HttpsURLConnection c = (HttpsURLConnection)myURL.openConnection();
            BufferedInputStream in = new BufferedInputStream(c.getInputStream());
            InputStreamReader r = new InputStreamReader(in);
            while ((i = ((Reader)r).read()) != -1) {
                input.append((char)i);
            }
            ((Reader)r).close();
            in.close();
            JsonObject obj = (JsonObject)new Gson().fromJson(input.toString(), JsonObject.class);
            String tempTitle = obj.getAsJsonArray(aPdbAccession).get(0).getAsJsonObject().get("title").getAsString();
            return tempTitle;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ConnectException e) {
            System.out.println("Connect exception for url " + aUrl);
        }
        catch (IOException e) {
            System.out.println("I/O exception for url " + aUrl);
        }
        return "";
    }
}

