/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.filter;

import com.github.psambit9791.jdsp.filter._IIRFilter;
import uk.me.berndporr.iirj.ChebyshevI;
import uk.me.berndporr.iirj.ChebyshevII;

public class Chebyshev
implements _IIRFilter {
    private double samplingFreq;
    private int filterType;
    private double rippleFactor;

    public Chebyshev(double Fs, double rf, int filterType) {
        this.samplingFreq = Fs;
        this.rippleFactor = rf;
        this.filterType = filterType;
    }

    public Chebyshev(double Fs, double rf) {
        this.samplingFreq = Fs;
        this.rippleFactor = rf;
        this.filterType = 1;
    }

    @Override
    public double[] lowPassFilter(double[] signal, int order, double cutoffFreq) {
        double[] output = new double[signal.length];
        if (this.filterType == 1) {
            ChebyshevI lp = new ChebyshevI();
            lp.lowPass(order, this.samplingFreq, cutoffFreq, this.rippleFactor);
            for (int i = 0; i < output.length; ++i) {
                output[i] = lp.filter(signal[i]);
            }
        } else if (this.filterType == 2) {
            ChebyshevII lp = new ChebyshevII();
            lp.lowPass(order, this.samplingFreq, cutoffFreq, this.rippleFactor);
            for (int i = 0; i < output.length; ++i) {
                output[i] = lp.filter(signal[i]);
            }
        } else {
            throw new ExceptionInInitializerError("Chebyshev filter can only be of Type 1 and 2.");
        }
        return output;
    }

    @Override
    public double[] highPassFilter(double[] signal, int order, double cutoffFreq) {
        double[] output = new double[signal.length];
        if (this.filterType == 1) {
            ChebyshevI hp = new ChebyshevI();
            hp.highPass(order, this.samplingFreq, cutoffFreq, this.rippleFactor);
            for (int i = 0; i < output.length; ++i) {
                output[i] = hp.filter(signal[i]);
            }
        } else if (this.filterType == 2) {
            ChebyshevII hp = new ChebyshevII();
            hp.highPass(order, this.samplingFreq, cutoffFreq, this.rippleFactor);
            for (int i = 0; i < output.length; ++i) {
                output[i] = hp.filter(signal[i]);
            }
        } else {
            throw new ExceptionInInitializerError("Chebyshev filter can only be of Type 1 and 2.");
        }
        return output;
    }

    @Override
    public double[] bandPassFilter(double[] signal, int order, double lowCutoff, double highCutoff) throws IllegalArgumentException {
        if (lowCutoff >= highCutoff) {
            throw new IllegalArgumentException("Lower Cutoff Frequency cannot be more than the Higher Cutoff Frequency");
        }
        double centreFreq = (highCutoff + lowCutoff) / 2.0;
        double width = Math.abs(highCutoff - lowCutoff);
        double[] output = new double[signal.length];
        if (this.filterType == 1) {
            ChebyshevI bp = new ChebyshevI();
            bp.bandPass(order, this.samplingFreq, centreFreq, width, this.rippleFactor);
            for (int i = 0; i < output.length; ++i) {
                output[i] = bp.filter(signal[i]);
            }
        } else if (this.filterType == 2) {
            ChebyshevII bp = new ChebyshevII();
            bp.bandPass(order, this.samplingFreq, centreFreq, width, this.rippleFactor);
            for (int i = 0; i < output.length; ++i) {
                output[i] = bp.filter(signal[i]);
            }
        } else {
            throw new ExceptionInInitializerError("Chebyshev filter can only be of Type 1 and 2.");
        }
        return output;
    }

    @Override
    public double[] bandStopFilter(double[] signal, int order, double lowCutoff, double highCutoff) throws IllegalArgumentException {
        if (lowCutoff >= highCutoff) {
            throw new IllegalArgumentException("Lower Cutoff Frequency cannot be more than the Higher Cutoff Frequency");
        }
        double centreFreq = (highCutoff + lowCutoff) / 2.0;
        double width = Math.abs(highCutoff - lowCutoff);
        double[] output = new double[signal.length];
        if (this.filterType == 1) {
            ChebyshevI bs = new ChebyshevI();
            bs.bandStop(order, this.samplingFreq, centreFreq, width, this.rippleFactor);
            for (int i = 0; i < output.length; ++i) {
                output[i] = bs.filter(signal[i]);
            }
        } else if (this.filterType == 2) {
            ChebyshevII bs = new ChebyshevII();
            bs.bandStop(order, this.samplingFreq, centreFreq, width, this.rippleFactor);
            for (int i = 0; i < output.length; ++i) {
                output[i] = bs.filter(signal[i]);
            }
        } else {
            throw new IllegalArgumentException("Chebyshev filter can only be of Type 1 and 2.");
        }
        return output;
    }
}

