/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.filter;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.signal.Convolution;

public abstract class _FIRFilter {
    public double[] firfilter(double[] b, double[] x, double[] zi) {
        if (x.length != zi.length) {
            throw new IllegalArgumentException("Shape of x and Shape of init must to be same");
        }
        double[] fout = new double[x.length];
        Convolution c1 = new Convolution(x, b);
        double[] conv_out = c1.convolve();
        for (int i = 0; i < zi.length; ++i) {
            fout[i] = conv_out[i] + zi[i];
        }
        return fout;
    }

    public double[] firfilter(double[] b, double[] x) {
        Convolution c1 = new Convolution(x, b);
        double[] conv_out = c1.convolve();
        double[] fout = UtilMethods.splitByIndex(conv_out, 0, x.length);
        return fout;
    }
}

