/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.signal;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.signal.Convolution;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.util.MathArrays;

public class ComplexConvolution {
    private double[] signal;
    private Complex[] complexSignal;
    private double[] kernel;
    private Complex[] complexKernel;
    private Complex[] output;

    public ComplexConvolution(Complex[] signal, double[] window) {
        this.signal = null;
        this.complexSignal = signal;
        this.kernel = window;
        this.complexKernel = null;
        this.output = null;
    }

    public ComplexConvolution(double[] signal, Complex[] window) {
        this.signal = signal;
        this.complexSignal = null;
        this.kernel = null;
        this.complexKernel = window;
        this.output = null;
    }

    public ComplexConvolution(Complex[] signal, Complex[] window) {
        this.signal = null;
        this.complexSignal = signal;
        this.kernel = null;
        this.complexKernel = window;
        this.output = null;
    }

    private void convolveDoubleComplex(String mode) {
        double[][] kernel2D = UtilMethods.transpose(UtilMethods.complexTo2D(this.complexKernel));
        Convolution c_real = new Convolution(this.signal, kernel2D[0]);
        Convolution c_imag = new Convolution(this.signal, kernel2D[1]);
        Object temp = new double[][]{c_real.convolve(mode), c_imag.convolve(mode)};
        temp = UtilMethods.transpose(temp);
        this.output = UtilMethods.matToComplex(temp);
    }

    private void convolveComplexDouble(String mode) {
        double[][] signal2D = UtilMethods.transpose(UtilMethods.complexTo2D(this.complexSignal));
        Convolution c_real = new Convolution(signal2D[0], this.kernel);
        Convolution c_imag = new Convolution(signal2D[1], this.kernel);
        Object temp = new double[][]{c_real.convolve(mode), c_imag.convolve(mode)};
        temp = UtilMethods.transpose(temp);
        this.output = UtilMethods.matToComplex(temp);
    }

    private void convolveComplexComplex(String mode) {
        double[][] signal2D = UtilMethods.transpose(UtilMethods.complexTo2D(this.complexSignal));
        double[][] kernel2D = UtilMethods.transpose(UtilMethods.complexTo2D(this.complexKernel));
        Convolution c_real_real = new Convolution(signal2D[0], kernel2D[0]);
        Convolution c_imag_imag = new Convolution(signal2D[1], kernel2D[1]);
        Convolution c_real_imag = new Convolution(signal2D[0], kernel2D[1]);
        Convolution c_imag_real = new Convolution(signal2D[1], kernel2D[0]);
        double[] real = MathArrays.ebeAdd((double[])c_real_real.convolve(mode), (double[])MathArrays.scale((double)-1.0, (double[])c_imag_imag.convolve(mode)));
        double[] imag = MathArrays.ebeAdd((double[])c_real_imag.convolve(mode), (double[])c_imag_real.convolve(mode));
        Object temp = new double[][]{real, imag};
        temp = UtilMethods.transpose(temp);
        this.output = UtilMethods.matToComplex(temp);
    }

    public Complex[] convolve(String mode) throws ExceptionInInitializerError {
        if (this.complexSignal != null && this.kernel != null) {
            this.convolveComplexDouble(mode);
        } else if (this.signal != null && this.complexKernel != null) {
            this.convolveDoubleComplex(mode);
        } else if (this.complexSignal != null && this.complexKernel != null) {
            this.convolveComplexComplex(mode);
        } else {
            throw new ExceptionInInitializerError("This is a complex convolution method. Please use normal convolution for non-complex signals.");
        }
        return this.output;
    }

    public Complex[] convolve() throws ExceptionInInitializerError {
        if (this.signal == null && this.complexKernel == null) {
            this.convolveComplexDouble("full");
        } else if (this.complexSignal == null && this.kernel == null) {
            this.convolveDoubleComplex("full");
        } else if (this.signal == null && this.kernel == null) {
            this.convolveComplexComplex("full");
        } else {
            throw new ExceptionInInitializerError("This is a complex convolution method. Please use normal convolution for non-complex signals.");
        }
        return this.output;
    }
}

