/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.signal;

import com.github.psambit9791.jdsp.filter.Chebyshev;
import com.github.psambit9791.jdsp.misc.UtilMethods;

public class Decimate {
    private double[] signal;
    private int samplingFreq;
    private boolean zeroPhase;

    public Decimate(double[] s, int Fs, boolean zeroPhase) {
        this.samplingFreq = Fs;
        this.signal = s;
        this.zeroPhase = zeroPhase;
    }

    public Decimate(double[] s, int Fs) {
        this.samplingFreq = Fs;
        this.signal = s;
        this.zeroPhase = true;
    }

    public double[] decimate(int downSamplingFactor) {
        double[] output = new double[(int)Math.ceil((double)this.signal.length / (double)downSamplingFactor)];
        if (!this.zeroPhase) {
            int newSamplingFreq = this.samplingFreq / downSamplingFactor;
            double nyquistFreq = (double)newSamplingFreq / 2.0;
            Chebyshev f = new Chebyshev(this.samplingFreq, 0.05);
            double[] lowPassOutput = f.lowPassFilter(this.signal, 8, nyquistFreq * 0.8);
            int index = 0;
            for (int i = 0; i < output.length; ++i) {
                output[i] = lowPassOutput[index];
                index += downSamplingFactor;
            }
        } else {
            int newSamplingFreq = this.samplingFreq / downSamplingFactor;
            double nyquistFreq = (double)newSamplingFreq / 2.0;
            Chebyshev f1 = new Chebyshev(this.samplingFreq, 0.05);
            double[] lowPassOutput = f1.lowPassFilter(this.signal, 4, nyquistFreq * 0.8);
            lowPassOutput = UtilMethods.reverse(lowPassOutput);
            Chebyshev f2 = new Chebyshev(this.samplingFreq, 0.05);
            lowPassOutput = f2.lowPassFilter(lowPassOutput, 4, nyquistFreq * 0.8);
            lowPassOutput = UtilMethods.reverse(lowPassOutput);
            int index = 0;
            for (int i = 0; i < output.length; ++i) {
                output[i] = lowPassOutput[index];
                index += downSamplingFactor;
            }
        }
        return output;
    }
}

