/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.signal;

import com.github.psambit9791.jdsp.filter.FIRWin1;
import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.transform.DiscreteFourier;
import com.github.psambit9791.jdsp.transform.InverseDiscreteFourier;
import java.util.Arrays;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.commons.math3.util.MathArrays;

public class Resample {
    private double[] signal;
    private boolean poly;
    private int num;
    private int up;
    private int down;
    private double beta;
    private double cval;
    private double[] output;
    private String padtype;
    private String upfirdn_mode;

    public Resample(int num) {
        this.num = num;
        this.poly = false;
    }

    public Resample(int up, int down, String padtype, double cval) {
        if (up < 1 && down < 1) {
            throw new IllegalArgumentException("up and down must be greater than 0");
        }
        this.up = up;
        this.down = down;
        this.beta = 5.0;
        this.cval = cval;
        if (!(padtype.equals("mean") || padtype.equals("median") || padtype.equals("min") || padtype.equals("max") || padtype.equals("constant") || padtype.equals("edge"))) {
            throw new ArithmeticException("padtype must be 'mean', 'median', 'min', 'max', 'constant' or 'edge'");
        }
        this.padtype = padtype;
        this.upfirdn_mode = padtype;
        this.poly = true;
    }

    public Resample(int up, int down, double beta, String padtype) {
        if (up < 1 && down < 1) {
            throw new IllegalArgumentException("up and down must be greater than 0");
        }
        this.up = up;
        this.down = down;
        this.beta = beta;
        this.cval = 0.0;
        if (!(padtype.equals("mean") || padtype.equals("median") || padtype.equals("min") || padtype.equals("max") || padtype.equals("constant") || padtype.equals("edge"))) {
            throw new ArithmeticException("padtype must be 'mean', 'median', 'min', 'max', 'constant' or 'edge'");
        }
        this.padtype = padtype;
        this.upfirdn_mode = padtype;
        this.poly = true;
    }

    public Resample(int up, int down, String padtype) {
        if (up < 1 && down < 1) {
            throw new IllegalArgumentException("up and down must be greater than 0");
        }
        this.up = up;
        this.down = down;
        this.beta = 5.0;
        this.cval = 0.0;
        if (!(padtype.equals("mean") || padtype.equals("median") || padtype.equals("min") || padtype.equals("max") || padtype.equals("constant") || padtype.equals("edge"))) {
            throw new ArithmeticException("padtype must be 'mean', 'median', 'min', 'max', 'constant' or 'edge'");
        }
        this.padtype = padtype;
        this.upfirdn_mode = padtype;
        this.poly = true;
    }

    public Resample(int up, int down, double beta, String padtype, double cval) {
        if (up < 1 && down < 1) {
            throw new IllegalArgumentException("up and down must be greater than 0");
        }
        this.up = up;
        this.down = down;
        this.beta = beta;
        this.cval = cval;
        if (!(padtype.equals("mean") || padtype.equals("median") || padtype.equals("min") || padtype.equals("max") || padtype.equals("constant") || padtype.equals("edge"))) {
            throw new ArithmeticException("padtype must be 'mean', 'median', 'min', 'max', 'constant' or 'edge'");
        }
        this.padtype = padtype;
        this.upfirdn_mode = padtype;
        this.poly = true;
    }

    private void resample_fft() {
        int Nx = this.signal.length;
        DiscreteFourier df = new DiscreteFourier(this.signal);
        df.transform();
        double[][] X = df.getComplex2D(true);
        double[][] Y = new double[this.num / 2 + 1][2];
        int N = Math.min(this.num, Nx);
        int nyquist_idx = N / 2 + 1;
        for (int i = 0; i < nyquist_idx; ++i) {
            Y[i][0] = X[i][0];
            Y[i][1] = X[i][1];
        }
        if (N % 2 == 0) {
            if (this.num < Nx) {
                Y[N / 2][0] = Y[N / 2][0] * 2.0;
                Y[N / 2][1] = Y[N / 2][1] * 2.0;
            } else {
                Y[N / 2][0] = Y[N / 2][0] * 0.5;
                Y[N / 2][1] = Y[N / 2][1] * 0.5;
            }
        }
        InverseDiscreteFourier idf = new InverseDiscreteFourier(Y, true);
        idf.transform();
        double[] y = idf.getReal();
        this.output = MathArrays.scale((double)((float)this.num / (float)Nx), (double[])y);
    }

    private double _funcs(double[] signal, String action) {
        double out;
        switch (action) {
            case "mean": {
                out = StatUtils.mean((double[])signal);
                this.upfirdn_mode = "constant";
                this.cval = 0.0;
                break;
            }
            case "median": {
                out = new Median().evaluate(signal);
                this.upfirdn_mode = "constant";
                this.cval = 0.0;
                break;
            }
            case "max": {
                out = StatUtils.max((double[])signal);
                this.upfirdn_mode = "constant";
                this.cval = 0.0;
                break;
            }
            case "min": {
                out = StatUtils.min((double[])signal);
                this.upfirdn_mode = "constant";
                this.cval = 0.0;
                break;
            }
            default: {
                out = 0.0;
            }
        }
        return out;
    }

    private static int _output_len(int hlen, int siglen, int up, int down) {
        return ((siglen - 1) * up + hlen - 1) / down + 1;
    }

    private void resample_poly() {
        int g = ArithmeticUtils.gcd((int)this.up, (int)this.down);
        this.up /= g;
        this.down /= g;
        if (this.up == 1 && this.down == 1) {
            this.output = this.signal;
        }
        int n_in = this.signal.length;
        int n_out = n_in * this.up;
        n_out = n_out / this.down + (UtilMethods.modulo(n_out, this.down) > 0 ? 1 : 0);
        int max_rate = Math.max(this.up, this.down);
        double f_c = 1.0 / (double)max_rate;
        int half_len = 10 * max_rate;
        FIRWin1 fw = new FIRWin1(2 * half_len + 1, this.beta, true);
        double[] h = fw.computeCoefficients(new double[]{f_c}, FIRWin1.FIRfilterType.LOWPASS, true);
        h = UtilMethods.scalarArithmetic(h, this.up, "mul");
        int n_pre_pad = this.down - half_len % this.down;
        int n_post_pad = 0;
        int n_pre_remove = (half_len + n_pre_pad) / this.down;
        int n_pre_remove_end = n_pre_remove + n_out;
        while (Resample._output_len(h.length + n_pre_pad + n_post_pad, n_in, this.up, this.down) < n_out + n_pre_remove) {
            ++n_post_pad;
        }
        double[] pre = new double[n_pre_pad];
        Arrays.fill(pre, 0.0);
        double[] post = new double[n_post_pad];
        Arrays.fill(post, 0.0);
        h = UtilMethods.concatenateArray(pre, h);
        h = UtilMethods.concatenateArray(h, post);
        double bg_val = this._funcs(this.signal, this.padtype);
        if (this.padtype.equals("mean") || this.padtype.equals("median") || this.padtype.equals("max") || this.padtype.equals("min")) {
            this.signal = UtilMethods.scalarArithmetic(this.signal, bg_val, "sub");
        }
        _UpFIRDown ufd = new _UpFIRDown(h, this.up, this.down, this.cval);
        this.output = ufd.apply_filter(this.signal, this.upfirdn_mode);
        this.output = UtilMethods.splitByIndex(this.output, n_pre_remove, n_pre_remove_end);
        if (this.padtype.equals("mean") || this.padtype.equals("median") || this.padtype.equals("max") || this.padtype.equals("min")) {
            this.output = UtilMethods.scalarArithmetic(this.output, bg_val, "add");
        }
    }

    public double[] resampleSignal(double[] signal) {
        this.signal = signal;
        if (this.poly) {
            this.resample_poly();
        } else {
            this.resample_fft();
        }
        return this.output;
    }

    class _UpFIRDown {
        private int up;
        private int down;
        private double[] h_trans_flip;
        private int h_orig_len;
        private double cval;

        private double[] _padH(double[] h, int up) {
            double[][] htemp;
            int h_padlen = h.length + UtilMethods.modulo(-h.length, up);
            for (double[] row : htemp = new double[h_padlen / up][up]) {
                Arrays.fill(row, 0.0);
            }
            for (int i = 0; i < h.length; ++i) {
                htemp[i / up][i % up] = h[i];
            }
            htemp = UtilMethods.transpose(htemp);
            htemp = UtilMethods.reverseMatrix(htemp);
            return UtilMethods.flattenMatrix(htemp);
        }

        private _UpFIRDown(double[] h, int up, int down, double cval) {
            this.up = up;
            this.down = down;
            this.h_orig_len = h.length;
            this.h_trans_flip = this._padH(h, up);
            this.cval = cval;
        }

        private double _extend_left(double[] signal, String padtype, double cval) {
            double out = padtype.equals("constant") ? cval : (padtype.equals("edge") ? signal[0] : -1.0);
            return out;
        }

        private double _extend_right(double[] signal, String padtype, double cval) {
            double out = padtype.equals("constant") ? cval : (padtype.equals("edge") ? signal[signal.length - 1] : -1.0);
            return out;
        }

        private double[] apply_filter(double[] signal, String padtype) {
            double x_val;
            int xcidx;
            int x_idx;
            boolean zpad;
            int len_out = Resample._output_len(this.h_orig_len, signal.length, this.up, this.down);
            double[] output = new double[len_out];
            Arrays.fill(output, 0.0);
            int len_x = signal.length;
            int len_h = this.h_trans_flip.length;
            int h_per_phase = len_h / this.up;
            int padded_len = len_x + h_per_phase - 1;
            int t = 0;
            int x_conv_idx = 0;
            int h_idx = 0;
            int y_idx = 0;
            boolean bl = zpad = padtype.equals("constant") && this.cval == 0.0;
            for (x_idx = 0; x_idx < len_x; x_idx += (t += this.down) / this.up) {
                h_idx = t * h_per_phase;
                x_conv_idx = x_idx - h_per_phase + 1;
                if (x_conv_idx < 0) {
                    if (zpad) {
                        h_idx -= x_conv_idx;
                    } else {
                        for (xcidx = x_conv_idx; xcidx < 0; ++xcidx) {
                            x_val = this._extend_left(signal, padtype, this.cval);
                            output[y_idx] = output[y_idx] + x_val * this.h_trans_flip[h_idx];
                            ++h_idx;
                        }
                    }
                    x_conv_idx = 0;
                }
                for (xcidx = x_conv_idx; xcidx < x_idx + 1; ++xcidx) {
                    output[y_idx] = output[y_idx] + signal[xcidx] * this.h_trans_flip[h_idx];
                    ++h_idx;
                }
                if (++y_idx >= len_out) {
                    return output;
                }
                t = UtilMethods.modulo(t, this.up);
            }
            while (x_idx < padded_len) {
                h_idx = t * h_per_phase;
                for (xcidx = x_conv_idx = x_idx - h_per_phase + 1; xcidx < x_idx + 1; ++xcidx) {
                    x_val = xcidx >= len_x ? this._extend_right(signal, padtype, this.cval) : (xcidx < 0 ? this._extend_left(signal, padtype, this.cval) : signal[xcidx]);
                    output[y_idx] = output[y_idx] + x_val * this.h_trans_flip[h_idx];
                    ++h_idx;
                }
                if (++y_idx >= len_out) {
                    return output;
                }
                x_idx += (t += this.down) / this.up;
                t = UtilMethods.modulo(t, this.up);
            }
            return output;
        }
    }
}

