/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.signal.peaks;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import java.util.ArrayList;

public class Spike {
    private double[] signal;
    private int[] peaks;
    private int[] left_trough;
    private int[] right_trough;
    private double[] left_spike;
    private double[] right_spike;
    private double[] mean_spike;
    private double[] max_spike;
    private double[] min_spike;

    public Spike(double[] signal, int[] peaks, int[] left, int[] right) {
        this.signal = signal;
        this.peaks = peaks;
        this.left_trough = left;
        this.right_trough = right;
        this.left_spike = this.calculateLeftSpikeHeight(this.peaks, this.left_trough);
        this.right_spike = this.calculateRightSpikeHeight(this.peaks, this.right_trough);
        this.mean_spike = this.calculateMeanSpikeHeight(this.left_spike, this.right_spike);
        this.max_spike = this.calculateMaxSpikeHeight(this.left_spike, this.right_spike);
        this.min_spike = this.calculateMinSpikeHeight(this.left_spike, this.right_spike);
    }

    public int[][] getAllTroughs() {
        int[][] troughData = new int[2][this.peaks.length];
        troughData[0] = this.left_trough;
        troughData[1] = this.right_trough;
        return troughData;
    }

    public double[] calculateLeftSpikeHeight(int[] peaks, int[] left_trough) {
        double[] left_spike = new double[peaks.length];
        for (int i = 0; i < peaks.length; ++i) {
            left_spike[i] = left_trough[i] != -1 ? Math.abs(this.signal[peaks[i]] - this.signal[left_trough[i]]) : Double.NaN;
        }
        return left_spike;
    }

    public double[] calculateRightSpikeHeight(int[] peaks, int[] right_trough) {
        double[] right_spike = new double[peaks.length];
        for (int i = 0; i < this.peaks.length; ++i) {
            right_spike[i] = right_trough[i] != -1 ? Math.abs(this.signal[peaks[i]] - this.signal[right_trough[i]]) : Double.NaN;
        }
        return right_spike;
    }

    public double[] calculateMeanSpikeHeight(double[] left_spike, double[] right_spike) {
        double[] mean_spike = new double[left_spike.length];
        for (int k = 0; k < mean_spike.length; ++k) {
            if (!Double.isNaN(left_spike[k]) && !Double.isNaN(right_spike[k])) {
                mean_spike[k] = (left_spike[k] + right_spike[k]) / 2.0;
                continue;
            }
            if (!Double.isNaN(left_spike[k]) && Double.isNaN(right_spike[k])) {
                mean_spike[k] = left_spike[k];
                continue;
            }
            if (Double.isNaN(right_spike[k]) || !Double.isNaN(left_spike[k])) continue;
            mean_spike[k] = right_spike[k];
        }
        return mean_spike;
    }

    public double[] calculateMaxSpikeHeight(double[] left_spike, double[] right_spike) {
        double[] max_spike = new double[left_spike.length];
        for (int k = 0; k < max_spike.length; ++k) {
            max_spike[k] = Double.isNaN(left_spike[k]) ? right_spike[k] : (Double.isNaN(right_spike[k]) ? left_spike[k] : Math.max(left_spike[k], right_spike[k]));
        }
        return max_spike;
    }

    public double[] calculateMinSpikeHeight(double[] left_spike, double[] right_spike) {
        double[] max_spike = new double[left_spike.length];
        for (int k = 0; k < max_spike.length; ++k) {
            max_spike[k] = Double.isNaN(left_spike[k]) ? right_spike[k] : (Double.isNaN(right_spike[k]) ? left_spike[k] : Math.min(left_spike[k], right_spike[k]));
        }
        return max_spike;
    }

    public int[] getPeaks() {
        return this.peaks;
    }

    public double[] getLeftSpike() {
        return this.left_spike;
    }

    public double[] getRightSpike() {
        return this.right_spike;
    }

    public double[] getMeanSpike() {
        return this.mean_spike;
    }

    public double[] getMaxSpike() {
        return this.max_spike;
    }

    public double[] getMinSpike() {
        return this.min_spike;
    }

    public int[] filterByProperty(Double lower_threshold, Double upper_threshold, String spikeType) {
        double[] spikeList;
        ArrayList<Integer> newPeaks = new ArrayList<Integer>();
        if (spikeType.equals("left")) {
            spikeList = this.left_spike;
        } else if (spikeType.equals("right")) {
            spikeList = this.right_spike;
        } else if (spikeType.equals("mean")) {
            spikeList = this.mean_spike;
        } else if (spikeType.equals("max")) {
            spikeList = this.max_spike;
        } else if (spikeType.equals("min")) {
            spikeList = this.min_spike;
        } else {
            throw new IllegalArgumentException("spikeType Can only be 'left', 'right', 'mean' and 'max'");
        }
        if (lower_threshold == null && upper_threshold == null) {
            throw new IllegalArgumentException("All thresholds cannot be null");
        }
        if (lower_threshold != null && upper_threshold == null) {
            for (int i = 0; i < spikeList.length; ++i) {
                if (Double.isNaN(spikeList[i]) || !(spikeList[i] > lower_threshold)) continue;
                newPeaks.add(this.peaks[i]);
            }
        } else if (lower_threshold == null && upper_threshold != null) {
            for (int i = 0; i < spikeList.length; ++i) {
                if (Double.isNaN(spikeList[i]) || !(spikeList[i] < upper_threshold)) continue;
                newPeaks.add(this.peaks[i]);
            }
        } else {
            for (int i = 0; i < spikeList.length; ++i) {
                if (Double.isNaN(spikeList[i]) || !(spikeList[i] > lower_threshold) || !(spikeList[i] < upper_threshold)) continue;
                newPeaks.add(this.peaks[i]);
            }
        }
        return UtilMethods.convertToPrimitiveInt(newPeaks);
    }

    public double[] findPeakHeights(int[] peaks) {
        double[] newHeight = new double[peaks.length];
        for (int i = 0; i < peaks.length; ++i) {
            newHeight[i] = this.signal[peaks[i]];
        }
        return newHeight;
    }
}

