/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.speech;

public class MFCC {
    private double[][] filterBank;
    private double[] frequencies;
    private float lowFreq;
    private float linc;
    private float logsc;
    private int linFilterCount;
    private int logFilterCount;
    private int totalFilterCount;

    public MFCC() {
        this.lowFreq = 133.33f;
        this.linc = 66.666664f;
        this.logsc = 1.0711703f;
        this.linFilterCount = 13;
        this.logFilterCount = 27;
        this.totalFilterCount = this.linFilterCount + this.logFilterCount;
    }

    public MFCC(float lowFreq, float linc, float logsc, int linFilterCount, int logFilterCount) {
        this.lowFreq = lowFreq;
        this.linc = linc;
        this.logsc = logsc;
        this.linFilterCount = linFilterCount;
        this.logFilterCount = logFilterCount;
        this.totalFilterCount = this.linFilterCount + this.logFilterCount;
    }

    public MFCC(int linFilterCount, int logFilterCount) {
        this.lowFreq = 133.33f;
        this.linc = 66.666664f;
        this.logsc = 1.0711703f;
        this.linFilterCount = linFilterCount;
        this.logFilterCount = logFilterCount;
        this.totalFilterCount = this.linFilterCount + this.logFilterCount;
    }

    public MFCC(float lowFreq, float linc, float logsc) {
        this.lowFreq = lowFreq;
        this.linc = linc;
        this.logsc = logsc;
        this.linFilterCount = 13;
        this.logFilterCount = 27;
        this.totalFilterCount = this.linFilterCount + this.logFilterCount;
    }

    private void initializeFilterBank(int Fs, int nFFT) {
        int i;
        int i2;
        this.frequencies = new double[this.totalFilterCount + 2];
        for (i2 = 0; i2 < this.linFilterCount; ++i2) {
            this.frequencies[i2] = this.lowFreq + (float)i2 * this.linc;
        }
        for (i2 = this.linFilterCount; i2 < this.frequencies.length; ++i2) {
            this.frequencies[i2] = this.frequencies[this.linFilterCount - 1] * Math.pow(this.logsc, i2 - this.linFilterCount + 1);
        }
        double[] heights = new double[this.totalFilterCount];
        for (int i3 = 0; i3 < heights.length; ++i3) {
            heights[i3] = 2.0 / (this.frequencies[i3 + 2] - this.frequencies[i3]);
        }
        this.filterBank = new double[this.totalFilterCount][nFFT];
        float[] nfreqs = new float[nFFT];
        for (i = 0; i < nfreqs.length; ++i) {
            nfreqs[i] = (float)(i * Fs) / (float)nFFT;
        }
        for (i = 0; i < this.totalFilterCount; ++i) {
            int j;
            double low = this.frequencies[i];
            double centre = this.frequencies[i + 1];
            double high = this.frequencies[i + 2];
            int lidStart = (int)(Math.floor(low * (double)nFFT / (double)Fs) + 1.0);
            int lidEnd = (int)(Math.ceil(centre * (double)nFFT / (double)Fs) + 1.0);
            double lSlope = heights[i] / (centre - low);
            int ridStart = (int)(Math.floor(centre * (double)nFFT / (double)Fs) + 1.0);
            int ridEnd = (int)(Math.ceil(high * (double)nFFT / (double)Fs) + 1.0);
            double rSlope = heights[i] / (high - centre);
            for (j = lidStart; j < lidEnd; ++j) {
                this.filterBank[i][j] = lSlope * ((double)nfreqs[j] - low);
            }
            for (j = ridStart; j < ridEnd; ++j) {
                this.filterBank[i][j] = rSlope * (high - (double)nfreqs[j]);
            }
        }
    }

    public double[][] getFilterBank() {
        return this.filterBank;
    }
}

